= Forwardable

クラスに対しメソッドの委譲機能を定義するモジュールです.

== 使い方

クラスに対して ((<Object/extend>)) して使います. ((<Module/include>)) でないところに注意して下さい。
  
  class Foo
    extend Forwardable

    def_delegators("@out", "printf", "print")
    def_delegators(:@in, :gets)
    def_delegator(:@contents, :[], "content_at")
  end
  f = Foo.new
  f.printf ...
  f.gets
  f.content_at(1)

== メソッド

--- def_instance_delegators(accessor, *methods)

    ((|methods|)) で渡されたメソッドのリストを ((|accessor|)) に委譲する
    ようにします.

--- def_instance_delegator(accessor, method, ali = method)

    ((|method|)) で渡されたメソッドを ((|accessor|)) に委譲するようにし
    ます. ((|ali|))が引数として渡されたときは, メソッド((|ali|))が呼ば
    れたときには, ((|accessor|)) に対し ((|method|)) を呼び出します.

--- def_delegators(accessor, *methods)

    def_instance_delegators の 別名です.

--- def_delegator(accessor, method, ali = method)

    def_instance_delegator の別名です.
