###nonref

= 組み込み変数

このマニュアルでは、全体にわたって次の用語を使用しています。

: グローバル変数
  `$' で始まる変数全般
: 組み込み変数
  グローバル変数の中でも組み込みのもの(このページの変数)
: 特殊変数
  組み込み変数の中でも「`$' + 1文字の数字、記号」であるもの
: オプション変数
  組み込み変数の中でもコマンドラインオプションにより設定されるもの
  「`$-' + オプションの1文字」であるもの。

組み込み変数(これらは特殊な機能と用途を持ちます)の中にはその有効なスコー
プがグローバルとは限らない場合がありますが、上記の定義でグローバル変数
の中に含まれます(どこでも使えるという意味ではグローバルですが、その値
はグローバルとは限りません)。

以下、変数の値のスコープで大別して組み込み変数の一覧を列挙します。

== ローカルスコープ

以下の変数はスレッドローカルでもあります。

--- $_

    最後に (({gets})) または (({readline})) で読み込んだ文字列です。
    EOF に達した場合には、nil。この変数はローカルスコープです。
    (覚え方: Perlと同じ)

--- $&

    現在のスコープで最後に成功した正規表現のパターンマッチでマッチした
    文字列です。最後のマッチが失敗していた場合には (({nil}))。
    (覚え方: いくつかのエディタでの (({&})) と同じ)

    ((<Regexp/Regexp.last_match>))[0] と同じ。

--- $~

    現在のスコープで最後に成功したマッチに関する ((<MatchData>))
    オブジェクトです。これを設定すると (({$&})) や (({$1 ... $9})) などの
    値が変化します。

    このデータから n 番目のマッチ($n)を取り出すためには (({$~[n]})) で
    参照できます。
    (覚え方: ~ はマッチに使われる)

    ((<Regexp/Regexp.last_match>)) と同じ。

--- $`

    現在のスコープで最後に成功した正規表現のパターンマッチでマッチした
    部分より前の文字列です。最後のマッチが失敗していた場合には (({nil}))。
    (覚え方: (({`}))は文字列の前に置かれる)

    (({((<Regexp/Regexp.last_match>)).((<MatchData/pre_match>))})) と同じ。

--- $'

    現在のスコープで最後に成功した正規表現のパターンマッチでマッチした
    部分より後ろの文字列です。最後のマッチが失敗していた場合には (({nil}))。
    (覚え方: (({'}))は文字列の後ろに置かれる)

    (({((<Regexp/Regexp.last_match>)).((<MatchData/post_match>))})) と同じ。

--- $+

    現在のスコープで最後に成功した正規表現のパターンマッチでマッチした
    中で最後の括弧に対応する部分文字列です。
    最後のマッチが失敗していた場合には (({nil}))。
    いくつかある選択型のパターンのどれがマッチしたのか分からない時に便利
    (覚え方: be positive and forward looking.)

--- $1
--- $2
--- $3 ...

    最後に成功したパターンマッチでn番目の括弧にマッチした値が格
    納されます。該当する括弧がなければ(({nil}))が入ってい
    ます。(覚え方: \数字 のようなもの)

    ((<Regexp/Regexp.last_match>))[1],
    ((<Regexp/Regexp.last_match>))[2], ... と同じ。

== スレッドローカルスコープ

以下の変数は一つのスレッド内ではグローバルスコープですが、スレッド間で
は独立しています。

--- $?

    このスレッドで最後に終了した子プロセスのステータスです。
    1.6 以前は整数で 1.7 からは ((<Process::Status>)) オブジェクトです。
    ((<Process#wait|Process/wait>)) なども参照。

    整数値として評価した値は (({wait()})) システムコールで得られる値そ
    のものなので、子プロセスのexit statusを得るには 1/256 します((({$?/256})))。
    1.7以降なら
    ((<Process::Status#exitstatus|Process::Status/exitstatus>)) も使え
    ます。

--- $!

    最近の例外に関する情報を表す ((<Exception>)) クラスのサブクラスのインスタンスです。
    ((<組み込み関数/raise>)) によって設定されます。

--- $@

    例外が発生した時のバックトレースを表す配列です。
    配列の各要素はメソッドの呼び出し位置を示す文字列で形式は

      "filename:line"

    または

      "filename:line:in `methodname'"

    です。これは ((<組み込み関数/caller>)) が返す値と同じ形式です。

    (({$@})) へ値を代入するときは、((<組み込み変数/$!>)) が nil であって
    はいけません。
    (({$@})) の参照は、((<$!.backtrace|Exception/backtrace>)) と同じです。
    代入に関しては、 ((<$!.set_backtrace|Exception/set_backtrace>))
    と同じです。

    (覚え方: where exception occurred ((*at*)).)

--- $SAFE

    カレントスレッドのセーフレベルを表す整数です。セーフレベルについては
    ((<セキュリティモデル>))を参照してください。

    ((<Thread.current.safe_level|Thread/safe_level>)) と同じ。

== グローバルスコープ

--- $=
    ((<obsolete>)): この変数は削除される予定です。

    パターンマッチや文字列の比較でアルファベットの大文字小文字を
    区別するかどうかのフラグ。デフォルトは nil です。

--- $/

    入力レコードセパレータを表す文字列です。デフォルト値は (({"\n"})) です。
    (({awk})) の RS 変数のように働きます。

    この変数に nil を設定するとファイル全体を一度に読み込みます。
    空文字列 "" を設定するとパラグラフモードとみなされ、2つ以上連続した
    改行がレコードの区切りになります。

    (({$/})) には正規表現は使えません。

    (覚え方: 詩では / を行の区切りに使う)

--- $\

    出力レコードセパレータを表す文字列です。
    ((<組み込み関数/print>)) が最後にこの文字列を出力します。

    デフォルトは (({nil})) で、何も出力しません。

--- $,

    デフォルトの区切り文字列です。
    ((<Array#join|Array/join>)) で引数を省略した場合と、
    ((<組み込み関数/print>)) の各引数の間で出力されます。

    デフォルト値は nil で、空文字列と同じ結果になります。

--- $;

    ((<String#split|String/split>)) で引数を省略した場合の
    区切り文字。デフォルト値は (({nil})) で、この場合特殊な
    分割を行います。詳細は ((<String#split|String/split>))
    を参照してください。

    ((<ruby 1.8 feature>)): 1.6 では、$; には文字列しか代入
    できません。1.8 では任意のオブジェクトを代入できますが、
    ((<String#split|String/split>)) の仕様変更を考慮すると
    常に正規表現を指定すべきです。

    なお、互換性を上げるには $; に頼らないのが一番です。

--- $.

    最後に読んだ入力ファイルの行番号を表す整数です。

    ((<ARGF/ARGF.lineno>)) と同じ。各引数ファイル毎の行番号が必要な場合は
    ((<ARGF/ARGF.file>)).((<IO/lineno>)) を使用します。

--- $<

    引数(なければ標準入力)で構成される仮想ファイルです。つまり
    定数 ((<組み込み定数/ARGF>)) の別名。
    (覚え方: (({<}))はシェルの入力元指定)

--- $deferr     ((<ruby 1.8 feature>)) ((<obsolete>))

    Ruby インタプリタが出力するエラーメッセージ、警告メッセージ、
    ((<組み込み関数/warn>)) の出力先。

    この変数には、 (({write})) という名前のメソッドが定義されたオブジェ
    クトだけしか代入できません(warn 等の組み込みのメソッドは、最終的に
    $deferr.write メソッドを呼ぶようになっています)。

    $deferr は $stderr の別名です。$deferr は(新設されたばかりですが)
    ((<obsolete>)) です。

--- $>
--- $defout     ((<obsolete>))

    組み込み関数 ((<組み込み関数/print>))、((<組み込み関数/puts>)) や
    ((<組み込み関数/p>)) などのデフォルトの出力先です。初期値は
    ((<組み込み定数/STDOUT>))。
    ((<Rubyの起動/-i[extension]>)) オプションを指定した場合には読み
    込み元と同じ名前のファイルです。
    (覚え方: (({>}))はシェルの出力先指定)

    この変数には、 (({write})) という名前のメソッドが定義されたオブジェ
    クトだけしか代入できません(print 等の組み込みのメソッドは、最終的に
    write メソッドを呼ぶようになっています)。

    print 等の Ruby の組み込み関数の出力先を変更するにはこの変数の値を別
    の ((<IO>)) に再設定すればよいですが、サブプロセスや C による拡張
    ライブラリの標準出力までも変更したい場合には
    ((<IO#reopen|IO/reopen>)) によって標準出力を別の IO にリダイレクト
    する必要があります。((<組み込み変数/$stdout>)) も参照。

    ((<ruby 1.8 feature>)):

    $defout は $stdout の別名です。$defout は ((<obsolete>)) です。

--- $0
--- $PROGRAM_NAME       ((<ruby 1.8 feature>))

    現在実行中のRubyスクリプトの名前を表す文字列です。OSによってはこの変数に代入すると
    ((<ps(1)|manual page>)) の出力が変化します。この機能はプログラムの
    現在の状態を表示するのに便利です。(覚え方: sh や ksh と同じ)

--- $*

    Rubyスクリプトに与えられた引数を表す配列です。組み込み定数 ((<組み込み定数/ARGV>))
    の別名です。Ruby 自身に対する引数は取り除かれています。
    (覚え方: sh や ksh と同じ)

--- $$

    現在実行中の Ruby プロセスの pid です。(覚え方: シェルと同じ)

    ((<Process/Process.pid>)) と同じです。

--- $:
--- $LOAD_PATH

    ((<組み込み関数/load>))や ((<組み込み関数/require>))
    がファイルをロードする時に検索するディレクトリのリスト
    を含む配列です。
    (覚え方: コロンは環境変数((|PATH|))の区切り文字である)

    起動時には、((<Rubyの起動/-I directory>)) オプションで指定したディ
    レクトリ、環境変数 ((<環境変数/RUBYLIB>)) の値、コンパイル時に指定
    したデフォルト値、"." (カレントディレクトリ) を含みます。
    以下に典型的な UNIX システム上でのロードパスを示します。

      -I で指定したパス
      環境変数 RUBYLIB の値
      /usr/local/lib/ruby/site_ruby/VERSION        サイト固有、バージョン依存のライブラリ
      /usr/local/lib/ruby/site_ruby/VERSION/ARCH   サイト固有、システム依存、拡張ライブラリ
      /usr/local/lib/ruby/site_ruby                サイト固有ライブラリ
      /usr/local/lib/ruby/VERSION                  標準ライブラリ
      /usr/local/lib/ruby/VERSION/ARCH             標準、システム依存、拡張ライブラリ
      .                                            カレントディレクトリ

    ((-デフォルトの順序は 1.6.5 から変更されました-))
    上記表中の VERSION は Ruby のバージョンを表す文字列で、
    「1.6」や「1.8」です。ARCH はハードウェアと OS を表す文字列で、
    「i686-linux」や「alpha-osf5.1」です。
    ((<Config::CONFIG['arch']|Config/arch>)) で得られます。

    コンパイル時のデフォルトパスは多くの UNIX システムでは
    "/usr/local/lib/ruby" です。((<mswin32>))、((<mingw32>))、
    ((<Cygwin>))、((<bccwin32>))、((<mswince>)) 環境では
    ruby.dll の置き場所から相対的に決まります。((<DJGPP>)) と
    ((<emx>)) (OS/2) では ruby.exe の位置から相対的に決まります。

    -T オプションで起動時に ((<組み込み変数/$SAFE>)) を 1 以上に
    設定したときは "." (カレントディレクトリ) はロードパスに入りません。

    (({require 'foo'})) としたとき foo は以下のように .rb, .so を交互
    に探索します。

      /usr/local/lib/ruby/site_ruby/VERSION/foo.rb
      /usr/local/lib/ruby/site_ruby/VERSION/foo.so
      /usr/local/lib/ruby/site_ruby/VERSION/ARCH/foo.rb
      /usr/local/lib/ruby/site_ruby/VERSION/ARCH/foo.so
        :
        :

    共有ライブラリの拡張子が .so でないシステムでは自動的に
    そちらを使います。例えば HP-UX では require 'foo.so'
    とすると foo.sl を検索します。ですから Ruby 内部では
    常に .so を使っておいて構いません。

    なお、ロードパスをコマンドラインから調べるには

      $ ruby -e 'puts $:'

    とします。

--- $"
--- $LOADED_FEATURES    ((<ruby 1.8 feature>))

    ((<組み込み関数/require>)) でロードされたファイル名を含む配列です。
    ((<組み込み関数/require>)) で同じファイルを複数回ロードしない
    ようにするためのロックです。

--- $DEBUG

    この値が真であればデバッグモードになります。
    ((<Rubyの起動/-d>)) オプションでセットされます。

    デバッグモードでは、通常の実行と以下の違いがあります。

    * いずれかのスレッドが例外によって終了した時に、インタプリタ全体
      を中断します。((<Thread/Thread.abort_on_exception>)) を true
      にセットした時と同じ効果がありますが、デバッグモードでは、スク
      リプト中で abort_on_exception= クラスメソッドによってフラグをリ
      セットしても、この効果をなくすことはできません。

      通常の実行では、あるスレッドで起こった例外は、
      ((<Thread#join|Thread/join>)) などで検出されない限り、そのスレッドだ
      けをなにも警告を出さずに終了させます。

    * 捕捉しているかどうかに関りなく、例外が発生した時点で
      それを $stderr にレポートします。処理は続行されます。

--- $FILENAME

    仮想ファイル ((<組み込み定数/ARGF>)) で現在読み込み中の(メソッド
    gets が今読んでいる)ファイル名です。((<ARGF/ARGF.filename>)) と同じです。

--- $stdin
--- $stdout
--- $stderr

    それぞれ 標準入力、標準出力、標準エラー出力です。

    ((<ruby 1.8 feature>))

    $stdout, $stderr は ((<組み込み変数/$defout>)),
    ((<組み込み変数/$deferr>)) の別名です。($defout, $deferr は 
    ((<obsolete>)) になりました)

    $stdout, $stderr に設定されるオブジェクトには write という名の
    メソッドが定義されている必要があります。詳細は
    ((<組み込み変数/$defout>)), ((<組み込み変数/$deferr>)) を参照して
    ください。

    $stdin に関しては $stdout, $stderr のように特定のメソッドを持たな
    くても代入できますが ((<組み込み関数/gets>)) などのメソッドを実行すると
    $stdin に設定されているオブジェクトにそのメソッドを投げます。
    (つまり、$stdin.gets を実行しようとします)

    $stdin に設定されるオブジェクトに定義すべきメソッドは以下です。
    (適宜必要なものを取捨選択してください)

        gets, readline, readlines, getc, readchar, tell, seek,
        pos=, rewind, fileno, to_io, eof, each_line, each_byte,
        binmode, closed?

    例:

        $stdin = Object.new
        def $stdin.gets
          "foo"
        end
        p gets

        # => "foo"

    標準入力、出力、エラー出力のリダイレクトを行いたい場合は、
    ((<IO#reopen|IO/reopen>)) を使用します(1.6 でも同じ)。例えば、

          $stdout = File.open("/tmp/foo", "w")

    は、
          STDOUT.reopen("/tmp/foo", "w")

    とします。リダイレクトを戻したい場合は、

          stdout_sv = STDOUT.dup          # STDOUT を保存
          STDOUT.reopen("/tmp/foo")       # STDOUT を /tmp/foo にリダイレクト

          puts "foo"                      # /tmp/foo に出力

          STDOUT.flush                    # 必要(?)
          STDOUT.reopen(stdout_sv)        # 元に戻す

    とします。ただし、子プロセスにもリダイレクトの影響を与えたいという要
    件がないなら ((<組み込み変数/$stdout>)) 等への代入で十分です。

          # 出力メソッドのデフォルトの出力先を置き換え
          $stdout = File.open("/tmp/foo", "w")

          puts "foo"

          # 出力メソッドのデフォルトの出力先を戻す。
          $stdout = STDOUT

    ((<ruby 1.6 feature>)): $stdin, $stdout, $stderr へ代入を行うと
    リダイレクトの動作をしていました。

    ((<ruby 1.7 feature>)): 暫定的にリダイレクトの挙動が変更されていま
    した((<ruby-dev:14601>))。

--- $VERBOSE

    冗長メッセージフラグです。Rubyインタプリタへの
    ((<Rubyの起動/-v>))オプションでセットされます。

    ((<ruby 1.8 feature>))

    警告レベルは三段階あり、それぞれ以下の通りです。

     * nil: 警告を出力しない
     * false: 重要な警告のみ出力(デフォルト)
     * true: すべての警告を出力する

    コマンドラインオプション ((<Rubyの起動/-W[level]>)) でレベルを指定
    できます。それぞれ、-W0, -W1, -W2 (or -W) が対応します。
    ((<Rubyの起動/-v>)) や ((<Rubyの起動/-w>)) を指定した場合は -W2 と
    同じです。

    nil, false 以外を設定すると値は true になります。

--- $KCODE

    Ruby の認識するマルチバイト文字列エンコーディングです。
    変数の値は "EUC" "SJIS" "UTF8" "NONE" のいずれかの文字列です。

    $KCODE の値が "EUC" のときは文字列や正規表現の
    エンコーディングが EUC-JP であると仮定します。
    同様に "SJIS" のときは Shift JIS を仮定します。
    "UTF8" のときは UTF-8 を仮定します。
    "NONE" のときはマルチバイト文字列を認識しません。

    代入するときには値の最初の 1 バイトしか意味がなく、
    また大文字小文字の違いも無視されます。すなわち、
    "e" "E" は "EUC"、"s" "S" は "SJIS"、
    "u" "U" は "UTF8"、"n" "N" は "NONE" に展開されます。

    デフォルト値は "NONE" です。

    [参考]

    現在の実装では (({$KCODE})) は Ruby の以下の動作に影響します。

      * インタプリタの字句解析器
      * ((<Regexp>)) のエンコーディングフラグのデフォルト値
      * (((<リテラル/正規表現リテラル>))
      * ((<Regexp/Regexp.new>)))
      * ((<String/upcase>))
      * ((<String/downcase>))
      * ((<String/swapcase>))
      * ((<String/capitalize>))
      * ((<String/inspect>))
      * ((<String/split>))
      * ((<String/gsub>))
      * ((<String/scan>))

=== オプション変数

Ruby インタプリタのコマンドライン情報を示す一連の変数があります。
形式は (({$-?})) で ? の部分にオプションの一文字が入ります。

--- $-0

    ((<組み込み変数/"$/">)) の別名です。

--- $-a

    ((<Rubyの起動/-a>)) が指定されている時、真です。リードオ
    ンリー変数です。

--- $-d

    ((<組み込み変数/$DEBUG>)) の別名です。

--- $-F

    ((<組み込み変数/$;>)) の別名です。

--- $-i

    ((<Rubyの起動/-i[extension]>)) が指定されている時、拡張子を表す
    文字列を格納します。指定されていない時の値は (({nil})) です。スクリ
    プト内で代入することもでき、その場合は ((<組み込み定数/ARGV>)) の次の
    ファイルを読み込み始めるタイミングで in-place 置換を開始します。

--- $-I

    ((<組み込み変数/$LOAD_PATH>)) の別名です。

--- $-K

    ((<組み込み変数/$KCODE>)) の別名です。

--- $-l

    ((<Rubyの起動/-l>)) が指定されている時、真です。リードオンリー変数です。

--- $-p

    ((<Rubyの起動/-p>)) が指定されている時、真です。リードオ
    ンリー変数です。

--- $-v
--- $-w

    ((<組み込み変数/$VERBOSE>)) の別名です。

--- $-W         ((<ruby 1.9 feature>))

    ((<Rubyの起動/-W[level]>)) で指定した値を返します。

    つまり、((<組み込み変数/$VERBOSE>)) の値に従って

     * nil: 警告を出力しない -> 0
     * false: 重要な警告のみ出力(デフォルト) -> 1
     * true: すべての警告を出力する -> 2

    のいずれかを返します。リードオンリー変数です。
