= pathname.rb

== Pathname

ѥ̾饹

=== 饹᥽å:

--- Pathname.new(path)

    ʸ path 򸵤 Pathname ֥Ȥ롣

--- Pathname.getwd
--- Pathname.pwd

    Pathname.new(Dir.getwd)

--- Pathname.glob(*args)

    if block_given?
      Dir.glob(*args) {|f| yield Pathname.new(f) }
    else
      Dir.glob(*args).map {|f| Pathname.new(f) }
    end

=== ᥽å:

--- self == other
--- self === other
--- eql?(other)

    ѥ̾ӡother Ʊʤ鿿֤ʸʸ϶̤롣
    other  Pathname ֥ȤǤʤФʤʤ

    ѥ̾Ӥñ˥ѥʸӤˤäƹԤΤŪ
    ƱѥǤۤʤȽǤ롣

        require 'pathname'

        p Pathname.new("foo/bar") == Pathname.new("foo/bar")
        p Pathname.new("foo/bar") == Pathname.new("foo//bar")
        p Pathname.new("foo/../foo/bar") == Pathname.new("foo/bar")

        # => true
             false
             false

--- self <=> other

    ѥ̾ӡother Ʊʤ 0 ASCII self 礭
    other 礭֤ʸʸ϶̤롣

    other  Pathname ֥ȤǤʤФʤʤ

    ѥ̾Ӥñ˥ѥʸӤˤäƹԤΤŪ
    ƱѥǤۤʤȽǤ롣

        require 'pathname'

        p Pathname.new("foo/bar") <=> Pathname.new("foo/bar")
        p Pathname.new("foo/bar") <=> Pathname.new("foo//bar")
        p Pathname.new("foo/../foo/bar") <=> Pathname.new("foo/bar")
        => 0
           1
           -1

--- hash

    ϥå֤ͤ

--- to_s
--- to_str

    ѥ̾ʸ֤

    to_str ϡFile.open ʤɤΰˤΤޤ Pathname ֥Ȥ
    Ϥ褦ѰդƤ롣

        require 'pathname'

        path = Pathname.new("/tmp/hogehoge")
        File.open(path)

--- cleanpath(consider_symlink = false)

    ;פ "."".."  "/"  Pathname ֥Ȥ֤

        require "pathname"
        path = Pathname.new("//.././../")
        p path                  # => #<Pathname://.././../>
        p path.cleanpath        # => #<Pathname:/>

    consider_symlink ʤѥǤ˥ܥå󥯤ä
    ˤʤ褦 .. Ĥ

    cleanpath ϡºݤ˥ե륷ƥ򻲾Ȥ뤳Ȥʤʸ
    ǽԤ

        require 'pathname'

        Dir.rmdir("/tmp/foo")      rescue nil
        File.unlink("/tmp/bar/foo") rescue nil
        Dir.rmdir("/tmp/bar")      rescue nil

        Dir.mkdir("/tmp/foo")
        Dir.mkdir("/tmp/bar")
        File.symlink("../foo", "/tmp/bar/foo")
        path = Pathname.new("bar/././//foo/../bar")

        Dir.chdir("/tmp")

        p path.cleanpath
        p path.cleanpath(true)

        => ruby 1.8.0 (2003-10-10) [i586-linux]
           #<Pathname:bar/bar>
           #<Pathname:bar/foo/../bar>

--- realpath(force_absolute = true)

    ;פ "."".."  "/"  Pathname ֥Ȥ֤

    ե륷ƥ򥢥ºݤ¸ߤѥ֤
    ܥå󥯤褵롣

    force_absolute ξ硢Хѥ֤self ХѥǤС
    ȥǥ쥯ȥ꤫ХѥȤƲᤵ롣

    self ؤѥ¸ߤʤ㳰 
    ((<Errno::ENOENT|Errno::EXXX>)) ȯ롣

        require 'pathname'

        Dir.rmdir("/tmp/foo")      rescue nil
        File.unlink("/tmp/bar/foo") rescue nil
        Dir.rmdir("/tmp/bar")      rescue nil

        Dir.mkdir("/tmp/foo")
        Dir.mkdir("/tmp/bar")
        File.symlink("../foo", "/tmp/bar/foo")
        path = Pathname.new("bar/././//foo/../bar")

        Dir.chdir("/tmp")

        p path.realpath
        p path.realpath(false)

        => ruby 1.8.0 (2003-10-10) [i586-linux]
           #<Pathname:/tmp/bar>
           #<Pathname:bar>

--- parent

    self οƥǥ쥯ȥؤ Pathname ֥Ȥ֤

--- mountpoint?

    self ޥȥݥȤǤп֤

--- root?

    self 롼ȥǥ쥯ȥǤп֤ȽǤʸˤ
    ƹԤ졢ե륷ƥϥʤ

--- absolute?

    self ХѥǤп֤

--- relative?

    self ХѥǤп֤

--- each_filename {|v| ... ]

    self Υѥ̾˥֥å¹Ԥ롣

        require 'pathname'

        Pathname.new("/foo/../bar").each_filename {|v| p v}

        # => "foo"
             ".."
             "bar"

--- self + other

    ѥ̾Ϣ뤹롣Ĥޤꡢother  self ХѥȤ 
    Pathname ֥Ȥ֤

    other Хѥʤñ other  Pathname ֥ȤȤ֤

    other ʸ Pathname ֥ȡ

--- children

    self ۲ˤѥ̾(Pathname֥)֤

        require 'pathname'

        p Pathname.new("/tmp").children
        => ruby 1.8.0 (2003-10-10) [i586-linux]
           [#<Pathname:.X11-unix>, #<Pathname:.iroha_unix>, ... ]

    ".", ".." Ǥ˴ޤޤʤ

    self ¸ߤʤѥǤäǥ쥯ȥǤʤ㳰 
    ((<Errno::EXXX>)) ȯ롣

--- relative_path_from(base_directory)

    base_direcoty  self ؤХѥ Pathname ֥Ȥ
    ֤

    ѥ̾βʸˤäƹԤ졢ե륷ƥ򥢥
    ʤ

        require 'pathname'

        path = Pathname.new("/tmp/foo")
        base = Pathname.new("/tmp")

        p path.relative_path_from(base)

        # => ruby 1.8.0 (2003-10-10) [i586-linux]
             #<Pathname:foo>

    self Хѥʤ base_directory Хѥself Хѥʤ 
    base_directory ХѥǤʤФʤʤ

    base_directory  Pathname ֥ȤǤʤФʤʤ

--- each_line(*args, &block)
    IO.foreach(self.to_s, *args, &block)

--- read(*args)
    IO.read(self.to_s, *args)

--- readlines(*args)
    IO.readlines(self.to_s, *args)

--- sysopen(*args)
    IO.sysopen(self.to_s, *args)

--- atime()
    File.atime(self.to_s)

--- ctime()
    File.ctime(self.to_s)

--- mtime()
    File.mtime(self.to_s)

--- chmod(mode)
    File.chmod(mode, self.to_s)

--- lchmod(mode)
    File.chmod(mode, self.to_s)

--- chown(owner, group)
    File.chown(owner, group, self.to_s)

--- lchown(owner, group)
    File.lchown(owner, group, self.to_s)

--- fnmatch(pattern, *args)
    File.fnmatch(pattern, self.to_s, *args)

--- fnmatch?(pattern, *args)
    File.fnmatch?(pattern, self.to_s, *args)

--- ftype()
    File.ftype(self.to_s)

--- link(old)
    File.link(old, self.to_s)

--- open(*args, &block)
    File.open(self.to_s, *args, &block)

--- readlink()
    Pathname.new(File.readlink(self.to_s))

--- rename(to)
    File.rename(self.to_s, to)

--- stat()
    File.stat(self.to_s)

--- lstat()
    File.lstat(self.to_s)

--- symlink(old)
    File.symlink(old, self.to_s)

--- truncate(length)
    File.truncate(self.to_s, length)

--- utime(atime, mtime)
    File.utime(atime, mtime, self.to_s)

--- basename(*args)
    Pathname.new(File.basename(self.to_s, *args))

--- dirname()
    Pathname.new(File.dirname(self.to_s))

--- extname()
    File.extname(self.to_s)

--- expand_path(*args)
    Pathname.new(File.expand_path(self.to_s, *args))

--- join(*args)
    Pathname.new(File.join(self.to_s, *args))

--- split()
    File.split(self.to_s)

--- blockdev?()
    FileTest.blockdev?(self.to_s)

--- chardev?()
    FileTest.chardev?(self.to_s)

--- executable?()
    FileTest.executable?(self.to_s)

--- executable_real?()
    FileTest.executable_real?(self.to_s)

--- exist?()
    FileTest.exist?(self.to_s)

--- grpowned?()
    FileTest.grpowned?(self.to_s)

--- directory?()
    FileTest.directory?(self.to_s)

--- file?()
    FileTest.file?(self.to_s)

--- pipe?()
    FileTest.pipe?(self.to_s)

--- socket?()
    FileTest.socket?(self.to_s)

--- owned?()
    FileTest.owned?(self.to_s)

--- readable?()
    FileTest.readable?(self.to_s)

--- readable_real?()
    FileTest.readable_real?(self.to_s)

--- setuid?()
    FileTest.setuid?(self.to_s)

--- setgid?()
    FileTest.setgid?(self.to_s)

--- size()
    FileTest.size(self.to_s)

--- size?()
    FileTest.size?(self.to_s)

--- sticky?()
    FileTest.sticky?(self.to_s)

--- symlink?()
    FileTest.symlink?(self.to_s)

--- writable?()
    FileTest.writable?(self.to_s)

--- writable_real?()
    FileTest.writable_real?(self.to_s)

--- zero?()
    FileTest.zero?(self.to_s)

--- rmdir()
    Dir.rmdir(self.to_s)

--- entries()
    Dir.entries(self.to_s)

--- each_entries(&block)
    Dir.foreach(self.to_s) {|f| yield Pathname.new(f) }

--- mkdir(*args)
    Dir.mkdir(self.to_s, *args)

--- opendir(&block)
    Dir.open(self.to_s, &block)

--- find(&block)

    require 'find'
    Find.find(self.to_s) {|f| yield Pathname.new(f) }

--- mkpath
    require 'fileutils'
    FileUtils.mkpath(self.to_s)

--- rmtree
    require 'fileutils'
    FileUtils.rm_r(self.to_s)

--- unlink
--- delete
    self ؤǥ쥯ȥꤢ뤤ϥե롣
