= Vector

[2002-04-03]  by ((<|URL:mailto:sugawah@attglobal.net>))

 ((<Numeric>)) ǤȤ٥ȥ򰷤饹

# ((-Vector饹ˤϱѸΥɥȤۤȤɤʤΤǡѸäƤߤޤȤꤢˤƤơΤѸǤʬΥޤ-))

== ȤUsage

Vector饹Ȥˤϡrequire 'matrix'ɬפ롣

    require 'matrix'


== 󥹥 Instance Creation

--- Vector.[](a)
#    Creates a new vector object, populated by elements of `a'.

    aǤȤ٥ȥ롣

--- Vector.elements(a, copy = true)
#    Creates a vector object, populated by elements of `a'.
#    A new object is created if `copy' is false.
    
    aǤȤ٥ȥ롣
    ץcopy(false)ʤСʣԤʤ

== ɤ߽Ф񤭹 Accessing
--- Vector#[](i)
#    Returns the i-th element. The index starts from 0.

    iܤǤ֤ǥå0鳫Ϥ롣

--- Vector#size
#    Returns the size of the vector

    ٥ȥ礭֤

--- Vector#[]=(i,x)
    iܤǤxѹ롣

Υ᥽åɤϡmatrix.rbƤʤ
ʲˡȻ򼨤

    require 'matrix'

    class Vector
      def []=(i,x)
        @elements[i]=x
      end
    end

    v=Vector[1,2,3]
    v[2]=-1
    p v #=> Vector[1,2,-1]


== 黻 Arithmatics
--- Vector#* a
#    returns a vector multiplied by scalar `a'

    a褸٥ȥ֤

--- Vector#* m
#    returns a vector multiplied by matrix `m' from right side.

    ٥ȥ()Ѵ(ºݤˤ((<Matrix#column_vector|Matrix/column_vector>))(self)Ŭ)顢m򱦤褸(((<Matrix>))饹)֤

--- Vector#+ v
#    plus

    ٥ȥvä٥ȥ֤

--- Vector#- v
#    minus

    ٥ȥv򸺤٥ȥ֤

== ٥ȥФؿ Vector Functions
--- Vector#inner_product(v)
#    Returns an inner product with `v'

    ٥ȥvȤѤ֤

--- Vector#r
#    Returns the absolute value.

    ٥ȥ֤ͤ
    ٥ȥͤϡǤΣ¤ʿäΤǤ롣

== ƥ졼 Iterators

--- Vector#collect {|x| ... }
--- Vector#map {|x| ... }
#    returns a new vector with the results of running block once for every elements.

    ٥ȥγǤФƥ֥åɾ̤ǤȤƻĥ٥ȥ롣

--- Vector#each2(v) {|x,y| ... }
#    Calls dyadic((-=of two parameters-)) block once for each correspoding elements of `self' and `v'.

    ٥ȥγǤȡб륤ǥåİvǤȤȤФ(2)֥å֤ɾ롣`v'size᥽åɤ[]᥽åɤĥ֥ȤǤ롣((-size᥽åɤ[]᥽åɤĤȤäArray饹ȤƤ褤ΤǤ礦?  ñ󥯥饹Ƚ񤱤Ȥ줷Ǥ-))

--- Vector#collect2(v) {|x,y| ... }
#    Applies dyadic block to corresponding elements of `self' and `v', and returns a new Array object of the results.
 
    ٥ȥγǤȡб륤ǥåİvǤȤȤФ(2)֥åɾη̤ǤȤƻ롣

--- Vector#map2(v) {|x,y| ... }
#    Applies dyadic block to corresponding elements of `self' and `v', and returns a new Vector object of the results.

    ٥ȥγǤȡб륤ǥåİ()ǤȤȤФ(2)֥åɾ̤ǤȤƻĥ٥ȥ֤

ϡĤΥ٥ȥѤȤ롣

    require 'matrix'

    v = Vector[2,3,5]
    w = Vector[7,9,11]
    z1 = v.collect2(w){|x,y| x*y } 
    z2 = v.map2(w) {|x,y| x*y }

    p z1 #=> [14, 27, 55]
    p z2 #=> Vector[14, 27, 55]


== Ѵ Converting
--- Vector#covector
#    Converts to the column vector, i.e., n-by-1 matrix.

    ٥ȥ()ʤ(n,1)ιѴ롣
    ºݤˤ((<Matrix#row_vector|Matrix/row_vector>))(self)ŬѤ롣

--- Vector#to_a
#    Converts to Array

    (((<Array>)))Ѵ

--- Vector#to_f
#    Converts each element to Float

    Ǥư(((<Float>)))Ѵ

--- Vector#to_i
#    Converts each element to Integer

    Ǥ(((<Integer>)))Ѵ

--- Vector#to_r
#    Converts each element to Rational

    Ǥͭ(((<Rational>)))Ѵ


== Complex饹Ȥʻ Working with Complex class

#"require 'complex'" extends every elements of Vector object to Complex class.
#Most of the methods of Matrix class works as expeced in this extended Vector class.

require 'complex'뤳Ȥˤäơ
Vector֥ȤǤ((<Complex>))饹˳ĥ롣
¿Υ᥽åɤϡγĥ줿Vector饹Ǥ⡢̤ư롣

#The following example illustrates Vector#conjugate method which replaces every lements into its conjugate.

ϡǤʣǿִ᥽å(Vector#conjugate)Ǥ롣

    require 'matrix'
    require 'complex'

    class Vector
      def conjugate
        collect{|e| e.conjugate }
      end
    end

    v1 = Vector[Complex(1,1),Complex(2,2),Complex(3,3)]
    v2 = v1.conjugate
    p v2 #=> Vector[Complex(1,-1),Complex(2,-2),Complex(3,-3)]
    v3 = v1+v2
    p v3 #=> Vector[Complex(1,0),Complex(2,0),Complex(3,0)]

#Some methods, however, fails work as expected in this extendend class.
#For instance, Vector#r method, which returns the absolute value (norm) of `self', may raise exception when it invokes Math#square method to the sum of the square of each element.  

ComplexǤ˳ĥ줿Vector饹ǡ
̤ưʤ᥽åɤ⤢롣
㤨С٥ȥͤ((<Vector#r|Vector/r>))᥽åɤϡ
Ǥ2¤ʿ((<Math#sqrt|Math/sqrt>))뤬
ΤȤ㳰ȯǽ롣

#Vector#abs method defined in the following list shows the right way to give the absolute value of `self', where Math#square method is applied to the sum of the square of the absolute value of each element.

ʣǿǤȤ٥ȥͤ뤿ˤϡ
Ǥͤ2¤ȤʤƤϤʤʤ( Vector#abs᥽åɡˡ


    require 'matrix'
    require 'complex'

    class Vector
      def abs
        r=0
        @elements.each{|e| r += e.abs2 }
        Math.sqrt(r)
      end
    end

    v = Vector[Complex(1,1),Complex(2,2),Complex(3,3)}
    p v.abs #=> 5.291502622 # Math.sqrt(28)
    p v.r   #=> 'sqrt': undefined method `Rational'


== ChangeLog

*[2002-04-03] by ((<|URL:mailto:sugawah@attglobal.net>))
  * Ȥɲ
  * Working with Complex classɲ
  * []=᥽åɤɲ
  * ƥ졼طƱˤޤȤ᤿ collect, map, each2, collect2, map2
  * ľ Ȥeach2, collect2, map2
  * ¾饹ؤΥ󥯤ɲ Numeric, Matrix 
*[2002-04-02]  by ((<|URL:mailto:sugawah@attglobal.net>))



