# -*- ruby -*-

require 'xtemplate'
require 'xtemplate/hash'

module XTemplate
  class ProcConnector
    include XData
    include XPath

    def initialize(&block)
      @proc = block
    end

    def to_hash
      Hash.new{|h,k|
	unless( k == ParentNode )
	  h[k] = @proc.call(k)
	end
      }
    end
  end

  class ObjectConnector
    include XData

    def ObjectConnector.[](*objs)
      objs.collect{|obj| ObjectConnector.new(obj)}
    end

    def initialize(obj, idmap=nil)
      @obj   = obj
      @idmap = idmap || Hash[*(@obj.methods.collect{|s| [s,s.intern]}.flatten)]
    end

    def to_hash
      h = @idmap.to_a.collect{|id,sym|
	[
	  id,
	  if( @obj.method(sym).arity == 0 )
	    ProcConnector.new{|k| @obj.__send__(sym) }.to_hash
	  else
	    ProcConnector.new{|k| @obj.__send__(sym,k) }.to_hash
	  end
	]
      }
      Hash[*(h.flatten)]
    end
  end
end

if( __FILE__ == $0 )
  include XTemplate

  text = <<EOF
<?xml version="1.0"?>
<members id="members">
  <member id="member{attr(uid)}">
    <name id="name" />
  </member>
</members>
EOF

  obj = XTemplate::ProcConnector.new{|key|
    case key
    when "member"
      ary = [
	{"name" => "name1", "uid" => 1},
	{"name" => "name2", "uid" => 2},
	{"name" => "name3", "uid" => 3},
      ]
      ary
    else
      nil
    end
  }
  data = {'members' => obj}

  print(XMLTemplate.new(text).expand(data))



  text = <<EOF
<?xml version="1.0"?>
<members id="members{member}">
  <member id="member" uid="@{uid}">
    <name id="name" />
  </member>
</members>
EOF

  class Person
    attr_reader :name, :uid
    def initialize(name,uid)
      @name = name
      @uid  = uid
    end
  end
  data = {'members' => ObjectConnector[
      Person.new('name1',1),
      Person.new('name2',2),
      Person.new('name3',3),
    ]}


  print(XMLTemplate.new(text).expand(data))
end
