require 'runit/testcase'
require 'runit/cui/testrunner'

require 'c2t'

class Foo
  def initialize
  end
  def foo
  end
  def Foo.bar
  end
end

module ModuleTestC2T
  def foo
  end
end

class TestC2T < RUNIT::TestCase
  def setup
    @c2t = C2T.new
  end

  def test_test_method_name
    assert_equal('test_foo', @c2t.test_method_name('foo'))
    assert_equal('test_MUL # \'*\'', @c2t.test_method_name('*'))
  end

  def test_test_singleton_method_name
    assert_equal('test_s_foo', @c2t.test_singleton_method_name('foo'))
  end

  def test_def_test_method
    expected = <<STR

  def test_foo
    assert_fail("untested")
  end
STR
    assert_equal(expected, @c2t.def_test_method('test_foo'))
  end

  def test_test_class_name
    assert_equal('TestFoo', @c2t.test_class_name('Foo'))
    assert_equal('TestFoo__Bar', @c2t.test_class_name('Foo::Bar'))
  end

  def test_def_test_class
    expect = 'class TestFoo < RUNIT::TestCase'
    assert_equal(expect, @c2t.def_test_class('Foo'))
  end

  def test_def_test_singleton_methods
    expect = <<STR

  def test_s_bar
    assert_fail("untested")
  end
STR
    assert_equal(expect, @c2t.def_test_singleton_methods(Foo))
  end

  def test_def_test_initialize_method
    expect = <<STR

  def test_s_new
    assert_fail("untested")
  end
STR
    assert_equal(expect, @c2t.def_test_initialize_method(Foo))
  end

  def test_def_test_instance_methods
    expect = <<STR

  def test_foo
    assert_fail("untested")
  end
STR
    assert_equal(expect, @c2t.def_test_instance_methods(Foo))
  end

  def test_c2t
    expect = <<STR
class TestFoo < RUNIT::TestCase

  def test_foo
    assert_fail("untested")
  end

  def test_s_new
    assert_fail("untested")
  end

  def test_s_bar
    assert_fail("untested")
  end

end
STR
    assert_equal(expect, @c2t.c2t(Foo))

    expect = <<STR
class TestModuleTestC2T < RUNIT::TestCase

  def test_foo
    assert_fail("untested")
  end

end
STR
    assert_equal(expect, @c2t.c2t(ModuleTestC2T))

    expect = <<STR
class TestBar < RUNIT::TestCase

end
STR
    assert_equal(expect, @c2t.c2t('Bar'))

  end

end

class TestTestFrame < RUNIT::TestCase
  def setup
    @tf = TestFrame.new
  end
  def test_require_frame
    expected = <<STR
require 'rubyunit'
STR
    assert_equal(expected, @tf.require_frame)
  end

  def test_require_target
    expected = 'require \'foo\''
    assert_equal(expected, @tf.require_target('foo'))
  end

end

if $0 == __FILE__
  RUNIT::CUI::TestRunner.run(TestC2T.suite)
  RUNIT::CUI::TestRunner.run(TestTestFrame.suite)
end

