=begin
= Ruby GetText Package

== What is Ruby GetText Package? 
Ruby GetText Package is Native Language Support Library and Tools which modeled after GNU gettext package, but is not a wrapper of GNU GetText.

== Requirements
* Ruby 1.6.6 or later<http://www.ruby-lang.org/ja/>
* Iconv module(and iconv) (Option)
  Iconv is standard library on Ruby 1.7.x. But on Ruby 1.6.x, you should get it yourself.
  <http://www.ruby-lang.org/en/raa-list.rhtml?name=iconv>
* GNU gettext 0.10.35 or later(Development times only)
  <http://www.gnu.org/software/gettext/gettext.html>

== Download
((<ruby-gettext-package-((VERSION)).tar.gz|URL:http://home2.highway.ne.jp/mutoh/tools/ruby/ruby-gettext-package-((VERSION)).tar.gz>))

== Install
De-Compress archive and enter its top directory.
Then type:

    # ruby install.rb config
    # ruby install.rb setup
    # ruby install.rb install

You can also install files in your favor directory by
supplying install.rb some options. Try "ruby install.rb --help".

== Basic term explanation
:pot-file, po-file
  They are the text files with msgid(Original message) and msgstr(Translated message). You can create it with rgettext from your script file.
:mo-file
  This is binary files which created from po-files by msgfmt.

:domain(TextDomain)
  domain is just mo-file name. Usually, it is called PACKAGE(like in GNOME). 

== API Reference
=== module GetText
--- GetText.bindtextdomain(domainname, path = nil, locale = nil, charset = nil)
     Bind TextDomain to #{path}/#{locale}/LC_MESSAGES/#{domainname}.mo
     *path - When value is nil, it is search in /usr/share/locale, /usr/local/share/locale)
     *locale - When value is nil, it is searched in ENV(LC_ALL > LC_CTYPE > LC_MESSAGES > LANG > System Default Language).
     *charset - output charset. When value is nil, it is searched in ENV(OUTPUT_CHARSET). If ENV is not set, return a charset by system APIs(Win32 is used GetACP(), POSIX is used nl_langinfo).

--- GetText._(msgid)
--- GetText.gettext(msgid)
    Return localized text by msgid. If there are not binded mo-file, it will return msgid.

--- GetText.N_(msgid)
    Return msgid. This method does nothing. But it is required in order to recognize the msgid by rgettext.

--- GetText.locale=(locale)
     Set locale(String) like "C", "de", "fr", "it", "ko", "ja_JP.eucJP", "zh_CN.EUC" ... 

--- GetText.charset=(charset)
     Set charset(String) like "euc-jp", "sjis", "CP932", "utf-8", ... 

== rgettext
rgettext is the tool which create po-files from your Ruby Scripts.

=== Usage
  $rgettext hoge.rb -o hoge.po

== Development procedure

=== Create hello.rb
For example, write hello.rb as follows.

  require 'gettext'

  include GetText

  bindtextdomain("hello")
  print _("Hello World\n")

=== Pick up strings in the script(create a po-file)
Create a po-file with rgettext.

  $rgettext hello.rb -o hello.pot

=== Translate hello.pot into <your language>.po.
This example for Japanese(not 2-byte string but 1-byte alphabet).

  $cp hello.pot ja.po

Then edit ja.po as follows.

  "Content-Type: text/plain; charset=euc-jp\n"
  
  #: ../hello.rb:7
  msgid "Hello World\n"
  msgstr "KON-NICHI-WA SEKAI\n"

Header part is also important. Especially Content-Type is indispensable.

In addition, you can use the some tools in GNU gettext package for maintainig po-file.

==== * How to use GetText.n_(msgid, msgid_plural, n)
For plural forms, there is GetText.n_().
This is just like ((<ngettext family|URL:http://www.gnu.org/manual/gettext/html_node/gettext_150.html#SEC150>)) of
GNU GetText Package.

  require 'gettext'

  include GetText
  bindtextdomain("plural")
  (0..10).each do |n|
    printf n_("%d file was removed", "%d files were removed", n), n)
  end

The information about the plural form selection has to be stored in the header entry of the PO file.
The plural form information looks like this:  

  "Plural-Forms: nplurals=2; plural=n == 1 ? 0 : 1;\n"

The nplurals value is number of msgstr. The string following plural is an expression which is using the Ruby language syntax. 

==== * How to use GetText.N_(msgid)
GetText.N_(msgid) is used with GetText._(msgid).

  require 'gettext'

  include GetText
  bindtextdomain("hello_noop")

  msgs = [N_("Hello World"), N_("Hello World2")]

  msgs.each do |msg|
    print _(msg), "\n"
  end

In this case, rgettext can not recognize _(msg) as msgid.
But since you use GetText.N_(msgid) to define the messages, it is recognized as msgid by rgettext.

==== * If are there "fuzzy" comments?
If po-file have some fuzzy comments as follows:

  #: hello.rb:7
  #, fuzzy
  msgid "Hello World"
  msgstr "KON-NICHI-WA SEKAI"

Then confirm the messages(msgid and msgstr) are correct, and remove "fuzzy" line.

  #: hello.rb:7
  msgid "Hello World"
  msgstr "KON-NICHI-WA SEKAI"

=== Make a mo-file.
Finally, you make a mo-file, and put it into a path properly.
In this example, you don't set path in bindtextdomain(), GetText search mo-file in /usr/share/locale/#{lang}/LC_MESSAGES/ or /usr/local/share/locale/#{lang}/LC_MESSAGES/. So you put it into one of them.
Here, you put it into /usr/local/share/locale/ja/LC_MESSAGES/.

  $msgfmt ja.po -o /usr/local/share/locale/ja/LC_MESSAGES/

=== Run the script
  $ruby hello.rb

Is it OK? Congratulations!

If you can't show the messages in your language, execute it with -d option.

  $ruby -d hello.rb
  Search path:["/usr/share/locale", "/usr/local/share/locale"]
  locale:"ja_JP.eucJP"

  MO file is not found in
        /usr/share/locale/ja_JP.eucJP/LC_MESSAGES/hello.mo
        /usr/share/locale/ja_JP/LC_MESSAGES/hello.mo
        /usr/share/locale/ja/LC_MESSAGES/hello.mo
        /usr/local/share/locale/ja_JP.eucJP/LC_MESSAGES/hello.mo
        /usr/local/share/locale/ja_JP/LC_MESSAGES/hello.mo
        /usr/local/share/locale/ja/LC_MESSAGES/hello.mo

Check hello.mo is in one of those pathes.
#You can't show the messages yet...  There are some other reasons but I don't know...:-<.

== Difference from GNU gettext
 *bindtextdomain has locale argument.
 *do not exist a method same as textdomain function.
 *do not support category.

== License
This program is licenced under the same licence as Ruby.
(See the file 'COPYING'.)

=== mo.rb
Copyright (C) 2001,2002 Masahiro Sakai <s01397ms@sfc.keio.ac.jp>, Masao Mutoh <mutoh@highwhay.ne.jp>

=== gettext.rb
Copyright (C) 2001,2002 Masahiro Sakai <s01397ms@sfc.keio.ac.jp>, Masao Mutoh <mutoh@highwhay.ne.jp>

=== rgettext 
Copyright (C) 2001,2002 Yasushi Shoji  <yashi@yashi.com>, Masao Mutoh <mutoh@highwhay.ne.jp>

=== install.rb
Copyright (C) 2000,2001 Minero Aoki <aamine@loveruby.net>
This file is released under LGPL. See the top of the install.rb.

=== others
Copyright (C) 2001,2002 Masao Mutoh <mutoh@highwhay.ne.jp>

== Maintainer
Masao Mutoh <mutoh@highway.ne.jp>

$Id: ruby-gettext.rd,v 1.23 2002/10/22 11:24:10 mutoh Exp $
=end
