require "kconv"
require "net/smtp"
require "tmail/mail"

module Dpklib_TMail
  class MailAddress < Struct.new(:address, :phrase)
    def tmail_address
      addr = TMail::Address.new(nil, nil)
      addr.addr = self.address
      if self.phrase then
        addr.phrase = Kconv::tojis( self.phrase )
      end
      addr
    end
  end #/MailAddress

  class << MailAddress
    def [](addr)
      case addr
      when self
        addr
      when String
        self.new(addr)
      else
        raise(TypeError,
              "not MailAddress or address string: #{addr.inspect}")
      end
    end
  end #/<< MailAddress

  class Message
    attr_accessor :body
    attr_accessor :subject
    attr_accessor :date
    attr_accessor :tmail_prototype
    attr_accessor :sender
    attr_accessor :smtp_host
    attr_accessor :smtp_port
    attr_reader :from
    attr_reader :to
    attr_reader :cc
    attr_reader :bcc
    attr_reader :reply_to

    def initialize
      @from = []
      @to = []
      @cc = []
      @bcc = []
      @reply_to = []
      @date = Time.now
      @body = nil
      @subject = nil
      @tmail_prototype = nil
      @sender = nil
      @smtp_host = "localhost"
      @smtp_port = 25
    end

    def send
      Net::SMTP.start(@smtp_host, @smtp_port) { |smtp|
        smtp.send_mail(encoded, sender, *rcpt)
      }
    end

    def receivers
      @to + @cc + @bcc
    end

    def rcpt
      receivers.collect { |addr|
        MailAddress[addr].address
      }
    end

    def sender
      if @sender then
        @sender
      else
        sender = @from[0]
        sender ? MailAddress[sender].address : ""
      end
    end

    def encoded
      compose.encoded
    end

    def compose
      mail = new_tmail

      conv = proc {|s| Kconv::tojis(s); }
      @subject && mail.subject = conv[@subject]
      if @body then
        body_port = mail.body_port
        body_port.wopen.write conv[@body]

        mail.set_content_type "text", "plain", {"charset"=>"ISO-2022-JP"}
        mail.encoding = "7bit"
      end

      tmail_addrs = proc { |addrs|
        addrs.collect { |addr|
          MailAddress[addr].tmail_address
        }
      }

      @from.empty? || mail.from_addrs = tmail_addrs[ @from ]
      @to.empty? || mail.to_addrs = tmail_addrs[ @to ]
      @cc.empty? || mail.cc_addrs = tmail_addrs[ @cc ]
      @reply_to.empty? || mail.reply_to_addrs = tmail_addrs[ @reply_to ]
      @date && mail.date = @date
      
      mail
    end

    protected
    def new_tmail
      mail = nil
      if @tmail_prototype then
        # deep copy
        mail = @tmail_prototype.encoded
        mail = TMail::Mail.parse(mail)
      else
        mail = TMail::Mail.new
      end
      mail
    end
  end #/Message

end #/Dpklib_TMail
