=begin
=TS_Lapidary.rb
The Lapidary test suite.
=end

#<standard_header>
#
# Copyright (C) 2000-2001 Nathaniel Talbott
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#</standard_header>
require 'Lapidary/TC_TestCase'
require 'Lapidary/TestResult'
require 'Lapidary/TC_Assertions'
require 'Lapidary/TC_TestResult'
require 'Lapidary/TC_TestSuite'
require 'Lapidary/UI/Util/TS_Utilities'
require 'Lapidary/UI/Console/TestRunner'

module Lapidary
	class TS_Lapidary
		def initialize
			@tests = [Lapidary::TC_TestCase.suite(),
				Lapidary::TC_Assertions.suite(), 
				Lapidary::TC_TestResult.suite(),
				Lapidary::TC_TestSuite.suite(),
				Lapidary::UI::Util::TS_Utilities.suite()]
		end
		def TS_Lapidary.suite
			return new
		end
		def run(result, &progressBlock)
			@tests.each {
				|test|
				if ( test.respond_to?(:name) )
					progressBlock.call("Running #{test.name}...") if (progressBlock != nil)
					test.run(result)
				else
					test.run(result, &progressBlock)
				end
			}
		end
		def size
			size = 0
			@tests.each {
				| test |
				size += test.size
			}
			size
		end
	end
end

if __FILE__ == $0
	Lapidary::UI::Console::TestRunner.run(Lapidary::TS_Lapidary)
end
