=begin
=Tuner.rb
A utility class for generic publish/subscribe.
=end

#<standard_header>
#
# Copyright (C) 2000-2001 Nathaniel Talbott
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#</standard_header>

module Lapidary
	module UI
		module Util
			class Tuner
				def initialize
					@channels = Hash.new
				end
				def addListener(channel, proc)
					return if ( proc.nil? )
					if ( proc.arity < -1 || proc.arity > 1 )
						raise ArgumentError.new("Cannot connect a proc with #{proc.arity} arity to the tuner")
					end
					if ( @channels[channel].nil? )
						@channels[channel] = Array.new
					end
					@channels[channel] << proc
				end
				def removeListener(channel, proc)
					@channels[channel].delete(proc)
				end
				def update(channel, value=nil)
					if ( ! @channels[channel].nil? )
						@channels[channel].each {
							| proc |
							if (proc.arity == 0)
								proc.call
							else
								proc.call(value)
							end
						}
					end
				end
			end
		end
	end
end
