require 'digest/md5'
require 'rubyunit'

require 'dpklib/shadow'

class TESTCASE_ShadowPassword < RUNIT::TestCase
  def test_it
    username = "rubychan"
    password = "rubychan-dayo"
    
    verify = proc { |verifier|
      assert verifier.verify(username, password)
      assert ! verifier.verify(username, "mattakuchigau")
      assert ! verifier.verify("zenzenchigau", password)
    }
    
    shadow = Dpklib::ShadowPasswordEntry.create(username, password).to_s
    entry = Dpklib::ShadowPasswordEntry.parse(shadow)
    verify[entry]

    manager = Dpklib::ShadowPasswordManager.new
    manager.add entry
    verify[manager]
  end
end #/TESTCASE_ShadowPassword
