require "rubyunit"
require "dpklib/format"

class TESTCASE_Format < RUNIT::TestCase
  class TestFormat < Dpklib::Format
    def parse(str)
      str.to_i
    end

    def format(obj)
      obj.to_s
    end
    Dpklib.install_singleton_format_and_parse(self)
  end #/TestFormat

  class InheritedFormat < TestFormat
    def parse(str)
      str + ":inherited"
    end

    Dpklib.install_singleton_format_and_parse(self)
  end #/InheritedFormat

  def test_it
    format = TestFormat.new
    assert_equals 2, format.parse("2")
    assert_equals "2", format.format(2)
    
    assert_equals format.parse("2"), TestFormat.parse("2")
    assert_equals format.format(2), TestFormat.format(2)
  end

  def test_inherit
    assert_equals "15:inherited", InheritedFormat.parse("15")
  end
end #/TESTCASE_Format

class TESTCASE_DecimalFormat < RUNIT::TestCase
  def test_it
    assert_equals([1, 2],
                  Dpklib::DecimalFormat.decimal_array([1, "2"])
                  )
  end
end #/TESTCASE_DecimalFormat

class TESTCASE_HashedFormat < RUNIT::TestCase
  class TestHashedFormat < Dpklib::HashedFormat
    def format_unknown_object(object)
      "UNKNOWN"
    end
  end #/TestHashedFormat

  def test_it
    format = TestHashedFormat.new(1 => "one", 2 => "two")
    assert_equals "one", format.format(1)
    assert_equals "two", format.format(2)
    assert_equals "UNKNOWN", format.format(3)
  end
end #/TESTCASE_HashedFormat

class TESTCASE_EnumFormat < RUNIT::TestCase
  class TestEnumFormat < Dpklib::EnumFormat
    def format_unknown_object(object)
      "UNKNOWN"
    end
  end #/TestEnumFormat

  def test_it
    format = TestEnumFormat.new(1, "one", "two")
    assert_equals "one", format.format(1)
    assert_equals "two", format.format(2)
    assert_equals "UNKNOWN", format.format(3)
    assert_equals "UNKNOWN", format.format(nil)
    assert_equals "UNKNOWN", format.format("?")
  end
end #/TESTCASE_EnumFormat

class TESTCASE_BitArrayFormat < RUNIT::TestCase
  def test_it
    assert_equals [true, false, true], Dpklib::BitArrayFormat.parse("101")
    assert_equals "001", Dpklib::BitArrayFormat.format([false, false, true])
  end
end #/TESTCASE_BitArrayFormat
