require 'dpklib/webrick+/action-cgi'
require 'webrick/httpservlet/abstract'
require 'webrick/httpservlet/filehandler'
require 'webrick/httputils'

module Dpklib_WEBrick
  class MIMEActionHandler < WEBrick::HTTPServlet::AbstractServlet
    def initialize(server, local_path)
      super
      @server = server
      @local_path = local_path
      @action_script_dir = @config[:MIMEActionScriptDir]
      @action_script_dir || raise("config[:MIMEActionScriptDir] is not configured.")
    end

    def service(request, response)
      mime = WEBrick::HTTPUtils::mime_type(@local_path, @config[:MimeTypes])
      action_script = search_action_script(mime)
      if action_script then
        @logger.debug "Execute MIME action: #{action_script}"
        exec_mime_action(request, response, action_script)
      else
        @logger.debug "Default action"
        exec_default_action(request, response)
      end
    end

    protected
    def exec_mime_action(request, response, action_script)
      handler = cgi_handler_class.get_instance(@server, @local_path,
                                               action_script)
      handler.service(request, response)
    end

    def exec_default_action(request, response)
      handler = file_handler_class.get_instance(@server, @local_path)
      handler.service(request, response)
    end

    def search_action_script(mime)
      path = action_script_path(mime)
      @logger.debug "Assume action script: #{path}"
      stat = nil
      begin
        stat = File::stat(path)
      rescue
      end
      
      if stat then
        stat.executable? || raise("Action script #{path} is not executable.")
      end
      stat ? path : nil
    end

    def action_script_path(mime)
      script_name = mime.gsub(%r"/", ".")
      File.expand_path(script_name, @action_script_dir)
    end

    def file_handler_class
      WEBrick::HTTPServlet::DefaultFileHandler
    end

    def cgi_handler_class
      Dpklib_WEBrick::ActionCGIHandler
    end
  end #/MIMEActionHandler

  class << MIMEActionHandler
    def setup_default_handler
      handler_table_hash = WEBrick::HTTPServlet::FileHandler::HandlerTable
      handler_class = self
      
      handler_table_hash.default = handler_class
    end
  end #/<< MIMEActionHandler

end #/Dpklib_WEBrick
