# -*- coding: euc-jp -*-
#
# text (basic facilities) widget demo (called by 'widget')
#

# toplevel widget ¸ߤк
if defined?($text_demo) && $text_demo
  $text_demo.destroy 
  $text_demo = nil
end

# demo Ѥ toplevel widget 
$text_demo = TkToplevel.new {|w|
  title("Text Demonstration - Basic Facilities")
  iconname("text")
  positionWindow(w)
}

# version check
if ((Tk::TK_VERSION.split('.').collect{|n| n.to_i} <=> [8,4]) < 0)
  undo_support = false
else
  undo_support = true
end

# frame 
TkFrame.new($text_demo) {|frame|
  TkButton.new(frame) {
    #text 'λ'
    text 'Ĥ'
    command proc{
      tmppath = $text_demo
      $text_demo = nil
      tmppath.destroy
    }
  }.pack('side'=>'left', 'expand'=>'yes')

  TkButton.new(frame) {
    text 'ɻ'
    command proc{showCode 'text'}
  }.pack('side'=>'left', 'expand'=>'yes')
}.pack('side'=>'bottom', 'fill'=>'x', 'pady'=>'2m')

# text 
TkText.new($text_demo){|t|
  # 
  relief 'sunken'
  bd 2
  setgrid 1
  height 30
  TkScrollbar.new($text_demo) {|s|
    pack('side'=>'right', 'fill'=>'y')
    command proc{|*args| t.yview(*args)}
    t.yscrollcommand proc{|first,last| s.set first,last}
  }
  pack('expand'=>'yes', 'fill'=>'both')

  # ƥ
  insert('0.0', <<EOT)
Υɥϥƥ widget Ǥ1ԤޤϤʾΥƥȤɽ
Խ뤳ȤǤޤʲϥƥ widget ǤǤˤĤ
ޤȤ᤿ΤǤ

1. 롣СǥƥȤɽʬưȤǤޤ

2. ˥󥰡ƥȤΥɥǥޥܥ2 (ܥ) 
ƾ岼˥ɥåƤȥƥȤ®ǥɥå졢
Ƥ򤶤äį뤳ȤǤޤ

3. ƥȤޥܥ1 (ܥ) 򲡤򥻥
ȤƤƥȤϤƤϤΤ widget ޤ

4. 򡣤ϰϤʸ򤹤ˤϥޥܥ1 򲡤ɥå
Ƥ٥ܥΥ顢եȥ򲡤ʤܥ1 򲡤
ȤϰϤĴǤޤϰϤκǸޥ
Ǥᤤ֤˥ꥻåȤܥΥ˥ޥɥå뤳ȤǤ
ϰϤĴǤޤ֥륯åǥɤ򡢤ޤȥץ륯
ǹΤ򤹤뤳ȤǤޤ

5. õִƥȤõˤϡõʸ򤷤ƥХå
ڡǥ꡼ȥϤƤ뤤ϡƥȤ
Ϥ򤵤줿ƥȤִޤ

6. ʬΥԡʬ򤳤ΥɥΤɤ˥ԡ
ˤϡޤԡ(ǡ뤤̤Υץꥱ)
ܥ 2 򥯥åơΰ֤˥ԡƤ

7. Խƥ widget  Emacs ΥХɤ˲äɸŪʤ Motif
Խǽ򥵥ݡȤƤޤХåڡȥȥ-H 
κ¦ʸޤǥ꡼ȥȥȥ-D 
α¦ʸޤMeta-Хåڡ
¦ñMeta-D κ¦ñޤ
ȥ-K 뤫ޤǤΰ֤˲
ʤäϡԤޤ#{
      if undo_support
        undo_text = "Control-z ϺǸ˹Ԥäѹμä(undo)Ԥ"
        case $tk_platform['platform']
        when "unix", "macintosh"
          undo_text << "Control-Shift-z"
        else # 'windows'
          undo_text << "Control-y"
        end
        undo_text << "undoѹκŬ(redo)Ԥޤ"
      else
        ""
      end
}


8. ɥΥꥵ widget  "setGrid" ץ򥪥ˤ
ƤޤΤǡɥꥵˤϹ⤵Ͼʸʸ
ܤˤʤޤޤɥ򶹤ˤĹԤư
Ūޤ֤졢ƤƤ褦ˤʤäƤޤ
EOT

  set_insert('0.0')
}

