#! /usr/local/bin/ruby

$lines_buffer = []

def fetch_line(input)
  return nil unless $lines_buffer
  if line = $lines_buffer.pop
    line
  else
    line = input.gets
    unless line
      $lines_buffer = nil
      return nil
    end
    line.chop!
    line
  end
end

def pushback_line(line)
  $lines_buffer.push line
end

def print_line(format,*args)
#  line = format(format, *args)
  line = format
  line.gsub!(/&/, '&amp;');	# must come first.
  line.gsub!(/</, '&lt;');
  line.gsub!(/>/, '&gt;');
  print line, "\n"
end

def indent(line)
  /^[ \t]*/ =~ line
  $&.size
end

def process_cmd(line, input)
  case line
  when /^@input\s+/, /^@input\(html\)\s+/
    f = open($')
    main(open)
    f.close
  when /^@input\($/
    # do nothing
  end
end

def chapter(line)
  case line
  when /^= +/
    level = 1
  when /^== +/
    level = 2
  when /^=== +/
    level = 3
  when /^==== +/
    level = 4
  when /^\+ +/
    level = 5
  when /^\+\+ +/
    level = 6
  end
  printf "<H%d>%s</H%d>\n", level, $', level
end

def vervatim(line, input)
  print "<BLOCKQUOTE><PRE>\n"
  blanks = 0
  while TRUE
    indent = indent(line)
    if indent < $indent[0]
      pushback_line line
      break
    end
    0.upto blanks-1 do
      print "\n"
    end
    blanks = 0
    line = line[$indent[0]..-1]
    print_line line
    while TRUE
      line = fetch_line(input)
      if line and line.size == 0
	blanks += 1
	next
      end
      break
    end
    break unless line
  end
  $indent.shift
  print "</PRE></BLOCKQUOTE>\n"
end

$indent = [0]
$list_mode = []

def push_list_mode(mode, level)
  $indent.unshift level
  $list_mode.unshift mode
  case mode
  when "item"
    print "<P><UL>\n"
  when "enum"
    print "<P><OL>\n"
  when "desc"
    print "<P><DL>\n"
  end
end

def pop_list_mode
  mode = $list_mode.shift
  case mode
  when "item"
    print "</UL></P>\n"
  when "enum"
    print "</OL></P>\n"
  when "desc"
    print "</DL></P>\n"
  end
end

def list_mode(mode, head)
  indent = head.size
  if indent > $indent[0]
    push_list_mode mode, indent
  elsif indent < $indent[0]
    while indent < $indent[0]
      $indent.shift
      pop_list_mode
    end
    push_list_mode mode, indent
  elsif $list_mode[0] != mode
    pop_list_mode
    push_list_mode mode, indent
  end
  if mode == "desc"
    print "<DT>\n"
  else
    print "<LI>\n"
  end
end

def body(line, input)
  print "<P>\n"
  while TRUE
    if line == nil or /^$/ =~ line
      print "</P>\n"
      return
    end
    
    # process listing..
    case line
    when /^\s*\*\s*/
      list_mode "item", $&
    when /^\s*\(\d*\)\s*/
      list_mode "enum", $&
    when /^\s*:\s*/
      list_mode "desc", $&
      print_line $'
      print "<DD><P>\n"
      line = fetch_line(input)
    else
      indent = indent(line)
      if indent > $indent[0]
	$indent.unshift indent
	vervatim(line, input)
	return
      end
      while indent < $indent[0]
	$indent.shift
	pop_list_mode
      end
    end

    line = line[$indent[0]..-1]
    # process inline command
    print_line line
    line = fetch_line(input)
  end
end

def main(input)
  while line = fetch_line(input)
    next unless (/^=begin/ === line) ... (/^=end/ === line)
    next if /^=(?:begin|end)/ === line
    case line
    when /^=/, /^\+/
      chapter(line)
    when /^@/
      process_cmd(line, input)
    when /^$/
      # ignore blank lines
    else
      body(line, input)
    end
  end
end

main($<)
