# tof

#### tcltk 饤֥
####	Sep. 5, 1997	Y. Shigehiro

require "tcltklib"

################

# module TclTk: tcl/tk Υ饤֥ΤɬפˤʤΤ򽸤᤿
# (, ֤̾ module ˤȤ.)
module TclTk

  # ñˤ˽񤱤кǽ 1 ټ¹ԤΤ??

  # դ̾ݻƤϢ.
  @namecnt = {}

  # ХåݻƤϢ.
  @callback = {}
end

# TclTk.mainloop(): TclTkLib.mainloop() Ƥ.
def TclTk.mainloop()
  print("mainloop: start\n") if $DEBUG
  TclTkLib.mainloop()
  print("mainloop: end\n") if $DEBUG
end

# TclTk.deletecallbackkey(ca): Хå TclTk module .
#     tcl/tk 󥿥ץ꥿ˤƥХåä櫓ǤϤʤ.
#     򤷤ʤ, Ǹ TclTkInterpreter  GC Ǥʤ.
#     (GC ʤ, ̤, 򤷤ʤƤɤ.)
#   ca: Хå(TclTkCallback)
def TclTk.deletecallbackkey(ca)
  print("deletecallbackkey: ", ca.to_s(), "\n") if $DEBUG
  @callback.delete(ca.to_s)
end

# TclTk.dcb(ca, wid, W): äƤʣΥХåФ
#     TclTk.deletecallbackkey() Ƥ.
#     ȥåץ٥ <Destroy> ٥ȤΥХåȤƸƤ֤Τ.
#   ca: Хå(TclTkCallback)  Array
#   wid: ȥåץ٥Υå(TclTkWidget)
#   w: Хå %W Ϳ, ɥ˴ؤѥ᡼(String)
def TclTk.dcb(ca, wid, w)
  if wid.to_s() == w
    ca.each{|i|
      TclTk.deletecallbackkey(i)
    }
  end
end

# TclTk._addcallback(ca): ХåϿ.
#   ca: Хå(TclTkCallback)
def TclTk._addcallback(ca)
  print("_addcallback: ", ca.to_s(), "\n") if $DEBUG
  @callback[ca.to_s()] = ca
end

# TclTk._callcallback(key, arg): ϿХåƤӽФ.
#   key: Хå򤹤륭 (TclTkCallback  to_s() ֤)
#   arg: tcl/tk 󥿥ץ꥿Υѥ᡼
def TclTk._callcallback(key, arg)
  print("_callcallback: ", @callback[key].inspect, "\n") if $DEBUG
  @callback[key]._call(arg)
  # Хå֤ͤϤɤΤƤ.
  # String ֤ʤ, rb_eval_string() 顼ˤʤ.
  return ""
end

# TclTk._newname(prefix): դ̾(String)֤.
#   prefix: ̾Ƭ
def TclTk._newname(prefix)
  # ̾Υ󥿤 @namecnt äƤΤ, Ĵ٤.
  if !@namecnt.key?(prefix)
    # ƻȤƬʤΤǽ.
    @namecnt[prefix] = 1
  else
    # ȤäȤΤƬʤΤ, ̾ˤ.
    @namecnt[prefix] += 1
  end
  return "#{prefix}#{@namecnt[prefix]}"
end

################

# class TclTkInterpreter: tcl/tk Υ󥿥ץ꥿
class TclTkInterpreter

  # initialize(): .
  def initialize()
    # 󥿥ץ꥿.
    @ip = TclTkIp.new()

    # 󥿥ץ꥿ ruby_fmt ޥɤɲä.
    # ruby_fmt ޥɤȤ, ΰ format ޥɤǽ
    # ruby ޥɤϤΤǤ.
    # (ʤ, ruby ޥɤ,  1 ĤȤʤ.)
    if $DEBUG
      @ip._eval("proc ruby_fmt {fmt args} { puts \"ruby_fmt: $fmt $args\" ; ruby [format $fmt $args] }")
    else
      @ip._eval("proc ruby_fmt {fmt args} { ruby [format $fmt $args] }")
    end

    # @ip._get_eval_string(*args): tcl/tk 󥿥ץ꥿ɾ
    #     ʸ(String)֤.
    #   *args: tcl/tk ɾ륹ץ(б륪֥)
    def @ip._get_eval_string(*args)
      argstr = ""
      args.each{|arg|
	argstr += " " if argstr != ""
	# ⤷ to_eval() ᥽åɤ
	if (arg.respond_to?(:to_eval))
	  # ƤФƤ.
	  argstr += arg.to_eval()
	else
	  # Ƥʤ to_s() Ƥ.
	  argstr += arg.to_s()
	end
      }
      return argstr
    end

    # @ip._eval_args(*args): tcl/tk 󥿥ץ꥿ɾ,
    #     η(String)֤.
    #   *args: tcl/tk ɾ륹ץ(б륪֥)
    def @ip._eval_args(*args)
      # 󥿥ץ꥿ɾʸ.
      argstr = _get_eval_string(*args)

      # 󥿥ץ꥿ɾ.
      print("_eval: \"", argstr, "\"") if $DEBUG
      res = _eval(argstr)
      if $DEBUG
	print(" -> \"", res, "\"\n")
      elsif  _return_value() != 0
	print(res, "\n")
      end
      fail(%Q/can't eval "#{argstr}"/) if _return_value() != 0
      return res
    end

    # tcl/tk Υޥɤб륪֥Ȥ, ϢƤ.
    @commands = {}
    # tcl/tk 󥿥ץ꥿ϿƤ뤹٤ƤΥޥɤФ,
    @ip._eval("info command").split(/ /).each{|comname|
      if comname =~ /^[.]/
	# ޥɤå(Υѥ̾)ξ
	# TclTkWidget Υ󥹥󥹤äϢ.
	@commands[comname] = TclTkWidget.new(@ip, comname)
      else
	# Ǥʤ
	# TclTkCommand Υ󥹥󥹤äϢ.
	@commands[comname] = TclTkCommand.new(@ip, comname)
      end
    }
  end

  # commands(): tcl/tk Υޥɤб륪֥Ȥ Hash 
  #     줿Τ֤.
  def commands()
    return @commands
  end

  # rootwidget(): 롼ȥå(TclTkWidget)֤.
  def rootwidget()
    return @commands["."]
  end

  # _tcltkip(): @ip(TclTkIp) ֤.
  def _tcltkip()
    return @ip
  end

  # method_missing(id, *args): ̤Υ᥽åɤ tcl/tk ΥޥɤȤߤʤ
  #     ¹Ԥ, η(String)֤.
  #   id: ᥽åɤΥܥ
  #   *args: ޥɤΰ
  def method_missing(id, *args)
    # ⤷, ᥽åɤ tcl/tk ޥɤ
    if @commands.key?(id.id2name)
      # , ¹ԤƷ̤֤.
      return @commands[id.id2name].e(*args)
    else
      # ̵ФȤȤν.
      super
    end
  end
end

# class TclTkObject: tcl/tk Υ֥
# (쥯饹ȤƻȤ.
#  tcltk 饤֥Ȥͤ TclTkObject.new() 뤳ȤϤʤϤ.)
class TclTkObject

  # initialize(ip, exp): .
  #   ip: 󥿥ץ꥿(TclTkIp)
  #   exp: tcl/tk Ǥɽ
  def initialize(ip, exp)
    fail("type is not TclTkIp") if !ip.kind_of?(TclTkIp)
    @ip = ip
    @exp = exp
  end

  # to_s(): tcl/tk Ǥɽ(String)֤.
  def to_s()
    return @exp
  end
end

# class TclTkCommand: tcl/tk Υޥ
# (tcltk 饤֥Ȥͤ TclTkCommand.new() 뤳ȤϤʤϤ.
#  TclTkInterpreter:initialize()  new() .)
class TclTkCommand < TclTkObject

  # e(*args): ޥɤ¹Ԥ, η(String)֤.
  #     (e  exec ޤ eval  e.)
  #   *args: ޥɤΰ
  def e(*args)
    return @ip._eval_args(to_s(), *args)
  end
end

# class TclTkLibCommand: tcl/tk Υޥ
# (饤֥ˤ¸륳ޥɤ, tcl/tk 󥿥ץ꥿˺ǽ餫
#  ¸ߤʤΤ, 󥿥ץ꥿ commands() ǤǤʤ.
#  Τ褦ʤΤФ, ޥɤ̾ TclTkCommand ֥Ȥ
#  .
class TclTkLibCommand < TclTkCommand

  # initialize(ip, name): 
  #   ip: 󥿥ץ꥿(TclTkInterpreter)
  #   name: ޥ̾ (String)
  def initialize(ip, name)
    super(ip._tcltkip, name)
  end
end

# class TclTkVariable: tcl/tk ѿ
class TclTkVariable < TclTkObject

  # initialize(interp, dat): .
  #   interp: 󥿥ץ꥿(TclTkInterpreter)
  #   dat: ꤹ(String)
  #       nil ʤ, ꤷʤ.
  def initialize(interp, dat)
    # tcl/tk Ǥɽ(ѿ̾)ư.
    exp = TclTk._newname("v_")
    # TclTkObject .
    super(interp._tcltkip(), exp)
    # set ޥɤȤΤǤȤäƤ.
    @set = interp.commands()["set"]
    # ͤꤹ.
    set(dat) if dat
  end

  # tcl/tk  set Ȥ, ͤ/ȤϤǤ뤬,
  # ǤϤʤʤΤ, , ᥽åɤ򤫤֤ΤѰդƤ.

  # set(data): tcl/tk ѿ set Ѥͤꤹ.
  #   data: ꤹ
  def set(data)
    @set.e(to_s(), data.to_s())
  end

  # get(): tcl/tk ѿ(String) set Ѥɤߤ֤.
  def get()
    return @set.e(to_s())
  end
end

# class TclTkWidget: tcl/tk Υå
class TclTkWidget < TclTkCommand

  # initialize(*args): .
  #   *args: ѥ᡼
  def initialize(*args)
    if args[0].kind_of?(TclTkIp)
      # ǽΰ TclTkIp ξ:

      #  tcl/tk Ƥ륦åȤ TclTkWidget ι¤
      # ֤. (TclTkInterpreter:initialize() Ȥ.)

      # ѥ᡼ 2 ǤʤХ顼.
      fail("illegal # of parameter") if args.size != 2

      # ip: 󥿥ץ꥿(TclTkIp)
      # exp: tcl/tk Ǥɽ
      ip, exp = args

      # TclTkObject .
      super(ip, exp)
    elsif args[0].kind_of?(TclTkInterpreter)
      # ǽΰ TclTkInterpreter ξ:

      # ƥåȤ鿷ʥȤ.

      # interp: 󥿥ץ꥿(TclTkInterpreter)
      # parent: ƥå
      # command: åȤ륳ޥ(label )
      # *args: command Ϥ
      interp, parent, command, *args = args

      # åȤ̾.
      exp = parent.to_s()
      exp += "." if exp !~ /[.]$/
      exp += TclTk._newname("w_")
      # TclTkObject .
      super(interp._tcltkip(), exp)
      # åȤ.
      res = @ip._eval_args(command, exp, *args)
#      fail("can't create Widget") if res != exp
      # tk_optionMenu Ǥ, ܥ̾ exp ǻꤹ
      # res ˥˥塼֤̾Τ res != exp Ȥʤ.
    else
      fail("first parameter is not TclTkInterpreter")
    end
  end
end

# class TclTkCallback: tcl/tk ΥХå
class TclTkCallback < TclTkObject

  # initialize(interp, pr, arg): .
  #   interp: 󥿥ץ꥿(TclTkInterpreter)
  #   pr: Хå³(Proc)
  #   arg: pr Υƥ졼ѿϤʸ
  #       tcl/tk  bind ޥɤǤϥѥ᡼뤿 % ִ
  #       Ѥ뤬, pr  % 񤤤Ƥ⤦ޤʤ.
  #       arg ʸ񤤤Ƥ, ִ̤, pr 
  #       ƥ졼ѿ̤Ƽ뤳ȤǤ.
  #       scrollbar ޥɤ -command ץΤ褦
  #       ꤷʤƤѥ᡼դޥɤФƤ,
  #       arg ꤷƤϤʤʤ.
  def initialize(interp, pr, arg = nil)
    # tcl/tk Ǥɽ(ѿ̾)ư.
    exp = TclTk._newname("c_")
    # TclTkObject .
    super(interp._tcltkip(), exp)
    # ѥ᡼ȤäƤ.
    @pr = pr
    @arg = arg
    # ⥸塼ϿƤ.
    TclTk._addcallback(self)
  end

  # to_eval(): @ip._eval_args ɾȤɽ(String)֤.
  def to_eval()
    if @arg
      # %s  ruby_fmt  bind ˤִƤޤΤ
      # %%s ȤƤ. ä,  bind .
      s = %Q/{ruby_fmt {TclTk._callcallback("#{to_s()}", "%%s")} #{@arg}}/
    else
      s = %Q/{ruby_fmt {TclTk._callcallback("#{to_s()}", "%s")}}/
    end

    return s
  end

  # _call(arg): ХåƤӽФ.
  #   arg: ХåϤѥ᡼
  def _call(arg)
    @pr.call(arg)
  end
end

# class TclTkImage: tcl/tk Υ᡼
class TclTkImage < TclTkCommand

  # initialize(interp, t, *args): .
  #     ᡼ TclTkImage.new() ǹԤ,
  #     ˲ image delete ǹԤ. (ޤɻ̵.)
  #   interp: 󥿥ץ꥿(TclTkInterpreter)
  #   t: ᡼Υ (photo, bitmap, etc.)
  #   *args: ޥɤΰ
  def initialize(interp, t, *args)
    # tcl/tk Ǥɽ(ѿ̾)ư.
    exp = TclTk._newname("i_")
    # TclTkObject .
    super(interp._tcltkip(), exp)
    # ᡼.
    res = @ip._eval_args("image create", t, exp, *args)
    fail("can't create Image") if res != exp
  end
end

# eof
