#!/usr/local/bin/ruby
#
# Get CGI String
#
# EXAMPLE:
# require "cgi-lib.rb"
# foo = CGI.new
# foo['field']   <== value of 'field'
# foo.keys       <== array of fields
# foo.inputs     <== hash of { <field> => <value> }

class CGI
  attr("inputs")

  # original is CGI.pm
  def read_from_cmdline
    require "shellwords.rb"
    input = ''
    query_string = ''
    if ARGV[1] then
      input = ARGV.join(' ')
    else
      STDERR.print "(offline mode: enter name=value pairs on standard input)\n"
      input = readlines.join(' ')
      input.gsub! /\n/, ''
    end
    # minimal handling of escape characters
    input.gsub! /\\=/, '%3D'
    input.gsub! /\\&/, '%26'

    words = shellwords(input)
    if words then
      if words.join('') =~ /=/ then
        query_string = words.join('&')
      else
        query_string = words.join('+')
      end
    end
    query_string
  end
  
  def initialize
    str = if ENV['REQUEST_METHOD'] == "GET" then
            ENV['QUERY_STRING'] or ""
          elsif ENV['REQUEST_METHOD'] == "POST" then
            $stdin.read ENV['CONTENT_LENGTH'].to_i
          else
            read_from_cmdline
          end
    arr = str.split(/&/)
    @inputs = {}
    arr.each do |x|
      x.gsub!(/\+/, ' ')
      key, val = x.split(/=/, 2)
      val = "" unless val
      
      key.gsub!(/%(..)/) { [$1.hex].pack("c") }
      val.gsub!(/%(..)/) { [$1.hex].pack("c") }

      @inputs[key] += "\0" if @inputs[key]
      @inputs[key] += val
    end
  end

  def keys
    @inputs.keys
  end

  def [](key)
    @inputs[key]
  end
  
  def CGI.message(msg, title = "")
    print "Content-type: text/html\n\n"
    print "<html><head><title>"
    print title
    print "</title></head><body>\n"
    print msg
    print "</body></html>\n"
    TRUE
  end

end
