NAME
    RISCOS::Filespec -- routines to control and perform filename
    conversion.

SYNOPSIS
        use RISCOS::Filespec;	# Turn off Unix filename conversion.

        use RISCOS::Filespec /riscosify/;
        @name = riscosify ('miniperlmain.c');

        use RISCOS::Filespec /canonicalise/;
        @pwd  = canonicalise '@';
        @name = canonicalise \*STDIN;


DESCRIPTION
    By default this RISC OS perl port assumes that all filenames are
    in "Unix" format, and automatically converts to "native" format
    for all `open' `rename' *etc.* operations.

    By using `RISCOS::Filespec' a perl script turns off this
    conversion, and shows that it understands RISC OS file naming
    conventions. Because UnixLib processes command line redirection
    before perl starts, let alone the script, the internal
    conversion routine is always used for filenames in command line
    redirection.

    As well as providing routines to control the name conversion on
    perl builtins, `RISCOS::Filespec' provides access to the
    conversion routines to and from "Unix" format, and a subroutine
    to convert filenames and filehandles to canonical filenames.

    The internal conversion routine to "native" format works as
    follows:

    *
    Full RISC OS pathnames of the form 'ADFS::Bagpuss.$.!Boot' and 'RAM:$'
    are recognised as such and are passed back unmodified.

    *
    Pathnames starting '/dev/' are converted to paths - '/dev/parallel' will
    return 'parallel:'.

    *
    Filenames starting '`/'' are checked in a special list - this allows '/tmp'
    to be mapped to '<Wimp$ScrapDir>'.

    *
    Pathnames starting with '`/'' '`$'' or '`<'' are taken as absolute - if a
    filing system name is found after '`/'' it is returned to start the name,
    otherwise '`$.'' is used.

    *
    Each '`/'' delimited section of the pathname is then processed in turn.
    If the section ends in a suffixes in the suffix list it is prefixed as a
    directory name. Other '`.'' are converted to '`/'', '`?'' and '`#'' map
    to each other, characters illegal in RISCOS filenames are mapped to '`_''.


  Subroutines to control the internal conversion routines

    The following routines control filename conversion on "user"
    filenames supplied by the script. Filename conversion for
    internal filenames in `use' and `require' statements is always
    turned on, and is unaffected by the use of these functions. [It
    would be hard to change internal filenames, as the perl source
    code assumes that '/' is a directory separator.]

    convert <new_status>

    convert
        Reports the status of filename conversion prior to the call,
        returning true if filename conversion was turned on, false
        if turned off. If called with no arguments, or an undefined
        argument, leaves the conversion setting unchanged. Otherwise
        it turns conversion on if the argument is true, off it is
        false.

    convert_on
        Turns filename conversion on. Returns true if filename
        conversion was on already, false if filename conversion was
        off.

    convert_off
        Turns filename conversion off. Returns true if filename
        conversion was off already, otherwise returns false.

    convert_set <flags>
        Sets the flags for filename conversion as detailed in the
        table below. convert_set will `croak' if reserved bits in
        the flags are not zero - always use the `__RISCOSIFY_*'
        subroutines provided to construct flag settings. convert_set
        will warn if it is called in array context - use an explicit
        `scalar' if necessary, as it is proposed to change the
        return value for an array context.

    __RISCOSIFY_NO_PROCESS
            If this bit is set then filename conversion is off, and
            no further action is taken. `riscosify' and `unixify'
            return the filename unmodified, perl builtins perform no
            filename conversion.

    __RISCOSIFY_DONT_TRUNCATE

    __RISCOSIFY_LONG_TRUNCATE

    __RISCOSIFY_MEDIUM_TRUNCATE

    __RISCOSIFY_SHORT_TRUNCATE
            Set the length to truncate each filename segment.
            `__RISCOSIFY_DONT_TRUNCATE' turns truncation off, the
            default setting. Filing systems such as `ADFS' currently
            will still truncate filenames to 10 characters, but not
            truncating filenames internally allows perl to work well
            with filing systems that support longer names.

            `__RISCOSIFY_SHORT_TRUNCATE' truncates to 10 characters
            - current `FileCore' filing systems such as `ADFS' and
            `SCSIFS' have a 10 character limit.

            `__RISCOSIFY_MEDIUM_TRUNCATE' truncates to 19 characters
            - SparkFS 1.28 and earlier have a bug relating to
            filename truncation.

            `__RISCOSIFY_LONG_TRUNCATE' truncates to 55 characters -
            the maximum length name allowed by the `longfiles'
            module.

    __RISCOSIFY_DROP_VOWEL
            If the path element is too long, drop vowels before
            truncating. (`a'`e'`i'`o'`u' independent of locale
            setting.)

    __RISCOSIFY_NO_SUFFIX
            Disable 'suffix' checking - UnixLib keeps a list of
            suffixes that it recognises. If a filename ends in a
            known suffix, it is used as a directory name. Hence
            'foo.bar' is mapped to 'foo/bar' ('bar' not a recognised
            suffix) whereas 'perl.c' is mapped to 'c.perl' ('c' is
            by default in the recognised list).

            Currently the default list is specified by `Unixfs$sfix'
            set by the !Boot file - removing '`pl'' and '`pm'' from
            this list will cause `use' and `require' to fail unless
            you rename all files in the library from pm.* to *.pm
            [This is feasible, and if a future filecore supports
            long filenames will become the default distribution
            arrangement.]

            By default suffix checking is on, so this bit is unset.

    __RISCOSIFY_DONT_CHECK_DIR
            By default this flag is off. If enabled, and the
            conversion routine is presented with '!Perl/lib/File.pm'
            it will check whether a directory '!Perl.lib.File'
            exists. If it does, it will return '!Perl.lib.File.pm',
            if it does not it will return '!Perl.lib.File/pm'.

    __RISCOSIFY_CHECK_DIR_IS_SUFFIX
            By default this flag is off. If enabled it will restrict
            the match of the above test to only match directories
            that are found in the suffix list. This allows a degree
            of "intuition" when presented with a filename that could
            be in "Unix" or "native" format: 'c.riscos' will map to
            'c.riscos' assuming the directory 'c' exists. 'riscos.c'
            will map to 'c.riscos'

    __RISCOSIFY_MASK
            Returns the mask of acceptable flag bits.


    riscosify <filename> [<flags>]

    riscosify <filehandle> [<flags>]
        Converts a filename to "native" format using the same
        routine as the builtin name conversion. If one argument is
        supplied uses the same flags as the builtin conversion
        routine - hence if `convert_off' has been called `riscosify'
        will return the filename unchanged. If two arguments are
        supplied the second is used as the flags to the conversion
        routine. Note that `riscosify' performs a many to one
        mapping, *e.g.* 'c/pp_hot' and 'pp_hot.c' both map to
        'c.pp_hot'

        If passed a filehandle (*i.e* reference to a typeglob, or an
        IO object) will convert that file handle to the name of the
        file it refers to, or undefined if the handle is not open on
        disc file. For a filehandle the value of flags doesn't
        affect the conversion, but will be faulted if it contains
        reserved bits set.

    unixify <filename> [<flags>]
    =item unixify <filehandle> [<flags>]
        Converts a filename or filehanedle to "Unix" format
        (currently this routine is roughly
        `tr:/.#?:./?#/ifconvert_on();' but with knowledge about
        `/../' and filing system special fields. Swapping back of
        suffixes may be available in future. Note that as
        `riscosify' performs a many to one mapping, correct recovery
        of the name by `unixify' is impossible 100% of the time.

    canonicalise
        canonicalises a filename (*i.e.* converts it to a full
        pathame, and removes any wildcards. If passed a filehandle
        (*i.e* reference to a typeglob, or an IO object) will
        convert that file handle to the name of the file it refers
        to, or undefined if the handle is not open on disc file.

        With one filename argument `canonicalise' is effectively

        	riscosify
        	OS_FSControl 37
        	unixify


        and with one filehandle argument

        	OS_Args 7
        	unixify


        If a second argument is given it is used as flags for
        `riscosify' and `unixify'. If three arguments are given, the
        second is the flag for `riscosify', the third the flag for
        `unixify'.

    RISCOS::Filespec::convert_internal
        returns the riscosify flags used by internal opens (*e.g.*
        use). This value is needed for the throwback module.


BUGS
    Aside from the deficiencies noted above, none known.

AUTHOR
    Nicholas Clark <nick@unfortu.net>

