NAME
    RISCOS::Mode --perl interface to RISC OS screen modes

SYNOPSIS
        use RISCOS::Mode qw(mode_block2string mode_read_current);
        print &mode_block2string (mode_read_current), "\n";


DESCRIPTION
    This module provides a perl interface to RISC OS screen modes,
    using both old-style mode numbers and new-style mode descriptor
    blocks.

    mode_read_block_from_pointer <pointer>
        *pointer* is assumed to be the numeric address of a mode
        descriptor block in memory, which is read from memory and
        returned as a 24 + 4*n* byte scalar. Fatal address
        exceptions are likely if <pointer> is invalid.

    mode_read_current
        returns the current mode, either as a mode number or a mode
        descriptor string. (What you get depends on what
        `OS_ScreenMode 1' or `OS_Byte 135' return.)

    mode_number2string <mode>
        "fakes" a mode descriptor string from a mode number by
        reading the mode variables `XWindLimit', `YWindLimit',
        `Log2BPP', `XEigFactor' and `YEigFactor'. Unlike a "true"
        mode descriptor string there is no framerate, as this cannot
        be determined from the mode variables. Returns `undef' on
        error, most likely if the mode number is unknown.

    mode_number2block <mode>
        "fakes" a mode descriptor block from a mode number by
        reading its mode variables. The frame rate is set to -1
        which matches the first available framerate.

    mode_block2string <block>
        converts a mode block to a mode string. If the "mode block"
        is under 20 bytes long it is assumed to be a mode number,
        and a call to `mode_number2string' is substituted.

    mode_read_vars <mode>, [variable...]
        reads the values of the mode variables for the mode number
        specified. Mode variables can be specified by (case
        sensitive) name or number:

        	 0	ModeFlags
        	 1	ScrRCol
        	 2	ScrBRow
        	 3	NColour
        	 4	XEigFactor
        	 5	YEigFactor
        	 6	LineLength
        	 7	ScreenSize
        	 8	YShftFactor
        	 9	Log2BPP
        	10	Log2BPC
        	11	XWindLimit
        	12	YWindLimit


        In array context returns an array corresponding the
        variables, in scalar context the value of the first variable
        requested. `undef' will be returned for unknown modes or
        variables.


BUGS
    Not tested enough.

AUTHOR
    Nicholas Clark <nick@unfortu.net>

