# DO NOT EDIT, PRETTY PLEASE!
# This file is automatically generated by wl-scanner.pl
#

use strict;
use warnings;
use utf8;

=encoding utf8
=cut

=head1 NAME

WL::wl_test - Perl binding for wl_test protocol

=head1 SYNOPSIS

  use WL::wl_test;

=head1 DESCRIPTION

B<WL::wl_test> is a package generated from Wayland protocol definition
using L<wl-scanner.pl>. It implements L<WL::Base> subclasses with wrappers
for requests, event processing and constants for enums.

It is not indended to be used directly. Instead, see L<WL::Connection> to see
how to obtain the object instances.

To see how to attach event callbacks and issue requests, please refer to
L<WL::Base> base class.

Until proper documentation is finished, please refer to documentation of C
bindings of the generated code (it is intended to be readable) to see what
arguments to give to requests and expect from events.

Please consider this an alpha quality code, whose API can change at any time,
until we reach version 1.0.

=cut

package WL::wl_test;

our $VERSION = 0.92;

package WL::wl_test;

our @ISA = qw/WL::Base/;
our $VERSION = 1;
our $INTERFACE = 'wl_test';

# Requests
use constant REQUEST_MOVE_SURFACE => 0;
use constant REQUEST_MOVE_POINTER => 1;
use constant REQUEST_SEND_BUTTON => 2;
use constant REQUEST_ACTIVATE_SURFACE => 3;
use constant REQUEST_SEND_KEY => 4;
use constant REQUEST_GET_N_EGL_BUFFERS => 5;

sub move_surface
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_MOVE_SURFACE, pack ('L l l',
		shift->{id},
		shift,
		shift), $file);

	return $retval;
}

sub move_pointer
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_MOVE_POINTER, pack ('l l',
		shift,
		shift), $file);

	return $retval;
}

sub send_button
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_SEND_BUTTON, pack ('l L',
		shift,
		shift), $file);

	return $retval;
}

sub activate_surface
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_ACTIVATE_SURFACE, pack ('L',
		shift->{id}), $file);

	return $retval;
}

sub send_key
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_SEND_KEY, pack ('L L',
		shift,
		shift), $file);

	return $retval;
}

sub get_n_egl_buffers
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_GET_N_EGL_BUFFERS, pack ('',
		), $file);

	return $retval;
}

# Events
use constant EVENT_POINTER_POSITION => 0;
use constant EVENT_N_EGL_BUFFERS => 1;

sub callback
{
	my $self = shift;
	my $opcode = shift;

	if ($opcode == EVENT_POINTER_POSITION) {
		@_ = unpack ('L L', shift);
		return $self->pointer_position ($self->fixed2nv (shift),
			$self->fixed2nv (shift));
	} elsif ($opcode == EVENT_N_EGL_BUFFERS) {
		@_ = unpack ('L', shift);
		return $self->n_egl_buffers (shift);
	} else {
		die 'Bad opcode';
	}
}


=head1 BUGS

The interface documentation for the bindings is lacking.

Only client part implemented, not server.

=head1 SEE ALSO

=over

=item *

L<http://wayland.freedesktop.org/> -- Wayland project web site

=item *

L<wl-draw.pl> -- Example Wayland client

=item *

L<wl-scanner.pl> -- Tool that generated this module

=item *

L<WL::Base> -- Base class for Wayland objects

=item *

L<WL::Connection> -- Estabilish a Wayland connection

=back

=head1 COPYRIGHT

Copyright 2013, 2014 Lubomir Rintel

This program is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

Copyright notice from the protocol definition file:

  Copyright © 2012 Intel Corporation
  
  Permission to use, copy, modify, distribute, and sell this
  software and its documentation for any purpose is hereby granted
  without fee, provided that the above copyright notice appear in
  all copies and that both that copyright notice and this permission
  notice appear in supporting documentation, and that the name of
  the copyright holders not be used in advertising or publicity
  pertaining to distribution of the software without specific,
  written prior permission.  The copyright holders make no
  representations about the suitability of this software for any
  purpose.  It is provided "as is" without express or implied
  warranty.
  
  THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS
  SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
  FITNESS, IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY
  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
  THIS SOFTWARE.

=head1 AUTHORS

Lubomir Rintel C<lkundrak@v3.sk>

=cut

