/* GoDaemon.c
 * This file is part of the LaBrea package
 *
 * Copyright (C) 2001, 2002 Tom Liston <tliston@premmag.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include "labrea.h"

/* detach this process */
#ifndef WIN32
static __inline void GoDaemon(void) {
  extern char err26[];
  extern char devnull[];
  pid_t fs;

  if(getppid() != 1) {
    fs = fork();
    if(fs > 0)
      exit(0); /* parent */
    if(fs < 0) {
      fprintf(stderr, err26);
      exit(1);
    }
    setsid();
  }
  /* redirect stdin/stdout/stderr to /dev/null */
  close(0);
  close(1);
  close(2);
  open(devnull, O_RDWR);
  dup(0);
  dup(0);
  return;
}
#endif


