package WebService::Bonusly::Rewards;
$WebService::Bonusly::Rewards::VERSION = '0.153420';
use v5.14;
use Moose;
use Carp;
use JSON;
use URI::Escape;

has ws => (
    is          => 'ro',
    isa         => 'WebService::Bonusly',
    required    => 1,
    weak_ref    => 1,
    handles     => [ qw( token base_url ua ) ],
);


sub get {
    my ($self, %params) = @_;

    my %clean;
            
    croak "parameter id is required for rewards->get"
        unless defined $params{id};
    
    $clean{id} = $params{id}
        if defined $params{id};
    
    my $path = $self->base_url . "rewards/:id";
    $path =~ s/:(\w+)/delete $params{$1}/ge;
    
    $path .= '?';
    $path .= 'access_token=' . $self->token;    while (my ($k, $v) = each %clean) {
        $path .= uri_escape($k) . '=' . uri_escape($v);
    }

    my $res = $self->ua->get($path);
    
    return decode_json($res->content);
}

sub list {
    my ($self, %params) = @_;

    my %clean;
            
    $clean{catalog_country} = $params{catalog_country}
        if defined $params{catalog_country};
            
    $clean{request_country} = $params{request_country}
        if defined $params{request_country};
            
    $clean{personalize_for} = $params{personalize_for}
        if defined $params{personalize_for};
    
    my $path = $self->base_url . "rewards";
    $path =~ s/:(\w+)/delete $params{$1}/ge;
    
    $path .= '?';
    $path .= 'access_token=' . $self->token;    while (my ($k, $v) = each %clean) {
        $path .= uri_escape($k) . '=' . uri_escape($v);
    }

    my $res = $self->ua->get($path);
    
    return decode_json($res->content);
}

sub take {
    my ($self, %params) = @_;

    my %clean;
            
    croak "parameter denomination_id is required for rewards->take"
        unless defined $params{denomination_id};
    
    $clean{denomination_id} = $params{denomination_id}
        if defined $params{denomination_id};
            
    croak "parameter user_id is required for rewards->take"
        unless defined $params{user_id};
    
    $clean{user_id} = $params{user_id}
        if defined $params{user_id};
    
    my $path = $self->base_url . "rewards";
    $path =~ s/:(\w+)/delete $params{$1}/ge;
    
    $path .= '?access_token=' . $self->token;    my $content = encode_json(\%clean);
    my $res = $self->ua->post($path, [ 'Content-Type' => 'application/json' ], $content); 
    
    return decode_json($res->content);
}


__PACKAGE__->meta->make_immutable;

__END__

=pod

=encoding UTF-8

=head1 NAME

WebService::Bonusly::Rewards

=head1 VERSION

version 0.153420

=for Pod::Coverage *EVERYTHING*

=head1 AUTHOR

Andrew Sterling Hanenkamp <hanenkamp@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by Qubling Software LLC.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
