# Write out the perl5i wrapper C program making sure it uses
# the Perl its built with.
use strict;
use warnings;
use File::Spec;

my $file = shift;

print("Generating $file\n");

# Its going inside double quotes.
my $perl_path = $^X;
$perl_path =~ s{ ([\\"]) }{\\$1}gx;

open my $fh, ">", $file or die $!;
printf $fh <<'END', $0, $perl_path;
/* THIS FILE IS GENERATED BY %s
 * Any changes here will be wiped out.  Edit it there instead.
 */

#define DEBUG 0

#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

/*
 * Meant to mimic the shell command
 *     exec perl -MSeis::CLI "$@"
 *
 * This is a C program so it works in a #! line.
 */

int main (int argc, char* argv[]) {
    int i, j;

    const char* perl_cmd = "%s";
    char* perl_args[argc+5];
    for (i=0; i<argc+5; i++) { /* NULL clear */
        perl_args[i] = NULL;
    }

    perl_args[0] = argv[0];
    perl_args[1] = "-MSeis::CLI";
    perl_args[2] = "-e";
    perl_args[3] = "Seis::CLI->new->run";
    perl_args[4] = "--";

    for (i=1; i<argc; ++i) {
        perl_args[i+4] = argv[i];
    }

#if DEBUG
    perl_args[argc+3+1] = (char *)NULL;
    printf("cmd: %%s\n", perl_cmd);
    for (j=0; j<argc+4; j++) {
        printf("-- %%d: %%s\n", j, perl_args[j]);
    }
#endif

    return execv( perl_cmd, perl_args );
}
END
