/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.PropertyException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.UnmarshallerHandler;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.attachment.AttachmentUnmarshaller;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.validation.Schema;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.xml.FilterVersion;
import org.apache.sis.xml.FilteredStreamReader;
import org.apache.sis.xml.InputFactory;
import org.apache.sis.xml.Pooled;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

final class PooledUnmarshaller
extends Pooled
implements Unmarshaller {
    private final Unmarshaller unmarshaller;

    PooledUnmarshaller(Unmarshaller unmarshaller, Pooled pooled) throws JAXBException {
        super(pooled);
        this.unmarshaller = unmarshaller;
        this.initialize(pooled);
    }

    @Override
    protected void reset(Object object, Object object2) throws JAXBException {
        if (object instanceof String) {
            this.unmarshaller.setProperty((String)object, object2);
        } else if (object == AttachmentUnmarshaller.class) {
            this.unmarshaller.setAttachmentUnmarshaller((AttachmentUnmarshaller)object2);
        } else if (object == Schema.class) {
            this.unmarshaller.setSchema((Schema)object2);
        } else if (object == Unmarshaller.Listener.class) {
            this.unmarshaller.setListener((Unmarshaller.Listener)object2);
        } else if (object == ValidationEventHandler.class) {
            this.unmarshaller.setEventHandler((ValidationEventHandler)object2);
        } else if (object == Boolean.class) {
            this.unmarshaller.setValidating((Boolean)object2);
        } else {
            this.unmarshaller.setAdapter((Class)object, (XmlAdapter)object2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object unmarshal(XMLStreamReader xMLStreamReader, FilterVersion filterVersion) throws XMLStreamException, JAXBException {
        Object object;
        xMLStreamReader = new FilteredStreamReader(xMLStreamReader, filterVersion);
        Context context = this.begin();
        try {
            object = this.unmarshaller.unmarshal(xMLStreamReader);
        }
        finally {
            context.finish();
        }
        xMLStreamReader.close();
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> JAXBElement<T> unmarshal(XMLStreamReader xMLStreamReader, FilterVersion filterVersion, Class<T> clazz) throws XMLStreamException, JAXBException {
        JAXBElement<T> jAXBElement;
        xMLStreamReader = new FilteredStreamReader(xMLStreamReader, filterVersion);
        Context context = this.begin();
        try {
            jAXBElement = this.unmarshaller.unmarshal(xMLStreamReader, clazz);
        }
        finally {
            context.finish();
        }
        xMLStreamReader.close();
        return jAXBElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object unmarshal(InputStream inputStream) throws JAXBException {
        FilterVersion filterVersion = this.getFilterVersion();
        if (filterVersion != null) {
            try {
                return this.unmarshal(InputFactory.createXMLStreamReader(inputStream), filterVersion);
            }
            catch (XMLStreamException xMLStreamException) {
                throw new JAXBException(xMLStreamException);
            }
        }
        Context context = this.begin();
        try {
            Object object = this.unmarshaller.unmarshal(inputStream);
            return object;
        }
        finally {
            context.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object unmarshal(URL uRL) throws JAXBException {
        FilterVersion filterVersion = this.getFilterVersion();
        if (filterVersion != null) {
            try (InputStream inputStream = uRL.openStream();){
                Object object = this.unmarshal(InputFactory.createXMLStreamReader(inputStream), filterVersion);
                return object;
            }
            catch (IOException | XMLStreamException exception) {
                throw new JAXBException(exception);
            }
        }
        Context context = this.begin();
        try {
            Object object = this.unmarshaller.unmarshal(uRL);
            return object;
        }
        finally {
            context.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object unmarshal(File file) throws JAXBException {
        FilterVersion filterVersion = this.getFilterVersion();
        if (filterVersion != null) {
            try (BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));){
                Object object = this.unmarshal(InputFactory.createXMLStreamReader(bufferedInputStream), filterVersion);
                return object;
            }
            catch (IOException | XMLStreamException exception) {
                throw new JAXBException(exception);
            }
        }
        Context context = this.begin();
        try {
            Object object = this.unmarshaller.unmarshal(file);
            return object;
        }
        finally {
            context.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object unmarshal(Reader reader) throws JAXBException {
        FilterVersion filterVersion = this.getFilterVersion();
        if (filterVersion != null) {
            try {
                return this.unmarshal(InputFactory.createXMLStreamReader(reader), filterVersion);
            }
            catch (XMLStreamException xMLStreamException) {
                throw new JAXBException(xMLStreamException);
            }
        }
        Context context = this.begin();
        try {
            Object object = this.unmarshaller.unmarshal(reader);
            return object;
        }
        finally {
            context.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object unmarshal(InputSource inputSource) throws JAXBException {
        FilterVersion filterVersion = this.getFilterVersion();
        if (filterVersion != null) {
            try {
                return this.unmarshal(InputFactory.createXMLStreamReader(inputSource), filterVersion);
            }
            catch (XMLStreamException xMLStreamException) {
                throw new JAXBException(xMLStreamException);
            }
        }
        Context context = this.begin();
        try {
            Object object = this.unmarshaller.unmarshal(inputSource);
            return object;
        }
        finally {
            context.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object unmarshal(Node node) throws JAXBException {
        FilterVersion filterVersion = this.getFilterVersion();
        if (filterVersion != null) {
            try {
                return this.unmarshal(InputFactory.createXMLStreamReader(node), filterVersion);
            }
            catch (XMLStreamException xMLStreamException) {
                throw new JAXBException(xMLStreamException);
            }
        }
        Context context = this.begin();
        try {
            Object object = this.unmarshaller.unmarshal(node);
            return object;
        }
        finally {
            context.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> JAXBElement<T> unmarshal(Node node, Class<T> clazz) throws JAXBException {
        FilterVersion filterVersion = this.getFilterVersion();
        if (filterVersion != null) {
            try {
                return this.unmarshal(InputFactory.createXMLStreamReader(node), filterVersion, clazz);
            }
            catch (XMLStreamException xMLStreamException) {
                throw new JAXBException(xMLStreamException);
            }
        }
        Context context = this.begin();
        try {
            JAXBElement<T> jAXBElement = this.unmarshaller.unmarshal(node, clazz);
            return jAXBElement;
        }
        finally {
            context.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object unmarshal(Source source) throws JAXBException {
        FilterVersion filterVersion = this.getFilterVersion();
        if (filterVersion != null) {
            try {
                return this.unmarshal(InputFactory.createXMLStreamReader(source), filterVersion);
            }
            catch (XMLStreamException xMLStreamException) {
                throw new JAXBException(xMLStreamException);
            }
        }
        Context context = this.begin();
        try {
            Object object = this.unmarshaller.unmarshal(source);
            return object;
        }
        finally {
            context.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> JAXBElement<T> unmarshal(Source source, Class<T> clazz) throws JAXBException {
        FilterVersion filterVersion = this.getFilterVersion();
        if (filterVersion != null) {
            try {
                return this.unmarshal(InputFactory.createXMLStreamReader(source), filterVersion, clazz);
            }
            catch (XMLStreamException xMLStreamException) {
                throw new JAXBException(xMLStreamException);
            }
        }
        Context context = this.begin();
        try {
            JAXBElement<T> jAXBElement = this.unmarshaller.unmarshal(source, clazz);
            return jAXBElement;
        }
        finally {
            context.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object unmarshal(XMLStreamReader xMLStreamReader) throws JAXBException {
        FilterVersion filterVersion = this.getFilterVersion();
        if (filterVersion != null) {
            xMLStreamReader = new FilteredStreamReader(xMLStreamReader, filterVersion);
        }
        Context context = this.begin();
        try {
            Object object = this.unmarshaller.unmarshal(xMLStreamReader);
            return object;
        }
        finally {
            context.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> JAXBElement<T> unmarshal(XMLStreamReader xMLStreamReader, Class<T> clazz) throws JAXBException {
        FilterVersion filterVersion = this.getFilterVersion();
        if (filterVersion != null) {
            xMLStreamReader = new FilteredStreamReader(xMLStreamReader, filterVersion);
        }
        Context context = this.begin();
        try {
            JAXBElement<T> jAXBElement = this.unmarshaller.unmarshal(xMLStreamReader, clazz);
            return jAXBElement;
        }
        finally {
            context.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object unmarshal(XMLEventReader xMLEventReader) throws JAXBException {
        FilterVersion filterVersion = this.getFilterVersion();
        if (filterVersion != null) {
            try {
                return this.unmarshal(InputFactory.createXMLStreamReader(xMLEventReader), filterVersion);
            }
            catch (XMLStreamException xMLStreamException) {
                throw new JAXBException(xMLStreamException);
            }
        }
        Context context = this.begin();
        try {
            Object object = this.unmarshaller.unmarshal(xMLEventReader);
            return object;
        }
        finally {
            context.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> JAXBElement<T> unmarshal(XMLEventReader xMLEventReader, Class<T> clazz) throws JAXBException {
        FilterVersion filterVersion = this.getFilterVersion();
        if (filterVersion != null) {
            try {
                return this.unmarshal(InputFactory.createXMLStreamReader(xMLEventReader), filterVersion, clazz);
            }
            catch (XMLStreamException xMLStreamException) {
                throw new JAXBException(xMLStreamException);
            }
        }
        Context context = this.begin();
        try {
            JAXBElement<T> jAXBElement = this.unmarshaller.unmarshal(xMLEventReader, clazz);
            return jAXBElement;
        }
        finally {
            context.finish();
        }
    }

    @Override
    public UnmarshallerHandler getUnmarshallerHandler() {
        return this.unmarshaller.getUnmarshallerHandler();
    }

    @Override
    void setStandardProperty(String string, Object object) throws PropertyException {
        this.unmarshaller.setProperty(string, object);
    }

    @Override
    Object getStandardProperty(String string) throws PropertyException {
        return this.unmarshaller.getProperty(string);
    }

    @Override
    public <A extends XmlAdapter> void setAdapter(Class<A> clazz, A a) {
        super.setAdapter(clazz, a);
        this.unmarshaller.setAdapter(clazz, a);
    }

    @Override
    public <A extends XmlAdapter> A getAdapter(Class<A> clazz) {
        return this.unmarshaller.getAdapter(clazz);
    }

    @Override
    @Deprecated
    public void setValidating(boolean bl) throws JAXBException {
        if (!this.isPropertySaved(Boolean.class)) {
            this.saveProperty(Boolean.class, this.unmarshaller.isValidating());
        }
        this.unmarshaller.setValidating(bl);
    }

    @Override
    @Deprecated
    public boolean isValidating() throws JAXBException {
        return this.unmarshaller.isValidating();
    }

    @Override
    public void setSchema(Schema schema) {
        super.setSchema(schema);
        this.unmarshaller.setSchema(schema);
    }

    @Override
    public Schema getSchema() {
        return this.unmarshaller.getSchema();
    }

    @Override
    public void setEventHandler(ValidationEventHandler validationEventHandler) throws JAXBException {
        super.setEventHandler(validationEventHandler);
        this.unmarshaller.setEventHandler(validationEventHandler);
    }

    @Override
    public ValidationEventHandler getEventHandler() throws JAXBException {
        return this.unmarshaller.getEventHandler();
    }

    @Override
    public void setAttachmentUnmarshaller(AttachmentUnmarshaller attachmentUnmarshaller) {
        if (!this.isPropertySaved(AttachmentUnmarshaller.class)) {
            this.saveProperty(AttachmentUnmarshaller.class, this.unmarshaller.getAttachmentUnmarshaller());
        }
        this.unmarshaller.setAttachmentUnmarshaller(attachmentUnmarshaller);
    }

    @Override
    public AttachmentUnmarshaller getAttachmentUnmarshaller() {
        return this.unmarshaller.getAttachmentUnmarshaller();
    }

    @Override
    public void setListener(Unmarshaller.Listener listener) {
        if (!this.isPropertySaved(Unmarshaller.Listener.class)) {
            this.saveProperty(Unmarshaller.Listener.class, this.unmarshaller.getListener());
        }
        this.unmarshaller.setListener(listener);
    }

    @Override
    public Unmarshaller.Listener getListener() {
        return this.unmarshaller.getListener();
    }
}

