/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.factory.sql;

import java.io.BufferedReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.apache.sis.internal.jdk8.BiFunction;
import org.apache.sis.internal.metadata.sql.SQLUtilities;
import org.apache.sis.internal.metadata.sql.ScriptRunner;
import org.apache.sis.internal.referencing.Fallback;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.referencing.factory.sql.InstallationScriptProvider;
import org.apache.sis.setup.InstallationResources;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.StringBuilders;
import org.apache.sis.util.logging.PerformanceLevel;
import org.apache.sis.util.resources.Messages;

final class EPSGInstaller
extends ScriptRunner {
    static final String REPLACE_STATEMENT = "UPDATE\\s+[\\w\\.\" ]+\\s+SET\\s+(\\w+)\\s*=\\s*replace\\s*\\(\\s*\\1\\W+.*";
    private final boolean replacePilcrow;

    public EPSGInstaller(Connection connection) throws SQLException {
        super(connection, 100);
        boolean bl = false;
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        String string = databaseMetaData.getStringFunctions();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (!string2.equalsIgnoreCase("REPLACE")) continue;
            bl = true;
            break;
        }
        if (!bl) {
            this.addStatementToSkip(REPLACE_STATEMENT);
        }
        this.addStatementToSkip("COMMIT");
        this.replacePilcrow = false;
    }

    public void setSchema(String string) throws SQLException, IOException {
        if (this.isSchemaSupported) {
            this.execute(new StringBuilder("CREATE SCHEMA ").append(this.identifierQuote).append(string).append(this.identifierQuote));
            if (this.isGrantOnSchemaSupported) {
                this.execute(new StringBuilder("GRANT USAGE ON SCHEMA ").append(this.identifierQuote).append(string).append(this.identifierQuote).append(" TO ").append("PUBLIC"));
            }
            this.addReplacement("epsg_alias", "Alias");
            this.addReplacement("epsg_area", "Area");
            this.addReplacement("epsg_change", "Change");
            this.addReplacement("epsg_coordinateaxis", "Coordinate Axis");
            this.addReplacement("epsg_coordinateaxisname", "Coordinate Axis Name");
            this.addReplacement("epsg_coordoperation", "Coordinate_Operation");
            this.addReplacement("epsg_coordoperationmethod", "Coordinate_Operation Method");
            this.addReplacement("epsg_coordoperationparam", "Coordinate_Operation Parameter");
            this.addReplacement("epsg_coordoperationparamusage", "Coordinate_Operation Parameter Usage");
            this.addReplacement("epsg_coordoperationparamvalue", "Coordinate_Operation Parameter Value");
            this.addReplacement("epsg_coordoperationpath", "Coordinate_Operation Path");
            this.addReplacement("epsg_coordinatereferencesystem", "Coordinate Reference System");
            this.addReplacement("epsg_coordinatesystem", "Coordinate System");
            this.addReplacement("epsg_datum", "Datum");
            this.addReplacement("epsg_deprecation", "Deprecation");
            this.addReplacement("epsg_ellipsoid", "Ellipsoid");
            this.addReplacement("epsg_namingsystem", "Naming System");
            this.addReplacement("epsg_primemeridian", "Prime Meridian");
            this.addReplacement("epsg_supersession", "Supersession");
            this.addReplacement("epsg_unitofmeasure", "Unit of Measure");
            this.addReplacement("epsg_versionhistory", "Version History");
            if (this.isEnumTypeSupported) {
                this.addReplacement("epsg_datum_kind", "Datum Kind");
                this.addReplacement("epsg_crs_kind", "CRS Kind");
                this.addReplacement("epsg_cs_kind", "CS Kind");
                this.addReplacement("epsg_table_name", "Table Name");
            }
            this.prependNamespace(string);
        }
        if (!this.isEnumTypeSupported) {
            this.addReplacement("epsg_datum_kind", "VARCHAR(24)");
            this.addReplacement("epsg_crs_kind", "VARCHAR(24)");
            this.addReplacement("epsg_cs_kind", "VARCHAR(24)");
            this.addReplacement("epsg_table_name", "VARCHAR(80)");
        }
    }

    final void prependNamespace(final String string) {
        this.modifyReplacements(new BiFunction<String, String, String>(){

            @Override
            public String apply(String string3, String string2) {
                if (string3.startsWith("epsg_")) {
                    StringBuilder stringBuilder = new StringBuilder(string2.length() + string.length() + 5);
                    stringBuilder.append(EPSGInstaller.this.identifierQuote).append(string).append(EPSGInstaller.this.identifierQuote).append('.');
                    boolean bl = string2.endsWith(EPSGInstaller.this.identifierQuote);
                    if (!bl) {
                        stringBuilder.append(EPSGInstaller.this.identifierQuote);
                    }
                    stringBuilder.append(string2);
                    if (!bl) {
                        stringBuilder.append(EPSGInstaller.this.identifierQuote);
                    }
                    string2 = stringBuilder.toString();
                }
                return string2;
            }
        });
    }

    @Override
    protected void editText(StringBuilder stringBuilder, int n, int n2) {
        switch (n2 - n) {
            default: {
                return;
            }
            case 2: 
        }
        String string = "Null";
        stringBuilder.replace(n, n2, string);
    }

    @Override
    protected int execute(StringBuilder stringBuilder) throws SQLException, IOException {
        if (this.replacePilcrow) {
            StringBuilders.replace(stringBuilder, "\u00b6", "\n");
        }
        return super.execute(stringBuilder);
    }

    public void run(InstallationResources installationResources, Locale locale) throws SQLException, IOException {
        long l = System.nanoTime();
        InstallationScriptProvider.log(Messages.getResources(locale).getLogRecord(Level.INFO, (short)11, "EPSG", SQLUtilities.getSimplifiedURL(this.getConnection().getMetaData())));
        if (installationResources == null) {
            installationResources = EPSGInstaller.lookupProvider(locale);
        }
        String[] stringArray = installationResources.getResourceNames("EPSG");
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            try (BufferedReader bufferedReader = installationResources.openScript("EPSG", i);){
                n += this.run(stringArray[i], bufferedReader);
                continue;
            }
        }
        l = System.nanoTime() - l;
        InstallationScriptProvider.log(Messages.getResources(locale).getLogRecord(PerformanceLevel.forDuration(l, TimeUnit.NANOSECONDS), (short)23, n, Float.valueOf((float)l / 1.0E9f)));
    }

    private static InstallationResources lookupProvider(Locale locale) throws IOException {
        InstallationResources installationResources = null;
        for (InstallationResources installationResources2 : DefaultFactories.createServiceLoader(InstallationResources.class)) {
            if (!installationResources2.getAuthorities().contains("EPSG")) continue;
            if (!installationResources2.getClass().isAnnotationPresent(Fallback.class)) {
                return installationResources2;
            }
            installationResources = installationResources2;
        }
        return installationResources != null ? installationResources : new InstallationScriptProvider.Default(locale);
    }

    final String failure(Locale locale, Exception exception) {
        String string = Messages.getResources(locale).getString((short)2, "EPSG");
        String string2 = this.status(locale);
        if (string2 != null) {
            string = string + ' ' + string2;
        }
        return Exceptions.formatChainedMessages(locale, string, exception);
    }
}

