/*
 * Decompiled with CFR 0.152.
 */
package com.github.junrar.vfs2.provider.rar;

import com.github.junrar.Archive;
import com.github.junrar.exception.RarException;
import com.github.junrar.rarfile.FileHeader;
import com.github.junrar.vfs2.provider.rar.RARFileObject;
import com.github.junrar.vfs2.provider.rar.RARFileProvider;
import com.github.junrar.vfs2.provider.rar.VFSVolumeManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.apache.commons.vfs2.provider.UriParser;

public class RARFileSystem
extends AbstractFileSystem
implements FileSystem {
    private final FileObject parentLayer;
    private Archive archive;
    private final Map<String, FileHeader> files = new HashMap<String, FileHeader>();

    public RARFileSystem(AbstractFileName rootName, FileObject parentLayer, FileSystemOptions fileSystemOptions) throws FileSystemException {
        super((FileName)rootName, parentLayer, fileSystemOptions);
        this.parentLayer = parentLayer;
    }

    public void init() throws FileSystemException {
        super.init();
        try {
            this.archive = new Archive(new VFSVolumeManager(this.parentLayer));
            ArrayList<RARFileObject> strongRef = new ArrayList<RARFileObject>(100);
            for (FileHeader header : this.archive.getFileHeaders()) {
                RARFileObject fileObj;
                AbstractFileName name = (AbstractFileName)this.getFileSystemManager().resolveName(this.getRootName(), UriParser.encode((String)header.getFileNameString()));
                if (header.isDirectory() && this.getFileFromCache((FileName)name) != null) {
                    fileObj = (RARFileObject)this.getFileFromCache((FileName)name);
                    fileObj.setHeader(header);
                    continue;
                }
                fileObj = this.createRARFileObject(name, header);
                this.putFileToCache(fileObj);
                strongRef.add(fileObj);
                fileObj.holdObject(strongRef);
                for (AbstractFileName parentName = (AbstractFileName)name.getParent(); parentName != null; parentName = (AbstractFileName)parentName.getParent()) {
                    RARFileObject parent = (RARFileObject)this.getFileFromCache((FileName)parentName);
                    if (parent == null) {
                        parent = this.createRARFileObject(parentName, null);
                        this.putFileToCache(parent);
                        strongRef.add(parent);
                        parent.holdObject(strongRef);
                    }
                    parent.attachChild(fileObj.getName());
                    fileObj = parent;
                }
            }
        }
        catch (RarException e) {
            throw new FileSystemException((Throwable)e);
        }
        catch (IOException e) {
            throw new FileSystemException((Throwable)e);
        }
    }

    protected RARFileObject createRARFileObject(AbstractFileName name, FileHeader header) throws FileSystemException {
        return new RARFileObject(name, this.archive, header, this);
    }

    protected void doCloseCommunicationLink() {
        try {
            this.archive.close();
        }
        catch (FileSystemException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void addCapabilities(Collection<Capability> caps) {
        caps.addAll(RARFileProvider.capabilities);
    }

    protected FileObject createFile(AbstractFileName name) throws FileSystemException {
        String path = name.getPath().substring(1);
        if (path.length() == 0) {
            return new RARFileObject(name, this.archive, null, this);
        }
        if (this.files.containsKey(name.getPath())) {
            return new RARFileObject(name, this.archive, this.files.get(name.getPath()), this);
        }
        return null;
    }

    protected void notifyAllStreamsClosed() {
        this.closeCommunicationLink();
    }
}

