package POE::Component::Server::AsyncEndpoint::ChannelAdapter::Config;

use warnings;
use strict;
our @EXPORT = ( );
use base qw(Exporter);
use vars qw($VERSION);
$VERSION = '0.10';

use AppConfig ':argcount';
use File::Find;
use Carp qw(croak);

sub init {

    my $self = shift;
    my $alias = shift;

    my $base_dir = 'endpoints/'.$alias;

    my $config = AppConfig->new(
        {GLOBAL => {ARGCOUNT => ARGCOUNT_ONE}},
        'socuser' => {DEFAULT => 'user'},
        'socpass' => {DEFAULT => 'pass'},
        'stcuser' => {DEFAULT => 'user'},
        'stcpass' => {DEFAULT => 'pass'},
        'soap_proxy' => {DEFAULT => undef},
        'soap_service' => {DEFAULT => undef},
        'mq_address' => {DEFAULT => '127.0.0.1'},
        'mq_port' => {DEFAULT => 61614},
        'ikc_addr' => {DEFAULT => undef},
        'ikc_port' => {DEFAULT => undef},
        'popper_freq' => {DEFAULT => 10},
        'soc_retry' => {DEFAULT => 10},
        'start' => {DEFAULT => 0},
    );

    my $fn = undef;

    # find and load endpoint config file...
    find( sub{ $fn = $File::Find::name if /^endpoint\.conf$/ }, $base_dir);
    $config->file($fn) if($fn);

    return $config;

}

1;

__END__

=head1 NAME

POE::Component::Server::AsyncEndpoint::ChannelAdapter::Config

=head1 DESCRIPTION

Encapsulation of the configuration details of the Endpoint

At the moment, you don't have to use this class directly because it
is used automatically by the ChannelAdapter class. This may change in
future versions because we want people to be able to extend the
configuration options.

Inside the ChannelAdapter class there is a bit of code as such:

    # our object
    my $self = {
        config => POE::Component::Server::AsyncEndpoint::ChannelAdapter::Config->init($alias),
    };

The standard configuration options have default values and can be
changed with the configuration file generated by the helper script. As
stated above, the next release will have the possibility to extend this
class and let you define other config parameters for constants and
other implementation specific information.

=head1 IMPORTANT NOTES

The name of the sub-directory containing the Endpoint MUST MATCH the
Alias used to initialize the configuration object.

=head1 SEE ALSO

L<AppConfig>

L<POE::Component::Server::AsyncEndpoint>
L<POE>


=head1 AUTHOR

Alejandro Imass <ait@p2ee.org>
Alejandro Imass <aimass@corcaribe.com>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2008 by Alejandro Imass / Corcaribe Tecnología C.A. for the P2EE Project

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.8.8 or,
at your option, any later version of Perl 5 you may have available.

=cut


