# Generated by default/object.tt
package Paws::SageMaker::ModelMetrics;
  use Moose;
  has Bias => (is => 'ro', isa => 'Paws::SageMaker::Bias');
  has Explainability => (is => 'ro', isa => 'Paws::SageMaker::Explainability');
  has ModelDataQuality => (is => 'ro', isa => 'Paws::SageMaker::ModelDataQuality');
  has ModelQuality => (is => 'ro', isa => 'Paws::SageMaker::ModelQuality');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SageMaker::ModelMetrics

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SageMaker::ModelMetrics object:

  $service_obj->Method(Att1 => { Bias => $value, ..., ModelQuality => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SageMaker::ModelMetrics object:

  $result = $service_obj->Method(...);
  $result->Att1->Bias

=head1 DESCRIPTION

Contains metrics captured from a model.

=head1 ATTRIBUTES


=head2 Bias => L<Paws::SageMaker::Bias>

Metrics that measure bais in a model.


=head2 Explainability => L<Paws::SageMaker::Explainability>

Metrics that help explain a model.


=head2 ModelDataQuality => L<Paws::SageMaker::ModelDataQuality>

Metrics that measure the quality of the input data for a model.


=head2 ModelQuality => L<Paws::SageMaker::ModelQuality>

Metrics that measure the quality of a model.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SageMaker>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

