# Generated by default/object.tt
package Paws::AppMesh::ListenerTls;
  use Moose;
  has Certificate => (is => 'ro', isa => 'Paws::AppMesh::ListenerTlsCertificate', request_name => 'certificate', traits => ['NameInRequest'], required => 1);
  has Mode => (is => 'ro', isa => 'Str', request_name => 'mode', traits => ['NameInRequest'], required => 1);
  has Validation => (is => 'ro', isa => 'Paws::AppMesh::ListenerTlsValidationContext', request_name => 'validation', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::AppMesh::ListenerTls

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AppMesh::ListenerTls object:

  $service_obj->Method(Att1 => { Certificate => $value, ..., Validation => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AppMesh::ListenerTls object:

  $result = $service_obj->Method(...);
  $result->Att1->Certificate

=head1 DESCRIPTION

An object that represents the Transport Layer Security (TLS) properties
for a listener.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Certificate => L<Paws::AppMesh::ListenerTlsCertificate>

A reference to an object that represents a listener's Transport Layer
Security (TLS) certificate.


=head2 B<REQUIRED> Mode => Str

Specify one of the following modes.

=over

=item *

B<STRICT E<ndash> Listener only accepts connections with TLS enabled.>

=item *

B<PERMISSIVE E<ndash> Listener accepts connections with or without TLS
enabled.>

=item *

B<DISABLED E<ndash> Listener only accepts connections without TLS.>

=back



=head2 Validation => L<Paws::AppMesh::ListenerTlsValidationContext>

A reference to an object that represents a listener's Transport Layer
Security (TLS) validation context.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AppMesh>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

