#!/usr/bin/perl
# based on fl1.mpg
# http://bmrc.berkeley.edu/ftp/pub/multimedia/mpeg/mpeg2/conformance-bitstreams/audio/mpeg1/compliance/

use strict;
use integer;

my $n;
use Test::More tests => ($n = 49) * 8 + 3;

BEGIN { use_ok("MPEG::Audio::Frame") };

$MPEG::Audio::Frame::lax = 1;

my $i;
for (1 .. $n){
	isa_ok(my $frame = MPEG::Audio::Frame->read(*DATA), "MPEG::Audio::Frame", "frame $_");
	ok($frame->mpeg1, "frame is MPEG1") or diag unpack("B*", scalar $frame->header);
	ok($frame->layer1, "frame is layer I");
	ok($frame->has_crc, "frame has CRC");
	ok(!$frame->broken, "frame isn't broken");
	is($frame->bitrate, 384, "bitrate");
	is($frame->sample, 32000, "sample rate");
	ok($frame->any_stereo, "frame is some kind of stereo");
	$i++ if $frame->joint_stereo;
}
is(MPEG::Audio::Frame->read(*DATA), undef, "nothing else in the file");
ok($i, "at least some frames were intensity mode joint stereo");

__DATA__
홈wwfwUfUUUUDDD3D"3""      0am,0Lm4u}~y~~㎺߿{ @~߿}}{mݶ 0 ?o @ >{n
 G_߿}Ϡyw{wm ΣvqX4mp@뮻B{ۺM %bW78PqӨqsmhRTVRnCv	M}riָ#Ksͧy~_7io6VT46TAF1r@_>$5]0@ pB uI	9;&MDJNC!uu|&%ݻ(au!:"mݶw4Ao/Imqֽ{n*  W`}Ϡyaw{wmD+ݪveT20ĒϾj Y#TqT@R%00ʘ!31hE|tO?M3J0KuE*.vxN<?3{rcHq(пЌ+l6"҉]5t؏	ӆ?20cqAj\_-;;&Fv1Z*hz@kUU޻UjLԼ76wF'tzqm)F
Ѐr<\|BsPM'_P՘K0:uzgWFPoT;.vsd\Ș1qfۃl/-̡G&fa/6^lnC:i^:Lnיȗ+֐م	*+\#ȭ&׻y3iX zᚎٚ5zxG xPÒMVwi%Wal TawwwvfUD3! <?-[ /^n^\z}vy\v/-"/EY,[M[ӊuj^T_mM*D&U(fBV<F:s2[m>˫YZWLo{zyjMNF@yRt^eK:YZ[2[-9G~7:\k[>EvvνJzd:pt]5نbA ]=v{fY9j-vڷoXGnj:iN(VFjoz~DNoGU'Xn)tit{6z|iy20udh'X)6;v;$WM%lqaXlgl_e!i5N#ZHW$wnu|k&S
HntcN3avu* dr4wwwwwffwfffUTC" 3MM?<, 0@`t.~ba"!Æͤ۷tHv40$"J4$i /NMҚ,caC\n?ŗ~f>>nYL}1K誕Έ[ń	!YFR""*)˕˟gZ@`؁I*)1&""!˗ϗ~gjX% Ǻd6JIڲXd]Tf-bvٟf>N|ف㛦vuDFX4$uϘ_7
fVV65ūV\ńՌqu	'~.w&baaMMvu۷Nb#I<Qt !CQsUxvu]]rc\0ETvP0aq_啕mmӟe=><ixA^?(~S^k݅,Y2]!8y}ẗwffffffffUUfUTD3! Q0Y8qtSQNP>LzȢ0B0lcMʰ* PzaJ=)Rl٣J+u4v#;5Pv0@e@:eez͖ݻ
$H&Y[-Ԣs!)?~  #,D>vJpmwkfV-[I^{~hfٳxTl֭pÇmraqB
-k±y
Zix
T7ʵaCN6>a^^|YrH|4e]uaaEl(%HZכIIgnÕ)˖ܹT(zSne#D7ܟ$#ʺ6hѣHbŇ
geZmXgw-ܵk\bW<xX0EӤ(>~w9Lr%ɾMqq$Gϙ2|ÉagrNI$1 `{!nnT$z$G._i%fr2P {ffUUffUUUUUUUEDDDD33"""     4M߾WJM~^zDI!YfZj1F0;#j#1f)SLRjߪmÆl0AEg؅Ymba!sp.ߎ48qȢi a"Veji+pݻwO*y?,tP뮻)#kfbm%6ÓaFgn*V硅V%$b9ӜDBRHbWˍ7ml첺28䲾:ZsֶRfwQ<߿y]V&Yi7m]ldc9`mCZsۜ8sM4ԩBI4/zkg7UXpiӠ)H|4r<wnY]uqh)1DD7"J2u+G0"V1c)GuYn60&!өQHaÖW߂]E'Br
;w͆l}A^8LtPέ]ٛm DhgwfT3!eMI/p8%+'^NjՀ\:c-)z<R:J!]HQz0&`&B#pr̆zg5&+zRĥ9s5|2	Vrsv	Ihk]Ŵi75PJXٶ%NHxfA2֣R'Q:v'".DXj"Ǚ}|e;9Jf3x[rQsc71ыƞb5gvr\D^w=\9`r+Lq_ʋ)qT:d*0O0iLkOa`LC)TJqeh,b)_Q
pᗖԁWf&׍s3#!d>	{$!T-2WQ:AilW46'Er*\ Iٟ[Q!%2*V?SPNwM-)1dc	B+m~++ Tw݈DDhwveD20燈 '#vdy
Vpٛa2Ў)jjF/|CAsieyLi:<ggY4:01cԢRpjrYkk_C]fD<gs˲\Z\mHx<~5:3͌0#\ܹ+h
sc.EH6`eҗ*PVVsXASR^L
T'ϗ0COm5E[Έ+͊>>nMtYѕ+Knigd
FП3

a8<<КH
byd0ՇJjkkLA)'sflٳ|>#&+ygy@'pIfzU8+w7އCcU̒̉nmBaa[3fNGӯYf3Z闈^Il	͒<^`4y82AVO:G&L:PZT~+xE§- dkwU33DfwwveTC"4奩QJ/Sǁ3b<;G4Cj\YI6i)!P# Eb*.Q8;wCrm&6rw̙EW^.^r03=CC>y3^%35Z`֛ZtŊ,N8)E%$9g
&fvRuy(&vBK]8	ꢤ _]'^ġEeef3y#COxӝ0/8pWxjާm\%k9ˮ5EŹjͦ)l]郰xY󁘜fJA
fGZtFԤw
;<+/+FWx3˞WM%`jVaa\G"P@A](QBcJ*4^?zpk|Υmvg@ k%;0229`'.nta]O' TO|H;'JHט,qvtfw̪3""3UfwwwwvfUD2! M3U_bŵpkA
u_U%XzɱQB(KCQ[)qJ_mK3006Δ*[Z4^W^u#jF0ْm\__||GyoJK
,,}8F3|h
s0
l2TnXZP/X2@VwmW[ۛa߶~48w
o#%J##
B薌Q79jZdFD=
yӎx*99Qe?\P@v.3EhͿ5
gGz
zH_?r&Umh
^^&%&)Jm../^86HQ7]:ZZgcf8 0 G8sYn!@qqll\vjͭv5ts?Ы5YQ$$44,,|C.q* iUfw3"3UUffVUUUDDD33"   SM4,ifUUw['N%PTx ƭceq1 ڬqj<V29#ꪓ0ǔ8祖IfmV#AA!F+Kgu:TppA$m)LM.ݹ9T;c'{H̲Ǎu}]]xP&	1b	Udfme\Ө!G>[ͪ3
c-Q
61bcYek{ІeVW^D:wUVitꪯ<0ֵ{tTi$f;EǏeZ9eXavBA`/:uUUwߪ&LqªBd 3"A/h^ʪۻm
9~i	J1fU_>a+Zb.Um'nOiK6NTT<<yFaHQ4μ}u׽kkYU DdEgweT20OSפ4tKRdPΦ'jWgg@PL+tP-]E9|A޾f@Ic#jMIHR|]NW-cIn׸26ԭ ZfGڼ>Xǿ2"/4C'V2D#%=ϣtnPnLג;(}l+NXïR办fA[պZ˿t*?UOl>/3il"Y8\q}6<ŲU񬌌v4?~_]n[}
8s_ PɣgtqPd	;tٳl.QD2;'G<iW ܷjU:IC[*夤v,PAݛPZ\<"~UAqߙ9U1 e[뛳u\U"?	`R U!)\K:\+¨T\AET~bO6ZQt]JO;{  TLԈݓ#EgwfT3!}EM}t]Fr>%H__h%"! dzX36 -; !8L_pDI[4vg	aiyaT*`=PIB v[{T_MV7LTs+`p6x*
Qʄ}>co/7˂-1E+JH7z;
<(ߪKY7FnZW^l:.bظq`  e Y7/w
՜zE~
w:z-^"Ɵq79_ɲ#HQ`e@ʕVX
읺d͖B)u۶X z YnD]v@v[CFc<W!:W)\I),c9a;6nk}ovSlg2j5ėeN`w?p?ŘKQ\1@v! dˈU""4VxwveD2ﾢMA
vT|Zf-Y .HvF15pgŊn&)x<S$dux
9{93L{6h93ddRJ
v\,{u:^W`7C%ys]m\	CkGI,/K%IQfT(F Ir-ef'/+7	k5K%fjGӶglĠRۚCTLP6=ho7څAqy<~]ڻ'RIIfu0cð[

Ó$ǛaR0m{Mg_r׳2Ajd2#x<A^m`VY&M͏dӪ,JbYTv]ׅByV[}Ҙ5~3ʀ_/O'Ceey^pYnSA{n6'jXh2uL	$,{twf3"3DfwvfUC"U0JZE	ӿNOURjg-9llywK!ܹ&T` )Y"fj`Qj!H2wU"1.9-I&Mo	{=pcǟPV"_zΥS
t: p4z>d
*(Q1m݌e$qGraa0yqUuHKZY_BtLXFBakF4h`}nUn!n6u4@ՉV*iӓIŁØ1!ae4BGFc1È
 4UwUm1haGmuKOܹ>puT\Fojdz=KFk5r0a3U mUq>>"Mqmm^O$NsH=2zCVZ_ՁPxP wwwwwwUfD "3DUUUUUDD33"  u<bammevyͽUV!]$Y$kXɗyllyyxxqqa,9{U2Y[m}cQ!*`㣞y/Ŀn"8ayekwmWGDWVFGe<`U[Uk^ybz1s"VVV!BweZPVV׊'mc%'yzzff\\wwttmC8ӆsUJYXb^yXǾUb[f&##m'UIUΖZێ8AwmW(*(WG?U[YfyuYU"!ѝ^<xa4٦1UV']aQHa艙\\ss#,TRVFf2b!QEf&[XXPPc#'i^]yBUIݭ}]i mQfmX(*zyǗ]~hId9U[weUV!)YRTD̩CEVxveCﾎ3U_<el؞!b$I﬋M~B}'LinK71$A,dv%[og=@g{9(@P+;JUiH2U93hR]]@EE˘zӕϿ
Ľ	Aa!i=\k*hۘmrۊKR8*E|WȬep݈~?=p"M[]P؄<GM^;{Nis`@(XUxg^	`k|
/RpAȱDt9&޵bld5pr*.vmtK5hcq{d%%HǊ1VjˤLJv$2
ix2!pHq/:%׺x+x8R=54j݌2)r21{fJaL1kFlt.w;؂f1T	.K T wC#DVgwweC"0Ǟ\8c{va&^up/,+5ҙf8MNSrQGj	XXyT*d)q]lm`9GW}wڭ6N

ܾ4LFa.Fm݌&i9c,^ed((+%-ZLԧ&7ScXۃp1Ld o  #|L?uW^g=Ns{}3\ʌpnn݌!l&8=Ti}o23!rVV+de7{ڏ&ADTV\˘7ߓY*)'+ÏV}7ʩ9T&G]ҙxz"p%t-ghA\BMsY97kgwYY;_1 ;aoňWJң:`	W&%__{6zUZ+yvݭP4F_[f::9ꂊݳ}W8f	Ɠ d2\fUwR#4EVfT3!m4M/ﾢazIX)߻)IӨ  Xy^j`kC
®ðrfLכ=p 867y
᷆Fƿ;	rlb!]WTJ\V	\p,h7ҷ-pZ}>%ILsx)>s:p@:?o[
d17M2Vkӆ(,[xأb(ԠBfg/k;G"CBK.OPT{
)#Ḣ(u]U3fzp1buy
C<wEh5y$/P^[QTBu
S2[A7'vDeYN}9j!wj#gkq>꺯3rд1"A.]T㖮4G	㋻gS{%GIg,:FtgD[aGwB\0ÚbQCal.6MP
/<C8t3򘈙wUUݻ3 #4EUT2!eMQO+fٶ-<^㱎@,+XL)m~5}_Z9Gw{D<B+KfYj| ̲>!Cu?Rܽ0`MpFfƺ,ƴk#LBt<wQKRm[LDǻ>+⪫C6i(-6"PT'
D<H<0]AuB<Bp/*u֩<4+Mk8NS++dXI۴.if;<obF.
1S2ق_));.8D1?ci
U^d)ips=l3GQ?譢:;N[1#\\L@'k33*ã278l3)%6Ե: JJ<<BA =wwDDUf   """33333" ノ4ppil[a\Ha	_J~UdIwxw{UT0Uz
 Ș9ΆjuG8߿UVm!eݵVfhQYn]Os|=wGUwfwfwmUS)erV%I~~ yU٦UYUxx2d2$!ns`miI䳑6)~[IUWwt_&ZabX)訫Y}{ @UVmݙݙYyzM&JHz+BB~
0uϩU&fUwfIV1j5,X}guݐsמK~qUnFٙUccY
x0W^(RmgxVTxV
6秨B's{@YJ!U!%Vp8'ɪj
sB}G VFfUUmUyh"vuvv{}&kuUYdU Dܘd3DUfwweCe0Î￾ﾅ\Ⴜ7U#|*"9d&V7GO/u6ɶLD6J&f羏6;a%qmlXjcTLF%pɃGv$3}E\ &0"<M2n+;c"B	,9ȿEÎy-ʶ
a
:΅S2;'D2@ە(S%+(iL$A@?F+.֚d$87Va<(E5/g)q5V8LRώ|A<^𑄋.ӱ:FUG%h
h!1e
6qhLCoMJB}k1#8լf۝D[ȝg] mjǡz~xtvyמ Urv&hbjNIn'Ƴнqφ|'ԕV`e㤦\p T,יg"#4EUUC!I#]ﾈ)!lq.K$_f
 v}̅<4 ZD^~(J%vwq5M)j	͜ZeYb<"ocjf}ןqn޻=u`
i$28m?)hu#^w;*[s
 ph|Jݾi V6#
wїRMdc:~70dbX{zՋa&܉5T]:+(|9(TrzdEblM8I	5fjf[P'gY(hFn$\:'Zw:pwt'B:W޷B6Ƿ"d#-dY6jUUj@dXe]8"/ۦs\n^}F@sn^&hrw){9'PsI᲍^e6
P	9
B>!#DV0IZ6XG\)9g,(z'}S1#&V\z d섉wUD~!"#4DDC!ﾾM4,RR+J	AG(z8nlFKmKol7Fo
5rRחem \n|!8cԴ~Wk!cqlꪲ9xOwV{ڣTt.º3Fcpuw{ݻR4$AR_
aQ̉'	8Ab˹2em>O	!glC(uXgn^57>PS:ni;w~3b.OR)@ctz.:w/r\_((BiAXMM>}>#@fLșPj0Ir\pNDibK$jMI߻UJ]v|&f\q)~k1\Be2H,i@H	cYk/+CC,sKlv[Zu`*grY9ge`㔠ߑ<9twwD3D1"#320ﾇ/~ x{h#NBxi
UBheHqdX$s&%fkGX4oTVCfFrd)	ED3{3Tg)K"33dBa2KW5nqgppcZy`rYV$V_/t:)n#KL!UkEػ_"Ř>Db2["Hk_gaWCAc_V:3%߁m7嵩j&S;a.\&E^0hwc软k~/pDՕKnрB cYz*SDD9o{d	XC*RudM}{kDy@湮۷DϷUvUX<WW`HJWUiZaX*
y<z[  3 x*^#"y>Nk-BLc\U wwU33Df     "" EM?vv]*jڷ{ʲ8Yww ,qcUUmX-eYXq\YRTmFppvg{9+QZUUVU^^z]=KR°aUfsnUmXju:eu"Ibr\6``x)H2񗟿UUVUiiiuuDdfYwp,eUEWSg3c1h0jǦuvhd8>UUTUb1!jZv]NvjHH ffsT%UUXL%vgWyt)zƱqȈBDR"cUPVU[yVUcYix6uZַ7:D{ߒjUUUnEWT)UUUmg9ΆuWw9Oj@B
UUVUxxDRoYփuejZVw{
l` EUUWǳm#oazf^W]]mII/yaBUUY$U D<ܗgC34DEUCﾢ<ﾏlg+9V(1Ak!ŒӘ}q,:?Ԉdbj,('@rp)78upa*1Q+
719!{Sژv÷rHx_ؾBc
/#"{[M+8l̖dOjƠ[кARX`C~[3pxiy35)1*V.oGyg:rX"	0=Obzg[Ys60Ο279z],t"9ã_nk{z{gNCmy;J͘m^
tEtWJ~SeXɵia?43L· w缽彻"
t
(=5/wVާo;T?YwsS7/{EF2^h?@)
֜T[+)QJhEv|ec)^FEs,af<6ml8.VJqWq+?3.` T?̙UnB"#320U}h/ܓk8yGKT(R8q=n$>efVi`nښb?F+I92L}_p*`YHp	qmYRg]V+ .mx/	7Y+^1(j$-'Z5r3·m(  r.viYXJ}Go^s侯A	`_{q/)]lV3]쩉xNb?p֪j }Ϻ
AIG~ w^=t\
2z/ENB$:C:SჟŊ#|ChܻyujRq_a,EБ*}|gq!%{XK9*i8v|ػO%U_'{ŚcVc?rKڲF2ٖeZa=Ň)j7OJ"3 dsifTFb""!8ﾍu1V*TI,5ӊq(?
,Q#agU4 9
By=6Fh Pxx?Oڬ6C
n1VDzSxCp_izmߵTj^5z>SyC(Z]4&w{\5?j9Uu#H6F~o&{ɏBB[qӖ@T	[+h,oh&	2_ai\ʨ` 9t] #y0߻xo3Y?D6Um)!hrVa"\K4%]KuiR}HWmr\ICpo9L	DN?i9sP-U'0VUhZ+%a!fL<ǖJ`vnn7|ҭ
ASKRU]Z1f,~l8pPގ5H⋛s_xdLmm¸ZeL㜣Ti7fm&H˂jtfD333 qM?ﾞO$9hY>]+wW5Fpַwu^ӕmDuHș:GDX;"dK%dӧNl%UUF=OX.n(~Cw.\PY@KJ3
`+qHqB(E6@)3;Hd	eTh4{VV]a"JID<twww{K(?B3sx;II(U2.Ug3yh9p͸7_3K<zeKL&	x5`ML0Uks|o	LdDD _n˕UN}_]qn-)e CoiG_ʪq;<<S$4cwm8m9aUVK%ZVx8U
9'B`t\]:Zb U|M,KE.7vݴpI;;=5UP ]xfD3""3w           49<W:s2KvݺI8.j̓b!o8?sur9"h(r6]w]{fm'qGw'L{=ON48.slt6A6Au-)r19NS"_J+MnsJR@;QƱR屎@
>^UjjEe\!eGQzVv͡dwu ]TTlV+U=OL<.5okUװD-Yji4㷡l[c5ͥhT*4g:!)|̍UF!+q'2+$ВKAC!\.}fVն8#Xַ=dRfnEXfD:!QUmY9S-[W2?sLۻ>
zeBjɲ""_桨t:#kb$mwDE Dx˘eis"#3430M?ﾌyzKlrw}TўTcڭ߂ykgt!ٜ0sM,b8|u9Aw&3y
8`4M7i4]xOچUxxEnYr̝!%	2wV{oC;\ʍح{N
	+N`<gqh1c<R0"I)HY4I(0ҊKhoh5CpΚۧ3&D;K^$RE1 JM7nI E2op9 h0Х
/Zm3pH/z`Dw͉!
ŋ eo,w]x׍)mwqfg5`9\+6%_,/~Uz"KBΏ
7؊4+B_uQVMݓLHO2`[(eK+nڙxk@Evl?a"=
44i|;PBP TX6T4"!iU_qf,ś}zQlfۍy6UUm6dY2fvg\A"E0듓!uV7d̚XK	5[˄8C}۝	zw:twH`BTUbPb\$Na&NZ\17=EGVbmflͤlrnNC$Glvӽ8Ja뱗Um(m
vDș! .ص#ݱ Z_eYց5E10eT9SxSE4YhgjGŚX[&n-o#"2&bf.>&aH?oU[MgYi>
AFir&`S&ʌU	]QJ)j-HM؝ܝacs!]UUmmϹ
cqxggy]h_u yllifns~T%AYyמ]YJA=8VUZM df؈S"^  ノ4eﾤRoF˹y1&!3|/m͹r\v,~ZgTUInZLi"'cu@N<E+U]1̆Ǆ0#w[kj3Vw&\ry*$3L<Ni;Gh>L#.nS*X
|ޗzdq0F	#]zUU*ȳ]gm~J<(0CXj|ΓEK6"۔/?V*BKI[#dQ>0&ti#)`gN5@<ܛPg-qwBu;Fy?/UgrcxZKF$į5f@(RgȖ%K#~S*8t94;-%@xOChlp[7D̔U[ozQ*(ۛj]n$**x߂J.^*58..<7T<rABp?
 Pt숙wUD3!(0    0Î;l[]w^fLHCDw䖖y!>m6x^>^TJDș4H!-oo7ak]Ϡ1hnzHsSJhewwe1U~]vxZiZZk¸2Wmx-""iTi\G"_K/*~VUmm}Ze	vUn	TUu\mͺ@OMgJbycd*dYnmת`7RT׵__u)U2BYu:Zsmx`uѺ7M] {SUBg)qӺvWp~_vjjX! jt:#t]#t/E&2kY򤋾z:6-X[_pص~~W!dCw]hZ#Ե l
v?7N
	מsڟ  6wwwU3" "̈         0Ymmyys9oC`0$WǶWȤR~}mUm4&.u߯ڝNQ(CxfUS(BByU'N-mjjQQn7.o7֡q+UbJc1#`S$x2hY\.iUopG^^S<U*Nmu:S)eUl½ e<mtm6NnJUJ^cck5{=T\N'	GG݅U強Q:aaVVX-4}>Gt:YfRU<
mppN`t:a0qys84jidUJC%ࡡ֋F
eo7w[JJU[ mbbkkbdWs9QQ'T
	,~~imx3EwwaalbGҩqM&-ey$Un@a D]ӻ̹TD~2""ﾾM40ﾈr'"qzSҟMm腙~ܽ.s =}vo!g*̇@Z7a9L[A_!P-pKYr5Ұ	Z%[꾬죮Nגbd]Dl!kilER6iz%_]&N4T=eĳ:1A˻[Ljq
7mލ}ka k.,.$6u˕Յ8؍_ f%(~s
ޙm3K2K$]ꫛ)CmhũpW-Wg6szwZ0VietkaꎜlՇt-4M{n=v<feF;W>@[mZM$[OJmdGW
.LN
arkMr7"@>poC'FKo*tm! TvC#K1  0Qﾤ)z]cr.FavA! 7-XZuc8d9Ck|vk9c>.+xCHX*
tMw.WWp!*k*Eӥ$$nѦ;eW%Z+FSJe_q^B(kco8ClS)"e]3#2`E).9]9rp\Z͠@u%iYɹ8=TdI_֟yz.S("ymiT6jY׆ٵ[)NQS~SdW!5,vUw\3SIfi!_xzŌG|kur:lTj&be}32;1]gAK. X(EfٶBX!<1
q'״pg:V!ivzjVBab!ywfFeZZbfU5Mi7qѺ7z~i6fmoaJϨrȌ)~U dCeB!$a   <US_m6b&	Ǹ_XkyVV9cBн75I߰(!>98|Q.Oi2Ll}_W&
6'IҴmڥ2XK	W*W+J҄NeI~jE'd\k&$)Z$:Y]%?pC{"gLCvà]KTu#[-RSXCJ1WH|=y^Wum_ulp=jU'ŏcB @,l͂Q}_O/iP{F<y4#sRNIk]HReFEym@"OIhVKIedQECǲ9F|czвF!I1EػA ȾBgƷ6)zmv%fY|o>&(H꺱yG֖)CmQ>.%+:Ίۘ-kt
wUD2}   ﾊ#4޺^EZez&(J;X	s}ki6n`2̳N3T-k[d6M mED=f[-WuݵmWyiZT
iGbXd2?Z剃&&I$>3ض1n7P xM[0y	z=+g^|z9NgobNME}k1η\;<;*|JҴ%	<#bm\8^VN^lnejb%-j`JzvY)6J$s9TXV
y$I4
IRQdYŮ\]㐄UgN(L%p$5{d%d'	v6a,&hO`mF
6L$IGQ/Wq[7G$44Q9
i-~?&s7wad(9 %~_ɘ̂}I֫Q8AΫ5JE34Lc쌏<?"  \wwwwwfU3"          4סUW؍ff!U|ooV5Fy<_O[엗hh(P<-pp{{yyߏ#I$Hj}>m6rr&(RUr'!iidhQMRHyyrU8G|%mmS)vf+__nnrIUn}>vaAMK%}}wwpbUp``Y,UD!Pv+OOzYUx	 vvJJK,YiiccdbUyO)]-__ww~~p9SG$?rU}-bbGL*U*}>BHl5{{dd(U䂂rrFF\Z}=vaá^i$U~}vvss`p9cm鏏]]fuRU
 D6˻vT26s04MϾ[yC$1ymtcd-e۲W31=eK6PeM9-CCU2l\Zc.AQ z}Hxةq^Or)ʉ=@B@hnG~Tv`A_>[%,B*~tZRcV5`%_(~4iV3,By3wqqT
B=TIKzv\{!&Q\oIY,]%n
g<x}7x7}b1tim,[bklgp1rݶ+񪮞"$rU99='(o)tׇe}Cd6DN! "T&:IB[J4*2 qE(ϋPۮj!FiiX_]!fV"YBt*)8N2,^
*/
)W"ϵʴ8:޽XՏu56HΝbl^nIMteP T2eC" qE0b7"dQf,x/M
یrml؎.ſH;NӔcpV֪ՙ)cNt. .eu6jm;pܜԚV*&,;k5<@ьb<J]|Y;ʈcR%(xe H(kcPA:Q/<M';>R1s7</_1PJ	(|[b͛V"G&Id27Q dèu#҄qn裑Qc6D<sݑ"9 s[z:G5jkYnsF5F3aЖTgSx&c}+0V{z$DĘp-nôM4n	wy@(0NiT9$qH`W7k@X ٶvѐ8fՊBv֊i\!* % d򅈈T2= 0Ȣ
rܷP9"H?ʩUE4M#HͼX`)/akk5C2UfsIRύyA{WSJz\DCf麏cVy^X"t3a̫+&IӴH1ԱE?f3FQ<(f3@Cphc/׋ZVx^hh\:bo#q{",rcH\wm%r+3>O8DPƊ2{=Ea+EludYvVհtI9Z5@YeYTuxFW&-+Li70
vM!=x/d0~BP|OmEFQx<6sayuj
p*
+J&'Fl/QY$Gefjovtt-
<s̰5
E j
Z&XgE\WĘ.*C
%v^tp(wwwUC!   ﾞsMI-rr^gSenhZkxeI `cqټ<&S2~OSѤh84
2Lx:M';J&3l$HZw"H{s9[q㋵\$qQM Md#l$R(PI#{{1ڱꪶ
suyǱՊE%Xd\43ye~.+Ou_
tm;`0YF82WCDDjj7CUl_{f1B~9d =^w o5VW[eCss1}b6w{/B#ᡘa~F}R6Q#F-7R)<^0po/0@j;V]o:o7
_oNK56^g#x3J$^似qU@ր \}fwwwwwwwwfD3"          0Ŗmnff)JZ5qqnn}}uu1J|qpnmrr_/XZU*+ll[[l٭wmQTTeFV !RR^^ZGs=xxqq__hΈmc=3 z65|S<~~smbH8#rRQeeJJffTw\Wr)pmmG"Yii[[dswmb8,1Z9Q#q⼼MMvvAI_wWz]^*)l`wllpfm_@
I$*)II~^\N'C!yyuu
Έm`Hp{==EF66W+c;3rrvvxx1wI_Y,lٕt:#$WWTTuuww&1wI_0	ω65ij`O'vvppnnA_y> D㞪̻T3"#^!c4ii
!_nh5xӟ%u{;C]o׻69<,R/qW	k3SB<&;&5_ƥT*$@9
16+0u}iK^+
fM{LƘFO>{繮i=Q)S:W	^i~c`,lVp	`sV9!va&ZiѮMY1N(3zEh-C93$Z-1o}H3zL4
\+l60qc~x/auk֠q!cu^D3W_;C<>1n
+tD=v% (q2>~ǤzE
čenA׆3Ҏb#htlp>]0n}-alJ:M^;9J6	!YW58Iԩ?F0,"?)^N.jv;џ>Clx A\5#<Z1e|cVLFҘa{sWP TҏeC"(1ﾆ<qhZ$	2@պnC4Wf_:3y6T dVƈܛ]^l[]
(5Y
CS;fђRJ[Kg "OcKܴo!1X7=Ҕ'I~hM#B-:;E%K*o'QuTj͹__YX %Mwqm0GX]+Ah1N)'f17ɒVjD- enaօRjO5:t.օP@/15U9·C2|YʎQzJ\YJvsª|glN$~ڮې*sZ4qVܐ/#oYQj-	2YNԠXN{f-7(8\i*Jyi+%\3P>I?bf51lr5[q.{^=
>7]	45o(rB0	 dweC! ́EMqϾnnd_#űWrl[x7]r5b,AOmC{LM3LM442!@rsI(TL5ku^,K [+B9K*d.'I}yu,V9eax=bغ6$D"]^/'3W/d#DDF#ɲjm>:.K-FQdYcZΐ6


OFya}vixivu`p9mɔRzpJ#			v]r8Q{*ʫA*oXݷ%jMqqA!A(.UՇ!gH}aU%p=A,[ZBp&&/:TJҗڸ&W,|~m[v<'9qZ%	[5U˲\WlNS!C[a4lvc\y
