## no critic (Documentation::PodSpelling)
## no critic (Documentation::RequirePodAtEnd)
## no critic (Documentation::RequirePodSections)

package Git::MoreHooks;

use strict;
use warnings;
use utf8;

# ABSTRACT: More plugins (Git hooks) for package Git::Hooks.

our $VERSION = '0.018'; # VERSION: generated by DZP::OurPkgVersion

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Git::MoreHooks - More plugins (Git hooks) for package Git::Hooks.

=head1 VERSION

version 0.018

=head1 SYNOPSIS

Use package via L<Git::Hooks|Git::Hooks> interface (git config file).

=head1 STATUS

Package Git::MoreHooks is currently being developed so changes in the existing hooks are possible.

=head1 REQUIREMENTS

L<Git::Hooks|Git::Hooks> v2.8.0 or later.

Git::MoreHooks uses L<Log::Any|Log::Any> logging API.
It must be installed even if you
haven't configured it to log anywhere.

=head1 NOTES

Thanks go to Gustavo Leite de Mendonça Chaves for his
L<Git::Hooks|https://metacpan.org/pod/Git::Hooks> package.

=head1 AUTHOR

'Mikko Koivunalho <mikkoi@cpan.org>'

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2022 by Mikko Koivunalho.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
