package Google::Ads::AdWords::v201710::AddressInfo;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'https://adwords.google.com/api/adwords/rm/v201710' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(Google::Ads::SOAP::Typelib::ComplexType);

{ # BLOCK to scope variables

my %hashedFirstName_of :ATTR(:get<hashedFirstName>);
my %hashedLastName_of :ATTR(:get<hashedLastName>);
my %countryCode_of :ATTR(:get<countryCode>);
my %zipCode_of :ATTR(:get<zipCode>);

__PACKAGE__->_factory(
    [ qw(        hashedFirstName
        hashedLastName
        countryCode
        zipCode

    ) ],
    {
        'hashedFirstName' => \%hashedFirstName_of,
        'hashedLastName' => \%hashedLastName_of,
        'countryCode' => \%countryCode_of,
        'zipCode' => \%zipCode_of,
    },
    {
        'hashedFirstName' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'hashedLastName' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'countryCode' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'zipCode' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
    },
    {

        'hashedFirstName' => 'hashedFirstName',
        'hashedLastName' => 'hashedLastName',
        'countryCode' => 'countryCode',
        'zipCode' => 'zipCode',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

Google::Ads::AdWords::v201710::AddressInfo

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
AddressInfo from the namespace https://adwords.google.com/api/adwords/rm/v201710.

Address identifier of a user list member. Accessible for whitelisted customers only. 




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * hashedFirstName


=item * hashedLastName


=item * countryCode


=item * zipCode




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():






=head1 AUTHOR

Generated by SOAP::WSDL

=cut

