######## GeoData for Geo::Location::TimeZone - Check main library for copyright.
######## Roughly GMT 8
package Geo::Location::TimeZone::H;
use Class::Singleton;
use Geo::Location::TimeZone;
@ISA = qw(Class::Singleton Geo::Location::TimeZone);
# Coordinates are X,Y, NOT lat,lon
# Output of partial data at 1172109537
my $data = {
	# Longitude 112.5 to 127.5
	"8" => {
		# Grid 8:-6 ; 2 records
		"-6" => {
			"def_z" => "Antartica/South_Pole",
			"391" => {
				"z" => "Etc/GMT+7",
				"c" => "ESRI",
				"s" => "22,2",
				"p" => [[112.50040435791,-82.5],[112.500411987305,-82.5],[112.500411987305,-90],[112.5,-90],[112.5,-82.5],[116.320938110352,-82.5],[112.50040435791,-82.5],],
			},
		},
		# Grid 8:-5 ; 1 records
		"-5" => {
			"392" => {
				"z" => "Etc/GMT+7",
				"c" => "ESRI",
				"s" => "22,2",
				"p" => [[112.50040435791,-67.5],[112.500411987305,-67.5],[112.500411987305,-82.5],[112.5,-82.5],[112.5,-67.5],[116.320938110352,-67.5],[112.50040435791,-67.5],],
			},
		},
		# Grid 8:-4 ; 1 records
		"-4" => {
			"393" => {
				"z" => "Etc/GMT+7",
				"c" => "ESRI",
				"s" => "22,2",
				"p" => [[112.50040435791,-52.5],[112.500409300953,-52.5],[112.500411987305,-59.4364776611328],[112.500411987305,-67.5],[112.5,-67.5],[112.5,-52.5],[116.320938110352,-52.5],[112.50040435791,-52.5],],
			},
		},
		# Grid 8:-3 ; 1 records
		"-3" => {
			"394" => {
				"z" => "Etc/GMT+7",
				"c" => "ESRI",
				"s" => "22,2",
				"p" => [[112.50040435791,-37.5],[112.50040435791,-39.7364768981934],[112.500409300953,-52.5],[112.5,-52.5],[112.5,-37.5],[116.320938110352,-37.5],[112.50040435791,-37.5],],
			},
		},
		# Grid 8:-2 ; 2 records
		"-2" => {
			"def_z" => "Australia/Perth",
			"395" => {
				"z" => "Etc/GMT+7",
				"c" => "ESRI",
				"s" => "22,2",
				"p" => [[112.50040435791,-22.5],[112.50040435791,-37.5],[112.5,-37.5],[112.5,-22.5],[116.320938110352,-22.5],[112.50040435791,-22.5],],
			},
		},
		# Grid 8:-1 ; 2 records
		"-1" => {
			"def_z" => "Etc/GMT+7",
			"158" => {
				"z" => "Etc/GMT+9",
				"c" => "ESRI",
				"s" => "12,2",
				"p" => [[127.5,-17.7180557250977],[127.5,-14.0630142336284],[127.446640014648,-14.0591659545898],[127.427757263184,-13.9566669464111],[127.39665222168,-13.9650001525879],[127.332786560059,-13.9066181182861],[127.332786560059,-7.5],[127.5,-7.5],[127.5,-12.8952789306641],[127.5,-17.7180557250977],],
			},
		},
		# Grid 8:0 ; 3 records
		"0" => {
			"def_z" => "Asia/Brunei",
			"159" => {
				"z" => "Etc/GMT+9",
				"c" => "ESRI",
				"s" => "12,2",
				"p" => [[127.5,7.5],[127.5,-7.5],[127.332786560059,-7.5],[127.332786560059,-7.29799747467041],[125.440979003906,-7.30675601959229],[125.440979003906,-3.06771492958069],[124.302398681641,-3.06771492958069],[124.302398681641,-1.20218682289124],[127.5,3.42822644705649],[127.5,7.5],[124.109710693359,7.5],[127.5,7.5],],
			},
			"397" => {
				"z" => "Etc/GMT+7",
				"c" => "ESRI",
				"s" => "22,2",
				"p" => [[112.5,2.36232399940491],[112.5,-3.47976858525807],[112.507507324219,-3.47959399223328],[112.50040435791,-5.20522594451904],[116.320938110352,-5.20522594451904],[116.320938110352,-7.5],[112.5,-7.5],[112.5,7.5],[112.504951882581,7.5],[112.503410339355,6.22285604476929],[112.5,6.22286039684103],[112.5,6.47983312606812],[112.5,2.36232399940491],],
			},
		},
		# Grid 8:1 ; 2 records
		"1" => {
			"def_z1" => "120.9822222,14.6041667,Asia/Manila",
			"def_z0" => "114.15,22.2833333,Asia/Hong_Kong",
			"def_z2" => "123.95,13.2333333,Asia/Manila",
			"def_z3" => "125.5672222,8.8055556,Asia/Manila",
			"def_z4" => "121.3380556,12.3663889,Asia/Manila",
			"def_z5" => "113.55,22.2,Asia/Macau",
			"398" => {
				"z" => "Etc/GMT+7",
				"c" => "ESRI",
				"s" => "22,2",
				"p" => [[112.5,21.5726356506348],[112.5,14.7117328643799],[112.513656616211,14.7117328643799],[112.504951882581,7.5],[112.5,7.5],[112.5,9.59020137786865],[112.5,21.5726356506348],],
			},
		},
		# Grid 8:2 ; 2 records
		"2" => {
			"def_z1" => "121.525,25.0391667,Asia/Taipei",
			"def_z0" => "121.4086111,31.005,Asia/Shanghai",
			"160" => {
				"z" => "Etc/GMT+9",
				"c" => "ESRI",
				"s" => "12,2",
				"p" => [[127.5,37.5],[127.5,22.5],[127.5,23.5489378946289],[122.8134765625,23.5664234161377],[122.8134765625,27.5251979827881],[127.5,27.5251979827881],[127.5,32.9641342163086],[124.109710693359,32.9641342163086],[124.109710693359,37.5],[127.5,37.5],],
			},
		},
		# Grid 8:3 ; 3 records
		"3" => {
			"def_z1" => "126.65,45.75,Asia/Harbin",
			"def_z0" => "114.5,48.0666667,Asia/Choibalsan",
			"152" => {
				"z" => "Etc/GMT+9",
				"c" => "ESRI",
				"s" => "12,1",
				"p" => [[112.5,51.513053894043],[112.5,52.2661657612483],[112.538879394531,52.3497161865234],[112.930267333984,52.3366546630859],[113.273323059082,52.4780426025391],[113.534149169922,52.4941558837891],[113.579162597656,52.4502716064453],[113.641398553386,52.5],[127.5,52.5],[127.5,49.9634754188917],[127.487762451172,49.9805450439453],[127.488311767578,50.0422210693359],[127.5,50.05458408631],[127.5,50.2436608625249],[127.336647033691,50.3102722167969],[127.354156494141,50.4133224487305],[127.289428710938,50.4602737426758],[127.367752075195,50.5708312988281],[127.279983520508,50.6808242797852],[127.297210693359,50.7324905395508],[127.217483520508,50.7841644287109],[127.127197265625,50.9155426025391],[126.930541992188,51.0599899291992],[126.898612976074,51.186653137207],[126.975540161133,51.313606262207],[126.861099243164,51.3069381713867],[126.893333435059,51.2391586303711],[126.816093444824,51.2663879394531],[126.821380615234,51.3302764892578],[126.901931762695,51.3394317626953],[126.915267944336,51.3791580200195],[126.790542602539,51.4244384765625],[126.82470703125,51.5013885498047],[126.802467346191,51.5369415283203],[126.672760009766,51.5747146606445],[126.729156494141,51.6383285522461],[126.721366882324,51.7086029052734],[126.641372680664,51.7452697753906],[126.442199707031,51.9880447387695],[126.461647033691,52.0269393920898],[126.51220703125,52.0388870239258],[126.55721282959,52.1305465698242],[126.306373596191,52.2041625976562],[126.436370849609,52.2808227539062],[126.320266723633,52.3083267211914],[126.340270996094,52.3894348144531],[126.267486572266,52.4586029052734],[126.197746276855,52.4644393920898],[126.208987922676,52.5],[120.702760410387,52.5],[120.686653137207,52.4336013793945],[120.622756958008,52.3402709960938],[120.759162902832,52.2391586303711],[120.782760620117,52.1552658081055],[120.753051757812,52.0791625976562],[120.694976806641,52.0486068725586],[120.712768554688,51.9824905395508],[120.657760620117,51.9174957275391],[120.488586425781,51.8772125244141],[120.197196960449,51.6861038208008],[120.096939086914,51.661376953125],[120.04914855957,51.5477752685547],[119.983047485352,51.493049621582],[119.956649780273,51.3899917602539],[119.891372680664,51.3741607666016],[119.920822143555,51.3363800048828],[119.809707641602,51.26416015625],[119.818046569824,51.2141571044922],[119.755256652832,51.2074966430664],[119.780548095703,51.1660995483398],[119.746643066406,51.0736083984375],[119.522491455078,50.9049911499023],[119.502212524414,50.7422180175781],[119.286926269531,50.593879699707],[119.242202758789,50.4452667236328],[119.135269165039,50.3897171020508],[119.198318481445,50.3452682495117],[119.348037719727,50.3483276367188],[119.368011474609,50.3099899291992],[119.328872680664,50.2738800048828],[119.348083496094,50.1594848632812],[119.322219848633,50.0972137451172],[119.214157104492,50.0152740478516],[119.099639892578,49.9904479980469],[118.58332824707,49.9269409179688],[118.464706420898,49.8244400024414],[118.385536193848,49.8166656494141],[118.36580657959,49.7783279418945],[117.89582824707,49.5499954223633],[117.87198638916,49.5102157592773],[117.494430541992,49.623046875],[117.169982910156,49.6524887084961],[116.711380004883,49.8304672241211],[116.615539550781,49.9313812255859],[116.24609375,50.0274887084961],[116.069717407227,50.0027770996094],[115.754707336426,49.8844375610352],[115.396377563477,49.9011001586914],[115.205261230469,49.9983291625977],[115.023612976074,50.1519317626953],[114.854156494141,50.2283248901367],[114.675811767578,50.26416015625],[114.443862915039,50.2452697753906],[114.313026428223,50.2841644287109],[114.176376342773,50.2483291625977],[113.874687194824,50.0869369506836],[113.782493591309,50.0869369506836],[113.586112976074,50.0163879394531],[113.216659545898,49.8191604614258],[113.101379394531,49.6788787841797],[113.0908203125,49.5986022949219],[112.766937255859,49.5008316040039],[112.5,49.540152359918],[112.5,49.1494369506836],[112.5,51.513053894043],],
			},
			"161" => {
				"z1" => "125.7547222,39.0194444,Asia/Pyongyang",
				"z0" => "126.9997222,37.5663889,Asia/Seoul",
				"c" => "ESRI",
				"s" => "12,2",
				"p" => [[127.5,46.0306663513184],[127.5,37.5],[124.109710693359,37.5],[124.109710693359,39.4803428649902],[124.370231628418,40.0028114318848],[124.373596191406,40.093620300293],[124.554702758789,40.2422180175781],[124.708442687988,40.305046081543],[124.743316650391,40.369987487793],[124.832763671875,40.4091567993164],[124.88053894043,40.4705429077148],[125.039978027344,40.4572143554688],[125.017761230469,40.5308227539062],[125.248031616211,40.6038818359375],[125.286102294922,40.6474914550781],[125.405822753906,40.6208267211914],[125.464157104492,40.7136077880859],[125.544708251953,40.7185974121094],[125.564147949219,40.7783279418945],[125.680267333984,40.7655487060547],[125.653053283691,40.821662902832],[125.761932373047,40.8836059570312],[125.821380615234,40.8613815307617],[125.878593444824,40.8947143554688],[126.016937255859,40.8999938964844],[125.977478027344,40.9133224487305],[126.073318481445,40.9730453491211],[126.132202148438,41.0441589355469],[126.123870849609,41.0811080932617],[126.279159545898,41.1527709960938],[126.456100463867,41.3572158813477],[126.527206420898,41.3574981689453],[126.500816345215,41.4319381713867],[126.584426879883,41.568603515625],[126.563346862793,41.6109161376953],[126.615127563477,41.6641693115234],[126.722213745117,41.6980438232422],[126.678863525391,41.7244338989258],[126.694702148438,41.7402725219727],[126.786926269531,41.6922149658203],[126.797492980957,41.7311019897461],[126.936096191406,41.7944412231445],[126.936370849609,41.763053894043],[127.045257568359,41.7244338989258],[127.078048706055,41.6819381713867],[127.039978027344,41.6719360351562],[127.057037353516,41.6435012817383],[127.178588867188,41.5874938964844],[127.102203369141,41.535270690918],[127.287200927734,41.501106262207],[127.27082824707,41.4724884033203],[127.5,41.4649034301789],[127.5,42.6830520629883],[127.5,46.0306663513184],],
			},
		},
		# Grid 8:4 ; 1 records
		"4" => {
			"153" => {
				"z" => "Etc/GMT+9",
				"c" => "ESRI",
				"s" => "12,1",
				"p" => [[112.5,52.5],[113.641398553386,52.5],[113.738037109375,52.5772171020508],[113.897773742676,52.6349945068359],[113.954162597656,52.6255493164062],[114.123596191406,52.7183227539062],[114.242202758789,52.8238830566406],[114.214431762695,52.8905487060547],[114.242202758789,52.927490234375],[114.232208251953,52.9652709960938],[114.317207336426,52.9672088623047],[114.281372070312,53.0213775634766],[114.325271606445,53.0677719116211],[114.231369018555,53.1036071777344],[114.126922607422,53.0719375610352],[114.20166015625,53.1922149658203],[114.092483520508,53.2047119140625],[114.046371459961,53.2236022949219],[114.048027038574,53.2524948120117],[113.982208251953,53.2330474853516],[113.939971923828,53.2844390869141],[113.963882446289,53.3194427490234],[113.943313598633,53.3563842773438],[113.832206726074,53.3897171020508],[113.827766418457,53.4574966430664],[113.895538330078,53.5347213745117],[113.814697265625,53.6164321899414],[113.974426269531,53.6444396972656],[113.968597412109,53.6994323730469],[113.99471282959,53.7169342041016],[114.143051147461,53.756103515625],[114.296096801758,53.7466583251953],[114.374687194824,53.8124923706055],[114.445251464844,53.802490234375],[114.503051757812,53.8091583251953],[114.595832824707,53.9027709960938],[114.975807189941,53.9924926757812],[115.023880004883,54.0308227539062],[115.024147033691,54.0702743530273],[115.149429321289,54.1202697753906],[115.183319091797,54.1844329833984],[115.499267578125,54.301383972168],[115.509162902832,54.3647155761719],[115.670822143555,54.4238815307617],[116.184982299805,54.5072174072266],[116.522750854492,54.4640731811523],[116.537200927734,54.5094375610352],[116.711929321289,54.5294342041016],[116.714431762695,54.5633239746094],[116.769989013672,54.5922164916992],[116.769706726074,54.6611022949219],[116.873870849609,54.7041625976562],[116.869430541992,54.7686004638672],[116.923866271973,54.7955474853516],[116.87776184082,54.9052658081055],[116.88916015625,54.9416580200195],[116.826393127441,54.9785995483398],[116.841087341309,55.0213775634766],[116.782493591309,55.1102752685547],[116.699142456055,55.1147155761719],[116.469436645508,55.2274856567383],[116.461647033691,55.305549621582],[116.402206420898,55.3608245849609],[116.114433288574,55.3474884033203],[116.069442749023,55.3794326782227],[115.963882446289,55.3655471801758],[115.929977416992,55.3969421386719],[115.967208862305,55.4452667236328],[115.889427185059,55.4988784790039],[115.913040161133,55.6461029052734],[115.841087341309,55.6722183227539],[115.868316650391,55.7449951171875],[115.841926574707,55.8263854980469],[115.898040771484,55.9166641235352],[115.758613586426,56.0411071777344],[115.785537719727,56.0719375610352],[115.769149780273,56.1169357299805],[115.836929321289,56.1494369506836],[115.761932373047,56.1741638183594],[115.684143066406,56.2969436645508],[115.679702758789,56.397216796875],[115.78441619873,56.4019317626953],[115.798797607422,56.4296722412109],[115.675537109375,56.4927673339844],[115.681930541992,56.5652694702148],[115.464706420898,56.589714050293],[115.431091308594,56.6282348632812],[115.44303894043,56.6638793945312],[115.590270996094,56.7155456542969],[115.61360168457,56.7861099243164],[115.586380004883,56.8724899291992],[115.736801147461,56.9565505981445],[115.86164855957,56.9327697753906],[115.962768554688,56.8611068725586],[116.041656494141,56.8636093139648],[116.12109375,56.8122100830078],[116.363876342773,56.8486022949219],[116.559417724609,56.7588882446289],[116.738586425781,56.7608261108398],[116.80721282959,56.723876953125],[116.967208862305,56.7811050415039],[117.040267944336,56.7763824462891],[117.001663208008,56.7994384765625],[117.022216796875,56.815544128418],[117.135536193848,56.8011016845703],[117.193313598633,56.8794326782227],[117.331100463867,56.948600769043],[117.364151000977,56.9160995483398],[117.344711303711,56.8669357299805],[117.415267944336,56.8577728271484],[117.410263061523,56.8258285522461],[117.460540771484,56.8169403076172],[117.498031616211,56.8713760375977],[117.572769165039,56.8472137451172],[117.56999206543,56.935546875],[117.674423217773,56.9747085571289],[117.688873291016,57.0144424438477],[117.67830657959,57.0666656494141],[117.596939086914,57.1533203125],[117.745246887207,57.1958236694336],[117.795532226562,57.2872161865234],[117.775817871094,57.302490234375],[117.596366882324,57.3233261108398],[117.546371459961,57.2599945068359],[117.474151611328,57.2377700805664],[117.426376342773,57.2586059570312],[117.444427490234,57.329719543457],[117.364990234375,57.3277740478516],[117.328598022461,57.4544372558594],[117.288879394531,57.4583282470703],[117.252212524414,57.5133285522461],[117.310531616211,57.565544128418],[117.287773132324,57.6130523681641],[117.137771606445,57.6397171020508],[117.17830657959,57.738883972168],[117.084426879883,57.8041610717773],[117.123031616211,57.8427658081055],[117.309982299805,57.843879699707],[117.41748046875,57.9066543579102],[117.366088867188,57.927490234375],[117.364700317383,57.9955444335938],[117.39582824707,58.0261001586914],[117.372482299805,58.0611038208008],[117.413879394531,58.0874938964844],[117.407493591309,58.1272125244141],[117.439971923828,58.1572113037109],[117.573883056641,58.1358261108398],[117.590553283691,58.185546875],[117.471366882324,58.2827682495117],[117.479156494141,58.313606262207],[117.664428710938,58.3711013793945],[117.672210693359,58.4005432128906],[117.830833435059,58.4122085571289],[118.013046264648,58.3930511474609],[118.063873291016,58.3383255004883],[118.13542175293,58.3874359130859],[118.30721282959,58.3602752685547],[118.489151000977,58.2111053466797],[118.561370849609,58.2144393920898],[118.647491455078,58.1702728271484],[118.803039550781,58.2166595458984],[119.108383178711,58.2226715087891],[119.131652832031,58.2902755737305],[119.065536499023,58.363883972168],[119.126083374023,58.4083251953125],[119.129699707031,58.4824905395508],[118.763046264648,58.6124954223633],[118.826927185059,58.6152725219727],[118.887496948242,58.6955413818359],[118.896942138672,58.8147125244141],[118.786651611328,58.8874969482422],[118.792190551758,58.939697265625],[118.853866577148,58.943603515625],[118.847793579102,59.0144119262695],[118.736923217773,59.0236053466797],[118.702476501465,59.065544128418],[118.701393127441,59.2130508422852],[118.851379394531,59.2861099243164],[118.755256652832,59.3333282470703],[118.763320922852,59.3872146606445],[118.764427185059,59.4011001586914],[118.390266418457,59.5177688598633],[118.350273132324,59.5888824462891],[118.283599853516,59.6105499267578],[118.05721282959,59.5833282470703],[117.986366271973,59.5363845825195],[117.939971923828,59.4547119140625],[117.883613586426,59.4416580200195],[117.818878173828,59.4494323730469],[117.758331298828,59.5408325195312],[117.598876953125,59.4708251953125],[117.236099243164,59.5277709960938],[117.196640014648,59.5691604614258],[117.084426879883,59.5872116088867],[117.200820922852,59.6549911499023],[117.227478027344,59.8294372558594],[117.05721282959,59.9088821411133],[117.113876342773,59.9633255004883],[117.233322143555,59.9569396972656],[117.308868408203,59.9952697753906],[117.297492980957,60.0194396972656],[117.048599243164,60.0358276367188],[117.04443359375,60.0824966430664],[116.973602294922,60.1577682495117],[116.839981079102,60.2422180175781],[116.732208251953,60.2577743530273],[116.600807189941,60.3572158813477],[116.078048706055,60.4041595458984],[116.003196716309,60.4593048095703],[115.842758178711,60.4649963378906],[115.675537109375,60.5266571044922],[115.189147949219,60.4297180175781],[115.090553283691,60.3827667236328],[115.013046264648,60.2716598510742],[114.813873291016,60.180549621582],[114.696640014648,60.2199859619141],[114.546096801758,60.113883972168],[114.521102905273,60.0452728271484],[114.566673278809,59.9977722167969],[114.315536499023,59.8836059570312],[114.165542602539,59.7458267211914],[114.043319702148,59.7411041259766],[114.041931152344,59.680549621582],[113.849151611328,59.6883239746094],[113.783599853516,59.609992980957],[113.608871459961,59.5811080932617],[113.586380004883,59.5591583251953],[113.609710693359,59.4952697753906],[113.472763061523,59.4385986328125],[113.421096801758,59.3766555786133],[113.486923217773,59.3333282470703],[113.455833435059,59.2988815307617],[113.469436645508,59.2649993896484],[113.281661987305,59.1611022949219],[112.971366882324,59.1344375610352],[112.911651611328,59.1549911499023],[112.882202148438,59.1183242797852],[112.731369018555,59.0872116088867],[112.645263671875,59.0324935913086],[112.57421875,59.0716857910156],[112.555541992188,59.0266571044922],[112.627616882324,58.961181640625],[112.500267028809,58.869987487793],[112.5,58.8702736572386],[112.5,59.2003806053861],[112.537773132324,59.2369384765625],[112.638603210449,59.2694396972656],[112.632202148438,59.3108215332031],[112.5,59.3240672005056],[112.5,67.5],[127.5,67.5],[127.5,52.5],[126.208987922676,52.5],[126.209426879883,52.5013885498047],[126.093872070312,52.5880432128906],[126.030822753906,52.5633239746094],[125.988586425781,52.5822143554688],[125.973037719727,52.6416625976562],[126.064147949219,52.676383972168],[126.035537719727,52.7210998535156],[126.095542907715,52.7644424438477],[126.050811767578,52.7858276367188],[125.970542907715,52.7633285522461],[125.859153747559,52.8516616821289],[125.844711303711,52.8994369506836],[125.646942138672,52.8788757324219],[125.648612976074,52.9127655029297],[125.719146728516,52.9422149658203],[125.728866577148,52.9794311523438],[125.623031616211,53.0499954223633],[125.506103515625,53.038330078125],[125.466087341309,53.0838775634766],[125.134162902832,53.1974868774414],[124.912200927734,53.1697158813477],[124.875526428223,53.1438827514648],[124.889976501465,53.0947113037109],[124.85164642334,53.0891571044922],[124.804977416992,53.1330490112305],[124.705833435059,53.1344375610352],[124.652770996094,53.1858215332031],[124.402206420898,53.2122116088867],[124.255256652832,53.3566589355469],[124.104431152344,53.3408279418945],[123.91081237793,53.464714050293],[123.697479248047,53.4958267211914],[123.619430541992,53.5427703857422],[123.529426574707,53.4994354248047],[123.542762756348,53.5338821411133],[123.497482299805,53.5469436645508],[123.478866577148,53.4991607666016],[123.24609375,53.5530471801758],[123.1533203125,53.5005493164062],[122.824432373047,53.4499969482422],[122.40998840332,53.4372100830078],[122.314422607422,53.4877700805664],[122.026092529297,53.4139709472656],[121.829986572266,53.4130477905273],[121.473793029785,53.3238143920898],[121.324996948242,53.3183288574219],[121.20832824707,53.2705459594727],[120.863876342773,53.2797164916992],[120.272773742676,52.8577728271484],[120.029159545898,52.7680511474609],[120.030548095703,52.6172103881836],[120.073036193848,52.5899887084961],[120.189147949219,52.5802764892578],[120.44026184082,52.6372146606445],[120.713607788086,52.5447158813477],[120.702760410387,52.5],[119.348083496094,52.5],[112.5,52.5],],
			},
		},
		# Grid 8:5 ; 2 records
		"5" => {
			"def_z" => "Etc/GMT+9",
			"382" => {
				"z" => "Etc/GMT+7",
				"c" => "ESRI",
				"s" => "22,1",
				"p" => [[112.5,72.3169403076172],[112.5,71.2713242548798],[112.512756347656,71.2658233642578],[112.642753601074,71.2897033691406],[112.725799560547,71.2435913085938],[112.686897277832,71.2027740478516],[112.521926879883,71.1638793945312],[112.59748840332,71.1047058105469],[112.5,71.0863512639267],[112.5,82.5],[112.520346035049,82.5],[112.509666442871,77.8509674072266],[112.508277893066,77.2461242675781],[113.351028442383,76.8701171875],[113.961791992188,76.4381103515625],[114.140556335449,75.8869247436523],[113.812828063965,75.2612609863281],[112.65087890625,74.7696685791016],[112.5,74.7288425114212],[112.5,72.3169403076172],],
			},
		},
		# Grid 8:6 ; 1 records
		"6" => {
			"383" => {
				"z" => "Etc/GMT+7",
				"c" => "ESRI",
				"s" => "22,1",
				"p" => [[112.725799560547,82.5],[112.5,82.5],[112.5,90],[112.537574768066,90],[112.520346035049,82.5],[112.5,82.5],[112.725799560547,82.5],],
			},
		},
	},
};

# Used by Class::Singleton
sub _new_instance
{
	return shift->_init( @_, data => $data );
}

1;
