#!/usr/bin/perl

package eBay::API::XML::DataType::AuthenticationEntryType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. AuthenticationEntryType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 07/07/2008 17:42
# API Release Number: ... 571
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::AuthenticationEntryType

=head1 DESCRIPTION

A set of application-level authentication preferences and related data that
you configure to support the user authentication and authorization process.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::AuthenticationEntryType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::Enum::TokenReturnMethodCodeType;


my @gaProperties = ( [ 'AcceptURL', 'xs:anyURI', '', '', '' ]
	, [ 'PrivacyPolicyURL', 'xs:anyURI', '', '', '' ]
	, [ 'RejectURL', 'xs:anyURI', '', '', '' ]
	, [ 'RuName', 'xs:string', '', '', '' ]
	, [ 'TokenReturnMethod', 'ns:TokenReturnMethodCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::TokenReturnMethodCodeType', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setAcceptURL()

A URL that you set up in order to determine when a
user's authentication and authorization process succeeded.
After a user signs into eBay and authorizes your application
to execute secure calls on their behalf, eBay redirects the
user's browser to this URL and, if TokenReturnMethod is set
to Redirect, appends the user's authentication token plus
other data that you specified to identify the user.
This needs to be a secure https URL.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=AuthNAuth
Title: Authentication & Authorization
MaxLength: 500

  Calls: SetReturnURL
  RequiredInput: No

#    Argument: 'xs:anyURI'

=cut

sub setAcceptURL {
  my $self = shift;
  $self->{'AcceptURL'} = shift
}

=head2 getAcceptURL()

  Calls: GetReturnURL
  Returned: Conditionally

#    Returns: 'xs:anyURI'

=cut

sub getAcceptURL {
  my $self = shift;
  return $self->{'AcceptURL'};
}


=head2 setPrivacyPolicyURL()

Your privacy policy URL, which is shown to end users on the eBay sign-in page.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=AuthNAuth
Title: Authentication & Authorization
MaxLength: 500

  Calls: SetReturnURL
  RequiredInput: No

#    Argument: 'xs:anyURI'

=cut

sub setPrivacyPolicyURL {
  my $self = shift;
  $self->{'PrivacyPolicyURL'} = shift
}

=head2 getPrivacyPolicyURL()

  Calls: GetReturnURL
  Returned: Conditionally

#    Returns: 'xs:anyURI'

=cut

sub getPrivacyPolicyURL {
  my $self = shift;
  return $self->{'PrivacyPolicyURL'};
}


=head2 setRejectURL()

A URL that you set up in order to determine when a
user's authentication and authorization process did not succeed.
After a user signs into eBay but chooses NOT to authorize your application
to execute secure calls on their behalf, eBay redirects the
user's browser to this URL and appends data that you specified
to identify the user (but does not return an authentication token).
This needs to be a secure https URL.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=AuthNAuth
Title: Authentication & Authorization
MaxLength: 500

  Calls: SetReturnURL
  RequiredInput: No

#    Argument: 'xs:anyURI'

=cut

sub setRejectURL {
  my $self = shift;
  $self->{'RejectURL'} = shift
}

=head2 getRejectURL()

  Calls: GetReturnURL
  Returned: Conditionally

#    Returns: 'xs:anyURI'

=cut

sub getRejectURL {
  my $self = shift;
  return $self->{'RejectURL'};
}


=head2 setRuName()

A unique identifier associated with application and the combination
of URLs within this authentication entry.
Unique across all applications that execute eBay Web Services calls.
For convenience, you can call GetRuName to generate a unique value.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=AuthNAuth
Title: Authentication & Authorization
MaxLength: 255

  Calls: SetReturnURL
  RequiredInput: Yes

#    Argument: 'xs:string'

=cut

sub setRuName {
  my $self = shift;
  $self->{'RuName'} = shift
}

=head2 getRuName()

  Calls: GetReturnURL
  Returned: Always

#    Returns: 'xs:string'

=cut

sub getRuName {
  my $self = shift;
  return $self->{'RuName'};
}


=head2 setTokenReturnMethod()

Specifies whether to return the token in the HTTP response stream
sent to the accept URL, or to make it available for retrieval via FetchToken.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=AuthNAuth
Title: Authentication & Authorization

  Calls: SetReturnURL
  RequiredInput: No

#    Argument: 'ns:TokenReturnMethodCodeType'

=cut

sub setTokenReturnMethod {
  my $self = shift;
  $self->{'TokenReturnMethod'} = shift
}

=head2 getTokenReturnMethod()

  Calls: GetReturnURL
  Returned: Conditionally

#    Returns: 'ns:TokenReturnMethodCodeType'

=cut

sub getTokenReturnMethod {
  my $self = shift;
  return $self->{'TokenReturnMethod'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
