# DO NOT EDIT, PRETTY PLEASE!
# This file is automatically generated by wl-scanner.pl
#

use strict;
use warnings;
use utf8;

=encoding utf8
=cut

=head1 NAME

WL::input_method - Perl binding for input_method protocol

=head1 SYNOPSIS

  use WL::input_method;

=head1 DESCRIPTION

B<WL::input_method> is a package generated from Wayland protocol definition
using L<wl-scanner.pl>. It implements L<WL::Base> subclasses with wrappers
for requests, event processing and constants for enums.

It is not indended to be used directly. Instead, see L<WL::Connection> to see
how to obtain the object instances.

To see how to attach event callbacks and issue requests, please refer to
L<WL::Base> base class.

Until proper documentation is finished, please refer to documentation of C
bindings of the generated code (it is intended to be readable) to see what
arguments to give to requests and expect from events.

Please consider this an alpha quality code, whose API can change at any time,
until we reach version 1.0.

=cut

package WL::input_method;

our $VERSION = 0.92;

package WL::wl_input_method_context;

our @ISA = qw/WL::Base/;
our $VERSION = 1;
our $INTERFACE = 'wl_input_method_context';

# Requests
use constant REQUEST_DESTROY => 0;
use constant REQUEST_COMMIT_STRING => 1;
use constant REQUEST_PREEDIT_STRING => 2;
use constant REQUEST_PREEDIT_STYLING => 3;
use constant REQUEST_PREEDIT_CURSOR => 4;
use constant REQUEST_DELETE_SURROUNDING_TEXT => 5;
use constant REQUEST_CURSOR_POSITION => 6;
use constant REQUEST_MODIFIERS_MAP => 7;
use constant REQUEST_KEYSYM => 8;
use constant REQUEST_GRAB_KEYBOARD => 9;
use constant REQUEST_KEY => 10;
use constant REQUEST_MODIFIERS => 11;
use constant REQUEST_LANGUAGE => 12;
use constant REQUEST_TEXT_DIRECTION => 13;

sub destroy
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_DESTROY, pack ('',
		), $file);

	return $retval;
}

sub commit_string
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_COMMIT_STRING, pack ('L L/ax!4',
		shift,
		shift."\x00"), $file);

	return $retval;
}

sub preedit_string
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_PREEDIT_STRING, pack ('L L/ax!4 L/ax!4',
		shift,
		shift."\x00",
		shift."\x00"), $file);

	return $retval;
}

sub preedit_styling
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_PREEDIT_STYLING, pack ('L L L',
		shift,
		shift,
		shift), $file);

	return $retval;
}

sub preedit_cursor
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_PREEDIT_CURSOR, pack ('l',
		shift), $file);

	return $retval;
}

sub delete_surrounding_text
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_DELETE_SURROUNDING_TEXT, pack ('l L',
		shift,
		shift), $file);

	return $retval;
}

sub cursor_position
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_CURSOR_POSITION, pack ('l l',
		shift,
		shift), $file);

	return $retval;
}

sub modifiers_map
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_MODIFIERS_MAP, pack ('L/ax!4',
		shift), $file);

	return $retval;
}

sub keysym
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_KEYSYM, pack ('L L L L L',
		shift,
		shift,
		shift,
		shift,
		shift), $file);

	return $retval;
}

sub grab_keyboard
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_GRAB_KEYBOARD, pack ('L',
		($retval = new WL::wl_keyboard ($self->{conn}))->{id}), $file);

	return $retval;
}

sub key
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_KEY, pack ('L L L L',
		shift,
		shift,
		shift,
		shift), $file);

	return $retval;
}

sub modifiers
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_MODIFIERS, pack ('L L L L L',
		shift,
		shift,
		shift,
		shift,
		shift), $file);

	return $retval;
}

sub language
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_LANGUAGE, pack ('L L/ax!4',
		shift,
		shift."\x00"), $file);

	return $retval;
}

sub text_direction
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_TEXT_DIRECTION, pack ('L L',
		shift,
		shift), $file);

	return $retval;
}

# Events
use constant EVENT_SURROUNDING_TEXT => 0;
use constant EVENT_RESET => 1;
use constant EVENT_CONTENT_TYPE => 2;
use constant EVENT_INVOKE_ACTION => 3;
use constant EVENT_COMMIT_STATE => 4;
use constant EVENT_PREFERRED_LANGUAGE => 5;

sub callback
{
	my $self = shift;
	my $opcode = shift;

	if ($opcode == EVENT_SURROUNDING_TEXT) {
		@_ = unpack ('L/ax!4 L L', shift);
		return $self->surrounding_text ([shift =~ /(.*)./]->[0],
			shift,
			shift);
	} elsif ($opcode == EVENT_RESET) {
		return $self->reset ();
	} elsif ($opcode == EVENT_CONTENT_TYPE) {
		@_ = unpack ('L L', shift);
		return $self->content_type (shift,
			shift);
	} elsif ($opcode == EVENT_INVOKE_ACTION) {
		@_ = unpack ('L L', shift);
		return $self->invoke_action (shift,
			shift);
	} elsif ($opcode == EVENT_COMMIT_STATE) {
		@_ = unpack ('L', shift);
		return $self->commit_state (shift);
	} elsif ($opcode == EVENT_PREFERRED_LANGUAGE) {
		@_ = unpack ('L/ax!4', shift);
		return $self->preferred_language ([shift =~ /(.*)./]->[0]);
	} else {
		die 'Bad opcode';
	}
}

package WL::wl_input_method;

our @ISA = qw/WL::Base/;
our $VERSION = 1;
our $INTERFACE = 'wl_input_method';

# Events
use constant EVENT_ACTIVATE => 0;
use constant EVENT_DEACTIVATE => 1;

sub callback
{
	my $self = shift;
	my $opcode = shift;

	if ($opcode == EVENT_ACTIVATE) {
		@_ = unpack ('L', shift);
		return $self->activate (new WL::wl_input_method_context ($self->{conn}));
	} elsif ($opcode == EVENT_DEACTIVATE) {
		@_ = unpack ('L', shift);
		return $self->deactivate (new WL::wl_input_method_context ($self->{conn}, shift));
	} else {
		die 'Bad opcode';
	}
}

package WL::wl_input_panel;

our @ISA = qw/WL::Base/;
our $VERSION = 1;
our $INTERFACE = 'wl_input_panel';

# Requests
use constant REQUEST_GET_INPUT_PANEL_SURFACE => 0;

sub get_input_panel_surface
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_GET_INPUT_PANEL_SURFACE, pack ('L L',
		($retval = new WL::wl_input_panel_surface ($self->{conn}))->{id},
		shift->{id}), $file);

	return $retval;
}

package WL::wl_input_panel_surface;

our @ISA = qw/WL::Base/;
our $VERSION = 1;
our $INTERFACE = 'wl_input_panel_surface';

# Requests
use constant REQUEST_SET_TOPLEVEL => 0;
use constant REQUEST_SET_OVERLAY_PANEL => 1;

sub set_toplevel
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_SET_TOPLEVEL, pack ('L L',
		shift->{id},
		shift), $file);

	return $retval;
}

sub set_overlay_panel
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_SET_OVERLAY_PANEL, pack ('',
		), $file);

	return $retval;
}

# Enums
use constant POSITION_CENTER_BOTTOM => 0;


=head1 BUGS

The interface documentation for the bindings is lacking.

Only client part implemented, not server.

=head1 SEE ALSO

=over

=item *

L<http://wayland.freedesktop.org/> -- Wayland project web site

=item *

L<wl-draw.pl> -- Example Wayland client

=item *

L<wl-scanner.pl> -- Tool that generated this module

=item *

L<WL::Base> -- Base class for Wayland objects

=item *

L<WL::Connection> -- Estabilish a Wayland connection

=back

=head1 COPYRIGHT

Copyright 2013, 2014 Lubomir Rintel

This program is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

Copyright notice from the protocol definition file:

  Copyright © 2012, 2013 Intel Corporation
  
  Permission to use, copy, modify, distribute, and sell this
  software and its documentation for any purpose is hereby granted
  without fee, provided that the above copyright notice appear in
  all copies and that both that copyright notice and this permission
  notice appear in supporting documentation, and that the name of
  the copyright holders not be used in advertising or publicity
  pertaining to distribution of the software without specific,
  written prior permission.  The copyright holders make no
  representations about the suitability of this software for any
  purpose.  It is provided "as is" without express or implied
  warranty.
  
  THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS
  SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
  FITNESS, IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY
  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
  THIS SOFTWARE.

=head1 AUTHORS

Lubomir Rintel C<lkundrak@v3.sk>

=cut

