package ICU::DecimalFormatSymbols;
#
#    DecimalFormatSymbols.pm
#
#    $Id: DecimalFormatSymbols.pm,v 1.2 2001/02/11 03:27:53 bstell Exp $
#
#    Copyright (c) 2000 Brian Stell
#
#    This package is free software and is provided ``as is'' without
#    express or implied warranty. It may be used, redistributed and/or
#    modified under the terms of the Perl Artistic License 
#    (see http://www.perl.com/perl/misc/Artistic.html)
#

use strict;
use Carp;
use vars qw(@ISA %EXPORT_TAGS $AUTOLOAD);

use Exporter;
@ISA = qw(Exporter);

use ICU;

%EXPORT_TAGS = (
   ENumberFormatSymbol => [qw(
       kDecimalSeparatorSymbol kGroupingSeparatorSymbol 
       kPatternSeparatorSymbol kPercentSymbol kZeroDigitSymbol 
       kDigitSymbol kMinusSignSymbol kPlusSignSymbol kCurrencySymbol 
       kIntlCurrencySymbol kMonetarySeparatorSymbol kExponentialSymbol
       kPermillSymbol kPadEscapeSymbol kInfinitySymbol kNaNSymbol 
       kFormatSymbolCount
       )],
);

Exporter::export_tags();

sub AUTOLOAD {
    # This AUTOLOAD is used to 'autoload' constants from the constant()
    # XS function.  If a constant is not found then control is passed
    # to the AUTOLOAD in AutoLoader.

    my $constname;
    ($constname = $AUTOLOAD) =~ s/.*:://;
    croak "& not defined" if $constname eq 'constant';
    my $val = constant_iv($constname, @_ ? $_[0] : 0);
    if ($! != 0) { 
        if ($! =~ /Invalid/) {
            $AutoLoader::AUTOLOAD = $AUTOLOAD;
            goto &AutoLoader::AUTOLOAD;
        }
        else {
                croak "Your vendor has not defined ICU::DecimalFormatSymbols macro $constname";
        }
    }
    no strict 'refs';
    *$AUTOLOAD = sub { $val };
    goto &$AUTOLOAD;
}

1;

__END__

=head1 NAME

ICU::DecimalFormatSymbols - Perl extension for International Components 
for Unicode

=head1 SYNOPSIS

  use ICU::DecimalFormatSymbols;

=head1 DESCRIPTION

TBD

