/*    DateFormatSymbols.xs
 *
 *    $Id: DateFormatSymbols.xs,v 1.6 2001/07/20 10:23:53 mrperl Exp $
 *
 *    Copyright (c) 2000 Brian Stell
 *
 *    This package is free software and is provided ``as is'' without
 *    express or implied warranty. It may be used, redistributed and/or
 *    modified under the terms of the Perl Artistic License
 *    (see http://www.perl.com/perl/misc/Artistic.html)
 */

extern "C" {
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"
}

#include  "picu/picu_debug.h"
#include  "picu/picu_utf8.h"
#include  "picu/picu_util.h"
#include  "picu/DateFormatSymbols.h"
#include  "picu/Locale.h"
#include  "unicode/dtfmtsym.h"

char *DateFormatSymbols_class_string = "ICU::DateFormatSymbols";
static int debugLevel = 0;


MODULE = ICU::DateFormatSymbols    PACKAGE = ICU::DateFormatSymbols  

# This requires xsubpp version 1.925 or greater
REQUIRE: 1.925

void
DateFormatSymbols::DESTROY()
    CODE:
        DEBUG100("DateFormatSymbols::DESTROY()");
        delete THIS;
        DEBUG100("DateFormatSymbols::DESTROY()");

void
DateFormatSymbols::getAmPmStrings()
    PREINIT:
        int i;
        int32_t count;
        const UnicodeString *ampm_strs;
        U8 *u8str;
        uint32_t u8len;
    PPCODE:
        ampm_strs = THIS->getAmPmStrings(count);
        DEBUG100("count = %d", count);
        EXTEND(SP, count);
        for (i=0; i<count; i++) {
            SV *sv = sv_newmortal();
            u8str = UnicodeStringToU8String((UnicodeString &)ampm_strs[i], &u8len);
            sv_usepvn(sv, (char*)u8str, u8len);
            PUSHs(sv);
        }

const char *
DateFormatSymbols::getLocalPatternChars()
    PREINIT:
        UnicodeString localPatternChars;
        U8 *u8str;
        uint32_t u8len;
    CODE:
        THIS->getLocalPatternChars(localPatternChars);
        u8str = UnicodeStringToU8String(localPatternChars, &u8len);
        ST(0) = sv_newmortal();
        sv_usepvn(ST(0), (char*)u8str, u8len);
    OUTPUT:

void
DateFormatSymbols::getMonths()
    PREINIT:
        int i;
        int32_t count;
        const UnicodeString *months;
        U8 *u8str;
        uint32_t u8len;
    PPCODE:
        months = THIS->getMonths(count);
        DEBUG100("count = %d", count);
        EXTEND(SP, count);
        for (i=0; i<count; i++) {
            SV *sv = sv_newmortal();
            u8str = UnicodeStringToU8String((UnicodeString &)months[i], &u8len);
            sv_usepvn(sv, (char*)u8str, u8len);
            PUSHs(sv);
        }

void
DateFormatSymbols::getShortMonths()
    PREINIT:
        int i;
        int32_t count;
        const UnicodeString *months;
        U8 *u8str;
        uint32_t u8len;
    PPCODE:
        months = THIS->getShortMonths(count);
        DEBUG100("count = %d", count);
        EXTEND(SP, count);
        for (i=0; i<count; i++) {
            SV *sv = sv_newmortal();
            u8str = UnicodeStringToU8String((UnicodeString &)months[i], &u8len);
            sv_usepvn(sv, (char*)u8str, u8len);
            PUSHs(sv);
        }

void
DateFormatSymbols::getShortWeekdays()
    PREINIT:
        int i;
        int32_t count;
        const UnicodeString *days;
        U8 *u8str;
        uint32_t u8len;
    PPCODE:
        days = THIS->getShortWeekdays(count);
        DEBUG100("count = %d", count);
        EXTEND(SP, count);
        for (i=0; i<count; i++) {
            SV *sv = sv_newmortal();
            u8str = UnicodeStringToU8String((UnicodeString &)days[i], &u8len);
            sv_usepvn(sv, (char*)u8str, u8len);
            PUSHs(sv);
        }

void
DateFormatSymbols::getWeekdays()
    PREINIT:
        int i;
        int32_t count;
        const UnicodeString *days;
        U8 *u8str;
        uint32_t u8len;
    PPCODE:
        days = THIS->getWeekdays(count);
        DEBUG100("count = %d", count);
        EXTEND(SP, count);
        for (i=0; i<count; i++) {
            SV *sv = sv_newmortal();
            u8str = UnicodeStringToU8String((UnicodeString &)days[i], &u8len);
            sv_usepvn(sv, (char*)u8str, u8len);
            PUSHs(sv);
        }

DateFormatSymbols *
DateFormatSymbols::new(...)
    PREINIT:
        Picu_Locale *locale = NULL;
        const DateFormatSymbols *dfs = NULL;
        UErrorCode status = U_ZERO_ERROR;
        SV *sv_status = NULL;
        int locale_index = 0;
        int status_index = 0;
    CODE:
        DEBUG100(" ");
        if (items < 1 || items > 3)
            Perl_croak(aTHX_ 
                  "Usage: new ICU::DateFormatSymbols([\\$status])\n"
                  "   or: new ICU::DateFormatSymbols(locale [, \\$status])"
                  "   or: new ICU::DateFormatSymbols(otherDateFormatSymbols)");
        //
        // distinguish between a locale object and a DateFormatObject
        // ie: figure out what the parameters we have
        //
        DEBUG100("items = %d", items);
        if (items == 3) {
            locale_index = 1;
            status_index = 2;
        }
        else if (items == 2) {
            if (sv_isobject(ST(1))) {
                if (IS_DATEFORMATSYMBOLS_OBJECT(ST(1))) {
                    DEBUG100("param 1 is a DateFormatSymbols object");
                    dfs = (DateFormatSymbols *)SvIV((SV*)SvRV(ST(1)));
                }
                else if (IS_LOCALE_OBJECT(ST(1))) {
                    DEBUG100("param 1 is a Locale object");
                    locale_index = 1;
                }
                else {
                    Perl_croak(aTHX_ "param 1 is an unrecognized object");
                }
            }
            else {
                // we will check if it is a status ref later
                status_index = 1;
            }
        }

        //
        // get the args
        //
        if (locale_index) {
            if ((!sv_isobject(ST(locale_index))) 
                || (!IS_LOCALE_OBJECT(ST(locale_index)))) {
               Perl_croak(aTHX_ "param %d is not a Locale", locale_index);
            }
            DEBUG100("param %d is a locale", locale_index);
            locale = (Picu_Locale *)SvIV((SV*)SvRV(ST(locale_index)));
        }
        if (status_index) {
            if ((!SVIsIntRef(ST(status_index)))) {
                Perl_croak(aTHX_ "param %d is not an integer reference", 
                                 status_index);
            }
            DEBUG100("param %d is a status ref", status_index);
            sv_status = SvRV(ST(status_index));
            status = (UErrorCode)SvIV(sv_status);
            if (U_FAILURE(status)) {
                XSRETURN_UNDEF;
            }
        }

        //
        // call the ICU func
        //
        if (dfs != NULL) {
            RETVAL = new DateFormatSymbols(*dfs);
        }
        else if (locale != NULL) {
            RETVAL = new DateFormatSymbols(*locale->getIcuLocale(), 
                                                     status);
        }
        else {
            RETVAL = new DateFormatSymbols(status);
        }
        if (sv_status) {
            sv_setiv(sv_status, (IV)status);
        }
    OUTPUT:
        RETVAL

int
setDebugLevel(...)
    CODE:
        RETVAL = debugLevel; // return old value
        if (items > 1) {
            Perl_croak(aTHX_ "Usage: ICU::DateFormatSymbols::setDebugLevel([new_debug_level])");
        }
        else if (items == 1) {
            debugLevel = SvIV(ST(0));
        }
        DEBUG100("debugLevel = %d", debugLevel);
    OUTPUT:
        RETVAL

