/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import com.gargoylesoftware.htmlunit.AjaxController;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.ref.WeakReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NicelyResynchronizingAjaxController
extends AjaxController {
    private static final Log LOG = LogFactory.getLog(NicelyResynchronizingAjaxController.class);
    private transient WeakReference<Thread> originatedThread_;

    public NicelyResynchronizingAjaxController() {
        this.init();
    }

    private void init() {
        this.originatedThread_ = new WeakReference<Thread>(Thread.currentThread());
    }

    @Override
    public boolean processSynchron(HtmlPage page, WebRequest settings, boolean async) {
        if (async && this.isInOriginalThread()) {
            LOG.info((Object)("Re-synchronized call to " + settings.getUrl()));
            return true;
        }
        return !async;
    }

    boolean isInOriginalThread() {
        return Thread.currentThread() == this.originatedThread_.get();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.init();
    }
}

