package Acme::CatalystX::ILoveDebug;
use Moose::Role;
use namespace::autoclean;

our $VERSION = '0.01';

requires 'uri_for';

around uri_for => sub {
    my ($orig, $self) = (shift, shift);
    my $params = ref($_[-1]) eq 'HASH' ? pop @_ : {};
    $params->{dump_info} = 1;
    $self->$orig(@_, $params); 
};

1;

=head1 NAME

Acme::CatalystX::ILoveDebug - Make all uris generated by an application trigger the debug page.

=head1 DESCRIPTION

Frivolous L<Catalyst> application class role to demonstrate a trivial application class role.

=head1 METHODS

=head2 uri_for

Wraps the normal uri_for call, injecting a parameter of C<< dump_info => 1 >>
into the call so that all URIs generated will cause the debug screen..

=head1 AUTHOR

Tomas Doran (t0m) C<< <bobtfish@bobtfish.net> >>.

=head1 COPYRIGHT & LICENSE

Copyright 2009 the above author(s).

This sofware is free software, and is licensed under the same terms as perl itself.

=cut
