package AssertHelper;

use strict;
use warnings;
use Exporter 'import';

our @EXPORT = qw/packit unpackit $es256_pk $cdh $authdata $sig/;

our $es256_pk = packit (qw(
	0x34 0xeb 0x99 0x77 0x02 0x9c 0x36 0x38
	0xbb 0xc2 0xae 0xa0 0xa0 0x18 0xc6 0x64
	0xfc 0xe8 0x49 0x92 0xd7 0x74 0x9e 0x0c
	0x46 0x8c 0x9d 0xa6 0xdf 0x46 0xf7 0x84
	0x60 0x1e 0x0f 0x8b 0x23 0x85 0x4a 0x9a
	0xec 0xc1 0x08 0x9f 0x30 0xd0 0x0d 0xd7
	0x76 0x7b 0x55 0x48 0x91 0x7c 0x4f 0x0f
	0x64 0x1a 0x1d 0xf8 0xbe 0x14 0x90 0x8a
));

our $cdh = packit (qw(
	0xec 0x8d 0x8f 0x78 0x42 0x4a 0x2b 0xb7
	0x82 0x34 0xaa 0xca 0x07 0xa1 0xf6 0x56
	0x42 0x1c 0xb6 0xf6 0xb3 0x00 0x86 0x52
	0x35 0x2d 0xa2 0x62 0x4a 0xbe 0x89 0x76
));

our $authdata = packit (qw(
	0x58 0x25 0x49 0x96 0x0d 0xe5 0x88 0x0e
	0x8c 0x68 0x74 0x34 0x17 0x0f 0x64 0x76
	0x60 0x5b 0x8f 0xe4 0xae 0xb9 0xa2 0x86
	0x32 0xc7 0x99 0x5c 0xf3 0xba 0x83 0x1d
	0x97 0x63 0x00 0x00 0x00 0x00 0x03
));

our $sig = packit (qw(
	0x30 0x46 0x02 0x21 0x00 0xf6 0xd1 0xa3
	0xd5 0x24 0x2b 0xde 0xee 0xa0 0x90 0x89
	0xcd 0xf8 0x9e 0xbd 0x6b 0x4d 0x55 0x79
	0xe4 0xc1 0x42 0x27 0xb7 0x9b 0x9b 0xa4
	0x0a 0xe2 0x47 0x64 0x0e 0x02 0x21 0x00
	0xe5 0xc9 0xc2 0x83 0x47 0x31 0xc7 0x26
	0xe5 0x25 0xb2 0xb4 0x39 0xa7 0xfc 0x3d
	0x70 0xbe 0xe9 0x81 0x0d 0x4a 0x62 0xa9
	0xab 0x4a 0x91 0xc0 0x7d 0x2d 0x23 0x1e
));


sub packit
{
	my $data = join ('', @_);
	$data =~ s/0x//g;
	$data =~ s/\s+//g;

    pack ("H*", $data);
}

sub unpackit
{
    local $_ = unpack ("H*", join ('', @_));
    s/(..)/$1 /g;
    s/ $//;
    $_;
}

1;

