#!/usr/bin/perl -w
use strict;

# ------------------------------------------------------------------------------
# THIS IS A GENERATED SCRIPT, CHANGES MADE HERE WILL BE OVERWRITTEN
# ------------------------------------------------------------------------------

use lib qw(../lib);

use Perl::Module;
use Data::Hub::Util qw(:all);
use Data::Hub qw($Hub);

our %Info = ();
$Info{'t1'} = {
  'test' => '  use Algorithm::KeyGen; 
  Algorithm::KeyGen->new(9, \'MyCharset\');',
  'num' => 1,
  'comparator' => 'abort',
  'package' => 'Algorithm::KeyGen',
  'summary' => 'Create a new KeyGen',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Algorithm/KeyGen.pm',
  'invert' => 1,
  'lineno' => 56,
  'result' => ''
}
;
$Info{'t2'} = {
  'test' => '  use Algorithm::KeyGen qw($KeyGen);
  for (1 .. 100) {
    die unless $KeyGen->validate($KeyGen->create());
  }',
  'num' => 2,
  'comparator' => 'abort',
  'package' => 'Algorithm::KeyGen',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Algorithm/KeyGen.pm',
  'invert' => 1,
  'lineno' => 177,
  'result' => ''
}
;
$Info{'t3'} = {
  'test' => '  use Data::CompositeHash;',
  'num' => 3,
  'comparator' => 'abort',
  'package' => 'Data::CompositeHash',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/CompositeHash.pm',
  'invert' => 1,
  'lineno' => 15,
  'result' => ''
}
;
$Info{'t4'} = {
  'test' => '  my $ch = Data::CompositeHash->new();',
  'num' => 4,
  'comparator' => 'abort',
  'package' => 'Data::CompositeHash',
  'summary' => 'no default hash provided',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/CompositeHash.pm',
  'invert' => 0,
  'lineno' => 16,
  'result' => ''
}
;
$Info{'t5'} = {
  'test' => '  my $h2 = {a=>\'a2\'};
  my $ch = Data::CompositeHash->new($h2);
  $ch->shift;
  $ch->{a};',
  'num' => 5,
  'comparator' => 'defined',
  'package' => 'Data::CompositeHash',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/CompositeHash.pm',
  'invert' => 1,
  'lineno' => 31,
  'result' => ''
}
;
$Info{'t6'} = {
  'test' => '  my $h1 = {a=>\'a1\'};
  my $h2 = {a=>\'a2\'};
  my $ch = Data::CompositeHash->new($h2);
  $ch->unshift($h1);
  $ch->{a};',
  'num' => 6,
  'comparator' => 'match',
  'package' => 'Data::CompositeHash',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/CompositeHash.pm',
  'invert' => 0,
  'lineno' => 49,
  'result' => 'a1'
}
;
$Info{'t7'} = {
  'test' => '  my $h2 = {a=>\'a2\'};
  my $h3 = {a=>\'a3\'};
  my $ch = Data::CompositeHash->new($h2);
  $ch->push($h3);
  $ch->{a};',
  'num' => 7,
  'comparator' => 'match',
  'package' => 'Data::CompositeHash',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/CompositeHash.pm',
  'invert' => 0,
  'lineno' => 68,
  'result' => 'a2'
}
;
$Info{'t8'} = {
  'test' => '  my $h2 = {a=>\'a2\'};
  my $ch = Data::CompositeHash->new($h2);
  $ch->pop;
  $ch->{a};',
  'num' => 8,
  'comparator' => 'defined',
  'package' => 'Data::CompositeHash',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/CompositeHash.pm',
  'invert' => 1,
  'lineno' => 87,
  'result' => ''
}
;
$Info{'t9'} = {
  'test' => '  my $h1 = {a=>\'a1\'};
  my $h2 = {a=>\'a2\', b=>\'b2\'};
  my $h3 = {a=>\'a3\', b=>\'b3\', c=>\'c3\'};
  my $ch = Data::CompositeHash->new($h2);
  $ch->unshift($h1);
  $ch->push($h3);
  # We now have a composite stack with prescedence: $h1, $h2, $h3
  # Where $h2 is the default hash
  $ch->{a} = \'AA\';
  $ch->{b} = \'BB\';
  $ch->{c} = \'CC\';
  $ch->{d} = \'DD\';
  die unless $h1->{a} eq \'AA\';
  die unless $h2->{b} eq \'BB\';
  die unless $h3->{c} eq \'CC\';
  die unless $h2->{d} eq \'DD\'; # set on default hash b/c \'d\' did not exist',
  'num' => 9,
  'comparator' => 'abort',
  'package' => 'Data::CompositeHash',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/CompositeHash.pm',
  'invert' => 1,
  'lineno' => 121,
  'result' => ''
}
;
$Info{'t10'} = {
  'test' => '  my $h1 = {a=>\'a1\'};
  my $h2 = {a=>\'a2\', b=>\'b2\'};
  my $h3 = {a=>\'a3\', b=>\'b3\', c=>\'c3\'};
  my $ch = Data::CompositeHash->new($h2);
  $ch->unshift($h1);
  $ch->push($h3);
  # We now have a composite stack with prescedence: $h1, $h2, $h3
  # Where $h2 is the default hash
  die unless $ch->{a} eq \'a1\';
  die unless $ch->{b} eq \'b2\';
  die unless $ch->{c} eq \'c3\';
  die unless ref($ch->{\'/\'});',
  'num' => 10,
  'comparator' => 'abort',
  'package' => 'Data::CompositeHash',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/CompositeHash.pm',
  'invert' => 1,
  'lineno' => 157,
  'result' => ''
}
;
$Info{'t11'} = {
  'test' => '  my $h1 = {a=>\'a1\'};
  my $h2 = {a=>\'a2\', b=>\'b2\'};
  my $h3 = {a=>\'a3\', b=>\'b3\', c=>\'c3\'};
  my $ch = Data::CompositeHash->new($h2);
  $ch->unshift($h1);
  $ch->push($h3);
  join \'\', sort values %$ch;',
  'num' => 11,
  'comparator' => 'match',
  'package' => 'Data::CompositeHash',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/CompositeHash.pm',
  'invert' => 0,
  'lineno' => 192,
  'result' => 'a1b2c3'
}
;
$Info{'t12'} = {
  'test' => '  my $h1 = {a=>\'a1\'};
  my $h2 = {a=>\'a2\', b=>\'b2\'};
  my $h3 = {a=>\'a3\', b=>\'b3\', c=>\'c3\'};
  my $ch = Data::CompositeHash->new($h2);
  $ch->unshift($h1);
  $ch->push($h3);
  die unless exists $$ch{a};
  die unless exists $$ch{b};
  die unless exists $$ch{c};
  die if exists $$ch{d};',
  'num' => 12,
  'comparator' => 'abort',
  'package' => 'Data::CompositeHash',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/CompositeHash.pm',
  'invert' => 1,
  'lineno' => 213,
  'result' => ''
}
;
$Info{'t13'} = {
  'test' => '  my $h1 = {a=>\'a1\'};
  my $h2 = {a=>\'a2\', b=>\'b2\'};
  my $h3 = {a=>\'a3\', b=>\'b3\', c=>\'c3\'};
  my $ch = Data::CompositeHash->new($h2);
  $ch->unshift($h1);
  $ch->push($h3);
  delete $ch->{a};
  delete $ch->{b};
  delete $ch->{c};
  join \'\', sort values %$ch;',
  'num' => 13,
  'comparator' => 'match',
  'package' => 'Data::CompositeHash',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/CompositeHash.pm',
  'invert' => 0,
  'lineno' => 234,
  'result' => 'a2b3'
}
;
$Info{'t14'} = {
  'test' => '  my $h1 = {a=>\'a1\'};
  my $h2 = {a=>\'a2\', b=>\'b2\'};
  my $h3 = {a=>\'a3\', b=>\'b3\', c=>\'c3\'};
  my $ch = Data::CompositeHash->new($h2);
  $ch->unshift($h1);
  $ch->push($h3);
  %$ch = ();
  join \'\', sort values %$ch;',
  'num' => 14,
  'comparator' => 'match',
  'package' => 'Data::CompositeHash',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/CompositeHash.pm',
  'invert' => 0,
  'lineno' => 255,
  'result' => 'a2b2'
}
;
$Info{'t15'} = {
  'test' => '  my $h2 = {a=>\'a2\', b=>\'b2\'};
  my $ch = Data::CompositeHash->new($h2);
  scalar(%$ch);',
  'num' => 15,
  'comparator' => 'true',
  'package' => 'Data::CompositeHash',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/CompositeHash.pm',
  'invert' => 0,
  'lineno' => 273,
  'result' => ''
}
;
$Info{'t16'} = {
  'test' => '  my $h2 = {a=>\'a2\', b=>\'b2\'};
  my $ch = Data::CompositeHash->new($h2);
  $ch->pop;
  scalar(%$ch);',
  'num' => 16,
  'comparator' => 'false',
  'package' => 'Data::CompositeHash',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/CompositeHash.pm',
  'invert' => 0,
  'lineno' => 278,
  'result' => ''
}
;
$Info{'t17'} = {
  'test' => '  use Data::CompositeHash;
  my $h1 = {
    \'a\' => \'argon\',
  };
  my $h2 = {
    \'a\' => \'apple\',
    \'b\' => \'banana\',
    \'c\' => \'cherry\',
  };
  my $h3 = {
    \'c\' => \'cyan\',
    \'d\' => \'dark brown\',
  };
  my $result = \'\';
  # Create a composite hash, using $h2 as the default hash
  my $ch = Data::CompositeHash->new($h2);
  # Add $h1 as a hash which will overried values in $h2
  $ch->unshift($h1);
  # Add $h3 as a hash with the least prescedence
  $ch->push($h3);
  # Fetch some values
  $result .= $ch->{a} . "\\n";
  $result .= $ch->{b} . "\\n";
  $result .= $ch->{c} . "\\n";
  $result .= $ch->{d} . "\\n";
  # Set an ambiguous value
  $result .= "--\\n";
  $ch->{a} = \'aluminium\';
  $result .= $h1->{a} . "\\n"; # contains new value
  $result .= $h2->{a} . "\\n"; # not touched
  # Set an ambiguous value
  $result .= "--\\n";
  $ch->{c} = \'cantelope\';
  $result .= $h2->{c} . "\\n"; # contains new value
  $result .= $h3->{c} . "\\n"; # not touched
  # Setting a value which is not defined in any hash sets
  # it on the defalut hash
  $result .= "--\\n";
  $ch->{e} = \'edible fruit\';
  $result .= $h2->{e};',
  'num' => 17,
  'comparator' => 'match',
  'package' => 'Data::CompositeHash',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/CompositeHash.pm',
  'invert' => 0,
  'lineno' => 289,
  'result' => 'argon
banana
cherry
dark brown
--
aluminium
apple
--
cantelope
cyan
--
edible fruit'
}
;
$Info{'t18'} = {
  'test' => '  use Data::Format::Hash qw(hf_parse);',
  'num' => 18,
  'comparator' => 'abort',
  'package' => 'Data::Format::Hash',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Format/Hash.pm',
  'invert' => 1,
  'lineno' => 73,
  'result' => ''
}
;
$Info{'t19'} = {
  'test' => '  my $d = q(
  baz => biz
  foo => %{
  bar => @{
  tender
  stool
  }
  }
  );
  my $h = hf_parse(\\$d);
  $$h{\'baz\'};',
  'num' => 19,
  'comparator' => 'match',
  'package' => 'Data::Format::Hash',
  'summary' => 'Parse a simple nested collection',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Format/Hash.pm',
  'invert' => 0,
  'lineno' => 74,
  'result' => 'biz'
}
;
$Info{'t20'} = {
  'test' => '  use Data::Format::Hash qw(hf_format);',
  'num' => 20,
  'comparator' => 'abort',
  'package' => 'Data::Format::Hash',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Format/Hash.pm',
  'invert' => 1,
  'lineno' => 315,
  'result' => ''
}
;
$Info{'t21'} = {
  'test' => '  my $d = {foo=>{bar=>[\'tender\',\'stool\']}};
  hf_format($d)',
  'num' => 21,
  'comparator' => 'match',
  'package' => 'Data::Format::Hash',
  'summary' => 'Format a simple nested collection',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Format/Hash.pm',
  'invert' => 0,
  'lineno' => 316,
  'result' => 'foo => %{
  bar => @{
    tender
    stool
  }
}'
}
;
$Info{'t22'} = {
  'test' => '  use Data::Format::HexString qw(:all);
  hexstr_format( \'Dogs (Waters, Gilmour) 17:06\' );',
  'num' => 22,
  'comparator' => 'match',
  'package' => 'Data::Format::HexString',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Format/HexString.pm',
  'invert' => 0,
  'lineno' => 15,
  'result' => 'Dogs_0x20__0x28_Waters_0x2c__0x20_Gilmour_0x29__0x20_17_0x3a_06'
}
;
$Info{'t23'} = {
  'test' => '  hexstr_parse(\'Dogs_0x20__0x28_Waters_0x2c__0x20_Gilmour_0x29__0x20_17_0x3a_06\');',
  'num' => 23,
  'comparator' => 'match',
  'package' => 'Data::Format::HexString',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Format/HexString.pm',
  'invert' => 0,
  'lineno' => 29,
  'result' => 'Dogs (Waters, Gilmour) 17:06'
}
;
$Info{'t24'} = {
  'test' => '  use Data::Format::XFR;
  use Data::OrderedHash;
  my $h = Data::OrderedHash->new(
    a => [\'alpha\', \'beta\', \'copper\'],
    b => {
      one => 1,
    },
    c => \'charlie\',
  );
  my $xfr = Data::Format::XFR->new(\'base64\');
  my $known = \'%{YQ==@{${YWxwaGE=}${YmV0YQ==}${Y29wcGVy}}Yg==%{b25l${MQ==}}Yw==${Y2hhcmxpZQ==}}\';
  my $str = $xfr->format($h);
  die "format error:\\nstr: $str\\n!= : $known" unless $str eq $known;
  my $h2 = $xfr->parse($str);
  die \'parse error\' unless $h2->{a}[1] eq $h->{a}[1];',
  'num' => 24,
  'comparator' => 'abort',
  'package' => 'Data::Format::XFR',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Format/XFR.pm',
  'invert' => 1,
  'lineno' => 205,
  'result' => ''
}
;
$Info{'t25'} = {
  'test' => '    
  use strict;
  use Data::Hub::Address;
  my $a = Data::Hub::Address->new("/b/c/d");
  die $a->to_string unless \'/b/c/d\' eq $a->to_string;
  die $a->first unless \'\' eq $a->first;
  die $a->last unless \'d\' eq $a->last;
  $a->pop;
  die unless \'/b/c\' eq $a->to_string;
  $a->push("D");
  die unless \'/b/c/D\' eq $a->to_string;
  $a->shift;
  die unless \'b/c/D\' eq $a->to_string;
  $a->unshift(\'A\');
  die unless \'A/b/c/D\' eq $a->to_string;',
  'num' => 25,
  'comparator' => 'abort',
  'package' => 'Data::Hub::Address',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Address.pm',
  'invert' => 1,
  'lineno' => 33,
  'result' => ''
}
;
$Info{'t26'} = {
  'test' => '  my $h = {g=>[qw(a b)]};
  Data::Hub::Courier::append($h, \'/g\', \'c\');
  join(\'\', @{$$h{g}});',
  'num' => 26,
  'comparator' => 'match',
  'package' => 'Data::Hub::Courier',
  'summary' => 'Append to an array',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Courier.pm',
  'invert' => 0,
  'lineno' => 208,
  'result' => 'abc'
}
;
$Info{'t27'} = {
  'test' => '  my $h = {g=>Data::OrderedHash->new(a => 1, b => 2)};
  Data::Hub::Courier::append($h, \'/g\', c => 3);
  join(\'\', keys %{$$h{g}});',
  'num' => 27,
  'comparator' => 'match',
  'package' => 'Data::Hub::Courier',
  'summary' => 'Append to a hash',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Courier.pm',
  'invert' => 0,
  'lineno' => 213,
  'result' => 'abc'
}
;
$Info{'t28'} = {
  'test' => '  my $h = {g=>str_ref(\'ab\')};
  Data::Hub::Courier::append($h, \'/g\', \'c\');
  ${$$h{g}};',
  'num' => 28,
  'comparator' => 'match',
  'package' => 'Data::Hub::Courier',
  'summary' => 'Append to a scalar',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Courier.pm',
  'invert' => 0,
  'lineno' => 218,
  'result' => 'abc'
}
;
$Info{'t29'} = {
  'test' => '  my $h = {g=>[qw(b c)]};
  Data::Hub::Courier::prepend($h, \'/g\', \'a\');
  join(\'\', @{$$h{g}});',
  'num' => 29,
  'comparator' => 'match',
  'package' => 'Data::Hub::Courier',
  'summary' => 'Prepend to an array',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Courier.pm',
  'invert' => 0,
  'lineno' => 255,
  'result' => 'abc'
}
;
$Info{'t30'} = {
  'test' => '  my $h = {g=>Data::OrderedHash->new(b => 2, c => 3)};
  Data::Hub::Courier::prepend($h, \'/g\', a => 1);
  join(\'\', keys %{$$h{g}});',
  'num' => 30,
  'comparator' => 'match',
  'package' => 'Data::Hub::Courier',
  'summary' => 'Prepend to a hash',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Courier.pm',
  'invert' => 0,
  'lineno' => 260,
  'result' => 'abc'
}
;
$Info{'t31'} = {
  'test' => '  my $h = {g=>str_ref(\'bc\')};
  Data::Hub::Courier::prepend($h, \'/g\', \'a\');
  ${$$h{g}};',
  'num' => 31,
  'comparator' => 'match',
  'package' => 'Data::Hub::Courier',
  'summary' => 'Prepend to a scalar',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Courier.pm',
  'invert' => 0,
  'lineno' => 265,
  'result' => 'abc'
}
;
$Info{'t32'} = {
  'test' => '  use Data::Hub::Courier;
  my $h = {
    A => {
      I => [
        \'Hello\'
      ],
    },
  };
  Data::Hub::Courier::set($h, \'/A/I/1\', \'World!\');
  my $a = Data::Hub::Courier::get($h, \'/A/I\');
  join \' \', @$a;',
  'num' => 32,
  'comparator' => 'match',
  'package' => 'Data::Hub::Courier',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Courier.pm',
  'invert' => 0,
  'lineno' => 385,
  'result' => 'Hello World!'
}
;
$Info{'t33'} = {
  'test' => '  # This test case simply sets up the test data and subroutine for running
  # subsequent test queries.
  use Data::Hub::Util qw(:all);
  use Data::Format::Hash qw(hf_format hf_parse);
  use Data::OrderedHash;
  my $ttt_data = curry(hf_parse(\'
    array => @{
      a
      b
      c
      ab
      abc
    }
    hash => %{
      a => Alpha
      b => Beta
      c => Charlie
    }
    array_of_hashes => @{
      %{
        name => a
        text => Alpha
      }
      %{
        name => b
        text => Beta
      }
      %{
        name => c
        text => Charlie
      }
    }
    hash_of_hashes => %{
      a => %{
        text => Alpha
        num => 3
      }
      b => %{
        text => Beta
        num => 2
      }
      c => %{
        text => Charlie
        num => 1
      }
    }
  \'));
  # The test data is curried to provide the get method of Data::Hub::Courier
  sub ttt_query {
    my $q = shift;
    my $r = $ttt_data->get($q);
    return unless defined $r;
    my $ref = ref($r);
    $ref ? hf_format({$ref => $r}) : $r;
  }',
  'num' => 33,
  'comparator' => 'abort',
  'package' => 'Data::Hub::Query',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Query.pm',
  'invert' => 1,
  'lineno' => 410,
  'result' => ''
}
;
$Info{'t34'} = {
  'test' => '  # Use an invalid index
  ttt_query(\'array/{?:fail}\');',
  'num' => 34,
  'comparator' => 'defined',
  'package' => 'Data::Hub::Query',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Query.pm',
  'invert' => 1,
  'lineno' => 481,
  'result' => ''
}
;
$Info{'t35'} = {
  'test' => '  # Get the value whose value is \'\'
  ttt_query(\'array/{?:}\');',
  'num' => 35,
  'comparator' => 'defined',
  'package' => 'Data::Hub::Query',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Query.pm',
  'invert' => 1,
  'lineno' => 486,
  'result' => ''
}
;
$Info{'t36'} = {
  'test' => '  # Get the value whose key is eq 0
  ttt_query(\'array/{?:0}\');',
  'num' => 36,
  'comparator' => 'match',
  'package' => 'Data::Hub::Query',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Query.pm',
  'invert' => 0,
  'lineno' => 491,
  'result' => 'a'
}
;
$Info{'t37'} = {
  'test' => '  # Get the value whose key is == 0
  ttt_query(\'array/{?(==):0}\');',
  'num' => 37,
  'comparator' => 'match',
  'package' => 'Data::Hub::Query',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Query.pm',
  'invert' => 0,
  'lineno' => 500,
  'result' => 'Data::Hub::Subset => %{
  0 => a
}'
}
;
$Info{'t38'} = {
  'test' => '  # Get all items whose key is >= 2
  ttt_query(\'array/{?(>=):2}\');',
  'num' => 38,
  'comparator' => 'match',
  'package' => 'Data::Hub::Query',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Query.pm',
  'invert' => 0,
  'lineno' => 511,
  'result' => 'Data::Hub::Subset => %{
  2 => c
  3 => ab
  4 => abc
}'
}
;
$Info{'t39'} = {
  'test' => '  # Get the value whose value is \'a\'
  ttt_query(\'array/{?*:a}\');',
  'num' => 39,
  'comparator' => 'match',
  'package' => 'Data::Hub::Query',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Query.pm',
  'invert' => 0,
  'lineno' => 524,
  'result' => 'a'
}
;
$Info{'t40'} = {
  'test' => '  # Get all items whose value is eq \'a\'
  ttt_query(\'array/{?*(eq):a}\');',
  'num' => 40,
  'comparator' => 'match',
  'package' => 'Data::Hub::Query',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Query.pm',
  'invert' => 0,
  'lineno' => 533,
  'result' => 'Data::Hub::Subset => %{
  0 => a
}'
}
;
$Info{'t41'} = {
  'test' => '  # Get all items whose value is =~ /a/
  ttt_query(\'array/{?*(=~):a}\');',
  'num' => 41,
  'comparator' => 'match',
  'package' => 'Data::Hub::Query',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Query.pm',
  'invert' => 0,
  'lineno' => 544,
  'result' => 'Data::Hub::Subset => %{
  0 => a
  3 => ab
  4 => abc
}'
}
;
$Info{'t42'} = {
  'test' => '  # Get the value whose key is eq \'a\'
  ttt_query(\'hash/{?:a}\');',
  'num' => 42,
  'comparator' => 'match',
  'package' => 'Data::Hub::Query',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Query.pm',
  'invert' => 0,
  'lineno' => 561,
  'result' => 'Alpha'
}
;
$Info{'t43'} = {
  'test' => '  # Get the value whose value is eq \'Alpha\'
  ttt_query(\'hash/{?*:Alpha}\');',
  'num' => 43,
  'comparator' => 'match',
  'package' => 'Data::Hub::Query',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Query.pm',
  'invert' => 0,
  'lineno' => 570,
  'result' => 'Alpha'
}
;
$Info{'t44'} = {
  'test' => '  # Get all items whose value is eq \'Alpha\'
  ttt_query(\'hash/{?*(eq):Alpha}\');',
  'num' => 44,
  'comparator' => 'match',
  'package' => 'Data::Hub::Query',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Query.pm',
  'invert' => 0,
  'lineno' => 579,
  'result' => 'Data::Hub::Subset => %{
  a => Alpha
}'
}
;
$Info{'t45'} = {
  'test' => '  # Get all items whose value is =~ /a$/
  ttt_query(\'hash/{?*(=~):a$}\');',
  'num' => 45,
  'comparator' => 'match',
  'package' => 'Data::Hub::Query',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Query.pm',
  'invert' => 0,
  'lineno' => 590,
  'result' => 'Data::Hub::Subset => %{
  a => Alpha
  b => Beta
}'
}
;
$Info{'t46'} = {
  'test' => '  # Get the value whose key is eq 0
  ttt_query(\'array_of_hashes/{?:0}\');',
  'num' => 46,
  'comparator' => 'match',
  'package' => 'Data::Hub::Query',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Query.pm',
  'invert' => 0,
  'lineno' => 606,
  'result' => 'Data::OrderedHash => %{
  name => a
  text => Alpha
}'
}
;
$Info{'t47'} = {
  'test' => '  # Get the value whose name is eq \'a\'
  ttt_query(\'array_of_hashes/{?name:a}\');',
  'num' => 47,
  'comparator' => 'match',
  'package' => 'Data::Hub::Query',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Query.pm',
  'invert' => 0,
  'lineno' => 618,
  'result' => 'Data::OrderedHash => %{
  name => a
  text => Alpha
}'
}
;
$Info{'t48'} = {
  'test' => '  # Get all items whose name is eq \'a\'
  ttt_query(\'array_of_hashes/{?name(eq):a}\');',
  'num' => 48,
  'comparator' => 'match',
  'package' => 'Data::Hub::Query',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Query.pm',
  'invert' => 0,
  'lineno' => 630,
  'result' => 'Data::Hub::Subset => %{
  0 => %{
    name => a
    text => Alpha
  }
}'
}
;
$Info{'t49'} = {
  'test' => '  # Get all items whose name is =~ /a|b/
  ttt_query(\'array_of_hashes/{?name(=~):a|b}\');',
  'num' => 49,
  'comparator' => 'match',
  'package' => 'Data::Hub::Query',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Query.pm',
  'invert' => 0,
  'lineno' => 644,
  'result' => 'Data::Hub::Subset => %{
  0 => %{
    name => a
    text => Alpha
  }
  1 => %{
    name => b
    text => Beta
  }
}'
}
;
$Info{'t50'} = {
  'test' => '  # Get the value whose key is eq \'a\'
  ttt_query(\'hash_of_hashes/{?:a}\');',
  'num' => 50,
  'comparator' => 'match',
  'package' => 'Data::Hub::Query',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Query.pm',
  'invert' => 0,
  'lineno' => 666,
  'result' => 'Data::OrderedHash => %{
  text => Alpha
  num => 3
}'
}
;
$Info{'t51'} = {
  'test' => '  # Get the value whose text is eq \'Alpha\'
  ttt_query(\'hash_of_hashes/{?text:Alpha}\');',
  'num' => 51,
  'comparator' => 'match',
  'package' => 'Data::Hub::Query',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Query.pm',
  'invert' => 0,
  'lineno' => 678,
  'result' => 'Data::OrderedHash => %{
  text => Alpha
  num => 3
}'
}
;
$Info{'t52'} = {
  'test' => '  # Get all items whose text is eq \'Alpha\'
  ttt_query(\'hash_of_hashes/{?text(eq):Alpha}\');',
  'num' => 52,
  'comparator' => 'match',
  'package' => 'Data::Hub::Query',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Query.pm',
  'invert' => 0,
  'lineno' => 690,
  'result' => 'Data::Hub::Subset => %{
  a => %{
    text => Alpha
    num => 3
  }
}'
}
;
$Info{'t53'} = {
  'test' => '  # Get all items whose num is > 1
  ttt_query(\'hash_of_hashes/{?num(>):1}\');',
  'num' => 53,
  'comparator' => 'match',
  'package' => 'Data::Hub::Query',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Query.pm',
  'invert' => 0,
  'lineno' => 704,
  'result' => 'Data::Hub::Subset => %{
  a => %{
    text => Alpha
    num => 3
  }
  b => %{
    text => Beta
    num => 2
  }
}'
}
;
$Info{'t54'} = {
  'test' => '  ttt_query(\'hash_of_hashes/*|{?(ne):b}\');',
  'num' => 54,
  'comparator' => 'match',
  'package' => 'Data::Hub::Query',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Query.pm',
  'invert' => 0,
  'lineno' => 726,
  'result' => 'Data::Hub::Subset => %{
  a => %{
    text => Alpha
    num => 3
  }
  c => %{
    text => Charlie
    num => 1
  }
}'
}
;
$Info{'t55'} = {
  'test' => '  ttt_query(\'hash_of_hashes/*|{?text(=~):B|C}\');',
  'num' => 55,
  'comparator' => 'match',
  'package' => 'Data::Hub::Query',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Query.pm',
  'invert' => 0,
  'lineno' => 743,
  'result' => 'Data::Hub::Subset => %{
  b => %{
    text => Beta
    num => 2
  }
  c => %{
    text => Charlie
    num => 1
  }
}'
}
;
$Info{'t56'} = {
  'test' => '  ttt_query(\'hash_of_hashes/*|{?(=~):[ab]}|{?text(=~):B|C}\');',
  'num' => 56,
  'comparator' => 'match',
  'package' => 'Data::Hub::Query',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Query.pm',
  'invert' => 0,
  'lineno' => 762,
  'result' => 'Data::Hub::Subset => %{
  b => %{
    text => Beta
    num => 2
  }
}'
}
;
$Info{'t57'} = {
  'test' => '  ttt_query(\'hash_of_hashes/{?(=~):[ab]}|{?text(=~):B|C}\');',
  'num' => 57,
  'comparator' => 'match',
  'package' => 'Data::Hub::Query',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Query.pm',
  'invert' => 0,
  'lineno' => 775,
  'result' => 'Data::Hub::Subset => %{
  b => %{
    text => Beta
    num => 2
  }
}'
}
;
$Info{'t58'} = {
  'test' => '  use Data::Hub::Util qw(:all);',
  'num' => 58,
  'comparator' => 'abort',
  'package' => 'Data::Hub::Util',
  'summary' => 'Load this module',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 1,
  'lineno' => 85,
  'result' => ''
}
;
$Info{'t59'} = {
  'test' => '  curry({a=>{b=>\'c\'}})->get(\'/a/b\');',
  'num' => 59,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 125,
  'result' => 'c'
}
;
$Info{'t60'} = {
  'test' => '  FS(\'Node\');',
  'num' => 60,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 137,
  'result' => 'Data::Hub::FileSystem::Node'
}
;
$Info{'t61'} = {
  'test' => '  typeof(\'foo.bar\', {});',
  'num' => 61,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 148,
  'result' => 'data-hash'
}
;
$Info{'t62'} = {
  'test' => '  typeof(\'/with/path/foo.bar\', []);',
  'num' => 62,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 149,
  'result' => 'data-array'
}
;
$Info{'t63'} = {
  'test' => '  typeof(\'foo.bar\', \'baz\');',
  'num' => 63,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 150,
  'result' => 'data-scalar-bar'
}
;
$Info{'t64'} = {
  'test' => '  my $addr = \'/one/two/{/i/am/three}/four\';
  join(\':\', addr_shift($addr), addr_shift($addr), addr_shift($addr),
  addr_shift($addr)); ',
  'num' => 64,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 228,
  'result' => 'one:two:{/i/am/three}:four'
}
;
$Info{'t65'} = {
  'test' => '  my $addr = \'/one/two\';
  my $last = addr_pop($addr);
  "$last,$addr"',
  'num' => 65,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 241,
  'result' => 'two,/one'
}
;
$Info{'t66'} = {
  'test' => '  addr_normalize(\'/\');',
  'num' => 66,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 255,
  'result' => '/'
}
;
$Info{'t67'} = {
  'test' => '  addr_normalize(\'/a/\');',
  'num' => 67,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 256,
  'result' => '/a'
}
;
$Info{'t68'} = {
  'test' => '  addr_normalize(\'/a/b/..\');',
  'num' => 68,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 257,
  'result' => '/a'
}
;
$Info{'t69'} = {
  'test' => '  addr_normalize(\'/a/../b\');',
  'num' => 69,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 258,
  'result' => '/b'
}
;
$Info{'t70'} = {
  'test' => '  addr_normalize(\'/a/../../b\');',
  'num' => 70,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 259,
  'result' => '/b'
}
;
$Info{'t71'} = {
  'test' => '  addr_normalize(\'/a/.../b\');',
  'num' => 71,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 260,
  'result' => '/a'
}
;
$Info{'t72'} = {
  'test' => '  addr_normalize(\'/a/.../\');',
  'num' => 72,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 261,
  'result' => '/a'
}
;
$Info{'t73'} = {
  'test' => '  addr_normalize(\'/a/...\');',
  'num' => 73,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 262,
  'result' => '/a'
}
;
$Info{'t74'} = {
  'test' => '  addr_normalize(\'/a/.../..\');',
  'num' => 74,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 263,
  'result' => '/a'
}
;
$Info{'t75'} = {
  'test' => '  addr_normalize(\'/a/../...\');',
  'num' => 75,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 264,
  'result' => '/'
}
;
$Info{'t76'} = {
  'test' => '  addr_parent();',
  'num' => 76,
  'comparator' => 'defined',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 1,
  'lineno' => 275,
  'result' => ''
}
;
$Info{'t77'} = {
  'test' => '  addr_parent(\'\');',
  'num' => 77,
  'comparator' => 'defined',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 1,
  'lineno' => 276,
  'result' => ''
}
;
$Info{'t78'} = {
  'test' => '  addr_parent(\'/\');',
  'num' => 78,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 277,
  'result' => '/'
}
;
$Info{'t79'} = {
  'test' => '  addr_parent(\'/a\');',
  'num' => 79,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 278,
  'result' => '/'
}
;
$Info{'t80'} = {
  'test' => '  addr_parent(\'/a/b/..\');',
  'num' => 80,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 279,
  'result' => '/'
}
;
$Info{'t81'} = {
  'test' => '  addr_parent(\'a/b/\');',
  'num' => 81,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 280,
  'result' => 'a'
}
;
$Info{'t82'} = {
  'test' => '  addr_parent(\'a/b.c\');',
  'num' => 82,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 281,
  'result' => 'a'
}
;
$Info{'t83'} = {
  'test' => '  addr_name(\'\');',
  'num' => 83,
  'comparator' => 'defined',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 1,
  'lineno' => 294,
  'result' => ''
}
;
$Info{'t84'} = {
  'test' => '  addr_name(\'/\');',
  'num' => 84,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 295,
  'result' => ''
}
;
$Info{'t85'} = {
  'test' => '  addr_name(\'/a\');',
  'num' => 85,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 296,
  'result' => 'a'
}
;
$Info{'t86'} = {
  'test' => '  addr_name(\'/a/b/..\');',
  'num' => 86,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 297,
  'result' => 'a'
}
;
$Info{'t87'} = {
  'test' => '  addr_name(\'a/b/\');',
  'num' => 87,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 298,
  'result' => 'b'
}
;
$Info{'t88'} = {
  'test' => '  addr_name(\'a/b.c\');',
  'num' => 88,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 299,
  'result' => 'b.c'
}
;
$Info{'t89'} = {
  'test' => '  scalar(addr_split(\'\'));',
  'num' => 89,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 311,
  'result' => '0'
}
;
$Info{'t90'} = {
  'test' => '  join \' \', addr_split(\'/\');',
  'num' => 90,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 312,
  'result' => ''
}
;
$Info{'t91'} = {
  'test' => '  join \' \', addr_split(\'/a\');',
  'num' => 91,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 313,
  'result' => 'a'
}
;
$Info{'t92'} = {
  'test' => '  join \' \', addr_split(\'/a/b/..\');',
  'num' => 92,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 314,
  'result' => 'a'
}
;
$Info{'t93'} = {
  'test' => '  join \' \', addr_split(\'a/b/\');',
  'num' => 93,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 315,
  'result' => 'a b'
}
;
$Info{'t94'} = {
  'test' => '  join \' \', addr_split(\'a/b.c\');',
  'num' => 94,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 316,
  'result' => 'a b.c'
}
;
$Info{'t95'} = {
  'test' => '  addr_join(\'/\');',
  'num' => 95,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 330,
  'result' => '/'
}
;
$Info{'t96'} = {
  'test' => '  addr_join(\'/a\', \'/\');',
  'num' => 96,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 331,
  'result' => '/a'
}
;
$Info{'t97'} = {
  'test' => '  addr_join(\'/a/\', \'b/..\');',
  'num' => 97,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 332,
  'result' => '/a'
}
;
$Info{'t98'} = {
  'test' => '  addr_join(\'/a/..\', \'/b\');',
  'num' => 98,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 333,
  'result' => '/b'
}
;
$Info{'t99'} = {
  'test' => '  addr_join(\'/a/../\', \'../b\');',
  'num' => 99,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 334,
  'result' => '/b'
}
;
$Info{'t100'} = {
  'test' => '  addr_join(\'/a/.../\', \'b\');',
  'num' => 100,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 335,
  'result' => '/a'
}
;
$Info{'t101'} = {
  'test' => '  addr_join(\'/a/\', \'.../\');',
  'num' => 101,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 336,
  'result' => '/a'
}
;
$Info{'t102'} = {
  'test' => '  addr_join(\'/a/\', \'...\');',
  'num' => 102,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 337,
  'result' => '/a'
}
;
$Info{'t103'} = {
  'test' => '  addr_join(\'/a/\', \'b/\');',
  'num' => 103,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 338,
  'result' => '/a/b'
}
;
$Info{'t104'} = {
  'test' => '  addr_join(\'/a/\', \'b\');',
  'num' => 104,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 339,
  'result' => '/a/b'
}
;
$Info{'t105'} = {
  'test' => '  addr_join(\'/a\', \'/b\');',
  'num' => 105,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 340,
  'result' => '/a/b'
}
;
$Info{'t106'} = {
  'test' => '  addr_join(\'/a\', \'b\');',
  'num' => 106,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 341,
  'result' => '/a/b'
}
;
$Info{'t107'} = {
  'test' => '  addr_join(\'/a\', \'b\', \'c\');',
  'num' => 107,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 342,
  'result' => '/a/b/c'
}
;
$Info{'t108'} = {
  'test' => '  addr_ext(undef);',
  'num' => 108,
  'comparator' => 'defined',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 1,
  'lineno' => 353,
  'result' => ''
}
;
$Info{'t109'} = {
  'test' => '  addr_ext(\'foo.txt\');',
  'num' => 109,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 354,
  'result' => 'txt'
}
;
$Info{'t110'} = {
  'test' => '  addr_ext(\'/foo.txt\');',
  'num' => 110,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 355,
  'result' => 'txt'
}
;
$Info{'t111'} = {
  'test' => '  addr_ext(\'./foo.txt\');',
  'num' => 111,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 356,
  'result' => 'txt'
}
;
$Info{'t112'} = {
  'test' => '  addr_ext(\'../foo.txt\');',
  'num' => 112,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 357,
  'result' => 'txt'
}
;
$Info{'t113'} = {
  'test' => '  addr_ext(\'/foo/foo.txt\');',
  'num' => 113,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 358,
  'result' => 'txt'
}
;
$Info{'t114'} = {
  'test' => '  addr_ext(\'/foo.bar.txt\');',
  'num' => 114,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 359,
  'result' => 'txt'
}
;
$Info{'t115'} = {
  'test' => '  addr_ext(\'/foo/bar.\');',
  'num' => 115,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 360,
  'result' => ''
}
;
$Info{'t116'} = {
  'test' => '  addr_ext(\'/foo/bar\');',
  'num' => 116,
  'comparator' => 'defined',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 1,
  'lineno' => 361,
  'result' => ''
}
;
$Info{'t117'} = {
  'test' => '  addr_ext(\'.metadata\');',
  'num' => 117,
  'comparator' => 'defined',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 1,
  'lineno' => 362,
  'result' => ''
}
;
$Info{'t118'} = {
  'test' => '  addr_ext(\'.metadata.bak\');',
  'num' => 118,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 363,
  'result' => 'bak'
}
;
$Info{'t119'} = {
  'test' => '  addr_basename(undef);',
  'num' => 119,
  'comparator' => 'defined',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 1,
  'lineno' => 377,
  'result' => ''
}
;
$Info{'t120'} = {
  'test' => '  addr_basename(\'/\');',
  'num' => 120,
  'comparator' => 'defined',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 1,
  'lineno' => 378,
  'result' => ''
}
;
$Info{'t121'} = {
  'test' => '  addr_basename(\'foo.txt\');',
  'num' => 121,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 379,
  'result' => 'foo'
}
;
$Info{'t122'} = {
  'test' => '  addr_basename(\'foo.txt/\');',
  'num' => 122,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 380,
  'result' => 'foo'
}
;
$Info{'t123'} = {
  'test' => '  addr_basename(\'/foo.txt\');',
  'num' => 123,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 381,
  'result' => 'foo'
}
;
$Info{'t124'} = {
  'test' => '  addr_basename(\'./foo.txt\');',
  'num' => 124,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 382,
  'result' => 'foo'
}
;
$Info{'t125'} = {
  'test' => '  addr_basename(\'../foo.txt\');',
  'num' => 125,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 383,
  'result' => 'foo'
}
;
$Info{'t126'} = {
  'test' => '  addr_basename(\'/foo/foo.txt\');',
  'num' => 126,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 384,
  'result' => 'foo'
}
;
$Info{'t127'} = {
  'test' => '  addr_basename(\'/foo.bar.txt\');',
  'num' => 127,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 385,
  'result' => 'foo.bar'
}
;
$Info{'t128'} = {
  'test' => '  addr_basename(\'/foo/bar.\');',
  'num' => 128,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 386,
  'result' => 'bar'
}
;
$Info{'t129'} = {
  'test' => '  addr_basename(\'/foo/bar\');',
  'num' => 129,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 387,
  'result' => 'bar'
}
;
$Info{'t130'} = {
  'test' => '  addr_basename(\'.metadata\');',
  'num' => 130,
  'comparator' => 'defined',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 1,
  'lineno' => 388,
  'result' => ''
}
;
$Info{'t131'} = {
  'test' => '  addr_basename(\'.metadata.bak\');',
  'num' => 131,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 389,
  'result' => '.metadata'
}
;
$Info{'t132'} = {
  'test' => '  addr_base(\'/a/b/{d}\');',
  'num' => 132,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 404,
  'result' => '/a/b'
}
;
$Info{'t133'} = {
  'test' => '  addr_base(\'/a/b/d\');',
  'num' => 133,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 405,
  'result' => '/a/b/d'
}
;
$Info{'t134'} = {
  'test' => '  my $path = \'/one/two/../four\';
  join(\':\', path_shift($path), path_shift($path), path_shift($path),
  path_shift($path)); ',
  'num' => 134,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 429,
  'result' => 'one:two:..:four'
}
;
$Info{'t135'} = {
  'test' => '  my $path = \'/one/two\';
  my $last = path_pop($path);
  "$last,$path"',
  'num' => 135,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 442,
  'result' => 'two,/one'
}
;
$Info{'t136'} = {
  'test' => '  my $path = \'/one/two\';
  my $count = path_push($path, \'three\');
  "$path"',
  'num' => 136,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 455,
  'result' => '/one/two/three'
}
;
$Info{'t137'} = {
  'test' => '  path_split(\'\');',
  'num' => 137,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 467,
  'result' => '0'
}
;
$Info{'t138'} = {
  'test' => '  join \' \', path_split(\'/\');',
  'num' => 138,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 468,
  'result' => ''
}
;
$Info{'t139'} = {
  'test' => '  join \' \', path_split(\'/a\');',
  'num' => 139,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 469,
  'result' => 'a'
}
;
$Info{'t140'} = {
  'test' => '  join \' \', path_split(\'/a/b/..\');',
  'num' => 140,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 470,
  'result' => 'a'
}
;
$Info{'t141'} = {
  'test' => '  join \' \', path_split(\'a/b/\');',
  'num' => 141,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 471,
  'result' => 'a b'
}
;
$Info{'t142'} = {
  'test' => '  join \' \', path_split(\'a/b.c\');',
  'num' => 142,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 472,
  'result' => 'a b.c'
}
;
$Info{'t143'} = {
  'test' => '  path_basename(undef);',
  'num' => 143,
  'comparator' => 'defined',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 1,
  'lineno' => 489,
  'result' => ''
}
;
$Info{'t144'} = {
  'test' => '  path_basename(\'foo.txt\');',
  'num' => 144,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 490,
  'result' => 'foo'
}
;
$Info{'t145'} = {
  'test' => '  path_basename(\'/foo.txt\');',
  'num' => 145,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 491,
  'result' => 'foo'
}
;
$Info{'t146'} = {
  'test' => '  path_basename(\'./foo.txt\');',
  'num' => 146,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 492,
  'result' => 'foo'
}
;
$Info{'t147'} = {
  'test' => '  path_basename(\'../foo.txt\');',
  'num' => 147,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 493,
  'result' => 'foo'
}
;
$Info{'t148'} = {
  'test' => '  path_basename(\'/foo/foo.txt\');',
  'num' => 148,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 494,
  'result' => 'foo'
}
;
$Info{'t149'} = {
  'test' => '  path_basename(\'/foo.bar.txt\');',
  'num' => 149,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 495,
  'result' => 'foo.bar'
}
;
$Info{'t150'} = {
  'test' => '  path_basename(\'/foo/bar.\');',
  'num' => 150,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 496,
  'result' => 'bar'
}
;
$Info{'t151'} = {
  'test' => '  path_basename(\'/foo/bar\');',
  'num' => 151,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 497,
  'result' => 'bar'
}
;
$Info{'t152'} = {
  'test' => '  path_basename(\'.bashrc\');',
  'num' => 152,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 498,
  'result' => '.bashrc'
}
;
$Info{'t153'} = {
  'test' => '  path_basename(\'.bashrc.tmp\');',
  'num' => 153,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 499,
  'result' => '.bashrc'
}
;
$Info{'t154'} = {
  'test' => '  path_basename(\'/no-dots\');',
  'num' => 154,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 500,
  'result' => 'no-dots'
}
;
$Info{'t155'} = {
  'test' => '  path_ext(undef);',
  'num' => 155,
  'comparator' => 'defined',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 1,
  'lineno' => 517,
  'result' => ''
}
;
$Info{'t156'} = {
  'test' => '  path_ext(\'foo.txt\');',
  'num' => 156,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 518,
  'result' => 'txt'
}
;
$Info{'t157'} = {
  'test' => '  path_ext(\'/foo.txt\');',
  'num' => 157,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 519,
  'result' => 'txt'
}
;
$Info{'t158'} = {
  'test' => '  path_ext(\'./foo.txt\');',
  'num' => 158,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 520,
  'result' => 'txt'
}
;
$Info{'t159'} = {
  'test' => '  path_ext(\'../foo.txt\');',
  'num' => 159,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 521,
  'result' => 'txt'
}
;
$Info{'t160'} = {
  'test' => '  path_ext(\'/foo/foo.txt\');',
  'num' => 160,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 522,
  'result' => 'txt'
}
;
$Info{'t161'} = {
  'test' => '  path_ext(\'/foo.bar.txt\');',
  'num' => 161,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 523,
  'result' => 'txt'
}
;
$Info{'t162'} = {
  'test' => '  path_ext(\'/foo/bar.\');',
  'num' => 162,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 524,
  'result' => ''
}
;
$Info{'t163'} = {
  'test' => '  path_ext(\'/foo/bar\');',
  'num' => 163,
  'comparator' => 'defined',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 1,
  'lineno' => 525,
  'result' => ''
}
;
$Info{'t164'} = {
  'test' => '  path_ext(\'.bashrc\');',
  'num' => 164,
  'comparator' => 'defined',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 1,
  'lineno' => 526,
  'result' => ''
}
;
$Info{'t165'} = {
  'test' => '  path_ext(\'.bashrc.tmp\');',
  'num' => 165,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 527,
  'result' => 'tmp'
}
;
$Info{'t166'} = {
  'test' => '  path_ext(\'/no-dots\');',
  'num' => 166,
  'comparator' => 'defined',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 1,
  'lineno' => 528,
  'result' => ''
}
;
$Info{'t167'} = {
  'test' => '  path_normalize(\'/\');',
  'num' => 167,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 544,
  'result' => '/'
}
;
$Info{'t168'} = {
  'test' => '  path_normalize(\'/a/\');',
  'num' => 168,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 545,
  'result' => '/a'
}
;
$Info{'t169'} = {
  'test' => '  path_normalize(\'/a/b/..\');',
  'num' => 169,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 546,
  'result' => '/a'
}
;
$Info{'t170'} = {
  'test' => '  path_normalize(\'/a/../a\');',
  'num' => 170,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 547,
  'result' => '/a'
}
;
$Info{'t171'} = {
  'test' => '  path_normalize(\'/a/../../a\');',
  'num' => 171,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 548,
  'result' => '/a'
}
;
$Info{'t172'} = {
  'test' => '  path_normalize( "../../w/b/../s/x" );',
  'num' => 172,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 549,
  'result' => '../../w/s/x'
}
;
$Info{'t173'} = {
  'test' => '  path_normalize( "u/n/w/" );',
  'num' => 173,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 550,
  'result' => 'u/n/w'
}
;
$Info{'t174'} = {
  'test' => '  path_normalize( "u/../w/b/../s" );',
  'num' => 174,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 551,
  'result' => 'w/s'
}
;
$Info{'t175'} = {
  'test' => '  path_normalize( "u//n" );',
  'num' => 175,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 552,
  'result' => 'u/n'
}
;
$Info{'t176'} = {
  'test' => '  path_normalize( "u//n/./f" );',
  'num' => 176,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 553,
  'result' => 'u/n/f'
}
;
$Info{'t177'} = {
  'test' => '  path_normalize( "http://t/u//n" );',
  'num' => 177,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 554,
  'result' => 'http://t/u/n'
}
;
$Info{'t178'} = {
  'test' => '  path_normalize( \'/a/b/c/../../../d/e/f\' );',
  'num' => 178,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 555,
  'result' => '/d/e/f'
}
;
$Info{'t179'} = {
  'test' => '  path_normalize( \'./a\' );',
  'num' => 179,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 556,
  'result' => './a'
}
;
$Info{'t180'} = {
  'test' => '  path_normalize( \'/./a\' );',
  'num' => 180,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 557,
  'result' => '/a'
}
;
$Info{'t181'} = {
  'test' => '  path_parent(\'\');',
  'num' => 181,
  'comparator' => 'defined',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 1,
  'lineno' => 595,
  'result' => ''
}
;
$Info{'t182'} = {
  'test' => '  path_parent(\'/\');',
  'num' => 182,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 596,
  'result' => '/'
}
;
$Info{'t183'} = {
  'test' => '  path_parent(\'/a\');',
  'num' => 183,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 597,
  'result' => '/'
}
;
$Info{'t184'} = {
  'test' => '  path_parent(\'/a/b/..\');',
  'num' => 184,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 598,
  'result' => '/'
}
;
$Info{'t185'} = {
  'test' => '  path_parent(\'a\');',
  'num' => 185,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 599,
  'result' => ''
}
;
$Info{'t186'} = {
  'test' => '  path_parent(\'a/b/\');',
  'num' => 186,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 600,
  'result' => 'a'
}
;
$Info{'t187'} = {
  'test' => '  path_parent(\'a/b.c\');',
  'num' => 187,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 601,
  'result' => 'a'
}
;
$Info{'t188'} = {
  'test' => '  path_parent(\'../../a\');',
  'num' => 188,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 602,
  'result' => '../..'
}
;
$Info{'t189'} = {
  'test' => '  path_name(\'\');',
  'num' => 189,
  'comparator' => 'defined',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 1,
  'lineno' => 614,
  'result' => ''
}
;
$Info{'t190'} = {
  'test' => '  path_name(\'/\');',
  'num' => 190,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 615,
  'result' => ''
}
;
$Info{'t191'} = {
  'test' => '  path_name(\'/a\');',
  'num' => 191,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 616,
  'result' => 'a'
}
;
$Info{'t192'} = {
  'test' => '  path_name(\'/a/b/..\');',
  'num' => 192,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 617,
  'result' => 'a'
}
;
$Info{'t193'} = {
  'test' => '  path_name(\'a/b/\');',
  'num' => 193,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 618,
  'result' => 'b'
}
;
$Info{'t194'} = {
  'test' => '  path_name(\'a/b.c\');',
  'num' => 194,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 619,
  'result' => 'b.c'
}
;
$Info{'t195'} = {
  'test' => '  path_is_absolute(\'/a\');',
  'num' => 195,
  'comparator' => 'true',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 631,
  'result' => ''
}
;
$Info{'t196'} = {
  'test' => '  path_is_absolute(\'A:/b\');',
  'num' => 196,
  'comparator' => 'true',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 632,
  'result' => ''
}
;
$Info{'t197'} = {
  'test' => '  path_is_absolute(\'/a/b\');',
  'num' => 197,
  'comparator' => 'true',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 633,
  'result' => ''
}
;
$Info{'t198'} = {
  'test' => '  path_is_absolute(\'http://a\');',
  'num' => 198,
  'comparator' => 'true',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 634,
  'result' => ''
}
;
$Info{'t199'} = {
  'test' => '  path_is_absolute(\'svn+ssh://a.b\');',
  'num' => 199,
  'comparator' => 'true',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 635,
  'result' => ''
}
;
$Info{'t200'} = {
  'test' => '  path_is_absolute(\'\');',
  'num' => 200,
  'comparator' => 'false',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 636,
  'result' => ''
}
;
$Info{'t201'} = {
  'test' => '  path_is_absolute(\'a/b\');',
  'num' => 201,
  'comparator' => 'false',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 637,
  'result' => ''
}
;
$Info{'t202'} = {
  'test' => '  path_is_absolute(\'a:\\\\b\');',
  'num' => 202,
  'comparator' => 'false',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 638,
  'result' => ''
}
;
$Info{'t203'} = {
  'test' => '  path_is_absolute(\'a/../b\');',
  'num' => 203,
  'comparator' => 'false',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 639,
  'result' => ''
}
;
$Info{'t204'} = {
  'test' => '  path_is_absolute(\'../a\');',
  'num' => 204,
  'comparator' => 'false',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 640,
  'result' => ''
}
;
$Info{'t205'} = {
  'test' => '  path_is_absolute(\'./a\');',
  'num' => 205,
  'comparator' => 'false',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 641,
  'result' => ''
}
;
$Info{'t206'} = {
  'test' => '  path_is_absolute(\'svn+ssh//a.b\');',
  'num' => 206,
  'comparator' => 'false',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 642,
  'result' => ''
}
;
$Info{'t207'} = {
  'test' => '  path_is_absolute(\'1://\');',
  'num' => 207,
  'comparator' => 'false',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 643,
  'result' => ''
}
;
$Info{'t208'} = {
  'test' => '  path_is_absolute(\'+://\');',
  'num' => 208,
  'comparator' => 'false',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 644,
  'result' => ''
}
;
$Info{'t209'} = {
  'test' => '  dir_is_system(\'.svn\', \'/tmp\');',
  'num' => 209,
  'comparator' => 'true',
  'package' => 'Data::Hub::Util',
  'summary' => 'normal usage',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 923,
  'result' => ''
}
;
$Info{'t210'} = {
  'test' => '  dir_is_system(\'.git\', \'/tmp\');',
  'num' => 210,
  'comparator' => 'true',
  'package' => 'Data::Hub::Util',
  'summary' => 'normal usage',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 924,
  'result' => ''
}
;
$Info{'t211'} = {
  'test' => '  dir_is_system(\'.Svn\', \'/tmp\');',
  'num' => 211,
  'comparator' => 'false',
  'package' => 'Data::Hub::Util',
  'summary' => 'case sensitive',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 0,
  'lineno' => 925,
  'result' => ''
}
;
$Info{'t212'} = {
  'test' => '  dir_is_system(undef, undef);',
  'num' => 212,
  'comparator' => 'defined',
  'package' => 'Data::Hub::Util',
  'summary' => 'undefined test',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm',
  'invert' => 1,
  'lineno' => 926,
  'result' => ''
}
;
$Info{'t213'} = {
  'test' => '  my %h = ();
  tie %h, \'Data::OrderedHash\';
  $h{\'first\'} = "Apple";
  $h{\'second\'} = "Cherry";
  $h{\'third\'} = "Banana";
  join \';\', values %h;',
  'num' => 213,
  'comparator' => 'match',
  'package' => 'Data::OrderedHash',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/OrderedHash.pm',
  'invert' => 0,
  'lineno' => 111,
  'result' => 'Apple;Cherry;Banana'
}
;
$Info{'t214'} = {
  'test' => '  my $h = Data::OrderedHash->new();
  %$h = qw(a A b B c C);
  $$h{\'a\'} = \'X\';
  join \'\', %$h;',
  'num' => 214,
  'comparator' => 'match',
  'package' => 'Data::OrderedHash',
  'summary' => 'Items retain their initial position',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/OrderedHash.pm',
  'invert' => 0,
  'lineno' => 120,
  'result' => 'aXbBcC'
}
;
$Info{'t215'} = {
  'test' => '  my $h = Data::OrderedHash->new();
  $h->{\'z\'} = "Apple";
  $h->{\'x\'} = "Banana";
  $h->{\'y\'} = "Cherry";
  my $r = \'\';
  while (my ($k, $v) = each %$h) { $r .= $k; delete $$h{$k} }
  $h->{\'w\'} = "Can\'t elope";
  $r .= join(\'\', keys %$h);
  $r;',
  'num' => 215,
  'comparator' => 'match',
  'package' => 'Data::OrderedHash',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/OrderedHash.pm',
  'invert' => 0,
  'lineno' => 127,
  'result' => 'zxyw'
}
;
$Info{'t216'} = {
  'test' => '  use Error::Logical;
  throw Error::DoesNotExist \'some resource\';',
  'num' => 216,
  'comparator' => 'abort',
  'package' => 'Error::Logical',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Error/Logical.pm',
  'invert' => 0,
  'lineno' => 9,
  'result' => ''
}
;
$Info{'t217'} = {
  'test' => '  use Error::Programatic;
  throw Error::NotStatic;',
  'num' => 217,
  'comparator' => 'abort',
  'package' => 'Error::Programatic',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Error/Programatic.pm',
  'invert' => 0,
  'lineno' => 12,
  'result' => ''
}
;
$Info{'t218'} = {
  'test' => '  use Misc::LogUtil;
  Misc::LogUtil->new();',
  'num' => 218,
  'comparator' => 'abort',
  'package' => 'Misc::LogUtil',
  'summary' => 'Create a new instance',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Misc/LogUtil.pm',
  'invert' => 1,
  'lineno' => 15,
  'result' => ''
}
;
$Info{'t219'} = {
  'test' => '  use Misc::Stopwatch;',
  'num' => 219,
  'comparator' => 'abort',
  'package' => 'Misc::Stopwatch',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Misc/Stopwatch.pm',
  'invert' => 1,
  'lineno' => 10,
  'result' => ''
}
;
$Info{'t220'} = {
  'test' => '  my $sw = Misc::Stopwatch->new();',
  'num' => 220,
  'comparator' => 'true',
  'package' => 'Misc::Stopwatch',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Misc/Stopwatch.pm',
  'invert' => 0,
  'lineno' => 11,
  'result' => ''
}
;
$Info{'t221'} = {
  'test' => '  my $sw = Misc::Stopwatch->new()->start();',
  'num' => 221,
  'comparator' => 'abort',
  'package' => 'Misc::Stopwatch',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Misc/Stopwatch.pm',
  'invert' => 1,
  'lineno' => 25,
  'result' => ''
}
;
$Info{'t222'} = {
  'test' => '  my $sw = Misc::Stopwatch->new()->start()->lap();',
  'num' => 222,
  'comparator' => 'abort',
  'package' => 'Misc::Stopwatch',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Misc/Stopwatch.pm',
  'invert' => 1,
  'lineno' => 41,
  'result' => ''
}
;
$Info{'t223'} = {
  'test' => '  my $sw = Misc::Stopwatch->new()->start()->stop();',
  'num' => 223,
  'comparator' => 'abort',
  'package' => 'Misc::Stopwatch',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Misc/Stopwatch.pm',
  'invert' => 1,
  'lineno' => 54,
  'result' => ''
}
;
$Info{'t224'} = {
  'test' => '  Misc::Stopwatch->new()->start()->elapsed();',
  'num' => 224,
  'comparator' => 'true',
  'package' => 'Misc::Stopwatch',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Misc/Stopwatch.pm',
  'invert' => 0,
  'lineno' => 76,
  'result' => ''
}
;
$Info{'t225'} = {
  'test' => '  my $sw = Misc::Stopwatch->new()->reset();',
  'num' => 225,
  'comparator' => 'abort',
  'package' => 'Misc::Stopwatch',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Misc/Stopwatch.pm',
  'invert' => 1,
  'lineno' => 97,
  'result' => ''
}
;
$Info{'t226'} = {
  'test' => '  Misc::Stopwatch->new()->is_running();',
  'num' => 226,
  'comparator' => 'false',
  'package' => 'Misc::Stopwatch',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Misc/Stopwatch.pm',
  'invert' => 0,
  'lineno' => 111,
  'result' => ''
}
;
$Info{'t227'} = {
  'test' => '  Misc::Stopwatch->new()->start()->is_running();',
  'num' => 227,
  'comparator' => 'true',
  'package' => 'Misc::Stopwatch',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Misc/Stopwatch.pm',
  'invert' => 0,
  'lineno' => 112,
  'result' => ''
}
;
$Info{'t228'} = {
  'test' => '  use Misc::Time qw(:all);',
  'num' => 228,
  'comparator' => 'abort',
  'package' => 'Misc::Time',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Misc/Time.pm',
  'invert' => 1,
  'lineno' => 88,
  'result' => ''
}
;
$Info{'t229'} = {
  'test' => '  time_apr_to_hires(\'1193094188212812\');',
  'num' => 229,
  'comparator' => 'match',
  'package' => 'Misc::Time',
  'summary' => 'Simple time string conversion',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Misc/Time.pm',
  'invert' => 0,
  'lineno' => 89,
  'result' => '1193094188.212812'
}
;
$Info{'t230'} = {
  'test' => '  use Parse::Padding qw(padding);',
  'num' => 230,
  'comparator' => 'abort',
  'package' => 'Parse::Padding',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Parse/Padding.pm',
  'invert' => 1,
  'lineno' => 31,
  'result' => ''
}
;
$Info{'t231'} = {
  'test' => '  my $str = "    a   ";
  join \';\', padding(\\$str, 4, 5);',
  'num' => 231,
  'comparator' => 'match',
  'package' => 'Parse::Padding',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Parse/Padding.pm',
  'invert' => 0,
  'lineno' => 33,
  'result' => '4;3'
}
;
$Info{'t232'} = {
  'test' => '  my $str = " \\na\\r\\n ";
  join \';\', padding(\\$str, 2, 3);',
  'num' => 232,
  'comparator' => 'match',
  'package' => 'Parse::Padding',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Parse/Padding.pm',
  'invert' => 0,
  'lineno' => 37,
  'result' => '2;3'
}
;
$Info{'t233'} = {
  'test' => '  my $str = " \\na\\r\\n ";
  join \';\', padding(\\$str, 2, 3, -crlf);',
  'num' => 233,
  'comparator' => 'match',
  'package' => 'Parse::Padding',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Parse/Padding.pm',
  'invert' => 0,
  'lineno' => 41,
  'result' => '1;2'
}
;
$Info{'t234'} = {
  'test' => '  my $str = " \\n\\na\\r\\n\\r\\n ";
  join \';\', padding(\\$str, 3, 4, -crlf);',
  'num' => 234,
  'comparator' => 'match',
  'package' => 'Parse::Padding',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Parse/Padding.pm',
  'invert' => 0,
  'lineno' => 45,
  'result' => '1;2'
}
;
$Info{'t235'} = {
  'test' => '  my $str = " a ";
  join \';\', padding(\\$str, 1, 2, -crlf);',
  'num' => 235,
  'comparator' => 'match',
  'package' => 'Parse::Padding',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Parse/Padding.pm',
  'invert' => 0,
  'lineno' => 49,
  'result' => '0;0'
}
;
$Info{'t236'} = {
  'test' => '  use Parse::Padding qw(trailing);',
  'num' => 236,
  'comparator' => 'abort',
  'package' => 'Parse::Padding',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Parse/Padding.pm',
  'invert' => 1,
  'lineno' => 92,
  'result' => ''
}
;
$Info{'t237'} = {
  'test' => '  trailing(\'\\r\\n\', " xxx\\r\\n", \'abc\');',
  'num' => 237,
  'comparator' => 'abort',
  'package' => 'Parse::Padding',
  'summary' => 'invalid index',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Parse/Padding.pm',
  'invert' => 0,
  'lineno' => 93,
  'result' => ''
}
;
$Info{'t238'} = {
  'test' => '  trailing(\'\', " xxx\\r\\n", 4);',
  'num' => 238,
  'comparator' => 'abort',
  'package' => 'Parse::Padding',
  'summary' => 'invalid chars',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Parse/Padding.pm',
  'invert' => 0,
  'lineno' => 94,
  'result' => ''
}
;
$Info{'t239'} = {
  'test' => '  trailing(\'\\s\', " xxx \\r\\n", 4);',
  'num' => 239,
  'comparator' => 'match',
  'package' => 'Parse::Padding',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Parse/Padding.pm',
  'invert' => 0,
  'lineno' => 95,
  'result' => '3'
}
;
$Info{'t240'} = {
  'test' => '  trailing(\'\\r\\n\', " xxx \\r\\n", 4);',
  'num' => 240,
  'comparator' => 'match',
  'package' => 'Parse::Padding',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Parse/Padding.pm',
  'invert' => 0,
  'lineno' => 96,
  'result' => '0'
}
;
$Info{'t241'} = {
  'test' => '  trailing(\'\\r\\n\', " xxx\\r\\n", 4);',
  'num' => 241,
  'comparator' => 'match',
  'package' => 'Parse::Padding',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Parse/Padding.pm',
  'invert' => 0,
  'lineno' => 97,
  'result' => '2'
}
;
$Info{'t242'} = {
  'test' => '  trailing(\'\\r\\n\', " xxx\\r\\n", 999);',
  'num' => 242,
  'comparator' => 'match',
  'package' => 'Parse::Padding',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Parse/Padding.pm',
  'invert' => 0,
  'lineno' => 98,
  'result' => '0'
}
;
$Info{'t243'} = {
  'test' => '  trailing(\'\\r\\n\', " xxx\\r\\n", -999);',
  'num' => 243,
  'comparator' => 'match',
  'package' => 'Parse::Padding',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Parse/Padding.pm',
  'invert' => 0,
  'lineno' => 99,
  'result' => '0'
}
;
$Info{'t244'} = {
  'test' => '  trailing(\'\\r\\n\', "\\r\\n\\r\\n", 0, 1);',
  'num' => 244,
  'comparator' => 'match',
  'package' => 'Parse::Padding',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Parse/Padding.pm',
  'invert' => 0,
  'lineno' => 100,
  'result' => '2'
}
;
$Info{'t245'} = {
  'test' => '  trailing(\'\\r\\n\', "\\n\\n\\n", 0, 1);',
  'num' => 245,
  'comparator' => 'match',
  'package' => 'Parse::Padding',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Parse/Padding.pm',
  'invert' => 0,
  'lineno' => 101,
  'result' => '1'
}
;
$Info{'t246'} = {
  'test' => '  trailing(\'abcd\', "a\\na", 2, 1);',
  'num' => 246,
  'comparator' => 'match',
  'package' => 'Parse::Padding',
  'summary' => 'end-of-string == $eol',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Parse/Padding.pm',
  'invert' => 0,
  'lineno' => 102,
  'result' => '1'
}
;
$Info{'t247'} = {
  'test' => '  use Parse::Padding qw(leading);',
  'num' => 247,
  'comparator' => 'abort',
  'package' => 'Parse::Padding',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Parse/Padding.pm',
  'invert' => 1,
  'lineno' => 142,
  'result' => ''
}
;
$Info{'t248'} = {
  'test' => '  leading(\'\\s\', " xxx", 1);',
  'num' => 248,
  'comparator' => 'match',
  'package' => 'Parse::Padding',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Parse/Padding.pm',
  'invert' => 0,
  'lineno' => 143,
  'result' => '1'
}
;
$Info{'t249'} = {
  'test' => '  leading(\'\\s\', "\\r \\nxxx", 3);',
  'num' => 249,
  'comparator' => 'match',
  'package' => 'Parse::Padding',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Parse/Padding.pm',
  'invert' => 0,
  'lineno' => 144,
  'result' => '3'
}
;
$Info{'t250'} = {
  'test' => '  leading(\'\\r\\n\', " xxx", 1);',
  'num' => 250,
  'comparator' => 'match',
  'package' => 'Parse::Padding',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Parse/Padding.pm',
  'invert' => 0,
  'lineno' => 145,
  'result' => '0'
}
;
$Info{'t251'} = {
  'test' => '  leading(\'\\r\\n\', "\\r\\n\\rxxx", 3);',
  'num' => 251,
  'comparator' => 'match',
  'package' => 'Parse::Padding',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Parse/Padding.pm',
  'invert' => 0,
  'lineno' => 146,
  'result' => '3'
}
;
$Info{'t252'} = {
  'test' => '  leading(\'\\r\\n\', "\\r\\n\\rxxx", -999);',
  'num' => 252,
  'comparator' => 'match',
  'package' => 'Parse::Padding',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Parse/Padding.pm',
  'invert' => 0,
  'lineno' => 147,
  'result' => '0'
}
;
$Info{'t253'} = {
  'test' => '  leading(\'\\r\\n\', "\\r\\n\\rxxx", 999);',
  'num' => 253,
  'comparator' => 'match',
  'package' => 'Parse::Padding',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Parse/Padding.pm',
  'invert' => 0,
  'lineno' => 148,
  'result' => '0'
}
;
$Info{'t254'} = {
  'test' => '  leading(\'\', "\\r\\n\\rxxx", 3);',
  'num' => 254,
  'comparator' => 'abort',
  'package' => 'Parse::Padding',
  'summary' => 'invalid chars',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Parse/Padding.pm',
  'invert' => 0,
  'lineno' => 149,
  'result' => ''
}
;
$Info{'t255'} = {
  'test' => '  leading(\'\\r\\n\', "\\r\\n\\rxxx", \'abc\');',
  'num' => 255,
  'comparator' => 'abort',
  'package' => 'Parse::Padding',
  'summary' => 'invalid index',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Parse/Padding.pm',
  'invert' => 0,
  'lineno' => 150,
  'result' => ''
}
;
$Info{'t256'} = {
  'test' => '  leading(\'abcd\', "axe", 1, 1);',
  'num' => 256,
  'comparator' => 'match',
  'package' => 'Parse::Padding',
  'summary' => 'begin-of-string == $bol',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Parse/Padding.pm',
  'invert' => 0,
  'lineno' => 151,
  'result' => '1'
}
;
$Info{'t257'} = {
  'test' => '  leading(\'abcd\', "\\naxe", 2, 1);',
  'num' => 257,
  'comparator' => 'match',
  'package' => 'Parse::Padding',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Parse/Padding.pm',
  'invert' => 0,
  'lineno' => 152,
  'result' => '1'
}
;
$Info{'t258'} = {
  'test' => '  use Parse::StringToken qw(:all);',
  'num' => 258,
  'comparator' => 'abort',
  'package' => 'Parse::StringToken',
  'summary' => 'Include symbols',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Parse/StringToken.pm',
  'invert' => 1,
  'lineno' => 21,
  'result' => ''
}
;
$Info{'t259'} = {
  'test' => '  str_token(\'\', -contained => \'123\');',
  'num' => 259,
  'comparator' => 'abort',
  'package' => 'Parse::StringToken',
  'summary' => 'Needs to have matching pairs',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Parse/StringToken.pm',
  'invert' => 0,
  'lineno' => 44,
  'result' => ''
}
;
$Info{'t260'} = {
  'test' => '  str_token("a b c")->shift;',
  'num' => 260,
  'comparator' => 'match',
  'package' => 'Parse::StringToken',
  'summary' => 'Basic',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Parse/StringToken.pm',
  'invert' => 0,
  'lineno' => 58,
  'result' => 'a'
}
;
$Info{'t261'} = {
  'test' => '  my $s = str_token(q(one \'and a two\' "and a three"));
  $s->shift; $s->shift;',
  'num' => 261,
  'comparator' => 'match',
  'package' => 'Parse::StringToken',
  'summary' => 'Contains spaces',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Parse/StringToken.pm',
  'invert' => 0,
  'lineno' => 59,
  'result' => 'and a two'
}
;
$Info{'t262'} = {
  'test' => '  str_token("a b c")->pop;',
  'num' => 262,
  'comparator' => 'match',
  'package' => 'Parse::StringToken',
  'summary' => 'Basic',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Parse/StringToken.pm',
  'invert' => 0,
  'lineno' => 82,
  'result' => 'c'
}
;
$Info{'t263'} = {
  'test' => '  my $s = str_token(q(one \'and a two\' "and a three"));
  $s->pop;
  $s->pop;',
  'num' => 263,
  'comparator' => 'match',
  'package' => 'Parse::StringToken',
  'summary' => 'Contains spaces',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Parse/StringToken.pm',
  'invert' => 0,
  'lineno' => 83,
  'result' => 'and a two'
}
;
$Info{'t264'} = {
  'test' => '  join(\'-\', str_token("a b c")->split);',
  'num' => 264,
  'comparator' => 'match',
  'package' => 'Parse::StringToken',
  'summary' => 'Basic',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Parse/StringToken.pm',
  'invert' => 0,
  'lineno' => 100,
  'result' => 'a-b-c'
}
;
$Info{'t265'} = {
  'test' => '  use Parse::Template::Base;
  my $p = new Parse::Template::Base;
  my $text = \'<<>>\';
  my @pos = $p->substr_pos(\\$text, \'<\', \'>\', 0);
  join \',\', map {join \'-\', @$_} @pos;',
  'num' => 265,
  'comparator' => 'match',
  'package' => 'Parse::Template::Base',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Parse/Template/Base.pm',
  'invert' => 0,
  'lineno' => 962,
  'result' => '0-3,1-2'
}
;
$Info{'t266'} = {
  'test' => '  use Parse::Template::Standard;
  my $t = \'Hello [#name]\';
  my $p = new Parse::Template::Standard();
  my $o = $p->compile_text(\\$t, {name => \'World\'});
  return $$o;',
  'num' => 266,
  'comparator' => 'match',
  'package' => 'Parse::Template::Base',
  'summary' => 'Simple replacement',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Parse/Template/Base.pm',
  'invert' => 0,
  'lineno' => 1063,
  'result' => 'Hello World'
}
;
$Info{'t267'} = {
  'test' => '  use Parse::Template::Standard;
  my $t = \'Hello [#name]\';
  my $p = new Parse::Template::Standard();
  my $o = $p->compile_text(\\$t, {name => \'[#next]\', next => \'World\'});
  return $$o;',
  'num' => 267,
  'comparator' => 'match',
  'package' => 'Parse::Template::Base',
  'summary' => 'Variable expansion',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Parse/Template/Base.pm',
  'invert' => 0,
  'lineno' => 1071,
  'result' => 'Hello World'
}
;
$Info{'t268'} = {
  'test' => '  use Parse::Template::Standard;
  my $t = \'Hello [#data/name]\';
  my $p = new Parse::Template::Standard();
  my $o = $p->compile_text(\\$t, {data => {name => \'World\'}});
  return $$o;',
  'num' => 268,
  'comparator' => 'match',
  'package' => 'Parse::Template::Base',
  'summary' => 'Nested elements',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Parse/Template/Base.pm',
  'invert' => 0,
  'lineno' => 1079,
  'result' => 'Hello World'
}
;
$Info{'t269'} = {
  'test' => '  use Parse::Template::Standard;
  my $t = \'Hello [#[#name]]\';
  my $p = new Parse::Template::Standard();
  my $o = $p->compile_text(\\$t, {name => \'next\', next => \'World\'});
  return $$o;',
  'num' => 269,
  'comparator' => 'match',
  'package' => 'Parse::Template::Base',
  'summary' => 'Dynamic expansion',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Parse/Template/Base.pm',
  'invert' => 0,
  'lineno' => 1087,
  'result' => 'Hello World'
}
;
$Info{'t270'} = {
  'test' => '  use Parse::Template::Web;',
  'num' => 270,
  'comparator' => 'abort',
  'package' => 'Parse::Template::Web',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Parse/Template/Web.pm',
  'invert' => 1,
  'lineno' => 64,
  'result' => ''
}
;
$Info{'t271'} = {
  'test' => '  use Data::Hub;',
  'num' => 271,
  'comparator' => 'abort',
  'package' => 'Parse::Template::Web',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Parse/Template/Web.pm',
  'invert' => 1,
  'lineno' => 65,
  'result' => ''
}
;
$Info{'t272'} = {
  'test' => '  my $p = Parse::Template::Web->new(Data::Hub->new());
  $p->defang(\'a[#b]c\');',
  'num' => 272,
  'comparator' => 'match',
  'package' => 'Parse::Template::Web',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Parse/Template/Web.pm',
  'invert' => 0,
  'lineno' => 66,
  'result' => 'abc'
}
;
$Info{'t273'} = {
  'test' => '  my $p = Parse::Template::Web->new(Data::Hub->new());
  my $r = $p->defang([\'a[#b]c\', \'a<b>c</d>e\']);
  join(\'\', @$r);',
  'num' => 273,
  'comparator' => 'match',
  'package' => 'Parse::Template::Web',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Parse/Template/Web.pm',
  'invert' => 0,
  'lineno' => 69,
  'result' => 'abcabc/de'
}
;
$Info{'t274'} = {
  'test' => '  package Foo;
  use Perl::Class;
  use base qw(Perl::Class::Hash);
  sub new {
    $_[0]->SUPER::new(1 => 2, \'odd\');
  }
  1;
  package main;
  my $c = Foo->new();
  $c->{3} = 4;
  join \':\', (keys %$c, \'|\', sort keys %{$c->__});',
  'num' => 274,
  'comparator' => 'match',
  'package' => 'Perl::Class::Scalar',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Class.pm',
  'invert' => 0,
  'lineno' => 69,
  'result' => '3:|:1:odd'
}
;
$Info{'t275'} = {
  'test' => '  compare(\'eq\',\'\',undef);',
  'num' => 275,
  'comparator' => 'false',
  'package' => 'Perl::Comparison',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Comparison.pm',
  'invert' => 0,
  'lineno' => 125,
  'result' => ''
}
;
$Info{'t276'} = {
  'test' => '  compare(\'eq\',\'abc\',\'abc\');',
  'num' => 276,
  'comparator' => 'true',
  'package' => 'Perl::Comparison',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Comparison.pm',
  'invert' => 0,
  'lineno' => 126,
  'result' => ''
}
;
$Info{'t277'} = {
  'test' => '  compare(\'ne\',\'abc\',\'Abc\');',
  'num' => 277,
  'comparator' => 'true',
  'package' => 'Perl::Comparison',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Comparison.pm',
  'invert' => 0,
  'lineno' => 127,
  'result' => ''
}
;
$Info{'t278'} = {
  'test' => '  compare(\'eq\',\'abc\',undef);',
  'num' => 278,
  'comparator' => 'false',
  'package' => 'Perl::Comparison',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Comparison.pm',
  'invert' => 0,
  'lineno' => 128,
  'result' => ''
}
;
$Info{'t279'} = {
  'test' => '  compare(\'!~\',\'abc\',\'A\');',
  'num' => 279,
  'comparator' => 'true',
  'package' => 'Perl::Comparison',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Comparison.pm',
  'invert' => 0,
  'lineno' => 129,
  'result' => ''
}
;
$Info{'t280'} = {
  'test' => '  compare(\'=~\',\'abc\',\'a\');',
  'num' => 280,
  'comparator' => 'true',
  'package' => 'Perl::Comparison',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Comparison.pm',
  'invert' => 0,
  'lineno' => 130,
  'result' => ''
}
;
$Info{'t281'} = {
  'test' => '  compare(\'==\',1234,1234);',
  'num' => 281,
  'comparator' => 'true',
  'package' => 'Perl::Comparison',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Comparison.pm',
  'invert' => 0,
  'lineno' => 131,
  'result' => ''
}
;
$Info{'t282'} = {
  'test' => '  compare(\'>=\',1234,1234);',
  'num' => 282,
  'comparator' => 'true',
  'package' => 'Perl::Comparison',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Comparison.pm',
  'invert' => 0,
  'lineno' => 132,
  'result' => ''
}
;
$Info{'t283'} = {
  'test' => '  compare(\'eqic\',\'abc\',\'Abc\');',
  'num' => 283,
  'comparator' => 'true',
  'package' => 'Perl::Comparison',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Comparison.pm',
  'invert' => 0,
  'lineno' => 133,
  'result' => ''
}
;
$Info{'t284'} = {
  'test' => '  compare(\'==\',undef,undef);',
  'num' => 284,
  'comparator' => 'true',
  'package' => 'Perl::Comparison',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Comparison.pm',
  'invert' => 0,
  'lineno' => 134,
  'result' => ''
}
;
$Info{'t285'} = {
  'test' => '  compare(\'==\',0,undef);',
  'num' => 285,
  'comparator' => 'false',
  'package' => 'Perl::Comparison',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Comparison.pm',
  'invert' => 0,
  'lineno' => 135,
  'result' => ''
}
;
$Info{'t286'} = {
  'test' => '  compare(\'!~i\',\'abc\',\'A\');',
  'num' => 286,
  'comparator' => 'false',
  'package' => 'Perl::Comparison',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Comparison.pm',
  'invert' => 0,
  'lineno' => 136,
  'result' => ''
}
;
$Info{'t287'} = {
  'test' => '  compare(\'=~i\',\'abc\',\'A\');',
  'num' => 287,
  'comparator' => 'true',
  'package' => 'Perl::Comparison',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Comparison.pm',
  'invert' => 0,
  'lineno' => 137,
  'result' => ''
}
;
$Info{'t288'} = {
  'test' => '  compare(\'eqic\',\'abc\',\'Abc\');',
  'num' => 288,
  'comparator' => 'true',
  'package' => 'Perl::Comparison',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Comparison.pm',
  'invert' => 0,
  'lineno' => 138,
  'result' => ''
}
;
$Info{'t289'} = {
  'test' => '  compare(\'neic\',\'abc\',\'Abc\');',
  'num' => 289,
  'comparator' => 'false',
  'package' => 'Perl::Comparison',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Comparison.pm',
  'invert' => 0,
  'lineno' => 139,
  'result' => ''
}
;
$Info{'t290'} = {
  'test' => '  compare(\'mod\',4,2);',
  'num' => 290,
  'comparator' => 'true',
  'package' => 'Perl::Comparison',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Comparison.pm',
  'invert' => 0,
  'lineno' => 140,
  'result' => ''
}
;
$Info{'t291'} = {
  'test' => '  compare(\'bw\',\'abc\',\'a\');',
  'num' => 291,
  'comparator' => 'true',
  'package' => 'Perl::Comparison',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Comparison.pm',
  'invert' => 0,
  'lineno' => 141,
  'result' => ''
}
;
$Info{'t292'} = {
  'test' => '  compare(\'bw\',\'abc\',\'b\');',
  'num' => 292,
  'comparator' => 'false',
  'package' => 'Perl::Comparison',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Comparison.pm',
  'invert' => 0,
  'lineno' => 142,
  'result' => ''
}
;
$Info{'t293'} = {
  'test' => '  compare(\'ew\',\'abc\',\'b\');',
  'num' => 293,
  'comparator' => 'false',
  'package' => 'Perl::Comparison',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Comparison.pm',
  'invert' => 0,
  'lineno' => 143,
  'result' => ''
}
;
$Info{'t294'} = {
  'test' => '  compare(\'ew\',\'abc\',\'c\');',
  'num' => 294,
  'comparator' => 'true',
  'package' => 'Perl::Comparison',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Comparison.pm',
  'invert' => 0,
  'lineno' => 144,
  'result' => ''
}
;
$Info{'t295'} = {
  'test' => '  my @numbers = ( 20, 1, 10, 2 );
  join \';\', sort { &sort_compare(\'<=>\',$a,$b) } @numbers;',
  'num' => 295,
  'comparator' => 'match',
  'package' => 'Perl::Comparison',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Comparison.pm',
  'invert' => 0,
  'lineno' => 158,
  'result' => '1;2;10;20'
}
;
$Info{'t296'} = {
  'test' => '  use Perl::Comparison qw(sort_keydepth);',
  'num' => 296,
  'comparator' => 'abort',
  'package' => 'Perl::Comparison',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Comparison.pm',
  'invert' => 1,
  'lineno' => 180,
  'result' => ''
}
;
$Info{'t297'} = {
  'test' => '  join \';\', sort {&sort_keydepth($a, $b)} qw(t/w/o o/ne th/r/e/e);',
  'num' => 297,
  'comparator' => 'match',
  'package' => 'Perl::Comparison',
  'summary' => 'The deepest elements come last',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Comparison.pm',
  'invert' => 0,
  'lineno' => 182,
  'result' => 'o/ne;t/w/o;th/r/e/e'
}
;
$Info{'t298'} = {
  'test' => '  no warnings \'uninitialized\';
  join \';\', sort {&sort_keydepth($a, $b)} (qw(t/w/o o/ne none th/r/e/e), undef);',
  'num' => 298,
  'comparator' => 'match',
  'package' => 'Perl::Comparison',
  'summary' => 'Those without come after undefined but before those with',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Comparison.pm',
  'invert' => 0,
  'lineno' => 186,
  'result' => ';none;o/ne;t/w/o;th/r/e/e'
}
;
$Info{'t299'} = {
  'test' => '  use Perl::Module;',
  'num' => 299,
  'comparator' => 'abort',
  'package' => 'Perl::Module',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Module.pm',
  'invert' => 1,
  'lineno' => 16,
  'result' => ''
}
;
$Info{'t300'} = {
  'test' => '  join "\\n", sort @Perl::Module::EXPORT;',
  'num' => 300,
  'comparator' => 'match',
  'package' => 'Perl::Module',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Module.pm',
  'invert' => 0,
  'lineno' => 17,
  'result' => 'Dumper
blessed
bytesize
can
carp
checksum
clone
cluck
compare
confess
croak
gettimeofday
grep_first
grep_first_index
index_imatch
index_match
index_unescaped
int_div
is_numeric
isa
max
min
my_opts
overlay
push_uniq
reftype
sleep
sort_compare
sort_keydepth
stat
str_ref
strftime
strptime
time
tv_interval
unshift_uniq
warnf'
}
;
$Info{'t301'} = {
  'test' => '  my $sub = sub {
    my ($opts, @argv) = my_opts(\\@_);
    my $ret = join(\',\', sort(@_));
    $ret .= \';\' . join(\',\', sort keys %$opts);
    return $ret;
  };
  &$sub(\'a\', \'b\', \'-opt1\', -opt2 => \'See\', \'-opt3=0\');',
  'num' => 301,
  'comparator' => 'match',
  'package' => 'Perl::Options',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Options.pm',
  'invert' => 0,
  'lineno' => 29,
  'result' => 'a,b;opt1,opt2,opt3'
}
;
$Info{'t302'} = {
  'test' => '  use Perl::Util qw(:all);',
  'num' => 302,
  'comparator' => 'abort',
  'package' => 'Perl::Util',
  'summary' => 'Load this module',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Util.pm',
  'invert' => 1,
  'lineno' => 58,
  'result' => ''
}
;
$Info{'t303'} = {
  'test' => '  my $a = str_ref("a"); $$a;',
  'num' => 303,
  'comparator' => 'match',
  'package' => 'Perl::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Util.pm',
  'invert' => 0,
  'lineno' => 92,
  'result' => 'a'
}
;
$Info{'t304'} = {
  'test' => '  is_numeric(\'-1\');',
  'num' => 304,
  'comparator' => 'true',
  'package' => 'Perl::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Util.pm',
  'invert' => 0,
  'lineno' => 128,
  'result' => ''
}
;
$Info{'t305'} = {
  'test' => '  is_numeric(\'0\');',
  'num' => 305,
  'comparator' => 'true',
  'package' => 'Perl::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Util.pm',
  'invert' => 0,
  'lineno' => 129,
  'result' => ''
}
;
$Info{'t306'} = {
  'test' => '  is_numeric(\'+1\');',
  'num' => 306,
  'comparator' => 'true',
  'package' => 'Perl::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Util.pm',
  'invert' => 0,
  'lineno' => 130,
  'result' => ''
}
;
$Info{'t307'} = {
  'test' => '  is_numeric(\'3.14\');',
  'num' => 307,
  'comparator' => 'true',
  'package' => 'Perl::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Util.pm',
  'invert' => 0,
  'lineno' => 131,
  'result' => ''
}
;
$Info{'t308'} = {
  'test' => '  is_numeric(\'6.02214E23\');',
  'num' => 308,
  'comparator' => 'true',
  'package' => 'Perl::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Util.pm',
  'invert' => 0,
  'lineno' => 132,
  'result' => ''
}
;
$Info{'t309'} = {
  'test' => '  is_numeric(\'6.626068e-34\');',
  'num' => 309,
  'comparator' => 'true',
  'package' => 'Perl::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Util.pm',
  'invert' => 0,
  'lineno' => 133,
  'result' => ''
}
;
$Info{'t310'} = {
  'test' => '  is_numeric(\'3.1.4\');',
  'num' => 310,
  'comparator' => 'false',
  'package' => 'Perl::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Util.pm',
  'invert' => 0,
  'lineno' => 134,
  'result' => ''
}
;
$Info{'t311'} = {
  'test' => '  is_numeric(\'\');',
  'num' => 311,
  'comparator' => 'false',
  'package' => 'Perl::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Util.pm',
  'invert' => 0,
  'lineno' => 135,
  'result' => ''
}
;
$Info{'t312'} = {
  'test' => '  is_numeric(\'three\');',
  'num' => 312,
  'comparator' => 'false',
  'package' => 'Perl::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Util.pm',
  'invert' => 0,
  'lineno' => 136,
  'result' => ''
}
;
$Info{'t313'} = {
  'test' => '  is_numeric(undef);',
  'num' => 313,
  'comparator' => 'false',
  'package' => 'Perl::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Util.pm',
  'invert' => 0,
  'lineno' => 137,
  'result' => ''
}
;
$Info{'t314'} = {
  'test' => '  join(\'r\',int_div(3,2));',
  'num' => 314,
  'comparator' => 'match',
  'package' => 'Perl::Util',
  'summary' => '3 divided by 2',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Util.pm',
  'invert' => 0,
  'lineno' => 151,
  'result' => '1r1'
}
;
$Info{'t315'} = {
  'test' => '  join(\'r\',int_div(3.9,2));',
  'num' => 315,
  'comparator' => 'match',
  'package' => 'Perl::Util',
  'summary' => '3.9 divided by 2 (does not round)',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Util.pm',
  'invert' => 0,
  'lineno' => 152,
  'result' => '1r1'
}
;
$Info{'t316'} = {
  'test' => '  int_div(3,0);',
  'num' => 316,
  'comparator' => 'abort',
  'package' => 'Perl::Util',
  'summary' => 'divide by zero',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Util.pm',
  'invert' => 0,
  'lineno' => 153,
  'result' => ''
}
;
$Info{'t317'} = {
  'test' => '  int_div(\'three\',1);',
  'num' => 317,
  'comparator' => 'abort',
  'package' => 'Perl::Util',
  'summary' => 'not numeric',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Util.pm',
  'invert' => 0,
  'lineno' => 154,
  'result' => ''
}
;
$Info{'t318'} = {
  'test' => '  grep_first {/a/} qw(apple banana cherry);',
  'num' => 318,
  'comparator' => 'match',
  'package' => 'Perl::Util',
  'summary' => 'first item with an \\\'a\\\' in it',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Util.pm',
  'invert' => 0,
  'lineno' => 167,
  'result' => 'apple'
}
;
$Info{'t319'} = {
  'test' => '  grep_first_index {/a/} qw(apple banana cherry);',
  'num' => 319,
  'comparator' => 'match',
  'package' => 'Perl::Util',
  'summary' => 'index of first item with an \\\'a\\\' in it',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Util.pm',
  'invert' => 0,
  'lineno' => 185,
  'result' => '0'
}
;
$Info{'t320'} = {
  'test' => '  index_match("abracadabra", "[cd]")',
  'num' => 320,
  'comparator' => 'match',
  'package' => 'Perl::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Util.pm',
  'invert' => 0,
  'lineno' => 252,
  'result' => '4'
}
;
$Info{'t321'} = {
  'test' => '  index_match("abracadabra", "a", 3)',
  'num' => 321,
  'comparator' => 'match',
  'package' => 'Perl::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Util.pm',
  'invert' => 0,
  'lineno' => 253,
  'result' => '3'
}
;
$Info{'t322'} = {
  'test' => '  index_match("abracadabra", "d{2,2}")',
  'num' => 322,
  'comparator' => 'match',
  'package' => 'Perl::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Util.pm',
  'invert' => 0,
  'lineno' => 254,
  'result' => '-1'
}
;
$Info{'t323'} = {
  'test' => '  my ($p, $str) = index_match("scant", "can");
  $p + length($str);',
  'num' => 323,
  'comparator' => 'match',
  'package' => 'Perl::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Util.pm',
  'invert' => 0,
  'lineno' => 255,
  'result' => '4'
}
;
$Info{'t324'} = {
  'test' => '  index_match("foobar foo bar", \'\\bfoo\\b\') # zero-width test',
  'num' => 324,
  'comparator' => 'match',
  'package' => 'Perl::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Util.pm',
  'invert' => 0,
  'lineno' => 257,
  'result' => '7'
}
;
$Info{'t325'} = {
  'test' => '  index_match("foobar foo bar", \'Bar\') # no-match',
  'num' => 325,
  'comparator' => 'match',
  'package' => 'Perl::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Util.pm',
  'invert' => 0,
  'lineno' => 258,
  'result' => '-1'
}
;
$Info{'t326'} = {
  'test' => '  index_match("aa", "a")',
  'num' => 326,
  'comparator' => 'match',
  'package' => 'Perl::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Util.pm',
  'invert' => 0,
  'lineno' => 259,
  'result' => '0'
}
;
$Info{'t327'} = {
  'test' => '  index_match("aa", "a", 1)',
  'num' => 327,
  'comparator' => 'match',
  'package' => 'Perl::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Util.pm',
  'invert' => 0,
  'lineno' => 260,
  'result' => '1'
}
;
$Info{'t328'} = {
  'test' => '  index_imatch("foobar foo bar", \'Bar\') # Case insensitive match',
  'num' => 328,
  'comparator' => 'match',
  'package' => 'Perl::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Util.pm',
  'invert' => 0,
  'lineno' => 271,
  'result' => '3'
}
;
$Info{'t329'} = {
  'test' => '  index_imatch(" b\\n a", \'\\s*a\') # Case insensitive match',
  'num' => 329,
  'comparator' => 'match',
  'package' => 'Perl::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Util.pm',
  'invert' => 0,
  'lineno' => 272,
  'result' => '2'
}
;
$Info{'t330'} = {
  'test' => "  checksum('\x{201c}Hello\x{201d}', 'world');",
  'num' => 330,
  'comparator' => 'match',
  'package' => 'Perl::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Util.pm',
  'invert' => 0,
  'lineno' => 302,
  'result' => '1625030915'
}
;
$Info{'t331'} = {
  'test' => '  bytesize(10)',
  'num' => 331,
  'comparator' => 'match',
  'package' => 'Perl::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Util.pm',
  'invert' => 0,
  'lineno' => 321,
  'result' => '10 B'
}
;
$Info{'t332'} = {
  'test' => '  bytesize(11028)',
  'num' => 332,
  'comparator' => 'match',
  'package' => 'Perl::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Util.pm',
  'invert' => 0,
  'lineno' => 322,
  'result' => '10.77 KB'
}
;
$Info{'t333'} = {
  'test' => '  bytesize(1000 ** 3, -precision => 4)',
  'num' => 333,
  'comparator' => 'match',
  'package' => 'Perl::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Util.pm',
  'invert' => 0,
  'lineno' => 323,
  'result' => '953.6743 MB'
}
;
$Info{'t334'} = {
  'test' => '  bytesize(2 ** 30)',
  'num' => 334,
  'comparator' => 'match',
  'package' => 'Perl::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Util.pm',
  'invert' => 0,
  'lineno' => 324,
  'result' => '1 GB'
}
;
$Info{'t335'} = {
  'test' => '  bytesize(2 ** 59, -binary_symbol)',
  'num' => 335,
  'comparator' => 'match',
  'package' => 'Perl::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Util.pm',
  'invert' => 0,
  'lineno' => 325,
  'result' => '512 PiB'
}
;
$Info{'t336'} = {
  'test' => '  reftype(undef)',
  'num' => 336,
  'comparator' => 'defined',
  'package' => 'Perl::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Util.pm',
  'invert' => 1,
  'lineno' => 357,
  'result' => ''
}
;
$Info{'t337'} = {
  'test' => '  reftype(\'\')',
  'num' => 337,
  'comparator' => 'match',
  'package' => 'Perl::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Util.pm',
  'invert' => 0,
  'lineno' => 358,
  'result' => ''
}
;
$Info{'t338'} = {
  'test' => '  reftype({})',
  'num' => 338,
  'comparator' => 'match',
  'package' => 'Perl::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Util.pm',
  'invert' => 0,
  'lineno' => 359,
  'result' => 'HASH'
}
;
$Info{'t339'} = {
  'test' => '  reftype([])',
  'num' => 339,
  'comparator' => 'match',
  'package' => 'Perl::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Util.pm',
  'invert' => 0,
  'lineno' => 360,
  'result' => 'ARRAY'
}
;
$Info{'t340'} = {
  'test' => '  my $a = \'\'; reftype(\\$a)',
  'num' => 340,
  'comparator' => 'match',
  'package' => 'Perl::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Util.pm',
  'invert' => 0,
  'lineno' => 361,
  'result' => 'SCALAR'
}
;
$Info{'t341'} = {
  'test' => '  my $a = \'\'; my $b = \\$a; reftype(\\$b)',
  'num' => 341,
  'comparator' => 'match',
  'package' => 'Perl::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Util.pm',
  'invert' => 0,
  'lineno' => 362,
  'result' => 'REF'
}
;
$Info{'t342'} = {
  'test' => '  isa({}, \'HASH\')',
  'num' => 342,
  'comparator' => 'true',
  'package' => 'Perl::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Util.pm',
  'invert' => 0,
  'lineno' => 374,
  'result' => ''
}
;
$Info{'t343'} = {
  'test' => '  isa([], \'ARRAY\')',
  'num' => 343,
  'comparator' => 'true',
  'package' => 'Perl::Util',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Util.pm',
  'invert' => 0,
  'lineno' => 375,
  'result' => ''
}
;
$Info{'t344'} = {
  'test' => '  use WWW::Livesite::Args;
  my $qs = WWW::Livesite::Args->new(\'msg=hello%20world\');
  die if defined $qs->{MSG};
  return $qs->{msg};',
  'num' => 344,
  'comparator' => 'match',
  'package' => 'WWW::Livesite::Args',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/WWW/Livesite/Args.pm',
  'invert' => 0,
  'lineno' => 86,
  'result' => 'hello world'
}
;
$Info{'t345'} = {
  'test' => '  use WWW::Livesite::Args;
  my $qs = WWW::Livesite::Args->new(\'a=1&a=2\');
  my $a = $qs->{a};
  return join \'|\', @$a;',
  'num' => 345,
  'comparator' => 'match',
  'package' => 'WWW::Livesite::Args',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/WWW/Livesite/Args.pm',
  'invert' => 0,
  'lineno' => 93,
  'result' => '1|2'
}
;
$Info{'t346'} = {
  'test' => '  use WWW::Misc::Image qw(resize_str_to_props);',
  'num' => 346,
  'comparator' => 'abort',
  'package' => 'WWW::Misc::Image',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/WWW/Misc/Image.pm',
  'invert' => 1,
  'lineno' => 197,
  'result' => ''
}
;
$Info{'t347'} = {
  'test' => '  my $props = resize_str_to_props(\'800\');
  join(\';\', map { $_ . \'=\' . $$props{$_} } sort keys %$props);',
  'num' => 347,
  'comparator' => 'match',
  'package' => 'WWW::Misc::Image',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/WWW/Misc/Image.pm',
  'invert' => 0,
  'lineno' => 198,
  'result' => 'max_x=800;max_y=0;min_x=0;min_y=0'
}
;
$Info{'t348'} = {
  'test' => '  my $props = resize_str_to_props(\'800x600\');
  join(\';\', map { $_ . \'=\' . $$props{$_} } sort keys %$props);',
  'num' => 348,
  'comparator' => 'match',
  'package' => 'WWW::Misc::Image',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/WWW/Misc/Image.pm',
  'invert' => 0,
  'lineno' => 202,
  'result' => 'max_x=800;max_y=600;min_x=0;min_y=0'
}
;
$Info{'t349'} = {
  'test' => '  my $props = resize_str_to_props(\'800x600/480\');
  join(\';\', map { $_ . \'=\' . $$props{$_} } sort keys %$props);',
  'num' => 349,
  'comparator' => 'match',
  'package' => 'WWW::Misc::Image',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/WWW/Misc/Image.pm',
  'invert' => 0,
  'lineno' => 206,
  'result' => 'max_x=800;max_y=600;min_x=480;min_y=0'
}
;
$Info{'t350'} = {
  'test' => '  my $props = resize_str_to_props(\'800/480\');
  join(\';\', map { $_ . \'=\' . $$props{$_} } sort keys %$props);',
  'num' => 350,
  'comparator' => 'match',
  'package' => 'WWW::Misc::Image',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/WWW/Misc/Image.pm',
  'invert' => 0,
  'lineno' => 210,
  'result' => 'max_x=800;max_y=0;min_x=480;min_y=0'
}
;
$Info{'t351'} = {
  'test' => '  my $props = resize_str_to_props(\'100/z\');
  join(\';\', map { $_ . \'=\' . $$props{$_} } sort keys %$props);',
  'num' => 351,
  'comparator' => 'match',
  'package' => 'WWW::Misc::Image',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/WWW/Misc/Image.pm',
  'invert' => 0,
  'lineno' => 214,
  'result' => 'flags=z;max_x=100;max_y=0;min_x=0;min_y=0'
}
;
$Info{'t352'} = {
  'test' => '  use WWW::Misc::Image qw(props_to_resize_str);',
  'num' => 352,
  'comparator' => 'abort',
  'package' => 'WWW::Misc::Image',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/WWW/Misc/Image.pm',
  'invert' => 1,
  'lineno' => 244,
  'result' => ''
}
;
$Info{'t353'} = {
  'test' => '  props_to_resize_str({max_x => 800});',
  'num' => 353,
  'comparator' => 'match',
  'package' => 'WWW::Misc::Image',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/WWW/Misc/Image.pm',
  'invert' => 0,
  'lineno' => 245,
  'result' => '800'
}
;
$Info{'t354'} = {
  'test' => '  props_to_resize_str({max_x => 800, max_y => 600});',
  'num' => 354,
  'comparator' => 'match',
  'package' => 'WWW::Misc::Image',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/WWW/Misc/Image.pm',
  'invert' => 0,
  'lineno' => 246,
  'result' => '800x600'
}
;
$Info{'t355'} = {
  'test' => '  props_to_resize_str({max_x => 800, min_x => 480});',
  'num' => 355,
  'comparator' => 'match',
  'package' => 'WWW::Misc::Image',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/WWW/Misc/Image.pm',
  'invert' => 0,
  'lineno' => 247,
  'result' => '800/480'
}
;
$Info{'t356'} = {
  'test' => '  props_to_resize_str({max_x => 100, max_y => 100,min_x => 100, min_y => 100});',
  'num' => 356,
  'comparator' => 'match',
  'package' => 'WWW::Misc::Image',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/WWW/Misc/Image.pm',
  'invert' => 0,
  'lineno' => 248,
  'result' => '100x100/100x100'
}
;
$Info{'t357'} = {
  'test' => '  props_to_resize_str({max_x => 100, flags => \'z\'});',
  'num' => 357,
  'comparator' => 'match',
  'package' => 'WWW::Misc::Image',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/WWW/Misc/Image.pm',
  'invert' => 0,
  'lineno' => 250,
  'result' => '100/z'
}
;
$Info{'t358'} = {
  'test' => '  use WWW::Misc::Image qw(image_dims);',
  'num' => 358,
  'comparator' => 'abort',
  'package' => 'WWW::Misc::Image',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/WWW/Misc/Image.pm',
  'invert' => 1,
  'lineno' => 301,
  'result' => ''
}
;
$Info{'t359'} = {
  'test' => '  image_dims("/foo");',
  'num' => 359,
  'comparator' => 'false',
  'package' => 'WWW::Misc::Image',
  'summary' => '',
  'lib' => '/home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/WWW/Misc/Image.pm',
  'invert' => 0,
  'lineno' => 302,
  'result' => ''
}
;

our ($test,$tinfo,$result,$total_tests) = (undef,undef,undef,0);
$$Hub{'/sys/OPTS/v'} = 0 unless defined $$Hub{'/sys/OPTS/v'};
main();

# ------------------------------------------------------------------------------
# main - Test harness
# ------------------------------------------------------------------------------

sub main {
  $test = 1; # start at 1 to match ExtUtils::Command::MM
  my ($pass_count,$fail_count) = (0,0);
  while (eval("defined &t$test")) {
    $tinfo = $Info{"t$test"} or die "Cannot find testcase: $test\n";
    undef $result;
    $total_tests++;
    my $passed = eval( "&t$test()" );
    if( $@ ) {
      $result = $@;
      $passed = 0;
    } else {
      $passed = !$passed if( $$tinfo{'invert'} );
    }
    my $result_str = defined $result ? "'$result'" : 'undef';
    chomp $result_str;
    if( $passed ) {
      $pass_count++;
      printstatus( "passed: $result_str" ) if $$Hub{'/sys/OPTS/v'} > 1;
      printstatus( 'passed' ) if $$Hub{'/sys/OPTS/v'} eq 1;
    } else {
      $fail_count++;
      my $prefix = $result_str =~ /\n/ ? "FAILED:\n" : "FAILED: ";
      printstatus( "$prefix$result_str" );
    }
    $test++;
  }
  print "$pass_count of $total_tests passed.\n";
  exit ($pass_count == $total_tests ? 0 : 1);
}

# ------------------------------------------------------------------------------
# printstatus - Print pass/fail message
# ------------------------------------------------------------------------------

sub printstatus {
  printf "Test [%4d] %-25s line %5d: %s\n",
    $test,
    path_name($$tinfo{'package'}),
    $$tinfo{'lineno'}, @_;
}

# ------------------------------------------------------------------------------
# t1 - Does not abort
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Algorithm/KeyGen.pm line: 56
# ------------------------------------------------------------------------------

sub t1 {
  no warnings 'closure';  # allows one test case to setup subroutines for 
                          # subsequent tests.
  $result = eval {
  use Algorithm::KeyGen; 
  Algorithm::KeyGen->new(9, 'MyCharset');
  };
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t2 - Does not abort
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Algorithm/KeyGen.pm line: 177
# ------------------------------------------------------------------------------

sub t2 {
  no warnings 'closure';  # allows one test case to setup subroutines for 
                          # subsequent tests.
  $result = eval {
  use Algorithm::KeyGen qw($KeyGen);
  for (1 .. 100) {
    die unless $KeyGen->validate($KeyGen->create());
  }
  };
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t3 - Does not abort
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/CompositeHash.pm line: 15
# ------------------------------------------------------------------------------

sub t3 {
  no warnings 'closure';  # allows one test case to setup subroutines for 
                          # subsequent tests.
  $result = eval {
  use Data::CompositeHash;
  };
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t4 - Abort
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/CompositeHash.pm line: 16
# ------------------------------------------------------------------------------

sub t4 {
  no warnings 'closure';  # allows one test case to setup subroutines for 
                          # subsequent tests.
  $result = eval {
  my $ch = Data::CompositeHash->new();
  };
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t5 - Is not defined
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/CompositeHash.pm line: 31
# ------------------------------------------------------------------------------

sub t5 {
  $result = eval {
  my $h2 = {a=>'a2'};
  my $ch = Data::CompositeHash->new($h2);
  $ch->shift;
  $ch->{a};
  };
  $@ and die $@;
  return defined $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t6 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/CompositeHash.pm line: 49
# ------------------------------------------------------------------------------

sub t6 {
  $result = eval {
  my $h1 = {a=>'a1'};
  my $h2 = {a=>'a2'};
  my $ch = Data::CompositeHash->new($h2);
  $ch->unshift($h1);
  $ch->{a};
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'a1';
}

# ------------------------------------------------------------------------------
# t7 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/CompositeHash.pm line: 68
# ------------------------------------------------------------------------------

sub t7 {
  $result = eval {
  my $h2 = {a=>'a2'};
  my $h3 = {a=>'a3'};
  my $ch = Data::CompositeHash->new($h2);
  $ch->push($h3);
  $ch->{a};
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'a2';
}

# ------------------------------------------------------------------------------
# t8 - Is not defined
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/CompositeHash.pm line: 87
# ------------------------------------------------------------------------------

sub t8 {
  $result = eval {
  my $h2 = {a=>'a2'};
  my $ch = Data::CompositeHash->new($h2);
  $ch->pop;
  $ch->{a};
  };
  $@ and die $@;
  return defined $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t9 - Does not abort
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/CompositeHash.pm line: 121
# ------------------------------------------------------------------------------

sub t9 {
  no warnings 'closure';  # allows one test case to setup subroutines for 
                          # subsequent tests.
  $result = eval {
  my $h1 = {a=>'a1'};
  my $h2 = {a=>'a2', b=>'b2'};
  my $h3 = {a=>'a3', b=>'b3', c=>'c3'};
  my $ch = Data::CompositeHash->new($h2);
  $ch->unshift($h1);
  $ch->push($h3);
  # We now have a composite stack with prescedence: $h1, $h2, $h3
  # Where $h2 is the default hash
  $ch->{a} = 'AA';
  $ch->{b} = 'BB';
  $ch->{c} = 'CC';
  $ch->{d} = 'DD';
  die unless $h1->{a} eq 'AA';
  die unless $h2->{b} eq 'BB';
  die unless $h3->{c} eq 'CC';
  die unless $h2->{d} eq 'DD'; # set on default hash b/c 'd' did not exist
  };
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t10 - Does not abort
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/CompositeHash.pm line: 157
# ------------------------------------------------------------------------------

sub t10 {
  no warnings 'closure';  # allows one test case to setup subroutines for 
                          # subsequent tests.
  $result = eval {
  my $h1 = {a=>'a1'};
  my $h2 = {a=>'a2', b=>'b2'};
  my $h3 = {a=>'a3', b=>'b3', c=>'c3'};
  my $ch = Data::CompositeHash->new($h2);
  $ch->unshift($h1);
  $ch->push($h3);
  # We now have a composite stack with prescedence: $h1, $h2, $h3
  # Where $h2 is the default hash
  die unless $ch->{a} eq 'a1';
  die unless $ch->{b} eq 'b2';
  die unless $ch->{c} eq 'c3';
  die unless ref($ch->{'/'});
  };
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t11 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/CompositeHash.pm line: 192
# ------------------------------------------------------------------------------

sub t11 {
  $result = eval {
  my $h1 = {a=>'a1'};
  my $h2 = {a=>'a2', b=>'b2'};
  my $h3 = {a=>'a3', b=>'b3', c=>'c3'};
  my $ch = Data::CompositeHash->new($h2);
  $ch->unshift($h1);
  $ch->push($h3);
  join '', sort values %$ch;
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'a1b2c3';
}

# ------------------------------------------------------------------------------
# t12 - Does not abort
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/CompositeHash.pm line: 213
# ------------------------------------------------------------------------------

sub t12 {
  no warnings 'closure';  # allows one test case to setup subroutines for 
                          # subsequent tests.
  $result = eval {
  my $h1 = {a=>'a1'};
  my $h2 = {a=>'a2', b=>'b2'};
  my $h3 = {a=>'a3', b=>'b3', c=>'c3'};
  my $ch = Data::CompositeHash->new($h2);
  $ch->unshift($h1);
  $ch->push($h3);
  die unless exists $$ch{a};
  die unless exists $$ch{b};
  die unless exists $$ch{c};
  die if exists $$ch{d};
  };
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t13 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/CompositeHash.pm line: 234
# ------------------------------------------------------------------------------

sub t13 {
  $result = eval {
  my $h1 = {a=>'a1'};
  my $h2 = {a=>'a2', b=>'b2'};
  my $h3 = {a=>'a3', b=>'b3', c=>'c3'};
  my $ch = Data::CompositeHash->new($h2);
  $ch->unshift($h1);
  $ch->push($h3);
  delete $ch->{a};
  delete $ch->{b};
  delete $ch->{c};
  join '', sort values %$ch;
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'a2b3';
}

# ------------------------------------------------------------------------------
# t14 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/CompositeHash.pm line: 255
# ------------------------------------------------------------------------------

sub t14 {
  $result = eval {
  my $h1 = {a=>'a1'};
  my $h2 = {a=>'a2', b=>'b2'};
  my $h3 = {a=>'a3', b=>'b3', c=>'c3'};
  my $ch = Data::CompositeHash->new($h2);
  $ch->unshift($h1);
  $ch->push($h3);
  %$ch = ();
  join '', sort values %$ch;
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'a2b2';
}

# ------------------------------------------------------------------------------
# t15 - True
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/CompositeHash.pm line: 273
# ------------------------------------------------------------------------------

sub t15 {
  $result = eval {
  my $h2 = {a=>'a2', b=>'b2'};
  my $ch = Data::CompositeHash->new($h2);
  scalar(%$ch);
  };
  $@ and die $@;
  return $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t16 - False
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/CompositeHash.pm line: 278
# ------------------------------------------------------------------------------

sub t16 {
  $result = eval {
  my $h2 = {a=>'a2', b=>'b2'};
  my $ch = Data::CompositeHash->new($h2);
  $ch->pop;
  scalar(%$ch);
  };
  $@ and die $@;
  return $result ? 0 : 1;
}

# ------------------------------------------------------------------------------
# t17 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/CompositeHash.pm line: 289
# ------------------------------------------------------------------------------

sub t17 {
  $result = eval {
  use Data::CompositeHash;
  my $h1 = {
    'a' => 'argon',
  };
  my $h2 = {
    'a' => 'apple',
    'b' => 'banana',
    'c' => 'cherry',
  };
  my $h3 = {
    'c' => 'cyan',
    'd' => 'dark brown',
  };
  my $result = '';
  # Create a composite hash, using $h2 as the default hash
  my $ch = Data::CompositeHash->new($h2);
  # Add $h1 as a hash which will overried values in $h2
  $ch->unshift($h1);
  # Add $h3 as a hash with the least prescedence
  $ch->push($h3);
  # Fetch some values
  $result .= $ch->{a} . "\n";
  $result .= $ch->{b} . "\n";
  $result .= $ch->{c} . "\n";
  $result .= $ch->{d} . "\n";
  # Set an ambiguous value
  $result .= "--\n";
  $ch->{a} = 'aluminium';
  $result .= $h1->{a} . "\n"; # contains new value
  $result .= $h2->{a} . "\n"; # not touched
  # Set an ambiguous value
  $result .= "--\n";
  $ch->{c} = 'cantelope';
  $result .= $h2->{c} . "\n"; # contains new value
  $result .= $h3->{c} . "\n"; # not touched
  # Setting a value which is not defined in any hash sets
  # it on the defalut hash
  $result .= "--\n";
  $ch->{e} = 'edible fruit';
  $result .= $h2->{e};
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'argon
banana
cherry
dark brown
--
aluminium
apple
--
cantelope
cyan
--
edible fruit';
}

# ------------------------------------------------------------------------------
# t18 - Does not abort
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Format/Hash.pm line: 73
# ------------------------------------------------------------------------------

sub t18 {
  no warnings 'closure';  # allows one test case to setup subroutines for 
                          # subsequent tests.
  $result = eval {
  use Data::Format::Hash qw(hf_parse);
  };
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t19 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Format/Hash.pm line: 74
# ------------------------------------------------------------------------------

sub t19 {
  $result = eval {
  my $d = q(
  baz => biz
  foo => %{
  bar => @{
  tender
  stool
  }
  }
  );
  my $h = hf_parse(\$d);
  $$h{'baz'};
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'biz';
}

# ------------------------------------------------------------------------------
# t20 - Does not abort
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Format/Hash.pm line: 315
# ------------------------------------------------------------------------------

sub t20 {
  no warnings 'closure';  # allows one test case to setup subroutines for 
                          # subsequent tests.
  $result = eval {
  use Data::Format::Hash qw(hf_format);
  };
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t21 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Format/Hash.pm line: 316
# ------------------------------------------------------------------------------

sub t21 {
  $result = eval {
  my $d = {foo=>{bar=>['tender','stool']}};
  hf_format($d)
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'foo => %{
  bar => @{
    tender
    stool
  }
}';
}

# ------------------------------------------------------------------------------
# t22 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Format/HexString.pm line: 15
# ------------------------------------------------------------------------------

sub t22 {
  $result = eval {
  use Data::Format::HexString qw(:all);
  hexstr_format( 'Dogs (Waters, Gilmour) 17:06' );
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'Dogs_0x20__0x28_Waters_0x2c__0x20_Gilmour_0x29__0x20_17_0x3a_06';
}

# ------------------------------------------------------------------------------
# t23 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Format/HexString.pm line: 29
# ------------------------------------------------------------------------------

sub t23 {
  $result = eval {
  hexstr_parse('Dogs_0x20__0x28_Waters_0x2c__0x20_Gilmour_0x29__0x20_17_0x3a_06');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'Dogs (Waters, Gilmour) 17:06';
}

# ------------------------------------------------------------------------------
# t24 - Does not abort
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Format/XFR.pm line: 205
# ------------------------------------------------------------------------------

sub t24 {
  no warnings 'closure';  # allows one test case to setup subroutines for 
                          # subsequent tests.
  $result = eval {
  use Data::Format::XFR;
  use Data::OrderedHash;
  my $h = Data::OrderedHash->new(
    a => ['alpha', 'beta', 'copper'],
    b => {
      one => 1,
    },
    c => 'charlie',
  );
  my $xfr = Data::Format::XFR->new('base64');
  my $known = '%{YQ==@{${YWxwaGE=}${YmV0YQ==}${Y29wcGVy}}Yg==%{b25l${MQ==}}Yw==${Y2hhcmxpZQ==}}';
  my $str = $xfr->format($h);
  die "format error:\nstr: $str\n!= : $known" unless $str eq $known;
  my $h2 = $xfr->parse($str);
  die 'parse error' unless $h2->{a}[1] eq $h->{a}[1];
  };
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t25 - Does not abort
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Address.pm line: 33
# ------------------------------------------------------------------------------

sub t25 {
  no warnings 'closure';  # allows one test case to setup subroutines for 
                          # subsequent tests.
  $result = eval {
    
  use strict;
  use Data::Hub::Address;
  my $a = Data::Hub::Address->new("/b/c/d");
  die $a->to_string unless '/b/c/d' eq $a->to_string;
  die $a->first unless '' eq $a->first;
  die $a->last unless 'd' eq $a->last;
  $a->pop;
  die unless '/b/c' eq $a->to_string;
  $a->push("D");
  die unless '/b/c/D' eq $a->to_string;
  $a->shift;
  die unless 'b/c/D' eq $a->to_string;
  $a->unshift('A');
  die unless 'A/b/c/D' eq $a->to_string;
  };
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t26 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Courier.pm line: 208
# ------------------------------------------------------------------------------

sub t26 {
  $result = eval {
  my $h = {g=>[qw(a b)]};
  Data::Hub::Courier::append($h, '/g', 'c');
  join('', @{$$h{g}});
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'abc';
}

# ------------------------------------------------------------------------------
# t27 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Courier.pm line: 213
# ------------------------------------------------------------------------------

sub t27 {
  $result = eval {
  my $h = {g=>Data::OrderedHash->new(a => 1, b => 2)};
  Data::Hub::Courier::append($h, '/g', c => 3);
  join('', keys %{$$h{g}});
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'abc';
}

# ------------------------------------------------------------------------------
# t28 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Courier.pm line: 218
# ------------------------------------------------------------------------------

sub t28 {
  $result = eval {
  my $h = {g=>str_ref('ab')};
  Data::Hub::Courier::append($h, '/g', 'c');
  ${$$h{g}};
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'abc';
}

# ------------------------------------------------------------------------------
# t29 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Courier.pm line: 255
# ------------------------------------------------------------------------------

sub t29 {
  $result = eval {
  my $h = {g=>[qw(b c)]};
  Data::Hub::Courier::prepend($h, '/g', 'a');
  join('', @{$$h{g}});
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'abc';
}

# ------------------------------------------------------------------------------
# t30 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Courier.pm line: 260
# ------------------------------------------------------------------------------

sub t30 {
  $result = eval {
  my $h = {g=>Data::OrderedHash->new(b => 2, c => 3)};
  Data::Hub::Courier::prepend($h, '/g', a => 1);
  join('', keys %{$$h{g}});
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'abc';
}

# ------------------------------------------------------------------------------
# t31 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Courier.pm line: 265
# ------------------------------------------------------------------------------

sub t31 {
  $result = eval {
  my $h = {g=>str_ref('bc')};
  Data::Hub::Courier::prepend($h, '/g', 'a');
  ${$$h{g}};
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'abc';
}

# ------------------------------------------------------------------------------
# t32 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Courier.pm line: 385
# ------------------------------------------------------------------------------

sub t32 {
  $result = eval {
  use Data::Hub::Courier;
  my $h = {
    A => {
      I => [
        'Hello'
      ],
    },
  };
  Data::Hub::Courier::set($h, '/A/I/1', 'World!');
  my $a = Data::Hub::Courier::get($h, '/A/I');
  join ' ', @$a;
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'Hello World!';
}

# ------------------------------------------------------------------------------
# t33 - Does not abort
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Query.pm line: 410
# ------------------------------------------------------------------------------

sub t33 {
  no warnings 'closure';  # allows one test case to setup subroutines for 
                          # subsequent tests.
  $result = eval {
  # This test case simply sets up the test data and subroutine for running
  # subsequent test queries.
  use Data::Hub::Util qw(:all);
  use Data::Format::Hash qw(hf_format hf_parse);
  use Data::OrderedHash;
  my $ttt_data = curry(hf_parse('
    array => @{
      a
      b
      c
      ab
      abc
    }
    hash => %{
      a => Alpha
      b => Beta
      c => Charlie
    }
    array_of_hashes => @{
      %{
        name => a
        text => Alpha
      }
      %{
        name => b
        text => Beta
      }
      %{
        name => c
        text => Charlie
      }
    }
    hash_of_hashes => %{
      a => %{
        text => Alpha
        num => 3
      }
      b => %{
        text => Beta
        num => 2
      }
      c => %{
        text => Charlie
        num => 1
      }
    }
  '));
  # The test data is curried to provide the get method of Data::Hub::Courier
  sub ttt_query {
    my $q = shift;
    my $r = $ttt_data->get($q);
    return unless defined $r;
    my $ref = ref($r);
    $ref ? hf_format({$ref => $r}) : $r;
  }
  };
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t34 - Is not defined
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Query.pm line: 481
# ------------------------------------------------------------------------------

sub t34 {
  $result = eval {
  # Use an invalid index
  ttt_query('array/{?:fail}');
  };
  $@ and die $@;
  return defined $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t35 - Is not defined
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Query.pm line: 486
# ------------------------------------------------------------------------------

sub t35 {
  $result = eval {
  # Get the value whose value is ''
  ttt_query('array/{?:}');
  };
  $@ and die $@;
  return defined $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t36 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Query.pm line: 491
# ------------------------------------------------------------------------------

sub t36 {
  $result = eval {
  # Get the value whose key is eq 0
  ttt_query('array/{?:0}');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'a';
}

# ------------------------------------------------------------------------------
# t37 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Query.pm line: 500
# ------------------------------------------------------------------------------

sub t37 {
  $result = eval {
  # Get the value whose key is == 0
  ttt_query('array/{?(==):0}');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'Data::Hub::Subset => %{
  0 => a
}';
}

# ------------------------------------------------------------------------------
# t38 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Query.pm line: 511
# ------------------------------------------------------------------------------

sub t38 {
  $result = eval {
  # Get all items whose key is >= 2
  ttt_query('array/{?(>=):2}');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'Data::Hub::Subset => %{
  2 => c
  3 => ab
  4 => abc
}';
}

# ------------------------------------------------------------------------------
# t39 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Query.pm line: 524
# ------------------------------------------------------------------------------

sub t39 {
  $result = eval {
  # Get the value whose value is 'a'
  ttt_query('array/{?*:a}');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'a';
}

# ------------------------------------------------------------------------------
# t40 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Query.pm line: 533
# ------------------------------------------------------------------------------

sub t40 {
  $result = eval {
  # Get all items whose value is eq 'a'
  ttt_query('array/{?*(eq):a}');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'Data::Hub::Subset => %{
  0 => a
}';
}

# ------------------------------------------------------------------------------
# t41 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Query.pm line: 544
# ------------------------------------------------------------------------------

sub t41 {
  $result = eval {
  # Get all items whose value is =~ /a/
  ttt_query('array/{?*(=~):a}');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'Data::Hub::Subset => %{
  0 => a
  3 => ab
  4 => abc
}';
}

# ------------------------------------------------------------------------------
# t42 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Query.pm line: 561
# ------------------------------------------------------------------------------

sub t42 {
  $result = eval {
  # Get the value whose key is eq 'a'
  ttt_query('hash/{?:a}');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'Alpha';
}

# ------------------------------------------------------------------------------
# t43 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Query.pm line: 570
# ------------------------------------------------------------------------------

sub t43 {
  $result = eval {
  # Get the value whose value is eq 'Alpha'
  ttt_query('hash/{?*:Alpha}');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'Alpha';
}

# ------------------------------------------------------------------------------
# t44 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Query.pm line: 579
# ------------------------------------------------------------------------------

sub t44 {
  $result = eval {
  # Get all items whose value is eq 'Alpha'
  ttt_query('hash/{?*(eq):Alpha}');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'Data::Hub::Subset => %{
  a => Alpha
}';
}

# ------------------------------------------------------------------------------
# t45 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Query.pm line: 590
# ------------------------------------------------------------------------------

sub t45 {
  $result = eval {
  # Get all items whose value is =~ /a$/
  ttt_query('hash/{?*(=~):a$}');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'Data::Hub::Subset => %{
  a => Alpha
  b => Beta
}';
}

# ------------------------------------------------------------------------------
# t46 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Query.pm line: 606
# ------------------------------------------------------------------------------

sub t46 {
  $result = eval {
  # Get the value whose key is eq 0
  ttt_query('array_of_hashes/{?:0}');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'Data::OrderedHash => %{
  name => a
  text => Alpha
}';
}

# ------------------------------------------------------------------------------
# t47 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Query.pm line: 618
# ------------------------------------------------------------------------------

sub t47 {
  $result = eval {
  # Get the value whose name is eq 'a'
  ttt_query('array_of_hashes/{?name:a}');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'Data::OrderedHash => %{
  name => a
  text => Alpha
}';
}

# ------------------------------------------------------------------------------
# t48 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Query.pm line: 630
# ------------------------------------------------------------------------------

sub t48 {
  $result = eval {
  # Get all items whose name is eq 'a'
  ttt_query('array_of_hashes/{?name(eq):a}');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'Data::Hub::Subset => %{
  0 => %{
    name => a
    text => Alpha
  }
}';
}

# ------------------------------------------------------------------------------
# t49 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Query.pm line: 644
# ------------------------------------------------------------------------------

sub t49 {
  $result = eval {
  # Get all items whose name is =~ /a|b/
  ttt_query('array_of_hashes/{?name(=~):a|b}');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'Data::Hub::Subset => %{
  0 => %{
    name => a
    text => Alpha
  }
  1 => %{
    name => b
    text => Beta
  }
}';
}

# ------------------------------------------------------------------------------
# t50 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Query.pm line: 666
# ------------------------------------------------------------------------------

sub t50 {
  $result = eval {
  # Get the value whose key is eq 'a'
  ttt_query('hash_of_hashes/{?:a}');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'Data::OrderedHash => %{
  text => Alpha
  num => 3
}';
}

# ------------------------------------------------------------------------------
# t51 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Query.pm line: 678
# ------------------------------------------------------------------------------

sub t51 {
  $result = eval {
  # Get the value whose text is eq 'Alpha'
  ttt_query('hash_of_hashes/{?text:Alpha}');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'Data::OrderedHash => %{
  text => Alpha
  num => 3
}';
}

# ------------------------------------------------------------------------------
# t52 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Query.pm line: 690
# ------------------------------------------------------------------------------

sub t52 {
  $result = eval {
  # Get all items whose text is eq 'Alpha'
  ttt_query('hash_of_hashes/{?text(eq):Alpha}');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'Data::Hub::Subset => %{
  a => %{
    text => Alpha
    num => 3
  }
}';
}

# ------------------------------------------------------------------------------
# t53 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Query.pm line: 704
# ------------------------------------------------------------------------------

sub t53 {
  $result = eval {
  # Get all items whose num is > 1
  ttt_query('hash_of_hashes/{?num(>):1}');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'Data::Hub::Subset => %{
  a => %{
    text => Alpha
    num => 3
  }
  b => %{
    text => Beta
    num => 2
  }
}';
}

# ------------------------------------------------------------------------------
# t54 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Query.pm line: 726
# ------------------------------------------------------------------------------

sub t54 {
  $result = eval {
  ttt_query('hash_of_hashes/*|{?(ne):b}');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'Data::Hub::Subset => %{
  a => %{
    text => Alpha
    num => 3
  }
  c => %{
    text => Charlie
    num => 1
  }
}';
}

# ------------------------------------------------------------------------------
# t55 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Query.pm line: 743
# ------------------------------------------------------------------------------

sub t55 {
  $result = eval {
  ttt_query('hash_of_hashes/*|{?text(=~):B|C}');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'Data::Hub::Subset => %{
  b => %{
    text => Beta
    num => 2
  }
  c => %{
    text => Charlie
    num => 1
  }
}';
}

# ------------------------------------------------------------------------------
# t56 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Query.pm line: 762
# ------------------------------------------------------------------------------

sub t56 {
  $result = eval {
  ttt_query('hash_of_hashes/*|{?(=~):[ab]}|{?text(=~):B|C}');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'Data::Hub::Subset => %{
  b => %{
    text => Beta
    num => 2
  }
}';
}

# ------------------------------------------------------------------------------
# t57 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Query.pm line: 775
# ------------------------------------------------------------------------------

sub t57 {
  $result = eval {
  ttt_query('hash_of_hashes/{?(=~):[ab]}|{?text(=~):B|C}');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'Data::Hub::Subset => %{
  b => %{
    text => Beta
    num => 2
  }
}';
}

# ------------------------------------------------------------------------------
# t58 - Does not abort
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 85
# ------------------------------------------------------------------------------

sub t58 {
  no warnings 'closure';  # allows one test case to setup subroutines for 
                          # subsequent tests.
  $result = eval {
  use Data::Hub::Util qw(:all);
  };
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t59 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 125
# ------------------------------------------------------------------------------

sub t59 {
  $result = eval {
  curry({a=>{b=>'c'}})->get('/a/b');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'c';
}

# ------------------------------------------------------------------------------
# t60 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 137
# ------------------------------------------------------------------------------

sub t60 {
  $result = eval {
  FS('Node');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'Data::Hub::FileSystem::Node';
}

# ------------------------------------------------------------------------------
# t61 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 148
# ------------------------------------------------------------------------------

sub t61 {
  $result = eval {
  typeof('foo.bar', {});
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'data-hash';
}

# ------------------------------------------------------------------------------
# t62 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 149
# ------------------------------------------------------------------------------

sub t62 {
  $result = eval {
  typeof('/with/path/foo.bar', []);
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'data-array';
}

# ------------------------------------------------------------------------------
# t63 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 150
# ------------------------------------------------------------------------------

sub t63 {
  $result = eval {
  typeof('foo.bar', 'baz');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'data-scalar-bar';
}

# ------------------------------------------------------------------------------
# t64 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 228
# ------------------------------------------------------------------------------

sub t64 {
  $result = eval {
  my $addr = '/one/two/{/i/am/three}/four';
  join(':', addr_shift($addr), addr_shift($addr), addr_shift($addr),
  addr_shift($addr)); 
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'one:two:{/i/am/three}:four';
}

# ------------------------------------------------------------------------------
# t65 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 241
# ------------------------------------------------------------------------------

sub t65 {
  $result = eval {
  my $addr = '/one/two';
  my $last = addr_pop($addr);
  "$last,$addr"
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'two,/one';
}

# ------------------------------------------------------------------------------
# t66 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 255
# ------------------------------------------------------------------------------

sub t66 {
  $result = eval {
  addr_normalize('/');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '/';
}

# ------------------------------------------------------------------------------
# t67 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 256
# ------------------------------------------------------------------------------

sub t67 {
  $result = eval {
  addr_normalize('/a/');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '/a';
}

# ------------------------------------------------------------------------------
# t68 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 257
# ------------------------------------------------------------------------------

sub t68 {
  $result = eval {
  addr_normalize('/a/b/..');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '/a';
}

# ------------------------------------------------------------------------------
# t69 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 258
# ------------------------------------------------------------------------------

sub t69 {
  $result = eval {
  addr_normalize('/a/../b');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '/b';
}

# ------------------------------------------------------------------------------
# t70 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 259
# ------------------------------------------------------------------------------

sub t70 {
  $result = eval {
  addr_normalize('/a/../../b');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '/b';
}

# ------------------------------------------------------------------------------
# t71 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 260
# ------------------------------------------------------------------------------

sub t71 {
  $result = eval {
  addr_normalize('/a/.../b');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '/a';
}

# ------------------------------------------------------------------------------
# t72 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 261
# ------------------------------------------------------------------------------

sub t72 {
  $result = eval {
  addr_normalize('/a/.../');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '/a';
}

# ------------------------------------------------------------------------------
# t73 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 262
# ------------------------------------------------------------------------------

sub t73 {
  $result = eval {
  addr_normalize('/a/...');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '/a';
}

# ------------------------------------------------------------------------------
# t74 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 263
# ------------------------------------------------------------------------------

sub t74 {
  $result = eval {
  addr_normalize('/a/.../..');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '/a';
}

# ------------------------------------------------------------------------------
# t75 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 264
# ------------------------------------------------------------------------------

sub t75 {
  $result = eval {
  addr_normalize('/a/../...');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '/';
}

# ------------------------------------------------------------------------------
# t76 - Is not defined
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 275
# ------------------------------------------------------------------------------

sub t76 {
  $result = eval {
  addr_parent();
  };
  $@ and die $@;
  return defined $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t77 - Is not defined
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 276
# ------------------------------------------------------------------------------

sub t77 {
  $result = eval {
  addr_parent('');
  };
  $@ and die $@;
  return defined $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t78 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 277
# ------------------------------------------------------------------------------

sub t78 {
  $result = eval {
  addr_parent('/');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '/';
}

# ------------------------------------------------------------------------------
# t79 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 278
# ------------------------------------------------------------------------------

sub t79 {
  $result = eval {
  addr_parent('/a');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '/';
}

# ------------------------------------------------------------------------------
# t80 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 279
# ------------------------------------------------------------------------------

sub t80 {
  $result = eval {
  addr_parent('/a/b/..');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '/';
}

# ------------------------------------------------------------------------------
# t81 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 280
# ------------------------------------------------------------------------------

sub t81 {
  $result = eval {
  addr_parent('a/b/');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'a';
}

# ------------------------------------------------------------------------------
# t82 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 281
# ------------------------------------------------------------------------------

sub t82 {
  $result = eval {
  addr_parent('a/b.c');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'a';
}

# ------------------------------------------------------------------------------
# t83 - Is not defined
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 294
# ------------------------------------------------------------------------------

sub t83 {
  $result = eval {
  addr_name('');
  };
  $@ and die $@;
  return defined $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t84 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 295
# ------------------------------------------------------------------------------

sub t84 {
  $result = eval {
  addr_name('/');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '';
}

# ------------------------------------------------------------------------------
# t85 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 296
# ------------------------------------------------------------------------------

sub t85 {
  $result = eval {
  addr_name('/a');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'a';
}

# ------------------------------------------------------------------------------
# t86 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 297
# ------------------------------------------------------------------------------

sub t86 {
  $result = eval {
  addr_name('/a/b/..');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'a';
}

# ------------------------------------------------------------------------------
# t87 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 298
# ------------------------------------------------------------------------------

sub t87 {
  $result = eval {
  addr_name('a/b/');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'b';
}

# ------------------------------------------------------------------------------
# t88 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 299
# ------------------------------------------------------------------------------

sub t88 {
  $result = eval {
  addr_name('a/b.c');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'b.c';
}

# ------------------------------------------------------------------------------
# t89 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 311
# ------------------------------------------------------------------------------

sub t89 {
  $result = eval {
  scalar(addr_split(''));
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '0';
}

# ------------------------------------------------------------------------------
# t90 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 312
# ------------------------------------------------------------------------------

sub t90 {
  $result = eval {
  join ' ', addr_split('/');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '';
}

# ------------------------------------------------------------------------------
# t91 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 313
# ------------------------------------------------------------------------------

sub t91 {
  $result = eval {
  join ' ', addr_split('/a');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'a';
}

# ------------------------------------------------------------------------------
# t92 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 314
# ------------------------------------------------------------------------------

sub t92 {
  $result = eval {
  join ' ', addr_split('/a/b/..');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'a';
}

# ------------------------------------------------------------------------------
# t93 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 315
# ------------------------------------------------------------------------------

sub t93 {
  $result = eval {
  join ' ', addr_split('a/b/');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'a b';
}

# ------------------------------------------------------------------------------
# t94 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 316
# ------------------------------------------------------------------------------

sub t94 {
  $result = eval {
  join ' ', addr_split('a/b.c');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'a b.c';
}

# ------------------------------------------------------------------------------
# t95 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 330
# ------------------------------------------------------------------------------

sub t95 {
  $result = eval {
  addr_join('/');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '/';
}

# ------------------------------------------------------------------------------
# t96 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 331
# ------------------------------------------------------------------------------

sub t96 {
  $result = eval {
  addr_join('/a', '/');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '/a';
}

# ------------------------------------------------------------------------------
# t97 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 332
# ------------------------------------------------------------------------------

sub t97 {
  $result = eval {
  addr_join('/a/', 'b/..');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '/a';
}

# ------------------------------------------------------------------------------
# t98 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 333
# ------------------------------------------------------------------------------

sub t98 {
  $result = eval {
  addr_join('/a/..', '/b');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '/b';
}

# ------------------------------------------------------------------------------
# t99 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 334
# ------------------------------------------------------------------------------

sub t99 {
  $result = eval {
  addr_join('/a/../', '../b');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '/b';
}

# ------------------------------------------------------------------------------
# t100 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 335
# ------------------------------------------------------------------------------

sub t100 {
  $result = eval {
  addr_join('/a/.../', 'b');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '/a';
}

# ------------------------------------------------------------------------------
# t101 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 336
# ------------------------------------------------------------------------------

sub t101 {
  $result = eval {
  addr_join('/a/', '.../');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '/a';
}

# ------------------------------------------------------------------------------
# t102 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 337
# ------------------------------------------------------------------------------

sub t102 {
  $result = eval {
  addr_join('/a/', '...');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '/a';
}

# ------------------------------------------------------------------------------
# t103 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 338
# ------------------------------------------------------------------------------

sub t103 {
  $result = eval {
  addr_join('/a/', 'b/');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '/a/b';
}

# ------------------------------------------------------------------------------
# t104 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 339
# ------------------------------------------------------------------------------

sub t104 {
  $result = eval {
  addr_join('/a/', 'b');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '/a/b';
}

# ------------------------------------------------------------------------------
# t105 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 340
# ------------------------------------------------------------------------------

sub t105 {
  $result = eval {
  addr_join('/a', '/b');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '/a/b';
}

# ------------------------------------------------------------------------------
# t106 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 341
# ------------------------------------------------------------------------------

sub t106 {
  $result = eval {
  addr_join('/a', 'b');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '/a/b';
}

# ------------------------------------------------------------------------------
# t107 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 342
# ------------------------------------------------------------------------------

sub t107 {
  $result = eval {
  addr_join('/a', 'b', 'c');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '/a/b/c';
}

# ------------------------------------------------------------------------------
# t108 - Is not defined
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 353
# ------------------------------------------------------------------------------

sub t108 {
  $result = eval {
  addr_ext(undef);
  };
  $@ and die $@;
  return defined $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t109 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 354
# ------------------------------------------------------------------------------

sub t109 {
  $result = eval {
  addr_ext('foo.txt');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'txt';
}

# ------------------------------------------------------------------------------
# t110 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 355
# ------------------------------------------------------------------------------

sub t110 {
  $result = eval {
  addr_ext('/foo.txt');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'txt';
}

# ------------------------------------------------------------------------------
# t111 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 356
# ------------------------------------------------------------------------------

sub t111 {
  $result = eval {
  addr_ext('./foo.txt');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'txt';
}

# ------------------------------------------------------------------------------
# t112 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 357
# ------------------------------------------------------------------------------

sub t112 {
  $result = eval {
  addr_ext('../foo.txt');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'txt';
}

# ------------------------------------------------------------------------------
# t113 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 358
# ------------------------------------------------------------------------------

sub t113 {
  $result = eval {
  addr_ext('/foo/foo.txt');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'txt';
}

# ------------------------------------------------------------------------------
# t114 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 359
# ------------------------------------------------------------------------------

sub t114 {
  $result = eval {
  addr_ext('/foo.bar.txt');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'txt';
}

# ------------------------------------------------------------------------------
# t115 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 360
# ------------------------------------------------------------------------------

sub t115 {
  $result = eval {
  addr_ext('/foo/bar.');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '';
}

# ------------------------------------------------------------------------------
# t116 - Is not defined
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 361
# ------------------------------------------------------------------------------

sub t116 {
  $result = eval {
  addr_ext('/foo/bar');
  };
  $@ and die $@;
  return defined $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t117 - Is not defined
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 362
# ------------------------------------------------------------------------------

sub t117 {
  $result = eval {
  addr_ext('.metadata');
  };
  $@ and die $@;
  return defined $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t118 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 363
# ------------------------------------------------------------------------------

sub t118 {
  $result = eval {
  addr_ext('.metadata.bak');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'bak';
}

# ------------------------------------------------------------------------------
# t119 - Is not defined
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 377
# ------------------------------------------------------------------------------

sub t119 {
  $result = eval {
  addr_basename(undef);
  };
  $@ and die $@;
  return defined $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t120 - Is not defined
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 378
# ------------------------------------------------------------------------------

sub t120 {
  $result = eval {
  addr_basename('/');
  };
  $@ and die $@;
  return defined $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t121 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 379
# ------------------------------------------------------------------------------

sub t121 {
  $result = eval {
  addr_basename('foo.txt');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'foo';
}

# ------------------------------------------------------------------------------
# t122 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 380
# ------------------------------------------------------------------------------

sub t122 {
  $result = eval {
  addr_basename('foo.txt/');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'foo';
}

# ------------------------------------------------------------------------------
# t123 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 381
# ------------------------------------------------------------------------------

sub t123 {
  $result = eval {
  addr_basename('/foo.txt');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'foo';
}

# ------------------------------------------------------------------------------
# t124 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 382
# ------------------------------------------------------------------------------

sub t124 {
  $result = eval {
  addr_basename('./foo.txt');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'foo';
}

# ------------------------------------------------------------------------------
# t125 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 383
# ------------------------------------------------------------------------------

sub t125 {
  $result = eval {
  addr_basename('../foo.txt');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'foo';
}

# ------------------------------------------------------------------------------
# t126 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 384
# ------------------------------------------------------------------------------

sub t126 {
  $result = eval {
  addr_basename('/foo/foo.txt');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'foo';
}

# ------------------------------------------------------------------------------
# t127 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 385
# ------------------------------------------------------------------------------

sub t127 {
  $result = eval {
  addr_basename('/foo.bar.txt');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'foo.bar';
}

# ------------------------------------------------------------------------------
# t128 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 386
# ------------------------------------------------------------------------------

sub t128 {
  $result = eval {
  addr_basename('/foo/bar.');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'bar';
}

# ------------------------------------------------------------------------------
# t129 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 387
# ------------------------------------------------------------------------------

sub t129 {
  $result = eval {
  addr_basename('/foo/bar');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'bar';
}

# ------------------------------------------------------------------------------
# t130 - Is not defined
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 388
# ------------------------------------------------------------------------------

sub t130 {
  $result = eval {
  addr_basename('.metadata');
  };
  $@ and die $@;
  return defined $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t131 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 389
# ------------------------------------------------------------------------------

sub t131 {
  $result = eval {
  addr_basename('.metadata.bak');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '.metadata';
}

# ------------------------------------------------------------------------------
# t132 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 404
# ------------------------------------------------------------------------------

sub t132 {
  $result = eval {
  addr_base('/a/b/{d}');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '/a/b';
}

# ------------------------------------------------------------------------------
# t133 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 405
# ------------------------------------------------------------------------------

sub t133 {
  $result = eval {
  addr_base('/a/b/d');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '/a/b/d';
}

# ------------------------------------------------------------------------------
# t134 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 429
# ------------------------------------------------------------------------------

sub t134 {
  $result = eval {
  my $path = '/one/two/../four';
  join(':', path_shift($path), path_shift($path), path_shift($path),
  path_shift($path)); 
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'one:two:..:four';
}

# ------------------------------------------------------------------------------
# t135 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 442
# ------------------------------------------------------------------------------

sub t135 {
  $result = eval {
  my $path = '/one/two';
  my $last = path_pop($path);
  "$last,$path"
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'two,/one';
}

# ------------------------------------------------------------------------------
# t136 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 455
# ------------------------------------------------------------------------------

sub t136 {
  $result = eval {
  my $path = '/one/two';
  my $count = path_push($path, 'three');
  "$path"
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '/one/two/three';
}

# ------------------------------------------------------------------------------
# t137 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 467
# ------------------------------------------------------------------------------

sub t137 {
  $result = eval {
  path_split('');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '0';
}

# ------------------------------------------------------------------------------
# t138 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 468
# ------------------------------------------------------------------------------

sub t138 {
  $result = eval {
  join ' ', path_split('/');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '';
}

# ------------------------------------------------------------------------------
# t139 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 469
# ------------------------------------------------------------------------------

sub t139 {
  $result = eval {
  join ' ', path_split('/a');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'a';
}

# ------------------------------------------------------------------------------
# t140 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 470
# ------------------------------------------------------------------------------

sub t140 {
  $result = eval {
  join ' ', path_split('/a/b/..');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'a';
}

# ------------------------------------------------------------------------------
# t141 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 471
# ------------------------------------------------------------------------------

sub t141 {
  $result = eval {
  join ' ', path_split('a/b/');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'a b';
}

# ------------------------------------------------------------------------------
# t142 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 472
# ------------------------------------------------------------------------------

sub t142 {
  $result = eval {
  join ' ', path_split('a/b.c');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'a b.c';
}

# ------------------------------------------------------------------------------
# t143 - Is not defined
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 489
# ------------------------------------------------------------------------------

sub t143 {
  $result = eval {
  path_basename(undef);
  };
  $@ and die $@;
  return defined $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t144 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 490
# ------------------------------------------------------------------------------

sub t144 {
  $result = eval {
  path_basename('foo.txt');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'foo';
}

# ------------------------------------------------------------------------------
# t145 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 491
# ------------------------------------------------------------------------------

sub t145 {
  $result = eval {
  path_basename('/foo.txt');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'foo';
}

# ------------------------------------------------------------------------------
# t146 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 492
# ------------------------------------------------------------------------------

sub t146 {
  $result = eval {
  path_basename('./foo.txt');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'foo';
}

# ------------------------------------------------------------------------------
# t147 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 493
# ------------------------------------------------------------------------------

sub t147 {
  $result = eval {
  path_basename('../foo.txt');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'foo';
}

# ------------------------------------------------------------------------------
# t148 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 494
# ------------------------------------------------------------------------------

sub t148 {
  $result = eval {
  path_basename('/foo/foo.txt');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'foo';
}

# ------------------------------------------------------------------------------
# t149 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 495
# ------------------------------------------------------------------------------

sub t149 {
  $result = eval {
  path_basename('/foo.bar.txt');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'foo.bar';
}

# ------------------------------------------------------------------------------
# t150 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 496
# ------------------------------------------------------------------------------

sub t150 {
  $result = eval {
  path_basename('/foo/bar.');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'bar';
}

# ------------------------------------------------------------------------------
# t151 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 497
# ------------------------------------------------------------------------------

sub t151 {
  $result = eval {
  path_basename('/foo/bar');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'bar';
}

# ------------------------------------------------------------------------------
# t152 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 498
# ------------------------------------------------------------------------------

sub t152 {
  $result = eval {
  path_basename('.bashrc');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '.bashrc';
}

# ------------------------------------------------------------------------------
# t153 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 499
# ------------------------------------------------------------------------------

sub t153 {
  $result = eval {
  path_basename('.bashrc.tmp');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '.bashrc';
}

# ------------------------------------------------------------------------------
# t154 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 500
# ------------------------------------------------------------------------------

sub t154 {
  $result = eval {
  path_basename('/no-dots');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'no-dots';
}

# ------------------------------------------------------------------------------
# t155 - Is not defined
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 517
# ------------------------------------------------------------------------------

sub t155 {
  $result = eval {
  path_ext(undef);
  };
  $@ and die $@;
  return defined $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t156 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 518
# ------------------------------------------------------------------------------

sub t156 {
  $result = eval {
  path_ext('foo.txt');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'txt';
}

# ------------------------------------------------------------------------------
# t157 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 519
# ------------------------------------------------------------------------------

sub t157 {
  $result = eval {
  path_ext('/foo.txt');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'txt';
}

# ------------------------------------------------------------------------------
# t158 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 520
# ------------------------------------------------------------------------------

sub t158 {
  $result = eval {
  path_ext('./foo.txt');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'txt';
}

# ------------------------------------------------------------------------------
# t159 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 521
# ------------------------------------------------------------------------------

sub t159 {
  $result = eval {
  path_ext('../foo.txt');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'txt';
}

# ------------------------------------------------------------------------------
# t160 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 522
# ------------------------------------------------------------------------------

sub t160 {
  $result = eval {
  path_ext('/foo/foo.txt');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'txt';
}

# ------------------------------------------------------------------------------
# t161 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 523
# ------------------------------------------------------------------------------

sub t161 {
  $result = eval {
  path_ext('/foo.bar.txt');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'txt';
}

# ------------------------------------------------------------------------------
# t162 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 524
# ------------------------------------------------------------------------------

sub t162 {
  $result = eval {
  path_ext('/foo/bar.');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '';
}

# ------------------------------------------------------------------------------
# t163 - Is not defined
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 525
# ------------------------------------------------------------------------------

sub t163 {
  $result = eval {
  path_ext('/foo/bar');
  };
  $@ and die $@;
  return defined $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t164 - Is not defined
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 526
# ------------------------------------------------------------------------------

sub t164 {
  $result = eval {
  path_ext('.bashrc');
  };
  $@ and die $@;
  return defined $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t165 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 527
# ------------------------------------------------------------------------------

sub t165 {
  $result = eval {
  path_ext('.bashrc.tmp');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'tmp';
}

# ------------------------------------------------------------------------------
# t166 - Is not defined
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 528
# ------------------------------------------------------------------------------

sub t166 {
  $result = eval {
  path_ext('/no-dots');
  };
  $@ and die $@;
  return defined $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t167 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 544
# ------------------------------------------------------------------------------

sub t167 {
  $result = eval {
  path_normalize('/');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '/';
}

# ------------------------------------------------------------------------------
# t168 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 545
# ------------------------------------------------------------------------------

sub t168 {
  $result = eval {
  path_normalize('/a/');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '/a';
}

# ------------------------------------------------------------------------------
# t169 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 546
# ------------------------------------------------------------------------------

sub t169 {
  $result = eval {
  path_normalize('/a/b/..');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '/a';
}

# ------------------------------------------------------------------------------
# t170 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 547
# ------------------------------------------------------------------------------

sub t170 {
  $result = eval {
  path_normalize('/a/../a');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '/a';
}

# ------------------------------------------------------------------------------
# t171 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 548
# ------------------------------------------------------------------------------

sub t171 {
  $result = eval {
  path_normalize('/a/../../a');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '/a';
}

# ------------------------------------------------------------------------------
# t172 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 549
# ------------------------------------------------------------------------------

sub t172 {
  $result = eval {
  path_normalize( "../../w/b/../s/x" );
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '../../w/s/x';
}

# ------------------------------------------------------------------------------
# t173 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 550
# ------------------------------------------------------------------------------

sub t173 {
  $result = eval {
  path_normalize( "u/n/w/" );
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'u/n/w';
}

# ------------------------------------------------------------------------------
# t174 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 551
# ------------------------------------------------------------------------------

sub t174 {
  $result = eval {
  path_normalize( "u/../w/b/../s" );
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'w/s';
}

# ------------------------------------------------------------------------------
# t175 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 552
# ------------------------------------------------------------------------------

sub t175 {
  $result = eval {
  path_normalize( "u//n" );
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'u/n';
}

# ------------------------------------------------------------------------------
# t176 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 553
# ------------------------------------------------------------------------------

sub t176 {
  $result = eval {
  path_normalize( "u//n/./f" );
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'u/n/f';
}

# ------------------------------------------------------------------------------
# t177 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 554
# ------------------------------------------------------------------------------

sub t177 {
  $result = eval {
  path_normalize( "http://t/u//n" );
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'http://t/u/n';
}

# ------------------------------------------------------------------------------
# t178 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 555
# ------------------------------------------------------------------------------

sub t178 {
  $result = eval {
  path_normalize( '/a/b/c/../../../d/e/f' );
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '/d/e/f';
}

# ------------------------------------------------------------------------------
# t179 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 556
# ------------------------------------------------------------------------------

sub t179 {
  $result = eval {
  path_normalize( './a' );
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq './a';
}

# ------------------------------------------------------------------------------
# t180 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 557
# ------------------------------------------------------------------------------

sub t180 {
  $result = eval {
  path_normalize( '/./a' );
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '/a';
}

# ------------------------------------------------------------------------------
# t181 - Is not defined
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 595
# ------------------------------------------------------------------------------

sub t181 {
  $result = eval {
  path_parent('');
  };
  $@ and die $@;
  return defined $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t182 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 596
# ------------------------------------------------------------------------------

sub t182 {
  $result = eval {
  path_parent('/');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '/';
}

# ------------------------------------------------------------------------------
# t183 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 597
# ------------------------------------------------------------------------------

sub t183 {
  $result = eval {
  path_parent('/a');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '/';
}

# ------------------------------------------------------------------------------
# t184 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 598
# ------------------------------------------------------------------------------

sub t184 {
  $result = eval {
  path_parent('/a/b/..');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '/';
}

# ------------------------------------------------------------------------------
# t185 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 599
# ------------------------------------------------------------------------------

sub t185 {
  $result = eval {
  path_parent('a');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '';
}

# ------------------------------------------------------------------------------
# t186 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 600
# ------------------------------------------------------------------------------

sub t186 {
  $result = eval {
  path_parent('a/b/');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'a';
}

# ------------------------------------------------------------------------------
# t187 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 601
# ------------------------------------------------------------------------------

sub t187 {
  $result = eval {
  path_parent('a/b.c');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'a';
}

# ------------------------------------------------------------------------------
# t188 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 602
# ------------------------------------------------------------------------------

sub t188 {
  $result = eval {
  path_parent('../../a');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '../..';
}

# ------------------------------------------------------------------------------
# t189 - Is not defined
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 614
# ------------------------------------------------------------------------------

sub t189 {
  $result = eval {
  path_name('');
  };
  $@ and die $@;
  return defined $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t190 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 615
# ------------------------------------------------------------------------------

sub t190 {
  $result = eval {
  path_name('/');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '';
}

# ------------------------------------------------------------------------------
# t191 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 616
# ------------------------------------------------------------------------------

sub t191 {
  $result = eval {
  path_name('/a');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'a';
}

# ------------------------------------------------------------------------------
# t192 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 617
# ------------------------------------------------------------------------------

sub t192 {
  $result = eval {
  path_name('/a/b/..');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'a';
}

# ------------------------------------------------------------------------------
# t193 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 618
# ------------------------------------------------------------------------------

sub t193 {
  $result = eval {
  path_name('a/b/');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'b';
}

# ------------------------------------------------------------------------------
# t194 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 619
# ------------------------------------------------------------------------------

sub t194 {
  $result = eval {
  path_name('a/b.c');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'b.c';
}

# ------------------------------------------------------------------------------
# t195 - True
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 631
# ------------------------------------------------------------------------------

sub t195 {
  $result = eval {
  path_is_absolute('/a');
  };
  $@ and die $@;
  return $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t196 - True
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 632
# ------------------------------------------------------------------------------

sub t196 {
  $result = eval {
  path_is_absolute('A:/b');
  };
  $@ and die $@;
  return $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t197 - True
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 633
# ------------------------------------------------------------------------------

sub t197 {
  $result = eval {
  path_is_absolute('/a/b');
  };
  $@ and die $@;
  return $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t198 - True
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 634
# ------------------------------------------------------------------------------

sub t198 {
  $result = eval {
  path_is_absolute('http://a');
  };
  $@ and die $@;
  return $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t199 - True
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 635
# ------------------------------------------------------------------------------

sub t199 {
  $result = eval {
  path_is_absolute('svn+ssh://a.b');
  };
  $@ and die $@;
  return $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t200 - False
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 636
# ------------------------------------------------------------------------------

sub t200 {
  $result = eval {
  path_is_absolute('');
  };
  $@ and die $@;
  return $result ? 0 : 1;
}

# ------------------------------------------------------------------------------
# t201 - False
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 637
# ------------------------------------------------------------------------------

sub t201 {
  $result = eval {
  path_is_absolute('a/b');
  };
  $@ and die $@;
  return $result ? 0 : 1;
}

# ------------------------------------------------------------------------------
# t202 - False
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 638
# ------------------------------------------------------------------------------

sub t202 {
  $result = eval {
  path_is_absolute('a:\\b');
  };
  $@ and die $@;
  return $result ? 0 : 1;
}

# ------------------------------------------------------------------------------
# t203 - False
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 639
# ------------------------------------------------------------------------------

sub t203 {
  $result = eval {
  path_is_absolute('a/../b');
  };
  $@ and die $@;
  return $result ? 0 : 1;
}

# ------------------------------------------------------------------------------
# t204 - False
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 640
# ------------------------------------------------------------------------------

sub t204 {
  $result = eval {
  path_is_absolute('../a');
  };
  $@ and die $@;
  return $result ? 0 : 1;
}

# ------------------------------------------------------------------------------
# t205 - False
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 641
# ------------------------------------------------------------------------------

sub t205 {
  $result = eval {
  path_is_absolute('./a');
  };
  $@ and die $@;
  return $result ? 0 : 1;
}

# ------------------------------------------------------------------------------
# t206 - False
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 642
# ------------------------------------------------------------------------------

sub t206 {
  $result = eval {
  path_is_absolute('svn+ssh//a.b');
  };
  $@ and die $@;
  return $result ? 0 : 1;
}

# ------------------------------------------------------------------------------
# t207 - False
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 643
# ------------------------------------------------------------------------------

sub t207 {
  $result = eval {
  path_is_absolute('1://');
  };
  $@ and die $@;
  return $result ? 0 : 1;
}

# ------------------------------------------------------------------------------
# t208 - False
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 644
# ------------------------------------------------------------------------------

sub t208 {
  $result = eval {
  path_is_absolute('+://');
  };
  $@ and die $@;
  return $result ? 0 : 1;
}

# ------------------------------------------------------------------------------
# t209 - True
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 923
# ------------------------------------------------------------------------------

sub t209 {
  $result = eval {
  dir_is_system('.svn', '/tmp');
  };
  $@ and die $@;
  return $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t210 - True
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 924
# ------------------------------------------------------------------------------

sub t210 {
  $result = eval {
  dir_is_system('.git', '/tmp');
  };
  $@ and die $@;
  return $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t211 - False
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 925
# ------------------------------------------------------------------------------

sub t211 {
  $result = eval {
  dir_is_system('.Svn', '/tmp');
  };
  $@ and die $@;
  return $result ? 0 : 1;
}

# ------------------------------------------------------------------------------
# t212 - Is not defined
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/Hub/Util.pm line: 926
# ------------------------------------------------------------------------------

sub t212 {
  $result = eval {
  dir_is_system(undef, undef);
  };
  $@ and die $@;
  return defined $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t213 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/OrderedHash.pm line: 111
# ------------------------------------------------------------------------------

sub t213 {
  $result = eval {
  my %h = ();
  tie %h, 'Data::OrderedHash';
  $h{'first'} = "Apple";
  $h{'second'} = "Cherry";
  $h{'third'} = "Banana";
  join ';', values %h;
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'Apple;Cherry;Banana';
}

# ------------------------------------------------------------------------------
# t214 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/OrderedHash.pm line: 120
# ------------------------------------------------------------------------------

sub t214 {
  $result = eval {
  my $h = Data::OrderedHash->new();
  %$h = qw(a A b B c C);
  $$h{'a'} = 'X';
  join '', %$h;
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'aXbBcC';
}

# ------------------------------------------------------------------------------
# t215 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Data/OrderedHash.pm line: 127
# ------------------------------------------------------------------------------

sub t215 {
  $result = eval {
  my $h = Data::OrderedHash->new();
  $h->{'z'} = "Apple";
  $h->{'x'} = "Banana";
  $h->{'y'} = "Cherry";
  my $r = '';
  while (my ($k, $v) = each %$h) { $r .= $k; delete $$h{$k} }
  $h->{'w'} = "Can't elope";
  $r .= join('', keys %$h);
  $r;
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'zxyw';
}

# ------------------------------------------------------------------------------
# t216 - Abort
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Error/Logical.pm line: 9
# ------------------------------------------------------------------------------

sub t216 {
  no warnings 'closure';  # allows one test case to setup subroutines for 
                          # subsequent tests.
  $result = eval {
  use Error::Logical;
  throw Error::DoesNotExist 'some resource';
  };
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t217 - Abort
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Error/Programatic.pm line: 12
# ------------------------------------------------------------------------------

sub t217 {
  no warnings 'closure';  # allows one test case to setup subroutines for 
                          # subsequent tests.
  $result = eval {
  use Error::Programatic;
  throw Error::NotStatic;
  };
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t218 - Does not abort
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Misc/LogUtil.pm line: 15
# ------------------------------------------------------------------------------

sub t218 {
  no warnings 'closure';  # allows one test case to setup subroutines for 
                          # subsequent tests.
  $result = eval {
  use Misc::LogUtil;
  Misc::LogUtil->new();
  };
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t219 - Does not abort
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Misc/Stopwatch.pm line: 10
# ------------------------------------------------------------------------------

sub t219 {
  no warnings 'closure';  # allows one test case to setup subroutines for 
                          # subsequent tests.
  $result = eval {
  use Misc::Stopwatch;
  };
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t220 - True
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Misc/Stopwatch.pm line: 11
# ------------------------------------------------------------------------------

sub t220 {
  $result = eval {
  my $sw = Misc::Stopwatch->new();
  };
  $@ and die $@;
  return $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t221 - Does not abort
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Misc/Stopwatch.pm line: 25
# ------------------------------------------------------------------------------

sub t221 {
  no warnings 'closure';  # allows one test case to setup subroutines for 
                          # subsequent tests.
  $result = eval {
  my $sw = Misc::Stopwatch->new()->start();
  };
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t222 - Does not abort
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Misc/Stopwatch.pm line: 41
# ------------------------------------------------------------------------------

sub t222 {
  no warnings 'closure';  # allows one test case to setup subroutines for 
                          # subsequent tests.
  $result = eval {
  my $sw = Misc::Stopwatch->new()->start()->lap();
  };
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t223 - Does not abort
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Misc/Stopwatch.pm line: 54
# ------------------------------------------------------------------------------

sub t223 {
  no warnings 'closure';  # allows one test case to setup subroutines for 
                          # subsequent tests.
  $result = eval {
  my $sw = Misc::Stopwatch->new()->start()->stop();
  };
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t224 - True
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Misc/Stopwatch.pm line: 76
# ------------------------------------------------------------------------------

sub t224 {
  $result = eval {
  Misc::Stopwatch->new()->start()->elapsed();
  };
  $@ and die $@;
  return $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t225 - Does not abort
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Misc/Stopwatch.pm line: 97
# ------------------------------------------------------------------------------

sub t225 {
  no warnings 'closure';  # allows one test case to setup subroutines for 
                          # subsequent tests.
  $result = eval {
  my $sw = Misc::Stopwatch->new()->reset();
  };
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t226 - False
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Misc/Stopwatch.pm line: 111
# ------------------------------------------------------------------------------

sub t226 {
  $result = eval {
  Misc::Stopwatch->new()->is_running();
  };
  $@ and die $@;
  return $result ? 0 : 1;
}

# ------------------------------------------------------------------------------
# t227 - True
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Misc/Stopwatch.pm line: 112
# ------------------------------------------------------------------------------

sub t227 {
  $result = eval {
  Misc::Stopwatch->new()->start()->is_running();
  };
  $@ and die $@;
  return $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t228 - Does not abort
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Misc/Time.pm line: 88
# ------------------------------------------------------------------------------

sub t228 {
  no warnings 'closure';  # allows one test case to setup subroutines for 
                          # subsequent tests.
  $result = eval {
  use Misc::Time qw(:all);
  };
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t229 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Misc/Time.pm line: 89
# ------------------------------------------------------------------------------

sub t229 {
  $result = eval {
  time_apr_to_hires('1193094188212812');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '1193094188.212812';
}

# ------------------------------------------------------------------------------
# t230 - Does not abort
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Parse/Padding.pm line: 31
# ------------------------------------------------------------------------------

sub t230 {
  no warnings 'closure';  # allows one test case to setup subroutines for 
                          # subsequent tests.
  $result = eval {
  use Parse::Padding qw(padding);
  };
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t231 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Parse/Padding.pm line: 33
# ------------------------------------------------------------------------------

sub t231 {
  $result = eval {
  my $str = "    a   ";
  join ';', padding(\$str, 4, 5);
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '4;3';
}

# ------------------------------------------------------------------------------
# t232 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Parse/Padding.pm line: 37
# ------------------------------------------------------------------------------

sub t232 {
  $result = eval {
  my $str = " \na\r\n ";
  join ';', padding(\$str, 2, 3);
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '2;3';
}

# ------------------------------------------------------------------------------
# t233 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Parse/Padding.pm line: 41
# ------------------------------------------------------------------------------

sub t233 {
  $result = eval {
  my $str = " \na\r\n ";
  join ';', padding(\$str, 2, 3, -crlf);
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '1;2';
}

# ------------------------------------------------------------------------------
# t234 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Parse/Padding.pm line: 45
# ------------------------------------------------------------------------------

sub t234 {
  $result = eval {
  my $str = " \n\na\r\n\r\n ";
  join ';', padding(\$str, 3, 4, -crlf);
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '1;2';
}

# ------------------------------------------------------------------------------
# t235 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Parse/Padding.pm line: 49
# ------------------------------------------------------------------------------

sub t235 {
  $result = eval {
  my $str = " a ";
  join ';', padding(\$str, 1, 2, -crlf);
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '0;0';
}

# ------------------------------------------------------------------------------
# t236 - Does not abort
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Parse/Padding.pm line: 92
# ------------------------------------------------------------------------------

sub t236 {
  no warnings 'closure';  # allows one test case to setup subroutines for 
                          # subsequent tests.
  $result = eval {
  use Parse::Padding qw(trailing);
  };
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t237 - Abort
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Parse/Padding.pm line: 93
# ------------------------------------------------------------------------------

sub t237 {
  no warnings 'closure';  # allows one test case to setup subroutines for 
                          # subsequent tests.
  $result = eval {
  trailing('\r\n', " xxx\r\n", 'abc');
  };
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t238 - Abort
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Parse/Padding.pm line: 94
# ------------------------------------------------------------------------------

sub t238 {
  no warnings 'closure';  # allows one test case to setup subroutines for 
                          # subsequent tests.
  $result = eval {
  trailing('', " xxx\r\n", 4);
  };
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t239 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Parse/Padding.pm line: 95
# ------------------------------------------------------------------------------

sub t239 {
  $result = eval {
  trailing('\s', " xxx \r\n", 4);
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '3';
}

# ------------------------------------------------------------------------------
# t240 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Parse/Padding.pm line: 96
# ------------------------------------------------------------------------------

sub t240 {
  $result = eval {
  trailing('\r\n', " xxx \r\n", 4);
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '0';
}

# ------------------------------------------------------------------------------
# t241 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Parse/Padding.pm line: 97
# ------------------------------------------------------------------------------

sub t241 {
  $result = eval {
  trailing('\r\n', " xxx\r\n", 4);
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '2';
}

# ------------------------------------------------------------------------------
# t242 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Parse/Padding.pm line: 98
# ------------------------------------------------------------------------------

sub t242 {
  $result = eval {
  trailing('\r\n', " xxx\r\n", 999);
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '0';
}

# ------------------------------------------------------------------------------
# t243 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Parse/Padding.pm line: 99
# ------------------------------------------------------------------------------

sub t243 {
  $result = eval {
  trailing('\r\n', " xxx\r\n", -999);
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '0';
}

# ------------------------------------------------------------------------------
# t244 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Parse/Padding.pm line: 100
# ------------------------------------------------------------------------------

sub t244 {
  $result = eval {
  trailing('\r\n', "\r\n\r\n", 0, 1);
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '2';
}

# ------------------------------------------------------------------------------
# t245 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Parse/Padding.pm line: 101
# ------------------------------------------------------------------------------

sub t245 {
  $result = eval {
  trailing('\r\n', "\n\n\n", 0, 1);
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '1';
}

# ------------------------------------------------------------------------------
# t246 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Parse/Padding.pm line: 102
# ------------------------------------------------------------------------------

sub t246 {
  $result = eval {
  trailing('abcd', "a\na", 2, 1);
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '1';
}

# ------------------------------------------------------------------------------
# t247 - Does not abort
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Parse/Padding.pm line: 142
# ------------------------------------------------------------------------------

sub t247 {
  no warnings 'closure';  # allows one test case to setup subroutines for 
                          # subsequent tests.
  $result = eval {
  use Parse::Padding qw(leading);
  };
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t248 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Parse/Padding.pm line: 143
# ------------------------------------------------------------------------------

sub t248 {
  $result = eval {
  leading('\s', " xxx", 1);
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '1';
}

# ------------------------------------------------------------------------------
# t249 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Parse/Padding.pm line: 144
# ------------------------------------------------------------------------------

sub t249 {
  $result = eval {
  leading('\s', "\r \nxxx", 3);
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '3';
}

# ------------------------------------------------------------------------------
# t250 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Parse/Padding.pm line: 145
# ------------------------------------------------------------------------------

sub t250 {
  $result = eval {
  leading('\r\n', " xxx", 1);
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '0';
}

# ------------------------------------------------------------------------------
# t251 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Parse/Padding.pm line: 146
# ------------------------------------------------------------------------------

sub t251 {
  $result = eval {
  leading('\r\n', "\r\n\rxxx", 3);
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '3';
}

# ------------------------------------------------------------------------------
# t252 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Parse/Padding.pm line: 147
# ------------------------------------------------------------------------------

sub t252 {
  $result = eval {
  leading('\r\n', "\r\n\rxxx", -999);
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '0';
}

# ------------------------------------------------------------------------------
# t253 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Parse/Padding.pm line: 148
# ------------------------------------------------------------------------------

sub t253 {
  $result = eval {
  leading('\r\n', "\r\n\rxxx", 999);
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '0';
}

# ------------------------------------------------------------------------------
# t254 - Abort
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Parse/Padding.pm line: 149
# ------------------------------------------------------------------------------

sub t254 {
  no warnings 'closure';  # allows one test case to setup subroutines for 
                          # subsequent tests.
  $result = eval {
  leading('', "\r\n\rxxx", 3);
  };
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t255 - Abort
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Parse/Padding.pm line: 150
# ------------------------------------------------------------------------------

sub t255 {
  no warnings 'closure';  # allows one test case to setup subroutines for 
                          # subsequent tests.
  $result = eval {
  leading('\r\n', "\r\n\rxxx", 'abc');
  };
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t256 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Parse/Padding.pm line: 151
# ------------------------------------------------------------------------------

sub t256 {
  $result = eval {
  leading('abcd', "axe", 1, 1);
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '1';
}

# ------------------------------------------------------------------------------
# t257 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Parse/Padding.pm line: 152
# ------------------------------------------------------------------------------

sub t257 {
  $result = eval {
  leading('abcd', "\naxe", 2, 1);
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '1';
}

# ------------------------------------------------------------------------------
# t258 - Does not abort
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Parse/StringToken.pm line: 21
# ------------------------------------------------------------------------------

sub t258 {
  no warnings 'closure';  # allows one test case to setup subroutines for 
                          # subsequent tests.
  $result = eval {
  use Parse::StringToken qw(:all);
  };
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t259 - Abort
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Parse/StringToken.pm line: 44
# ------------------------------------------------------------------------------

sub t259 {
  no warnings 'closure';  # allows one test case to setup subroutines for 
                          # subsequent tests.
  $result = eval {
  str_token('', -contained => '123');
  };
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t260 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Parse/StringToken.pm line: 58
# ------------------------------------------------------------------------------

sub t260 {
  $result = eval {
  str_token("a b c")->shift;
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'a';
}

# ------------------------------------------------------------------------------
# t261 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Parse/StringToken.pm line: 59
# ------------------------------------------------------------------------------

sub t261 {
  $result = eval {
  my $s = str_token(q(one 'and a two' "and a three"));
  $s->shift; $s->shift;
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'and a two';
}

# ------------------------------------------------------------------------------
# t262 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Parse/StringToken.pm line: 82
# ------------------------------------------------------------------------------

sub t262 {
  $result = eval {
  str_token("a b c")->pop;
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'c';
}

# ------------------------------------------------------------------------------
# t263 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Parse/StringToken.pm line: 83
# ------------------------------------------------------------------------------

sub t263 {
  $result = eval {
  my $s = str_token(q(one 'and a two' "and a three"));
  $s->pop;
  $s->pop;
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'and a two';
}

# ------------------------------------------------------------------------------
# t264 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Parse/StringToken.pm line: 100
# ------------------------------------------------------------------------------

sub t264 {
  $result = eval {
  join('-', str_token("a b c")->split);
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'a-b-c';
}

# ------------------------------------------------------------------------------
# t265 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Parse/Template/Base.pm line: 962
# ------------------------------------------------------------------------------

sub t265 {
  $result = eval {
  use Parse::Template::Base;
  my $p = new Parse::Template::Base;
  my $text = '<<>>';
  my @pos = $p->substr_pos(\$text, '<', '>', 0);
  join ',', map {join '-', @$_} @pos;
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '0-3,1-2';
}

# ------------------------------------------------------------------------------
# t266 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Parse/Template/Base.pm line: 1063
# ------------------------------------------------------------------------------

sub t266 {
  $result = eval {
  use Parse::Template::Standard;
  my $t = 'Hello [#name]';
  my $p = new Parse::Template::Standard();
  my $o = $p->compile_text(\$t, {name => 'World'});
  return $$o;
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'Hello World';
}

# ------------------------------------------------------------------------------
# t267 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Parse/Template/Base.pm line: 1071
# ------------------------------------------------------------------------------

sub t267 {
  $result = eval {
  use Parse::Template::Standard;
  my $t = 'Hello [#name]';
  my $p = new Parse::Template::Standard();
  my $o = $p->compile_text(\$t, {name => '[#next]', next => 'World'});
  return $$o;
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'Hello World';
}

# ------------------------------------------------------------------------------
# t268 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Parse/Template/Base.pm line: 1079
# ------------------------------------------------------------------------------

sub t268 {
  $result = eval {
  use Parse::Template::Standard;
  my $t = 'Hello [#data/name]';
  my $p = new Parse::Template::Standard();
  my $o = $p->compile_text(\$t, {data => {name => 'World'}});
  return $$o;
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'Hello World';
}

# ------------------------------------------------------------------------------
# t269 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Parse/Template/Base.pm line: 1087
# ------------------------------------------------------------------------------

sub t269 {
  $result = eval {
  use Parse::Template::Standard;
  my $t = 'Hello [#[#name]]';
  my $p = new Parse::Template::Standard();
  my $o = $p->compile_text(\$t, {name => 'next', next => 'World'});
  return $$o;
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'Hello World';
}

# ------------------------------------------------------------------------------
# t270 - Does not abort
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Parse/Template/Web.pm line: 64
# ------------------------------------------------------------------------------

sub t270 {
  no warnings 'closure';  # allows one test case to setup subroutines for 
                          # subsequent tests.
  $result = eval {
  use Parse::Template::Web;
  };
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t271 - Does not abort
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Parse/Template/Web.pm line: 65
# ------------------------------------------------------------------------------

sub t271 {
  no warnings 'closure';  # allows one test case to setup subroutines for 
                          # subsequent tests.
  $result = eval {
  use Data::Hub;
  };
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t272 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Parse/Template/Web.pm line: 66
# ------------------------------------------------------------------------------

sub t272 {
  $result = eval {
  my $p = Parse::Template::Web->new(Data::Hub->new());
  $p->defang('a[#b]c');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'abc';
}

# ------------------------------------------------------------------------------
# t273 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Parse/Template/Web.pm line: 69
# ------------------------------------------------------------------------------

sub t273 {
  $result = eval {
  my $p = Parse::Template::Web->new(Data::Hub->new());
  my $r = $p->defang(['a[#b]c', 'a<b>c</d>e']);
  join('', @$r);
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'abcabc/de';
}

# ------------------------------------------------------------------------------
# t274 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Class.pm line: 69
# ------------------------------------------------------------------------------

sub t274 {
  $result = eval {
  package Foo;
  use Perl::Class;
  use base qw(Perl::Class::Hash);
  sub new {
    $_[0]->SUPER::new(1 => 2, 'odd');
  }
  1;
  package main;
  my $c = Foo->new();
  $c->{3} = 4;
  join ':', (keys %$c, '|', sort keys %{$c->__});
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '3:|:1:odd';
}

# ------------------------------------------------------------------------------
# t275 - False
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Comparison.pm line: 125
# ------------------------------------------------------------------------------

sub t275 {
  $result = eval {
  compare('eq','',undef);
  };
  $@ and die $@;
  return $result ? 0 : 1;
}

# ------------------------------------------------------------------------------
# t276 - True
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Comparison.pm line: 126
# ------------------------------------------------------------------------------

sub t276 {
  $result = eval {
  compare('eq','abc','abc');
  };
  $@ and die $@;
  return $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t277 - True
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Comparison.pm line: 127
# ------------------------------------------------------------------------------

sub t277 {
  $result = eval {
  compare('ne','abc','Abc');
  };
  $@ and die $@;
  return $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t278 - False
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Comparison.pm line: 128
# ------------------------------------------------------------------------------

sub t278 {
  $result = eval {
  compare('eq','abc',undef);
  };
  $@ and die $@;
  return $result ? 0 : 1;
}

# ------------------------------------------------------------------------------
# t279 - True
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Comparison.pm line: 129
# ------------------------------------------------------------------------------

sub t279 {
  $result = eval {
  compare('!~','abc','A');
  };
  $@ and die $@;
  return $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t280 - True
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Comparison.pm line: 130
# ------------------------------------------------------------------------------

sub t280 {
  $result = eval {
  compare('=~','abc','a');
  };
  $@ and die $@;
  return $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t281 - True
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Comparison.pm line: 131
# ------------------------------------------------------------------------------

sub t281 {
  $result = eval {
  compare('==',1234,1234);
  };
  $@ and die $@;
  return $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t282 - True
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Comparison.pm line: 132
# ------------------------------------------------------------------------------

sub t282 {
  $result = eval {
  compare('>=',1234,1234);
  };
  $@ and die $@;
  return $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t283 - True
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Comparison.pm line: 133
# ------------------------------------------------------------------------------

sub t283 {
  $result = eval {
  compare('eqic','abc','Abc');
  };
  $@ and die $@;
  return $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t284 - True
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Comparison.pm line: 134
# ------------------------------------------------------------------------------

sub t284 {
  $result = eval {
  compare('==',undef,undef);
  };
  $@ and die $@;
  return $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t285 - False
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Comparison.pm line: 135
# ------------------------------------------------------------------------------

sub t285 {
  $result = eval {
  compare('==',0,undef);
  };
  $@ and die $@;
  return $result ? 0 : 1;
}

# ------------------------------------------------------------------------------
# t286 - False
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Comparison.pm line: 136
# ------------------------------------------------------------------------------

sub t286 {
  $result = eval {
  compare('!~i','abc','A');
  };
  $@ and die $@;
  return $result ? 0 : 1;
}

# ------------------------------------------------------------------------------
# t287 - True
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Comparison.pm line: 137
# ------------------------------------------------------------------------------

sub t287 {
  $result = eval {
  compare('=~i','abc','A');
  };
  $@ and die $@;
  return $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t288 - True
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Comparison.pm line: 138
# ------------------------------------------------------------------------------

sub t288 {
  $result = eval {
  compare('eqic','abc','Abc');
  };
  $@ and die $@;
  return $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t289 - False
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Comparison.pm line: 139
# ------------------------------------------------------------------------------

sub t289 {
  $result = eval {
  compare('neic','abc','Abc');
  };
  $@ and die $@;
  return $result ? 0 : 1;
}

# ------------------------------------------------------------------------------
# t290 - True
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Comparison.pm line: 140
# ------------------------------------------------------------------------------

sub t290 {
  $result = eval {
  compare('mod',4,2);
  };
  $@ and die $@;
  return $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t291 - True
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Comparison.pm line: 141
# ------------------------------------------------------------------------------

sub t291 {
  $result = eval {
  compare('bw','abc','a');
  };
  $@ and die $@;
  return $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t292 - False
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Comparison.pm line: 142
# ------------------------------------------------------------------------------

sub t292 {
  $result = eval {
  compare('bw','abc','b');
  };
  $@ and die $@;
  return $result ? 0 : 1;
}

# ------------------------------------------------------------------------------
# t293 - False
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Comparison.pm line: 143
# ------------------------------------------------------------------------------

sub t293 {
  $result = eval {
  compare('ew','abc','b');
  };
  $@ and die $@;
  return $result ? 0 : 1;
}

# ------------------------------------------------------------------------------
# t294 - True
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Comparison.pm line: 144
# ------------------------------------------------------------------------------

sub t294 {
  $result = eval {
  compare('ew','abc','c');
  };
  $@ and die $@;
  return $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t295 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Comparison.pm line: 158
# ------------------------------------------------------------------------------

sub t295 {
  $result = eval {
  my @numbers = ( 20, 1, 10, 2 );
  join ';', sort { &sort_compare('<=>',$a,$b) } @numbers;
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '1;2;10;20';
}

# ------------------------------------------------------------------------------
# t296 - Does not abort
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Comparison.pm line: 180
# ------------------------------------------------------------------------------

sub t296 {
  no warnings 'closure';  # allows one test case to setup subroutines for 
                          # subsequent tests.
  $result = eval {
  use Perl::Comparison qw(sort_keydepth);
  };
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t297 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Comparison.pm line: 182
# ------------------------------------------------------------------------------

sub t297 {
  $result = eval {
  join ';', sort {&sort_keydepth($a, $b)} qw(t/w/o o/ne th/r/e/e);
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'o/ne;t/w/o;th/r/e/e';
}

# ------------------------------------------------------------------------------
# t298 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Comparison.pm line: 186
# ------------------------------------------------------------------------------

sub t298 {
  $result = eval {
  no warnings 'uninitialized';
  join ';', sort {&sort_keydepth($a, $b)} (qw(t/w/o o/ne none th/r/e/e), undef);
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq ';none;o/ne;t/w/o;th/r/e/e';
}

# ------------------------------------------------------------------------------
# t299 - Does not abort
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Module.pm line: 16
# ------------------------------------------------------------------------------

sub t299 {
  no warnings 'closure';  # allows one test case to setup subroutines for 
                          # subsequent tests.
  $result = eval {
  use Perl::Module;
  };
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t300 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Module.pm line: 17
# ------------------------------------------------------------------------------

sub t300 {
  $result = eval {
  join "\n", sort @Perl::Module::EXPORT;
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'Dumper
blessed
bytesize
can
carp
checksum
clone
cluck
compare
confess
croak
gettimeofday
grep_first
grep_first_index
index_imatch
index_match
index_unescaped
int_div
is_numeric
isa
max
min
my_opts
overlay
push_uniq
reftype
sleep
sort_compare
sort_keydepth
stat
str_ref
strftime
strptime
time
tv_interval
unshift_uniq
warnf';
}

# ------------------------------------------------------------------------------
# t301 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Options.pm line: 29
# ------------------------------------------------------------------------------

sub t301 {
  $result = eval {
  my $sub = sub {
    my ($opts, @argv) = my_opts(\@_);
    my $ret = join(',', sort(@_));
    $ret .= ';' . join(',', sort keys %$opts);
    return $ret;
  };
  &$sub('a', 'b', '-opt1', -opt2 => 'See', '-opt3=0');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'a,b;opt1,opt2,opt3';
}

# ------------------------------------------------------------------------------
# t302 - Does not abort
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Util.pm line: 58
# ------------------------------------------------------------------------------

sub t302 {
  no warnings 'closure';  # allows one test case to setup subroutines for 
                          # subsequent tests.
  $result = eval {
  use Perl::Util qw(:all);
  };
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t303 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Util.pm line: 92
# ------------------------------------------------------------------------------

sub t303 {
  $result = eval {
  my $a = str_ref("a"); $$a;
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'a';
}

# ------------------------------------------------------------------------------
# t304 - True
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Util.pm line: 128
# ------------------------------------------------------------------------------

sub t304 {
  $result = eval {
  is_numeric('-1');
  };
  $@ and die $@;
  return $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t305 - True
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Util.pm line: 129
# ------------------------------------------------------------------------------

sub t305 {
  $result = eval {
  is_numeric('0');
  };
  $@ and die $@;
  return $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t306 - True
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Util.pm line: 130
# ------------------------------------------------------------------------------

sub t306 {
  $result = eval {
  is_numeric('+1');
  };
  $@ and die $@;
  return $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t307 - True
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Util.pm line: 131
# ------------------------------------------------------------------------------

sub t307 {
  $result = eval {
  is_numeric('3.14');
  };
  $@ and die $@;
  return $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t308 - True
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Util.pm line: 132
# ------------------------------------------------------------------------------

sub t308 {
  $result = eval {
  is_numeric('6.02214E23');
  };
  $@ and die $@;
  return $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t309 - True
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Util.pm line: 133
# ------------------------------------------------------------------------------

sub t309 {
  $result = eval {
  is_numeric('6.626068e-34');
  };
  $@ and die $@;
  return $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t310 - False
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Util.pm line: 134
# ------------------------------------------------------------------------------

sub t310 {
  $result = eval {
  is_numeric('3.1.4');
  };
  $@ and die $@;
  return $result ? 0 : 1;
}

# ------------------------------------------------------------------------------
# t311 - False
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Util.pm line: 135
# ------------------------------------------------------------------------------

sub t311 {
  $result = eval {
  is_numeric('');
  };
  $@ and die $@;
  return $result ? 0 : 1;
}

# ------------------------------------------------------------------------------
# t312 - False
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Util.pm line: 136
# ------------------------------------------------------------------------------

sub t312 {
  $result = eval {
  is_numeric('three');
  };
  $@ and die $@;
  return $result ? 0 : 1;
}

# ------------------------------------------------------------------------------
# t313 - False
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Util.pm line: 137
# ------------------------------------------------------------------------------

sub t313 {
  $result = eval {
  is_numeric(undef);
  };
  $@ and die $@;
  return $result ? 0 : 1;
}

# ------------------------------------------------------------------------------
# t314 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Util.pm line: 151
# ------------------------------------------------------------------------------

sub t314 {
  $result = eval {
  join('r',int_div(3,2));
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '1r1';
}

# ------------------------------------------------------------------------------
# t315 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Util.pm line: 152
# ------------------------------------------------------------------------------

sub t315 {
  $result = eval {
  join('r',int_div(3.9,2));
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '1r1';
}

# ------------------------------------------------------------------------------
# t316 - Abort
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Util.pm line: 153
# ------------------------------------------------------------------------------

sub t316 {
  no warnings 'closure';  # allows one test case to setup subroutines for 
                          # subsequent tests.
  $result = eval {
  int_div(3,0);
  };
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t317 - Abort
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Util.pm line: 154
# ------------------------------------------------------------------------------

sub t317 {
  no warnings 'closure';  # allows one test case to setup subroutines for 
                          # subsequent tests.
  $result = eval {
  int_div('three',1);
  };
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t318 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Util.pm line: 167
# ------------------------------------------------------------------------------

sub t318 {
  $result = eval {
  grep_first {/a/} qw(apple banana cherry);
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'apple';
}

# ------------------------------------------------------------------------------
# t319 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Util.pm line: 185
# ------------------------------------------------------------------------------

sub t319 {
  $result = eval {
  grep_first_index {/a/} qw(apple banana cherry);
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '0';
}

# ------------------------------------------------------------------------------
# t320 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Util.pm line: 252
# ------------------------------------------------------------------------------

sub t320 {
  $result = eval {
  index_match("abracadabra", "[cd]")
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '4';
}

# ------------------------------------------------------------------------------
# t321 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Util.pm line: 253
# ------------------------------------------------------------------------------

sub t321 {
  $result = eval {
  index_match("abracadabra", "a", 3)
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '3';
}

# ------------------------------------------------------------------------------
# t322 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Util.pm line: 254
# ------------------------------------------------------------------------------

sub t322 {
  $result = eval {
  index_match("abracadabra", "d{2,2}")
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '-1';
}

# ------------------------------------------------------------------------------
# t323 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Util.pm line: 255
# ------------------------------------------------------------------------------

sub t323 {
  $result = eval {
  my ($p, $str) = index_match("scant", "can");
  $p + length($str);
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '4';
}

# ------------------------------------------------------------------------------
# t324 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Util.pm line: 257
# ------------------------------------------------------------------------------

sub t324 {
  $result = eval {
  index_match("foobar foo bar", '\bfoo\b') # zero-width test
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '7';
}

# ------------------------------------------------------------------------------
# t325 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Util.pm line: 258
# ------------------------------------------------------------------------------

sub t325 {
  $result = eval {
  index_match("foobar foo bar", 'Bar') # no-match
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '-1';
}

# ------------------------------------------------------------------------------
# t326 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Util.pm line: 259
# ------------------------------------------------------------------------------

sub t326 {
  $result = eval {
  index_match("aa", "a")
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '0';
}

# ------------------------------------------------------------------------------
# t327 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Util.pm line: 260
# ------------------------------------------------------------------------------

sub t327 {
  $result = eval {
  index_match("aa", "a", 1)
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '1';
}

# ------------------------------------------------------------------------------
# t328 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Util.pm line: 271
# ------------------------------------------------------------------------------

sub t328 {
  $result = eval {
  index_imatch("foobar foo bar", 'Bar') # Case insensitive match
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '3';
}

# ------------------------------------------------------------------------------
# t329 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Util.pm line: 272
# ------------------------------------------------------------------------------

sub t329 {
  $result = eval {
  index_imatch(" b\n a", '\s*a') # Case insensitive match
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '2';
}

# ------------------------------------------------------------------------------
# t330 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Util.pm line: 302
# ------------------------------------------------------------------------------

sub t330 {
  $result = eval {
  checksum('“Hello”', 'world');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '1625030915';
}

# ------------------------------------------------------------------------------
# t331 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Util.pm line: 321
# ------------------------------------------------------------------------------

sub t331 {
  $result = eval {
  bytesize(10)
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '10 B';
}

# ------------------------------------------------------------------------------
# t332 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Util.pm line: 322
# ------------------------------------------------------------------------------

sub t332 {
  $result = eval {
  bytesize(11028)
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '10.77 KB';
}

# ------------------------------------------------------------------------------
# t333 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Util.pm line: 323
# ------------------------------------------------------------------------------

sub t333 {
  $result = eval {
  bytesize(1000 ** 3, -precision => 4)
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '953.6743 MB';
}

# ------------------------------------------------------------------------------
# t334 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Util.pm line: 324
# ------------------------------------------------------------------------------

sub t334 {
  $result = eval {
  bytesize(2 ** 30)
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '1 GB';
}

# ------------------------------------------------------------------------------
# t335 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Util.pm line: 325
# ------------------------------------------------------------------------------

sub t335 {
  $result = eval {
  bytesize(2 ** 59, -binary_symbol)
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '512 PiB';
}

# ------------------------------------------------------------------------------
# t336 - Is not defined
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Util.pm line: 357
# ------------------------------------------------------------------------------

sub t336 {
  $result = eval {
  reftype(undef)
  };
  $@ and die $@;
  return defined $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t337 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Util.pm line: 358
# ------------------------------------------------------------------------------

sub t337 {
  $result = eval {
  reftype('')
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '';
}

# ------------------------------------------------------------------------------
# t338 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Util.pm line: 359
# ------------------------------------------------------------------------------

sub t338 {
  $result = eval {
  reftype({})
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'HASH';
}

# ------------------------------------------------------------------------------
# t339 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Util.pm line: 360
# ------------------------------------------------------------------------------

sub t339 {
  $result = eval {
  reftype([])
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'ARRAY';
}

# ------------------------------------------------------------------------------
# t340 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Util.pm line: 361
# ------------------------------------------------------------------------------

sub t340 {
  $result = eval {
  my $a = ''; reftype(\$a)
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'SCALAR';
}

# ------------------------------------------------------------------------------
# t341 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Util.pm line: 362
# ------------------------------------------------------------------------------

sub t341 {
  $result = eval {
  my $a = ''; my $b = \$a; reftype(\$b)
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'REF';
}

# ------------------------------------------------------------------------------
# t342 - True
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Util.pm line: 374
# ------------------------------------------------------------------------------

sub t342 {
  $result = eval {
  isa({}, 'HASH')
  };
  $@ and die $@;
  return $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t343 - True
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/Perl/Util.pm line: 375
# ------------------------------------------------------------------------------

sub t343 {
  $result = eval {
  isa([], 'ARRAY')
  };
  $@ and die $@;
  return $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t344 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/WWW/Livesite/Args.pm line: 86
# ------------------------------------------------------------------------------

sub t344 {
  $result = eval {
  use WWW::Livesite::Args;
  my $qs = WWW::Livesite::Args->new('msg=hello%20world');
  die if defined $qs->{MSG};
  return $qs->{msg};
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'hello world';
}

# ------------------------------------------------------------------------------
# t345 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/WWW/Livesite/Args.pm line: 93
# ------------------------------------------------------------------------------

sub t345 {
  $result = eval {
  use WWW::Livesite::Args;
  my $qs = WWW::Livesite::Args->new('a=1&a=2');
  my $a = $qs->{a};
  return join '|', @$a;
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '1|2';
}

# ------------------------------------------------------------------------------
# t346 - Does not abort
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/WWW/Misc/Image.pm line: 197
# ------------------------------------------------------------------------------

sub t346 {
  no warnings 'closure';  # allows one test case to setup subroutines for 
                          # subsequent tests.
  $result = eval {
  use WWW::Misc::Image qw(resize_str_to_props);
  };
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t347 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/WWW/Misc/Image.pm line: 198
# ------------------------------------------------------------------------------

sub t347 {
  $result = eval {
  my $props = resize_str_to_props('800');
  join(';', map { $_ . '=' . $$props{$_} } sort keys %$props);
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'max_x=800;max_y=0;min_x=0;min_y=0';
}

# ------------------------------------------------------------------------------
# t348 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/WWW/Misc/Image.pm line: 202
# ------------------------------------------------------------------------------

sub t348 {
  $result = eval {
  my $props = resize_str_to_props('800x600');
  join(';', map { $_ . '=' . $$props{$_} } sort keys %$props);
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'max_x=800;max_y=600;min_x=0;min_y=0';
}

# ------------------------------------------------------------------------------
# t349 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/WWW/Misc/Image.pm line: 206
# ------------------------------------------------------------------------------

sub t349 {
  $result = eval {
  my $props = resize_str_to_props('800x600/480');
  join(';', map { $_ . '=' . $$props{$_} } sort keys %$props);
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'max_x=800;max_y=600;min_x=480;min_y=0';
}

# ------------------------------------------------------------------------------
# t350 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/WWW/Misc/Image.pm line: 210
# ------------------------------------------------------------------------------

sub t350 {
  $result = eval {
  my $props = resize_str_to_props('800/480');
  join(';', map { $_ . '=' . $$props{$_} } sort keys %$props);
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'max_x=800;max_y=0;min_x=480;min_y=0';
}

# ------------------------------------------------------------------------------
# t351 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/WWW/Misc/Image.pm line: 214
# ------------------------------------------------------------------------------

sub t351 {
  $result = eval {
  my $props = resize_str_to_props('100/z');
  join(';', map { $_ . '=' . $$props{$_} } sort keys %$props);
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'flags=z;max_x=100;max_y=0;min_x=0;min_y=0';
}

# ------------------------------------------------------------------------------
# t352 - Does not abort
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/WWW/Misc/Image.pm line: 244
# ------------------------------------------------------------------------------

sub t352 {
  no warnings 'closure';  # allows one test case to setup subroutines for 
                          # subsequent tests.
  $result = eval {
  use WWW::Misc::Image qw(props_to_resize_str);
  };
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t353 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/WWW/Misc/Image.pm line: 245
# ------------------------------------------------------------------------------

sub t353 {
  $result = eval {
  props_to_resize_str({max_x => 800});
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '800';
}

# ------------------------------------------------------------------------------
# t354 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/WWW/Misc/Image.pm line: 246
# ------------------------------------------------------------------------------

sub t354 {
  $result = eval {
  props_to_resize_str({max_x => 800, max_y => 600});
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '800x600';
}

# ------------------------------------------------------------------------------
# t355 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/WWW/Misc/Image.pm line: 247
# ------------------------------------------------------------------------------

sub t355 {
  $result = eval {
  props_to_resize_str({max_x => 800, min_x => 480});
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '800/480';
}

# ------------------------------------------------------------------------------
# t356 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/WWW/Misc/Image.pm line: 248
# ------------------------------------------------------------------------------

sub t356 {
  $result = eval {
  props_to_resize_str({max_x => 100, max_y => 100,min_x => 100, min_y => 100});
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '100x100/100x100';
}

# ------------------------------------------------------------------------------
# t357 - Match
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/WWW/Misc/Image.pm line: 250
# ------------------------------------------------------------------------------

sub t357 {
  $result = eval {
  props_to_resize_str({max_x => 100, flags => 'z'});
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '100/z';
}

# ------------------------------------------------------------------------------
# t358 - Does not abort
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/WWW/Misc/Image.pm line: 301
# ------------------------------------------------------------------------------

sub t358 {
  no warnings 'closure';  # allows one test case to setup subroutines for 
                          # subsequent tests.
  $result = eval {
  use WWW::Misc::Image qw(image_dims);
  };
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t359 - False
# Generated from /home/ryan/lsn/lsn-data-hub/out/lsn-data-hub-05.00293/lib/WWW/Misc/Image.pm line: 302
# ------------------------------------------------------------------------------

sub t359 {
  $result = eval {
  image_dims("/foo");
  };
  $@ and die $@;
  return $result ? 0 : 1;
}

