package Bundle::Math::Big;
use strict;
use warnings;

$VERSION = '1.00';

1;

__END__

=head1 NAME

Bundle::Math::Big - Bundle of modules related to arbitrary size numbers

=head1 SYNOPSIS

 perl -MCPAN -e 'install Bundle::Math::Big'

=head1 CONTENTS

bignum

Math::Big

Math::BigFloat

Math::BigInt

Math::BigInt::BitVect

Math::BigInt::Constant

Math::BigInt::FastCalc

Math::BigInt::GMP

Math::BigInt::Lite

Math::BigInt::Named

Math::BigInt::Pari

Math::BigRat

Math::Fleximal

Math::FixedPrecision

Math::Fraction

Math::NoCarry

Math::SigFigs

=head1 DESCRIPTION

This is a bundle of modules related to arbitrary size numbers. This also
includes arbitrary precision number modules.

Please have a look at L<Bundle::Math>.

If you would like to see a specific module included in a future version of
this bundle, please send me an email or use rt.cpan.org.

=head1 AUTHOR

Steffen Mueller E<lt>bundlemath-module at steffen-mueller dot netE<gt>

=cut 
