#!perl -w
use strict;

use Imager;
use FindBin;
use lib $FindBin::Bin;
use Tester;
use Test::More;

my $data;
{
	local $/ = undef;
	$data = <DATA>;
}	

my $test_image = Imager->new;
$test_image->open( data => $data, , type=>'jpeg' );




Tester::test_package('Acme::Steganography::Image::Png::RGB::556', $test_image);
Tester::test_package('Acme::Steganography::Image::Png::RGB::323', $test_image);
Tester::test_package('Acme::Steganography::Image::Png::RGB::556FS',
		     $test_image);
__DATA__
Exif  MM *                  n       v(       1       ~2       <                  H      H     QuickTime 6.5.2 2005:03:12 10:28:01 Mac OS X 10.3.8                     (                               H      H      JFIF  H H   AppleMark
  

		
% #!,!#'(***.1-)1%)*(
	
(((((((((((((((((((((((((((((((((((((((((((((((((((          	
       	
   } !1AQa"q2#BR$3br	
%&'()*456789:CDEFGHIJSTUVWXYZcdefghijstuvwxyz  w !1AQaq"2B	#3Rbr
$4%&'()*56789:CDEFGHIJSTUVWXYZcdefghijstuvwxyz  _ "    ? Jb%!99fP<r2BvOQ]9@4cZsٓ*<sXʤc3ѣY^[)CNxDnFK>o,Ή<WY!cn@Sי 1%W	s)rc6HS!j!JIY&^Q/1N)Ю.ޗf'b1llݍheڨkd1{\nʝ;+嶍Q< 
&sigB	P0$=M /̦\æp{0]KȂtY09?3ԏAY:eq`^a\!rHJubildkdP	F\#j%mp 6&Ǵ]{ҹ)9m|
 ]R+oks\$\|LM9gxbR7*>B8Ol5i(3>Q}ўbO4	oa4_MS+Q*kkT 1ڡ4f8Vљu%)t-V0`WߪԞ"[;Dled$qzqf-[HLo#$]Gj犴YwlH^x>#[~UbV-Ü-^if bpOio$H0ǎ=?Z~@Ϫ1 sտ=hѻ3簩QJ63Z4j}[DR+ SZAj%a(E+J*q0b yz!JR[7mi/nE]9l#H=H]*X
ipElHIG
>:3s{)ҲuC;ԶVnY=ARxӠ0w*.YXa>}9"͇[2$)dSǪ>Mw*Dp۲[1 QgZ^"!0'>XZ0AU ?_95[-)eǚC00O?e:roByLU}ys,SK Y
3{Tr.{@T_~6WxKNФ=D~ۈHADʝu76k_L[01V__O՞w"əA>Ɛ'~q]ލt{5yl g^F}:Woi2ϧX,*vP͏7uǵgڝ2]ܺN%HE(*.T nIlar0ryd3Ҷ%MZBKuBF#A[z4km+r]mKt>ڸOjZmymp'bl\}ҥ?iX"ICذ2}"iN:T~cKf1h܂p}:k>"6m4mr=Pz%s-@_b28;}3+TAs}dr[ BtX iY2(7{{_KNe5g*ZSG)=&\<1GmwT)kN(hmPLpt[Z]j0jڛ2)i+X%b%hM;]LmCB/f󭧉J4MXKYoyJcje(;&J-uB^`2s,G~=)Gk~ugVN*m-;yjgԖy V*><jGc.rqg-ٓ^{s[7PijJ~y6jƮ>&Q
fzҵ弴F
NU9%Sn-(^Vrw[  9S؟JHS i+%"6wlT^KcCnAIѴ
vQ7$P˃0R9l~dgEmJ'J	j_ELtH!3L̘	WU⏌e.:$3wcןâ끡fWFwq@
[_~%Xm3\9ǥuCS˄Fqs1O"%K/lɢŚ̍!7#Wʅ tzYOmڄVw> v)gneAk;$J_ƹc_i$._Q^ٓJ1ۭ,~;nZ[7q>A:)Mth.-5/4-L0Cѽ+x:E~_/j˺lo7s.67H$tZ|Kf`H\SX8L#횖aB`N+hQ8r՚xRωbO;:zqҴ,CqG\4BB uO4=odyºSqYxv[m~&#v8:3M3sO@FpK{r;qVtoȚlui0=ڸ[6u)$3=\\
qm7}{QCvL[7qj7kqN ySxQCH:s59U8lkRGyʄ'5.ёO*3%n}CqhF.DL4'j,^E$y"y~v 3 =58y$L=T26zxoI>R3?vz.cݬSCt|b6=[--c_\TAt[Nb۾߃YqJѵir?WF׮IR6nR|8io'M4`	\s{TZVע3:`? ]uAӭKXޟ4l7"Q'Ho,a(۹WWl@8=?ҹMKDԡcXihQDIvM)}GCu)Wu%˳:cad<n@ <VW|	xL.S$mفQ\ǉu+8wIa6p=oº-"KtHY\gi+ZxU0ӂj>՞YaW"xќ\ szqۚE&y@8kk;%Y$ğl55VP-JHALj8jQ[M-KxYByC4ķMe`M62Nש5pmbڔ $`r7^p׺z4R<pmInOkPYAV$-o
r2<)<ufU7׵1^(i@SN´hJ'}+$T!N\XUݷ5[p#zC<cyۜհIgr_)RH9lviz.U"z󊣩$3bFXOT-0Bnd(>WgM;HoYe0279_N+/tmiVJݤ \Oݮ_񽍳DʵÒRLc 0s=
>+""8ۑ'vOdXb-Y2 9s3RSQrMfXO8}t1^O6z(*IGJm@]z;wsЋ͟4׊@2
ˑA$y<tvgeBt: P~enA,pKBba SB:Jࣃ\kDLmd ukS<c{vM,kp~e<``Wh=WP=_GzپXG*[
=;*s
<ĐW_(՝ў4+nSjo0[;Ü89:pzL/6*J7L㾟N$I=%{> ;Wge dkPy['^)N6d^smbMaq))alcj>o <V,GtiONquŷs k{r3W \`,ș#ۻH9P iRL3*@r{zd`.׼%
u#* ;m U{872!^3K{N7LJl	<`H3zAJgd=
|+0盷 sh\x	 TJN22=~5gmѝHS 7$C%Dk1]|F,R싇!XIϹMépj{Jn9W{ 'OoOQ^|Gu=hpV8^cJOG+>|2xXpGWw?Lfdmc<R?M#W?*$W1pkstOkzlv<+~SS=9ToV""@KE1t<!Hq	F.	`{z\ƒlgXZpeA ~x⥦blsf a@9SƤ1CRO`sߥ2JI8l}cZӒC,I(dцEŕf&V}?3a?(9 ƉFI\J;pz0ϧ_J4s*Q8?U)6"!,v;M'F2%3x+9<g<c-?-Rwo\:r1 w<rH~Y(9=`HdDѶ)gJUfOA(1+bF9Q<x k\>wYy129_{[wVX tߩ8ݥ!
pO^;ْ(xCÚ2mBtb pH'9 NH8"%sYFG,g;%2!qVqoϖc-@qSs,&PIĜϦ?''v]6B6[;Np.5$(qQ$  3UbWT߹c׀r:t,ei^4]sxn/R/ݎ$I7c#r{
ryV	 $ V%ן<@䫍z{{i!;K %<CŻKE|t FAG&@}3:DĉF#8`c$7dz`6Av6P9 ꫫoD$g² u>ک˨(9r\Lr<g89i=f+ؕ9\d U#錛2cݠgo9=G=Hf@Ww{ARgKUMb8?}"Qہgwd].PF
8ztUl(eF 8ɷoQ'218Un~dZ/S AppleMark
            	
       	
   } !1AQa"q2#BR$3br	
%&'()*456789:CDEFGHIJSTUVWXYZcdefghijstuvwxyz  w !1AQaq"2B	#3Rbr
$4%&'()*56789:CDEFGHIJSTUVWXYZcdefghijstuvwxyz +!    ? }BH6b$짮}עKyee~  bTQNItьj8y|!639vsh5
" 6ey!}ݏ\sSMtiTNWI@Yz(<}3~+ҭ5g`uqW$pNA^9+<CNteibiMQ?Aĵ䞙ECj&%Cia'%rA96<hҥ+ݘsjM:rN??R9º՚<W=k5F*G+RH˻?L%'}Irb֛%JldsۜRWZ,R-,Nsa<UgIܳ/Njղh#+C,s!ëQM0= ƻ/
뷬 |yU~<i$֯wt8F;֌a[m>tП˟K/;pIK'2}zUUi" lr:dRjՕ)ZS+{M	E??W?[_|9KOMp/'!F	nCd:װڵHQI/u搊޺s~%xGkҤ<G;82k_Yl9rc< ]zX~R٫K~ٟ/?\|Iʶavo]#IFP/~8x_O%Ʉ)~ai>%A]FR鎽=/&e6>+u)5#Ў]5g~5'<9uFX|g*	;)l6sokϔlSWsjj^Dާںg𵏈eehpH zWjz/xON𗂾J`sK?*m c c<7LuW\dڎ ԎUm^w(?bIG8sھ^0;K=-@P1#89w<bu)l䩷|3ou)#m8 A8$<v뜓__vfkQdftw'Ӡ+-jtWG_
IAu.E'2<cG~ֵEє~=	یQQe%1I{WS$	 Ռ_kUzxp9^i8AH^hT:sZ4gyՒ_N-JmąFCn@7c9_(eˬEnꁁVj?rvGF'<S౹$GAҿC'{oY<H|3:g:{I9;lU9Rջ'n<7]7hD6x5/3xTL&FUA=z y/3<w<2>?fV[s柜Ƽp:?cO)]NxWy9 zs޸y?'C,U _?kAK}[^kпd?PhV@i#eQ 9>s޺?} :)ڞ{S~Z/A1^9PO̟Wwm6Aԓwnc:j3&{v;W9HEvsQg\VfxmfR9 *):?N#.[W6&Kf#0rzv+JVYJ2\s:~2[g
*V=᦭k∓Bl 9$۾9y)<9h"nP1m~ƜZsU~W> gᷰ<fO WmvnUEWM34 z{ve<:U}Tkv&a,1g
ʁrKc[5qN;z v0bU]8dּA2nm$iUwUB*	8$r*{<eG'?~hlZ¦!r̨-o5w}`=;UGD-fX沗q RE5QVIW}wXӥKflFx8;gA'EbWÿ=a
Eo+! 6*:];ȓznڅ&,z]<:<m]*\H>qS$Ƭg(4Oqwp-^Xe24++$k->8I53
e$۲;xQi6"s"Ǹ8$+gNOjjvk3iѧ'}cޕ|Tt5hl,@O>x]_2 2GC]qSi0&H,Ho p0=zzW
Amh+g)qo}µ<=?e6R2xfHG~j!u/hLb!Nu5_%閚l*5B
 ~;˿c1iƔ`*zG.?'Iw2HB+t5?+=7GӞhǗ=RzccsGs֥-SWJwJ:Y>:1vN~a'<W>#ιoK4A<΅a=9uF7̹(E)'oV<,4?	<ĸE c~ע[௏u
EeЅ,[Jlu<u<(־BotiЅZZև~!iؒ
	Ss_h|^9ONFqgpZGqWR	6$KkNz8	Ziǩ (#(krR:7۶[Tm^x7᜶	"	$	ױk̾+~<5HSE)6>#ӑ+l%Nzs]f4GSGӟIӯ67Q2y?C c6"ߐ{	=O<xWti-^穄Vs
.MPH"<>+FQ?44BeVN:zR猕K>8j>Ο2+?MNS\_j>Jq9~]kSJ ,AhaAϸ=F	yi89hy9j4J4^}Klԑ̸Gֽ~O!&5@p1 pYIF&G
S'F&=&Fwà#:z|3?fh`0L>R P{j]9I]X1ջ& G/}oCǙ`~yO>2[&L[OdG~%*WӋi	_V}*UlR_-$ep2G=_n	/-4sӯNw5#i)>|~|v'/x^  /Nza2i| @S /ڌݣ|]1mn%}2GA㡯n+(
<!	A}qqs+G'̠w5+5,*Tl\lY`;^TS@52}ϞTĦ%!f1(ǩے19?|Aq]|AԬ
pFys^m [Wv^V
QI_F4+Y~vw@wuT[r?fpJ'?foO{ ]>O }oiO $8;JǐGֽ6_>Rh@ܘ*}{泚יxHS[~x?L6pڤy(翮1ڼ_g3FϕFcG?QQZ)tiJ[3牴65جm:Gu<wֺ#JEבÑ{um'9;ic*NJE|=*F">VRI<^H{ǑwF<p2}^l*쥧ڝ:Xz
)D쎳hPmP'p^M~M|~dBs +2G_Z;;e|_Jx3B8k AzzUd8`0Ee|AGHc e3~?+kh^alq~?_֓e22s=*+<#kW%cQKjkPq$MO6}U5'Y8WI0ǷڗN;yˤS\g?_/eqUʟMUӝYG?g [ m-6BG  _Cǧ{ yu[<_ૼZ3RsvZ<	9E(ǖ 'boZC<{a+ ˞81|%ӵKGE En+g;;xuqWGXC@ğ?~"ZDңkhseɂBy8Ry麼\NMRYZC98x&=tTr{I/9V=ſg{<1.AQ<s֞&WnזWJXmwS:W[<D'9+7&"]/ZǅItbcy
'},|N𵽦ZXoTbD%%=%s~GaVߨҕJI<3=o:6%q^7 -ps_\x,n|F4VZl"߰	q#>}jNބNu+νtL:=	^K$/,D'1d`}hu4cRnGu|xº}k(v .z#$sӾ	\mBeb0L|a['\9"zze7,U'dq^#aĄx.4~= )
Ddr8	=wI0TTlMGZɩFGqI_+O$AcL|ꝳYԋI`ܪNJj;E-eȣggr}}h&4?
	_~³u(q]i:\LC1;kG_~x#rA%"DrD2rOLqEbH룹.MmoS#!'m~&E!b)IX3 XW| <Sv9 G!ʝ68bW5pN~}[
>}Yx@"Ln$Ϙy=υ)EΔeF(\lF<~@TYNKٯ=Gmf3
#}+Ʊa[bN-^s#F2C
BOP9<0tOt|%7O4+)Amza%
GR 9؎$2F	''5K'>T}RŰeTuH:kli%KH<TdX:{m9i;C9CC o;*N
$#~\j[6㹼w'U\d :7/S[#rjOcSa.GKqESnrU91tE|-o
AoJMR%aܮO ~u)i++hSV>~SB#EOtۅM5nmP:ynNp<rGL54ө eb,YRr>Uo3 ֯Q~~GGQx9!c}=)#	c>){BeQ['A#\Z
F\`@^QJ=ee9[XTeXEx^%@#'9XOT#ϤS+5y]1ً9$_ɨ<KQ9n9/zxC{xxI,b@zWLBt$)<wҭ|=Y&ϋ4OZ;"c k>"<8$3+O gPA?z|j^g>UQr?î+#me\:n9(մuݙpcnzqA't|K[g%2HeGJGgO"MSJ{Ye$oLZr=tfLӷ>ں
@ӭե?g)\=jN)}=Z[K{Gnv#st+Л׉
&GS qָaR<av [ԦxMěr$\ߎ_[xN]0\I3x㡥Fߏ]=FYoS(x)5-f[_XŷW +~Z[7<9tQN>XxiS7b5k{_jl
l'؀9k|Cmö'!y `{ׇӄhyr]J>>?^m=+(1C	>|^w 3y¤/k,ChρG֟ !Ev.x9<kxsBMFk!QcA0XZx~K;/m	 @ձCմLA}$II	
2_8Q\Wn'ʗ[0uf_㗌g?Ki37OBwMҠ29ƶup[BmTG$?jWS0߆%ڗM
_0YiA\)7K u
:mgutэ2+ xJO\Z@Ya$#8~u,DjklMjmJ2?V_ۋep =z4K[bBd|?xN?h
wϯM(ZMH1f~Aڿ7
zյXWag'G-bS勦9YY>čG:Lױa*( t5xEkHDҗtd  zMLWSON;:>w:-࿇w\;BacV
埕X -k	<UxpJeqdy9=xiYQNt<m;_m#V4Iʅ&Ns:^⏆iZ۵C(69FxsZO[Y}nѭwyYO|X<W{m`
Yܨrg
R>4I<ü6s/ ڮ4r{}1L$ϡ"Q֧>tEෘnn2py$go7%׎HN`%Ӝ\SS9Arܫ
DD8 
zdÜϟ뿇[	V	LjM^ ք^q?Tdڜr7`tns L|=S{T#OOv1WT4`
4h˗U#$8r+/|?>$ɲ*iw!|'ϯ9wѽ?肳r}- ֹe*7̊62xϥ~~~ڞ}*UC6;yz`r9jMr;_%Rz?
xD0pAIץSʺ  iN+jrKO[0畉r\; Ieq$\Lʌ9B\g#\5^e#hAx
yKglT"%SϽeK]Ernp"ץ?Em% n*AIKPBTNm>ٺm~)  [rGnWzQ|g]nmA`F:Hy_H7
r~\`q^91_syc\bC#nV~$-``^()R^[2zv #oN9Ͻu
5<@6LJnR+?N3]faBJ2>/+DJ:v_JZ G$ Q9|TM{'s^Л 2 3lzꏉԴR8oW<P;!,clr٨]u[̭0|w >I&eފI,FF8}+iU34{#@v'ZﴫS k.?<?SWZ>hKLѢ[rDZ Or:ⶍp `cʒrA##(ͭ;P2j~|xcMtj\w?y}k]ǙL0%ԓۧNGI73bkb\ ڗi 6ѡ0=s9_.ȳQpSn1ʾeESW1>x}Nj/ x!Mv}n#𯺬~/^xG?a弙+9OQTbk,O#aU"[3/=;ei$|Cc]Ǌ85M1_92iAP꘩Щﾝc<QY<{XkA(~>s_׍XKkR̷ApP:#jz(P%ԗ(Sg៍y$vXG?N!#t.A>М1nƒZ?ϡO7]vsy3Ѓ{ׄj7$׮"ӣ'2Ԩ?^8ֵNsr彵IJ~K_fjvoYݺ
XdɈcIͯ§<E3Z>~f*F=?!t_5ţ6hwu`} ^=8G$3;}UcdN76Ǽ+0`G
97hjƻoui8YcRW}{yJ1G-:ǩ\K
#E:jEX 
qy^ ^Wi⋋;_i.^XywӚ
Qz3IӮsG+[:^/cur}Ok6{eȮȊSr~P:g*x,?݇-AXZ'C^O=sk/WVo4yטw<jL GLz&'PZ)jZ̯/|_x]B.zdq'ۭ|}ῂ<5r@#>߉fTfFO'
U1-/c)H$tnB KlKeN2GW^>mߎ3iw{]^g˟5KėgFnW<1N|D߻tU"U	#+ j-(5%6 ) kUmI|snv8ݸ35|?Eoh>%8׌.6rU[?tuBcƘ 2[_"gW 2~$֌膻Y?6(Nxڿ. nH#FqػS8dKu_:(V~QϩL8EۜX ٟ?#*J)83Ĕfڭo5+?pQ0  {A(WVU!{{	)E+lQA SLd}3ұ闰f,Cc)35>^.?^ĕ*c8G]9Uд4El]LI	 1pF~ʓO#cǖ]5=+Nej͹A2OӮzzbm<R\@Ák8bihl'q9NgW,<[Z "9]??ⷆm_P:sv>nKҽL>i'*7m?lW	̲yJXho;ht)p/;~a5Ļb%KpNpvvH&=_ƚ%{}>5>@2pGӶ+[ʱ_ <~	|nj#V&\y㯿n4q n93/5;+{M>!2uLsH<cONf)Ff9|}nqM3lV 7 QjW+PU[s3o,u!f#s8##=d
2ޣ8Hîdٞ"1i&]gE@!8lA<g gfu>&tk1QU\Cg9*c~K/ӌ^yoxj^/.7s(5B+c3ӯ<W4_i&/0#
8qJT:AJ>
W޳ItQ"
|~nz0<+*8PA =J(ӥ<Ke{8R}1V榚\ַw,ŷ`q8[
^WGtkHta-as@b
skj? U
YIPpy{SfqSh	Soٓv{mb`ݰtOCwwv Z[$
X7MxklhCvmbyfY<7s|e eI;UO9<={*VlFu+Jg m\HqS=qڽ^|by @zc(ҩ	-gDI4/ſ<Yr7$͸mV nc׸̾,g|ii_4y*ѕH9<{=j1nL3EYdyRv  dW_i`fX"(7j w3[.E0O|+*5gV"۱-KNkizȢ1.Xq_GsA&q	@]gٖTTTRw}
և~#ӼT(RCz={W<iO𖞫<Q
cEL%yP<M2^joi^@(	v9Oӥk[ᯉ~˩x5D
đ+ΣBHv]	Ɣq5tu"dES;gO5N3Gzc_Ԑp1}35ՀºVz><?xQ4m.Ir#$u_Oshx	a8};Z	2oJ1,Z_O
]fi'ۏ}+oD1b#9=7)<?nՊkjk7yi%5xC,ϧOڎᎡ1v_Ԝ3NQ+*оpW >W9OL<8&kuTg?:=fC4E9yg>-x_>76:G)r	9}|ړJ{խK6$g kO5Ja6V9{[{5?&/n^UVe<p3p}Zj 4 kZ$yNI9O_l渞yhAgϽth:|B%tr?.Oӥ|iĵ8F~RQf*T;r?1կZ6qYF)
rHAg4?tᜆ
e4r'~mE9~EN>r7u>rGFxuWӾ$o27[qb{ 2GexkqfrO<c;;w.T[ :ϖ¦ob)Yr^k+ǿ<Gi)$i@,lsΥA5*re񯛅Yʴm|G^Od42XSNIs߄E#	8wNë,zMU1wg#ƿhbЪJOrId|]e>*J whFzq{dܜө?*|:ɢ``,`q=0{:/ͪ<ۙms̠S;>]lw1ӏ\Q(s}>G ^	_xܘ] O c8scxwPYŸ,ۑWW'=*{-40_̠؂{ק;Յql|/+ϡӷ_=\$SJS _sZm=Nx$<Oá|?sci7[MI|'8$gsQy{:Q
֟giu
Dg@ ?9LaӎEmG [Gq~{W8Vnu>B&=tǇ/|5Ҵējv&hC q|dcZ_kEɤz_cbʟ~]q/h\Tu0~|2UQne)p}	\-o P{Pkmҵ.y2Ka-ӿYqm]^c{n._&@T1dq ֮.J&59]	u/w m(:$
uv#:X9m*>g3K׼-hZ=+4iG ־mhn	's"߼:IzL:W}K`;x'xSKЅՂr8ܼ(UX1&=6_70)cdeGΠ195W+k߃F
86nN=x*u׶kmC|'V8#ooX*8?O5x43CDXp2?
+c!B>vJQR>9(]t h,A#<?ZM7Ė( Ie` {s^Uju42RQgwo;ط3%ևy8K-ue Hrl F0xNxbS5~m&v'|`c<Ny} jz7.ǚ<g^#NvuoQψz֥k}`ţ<`q^/_<i营[xCo &ʴf:pM3{{w<A41cFtHryuֽ
hLFdR|X7==: *gNTmOOxBo-"Q0a$`}sϾk	5m:xU)pFۻӿ~ǡF\z`%??O!W18נ9W<F,, +o^+^xW7wG&5a|l8\|_=~Ժ}熦-'`Bry8tZuew x}M | b3Awnus޾r;=d@$n>GkY=68K+ঁptr7!c?]߉W϶4s;p=c2_ǽCw eOkVz9eF:rN^_ g>.eפ<2f<cp >s]4'KyUpɴڱΓ%!cCig_ƫ_/׫hڤw-0Z0 O=uOK뺎	g(_a^8zRoOS(ΰx[j(AѱUX?J'%fP3:HҧRj4Չϲ>.uSiqְZen@?toMWE}`;<_CPx3<N|SR^ǒ'v Fu)
oھiovEl਑81a15ka5{WJ<EafnO[[^-4_9o9w~/lN93I5Q&v_=:\y)I|d7/!W	\z׀x.-*y~`"-ʆ'2z)_pǵӟIiǞ7/+gJ<$ۭvrݙh#ߊWM$fFݲ[{r}E}$el~ERs՜H5(iAUx=rN)wڪI@pON랜ҌFҧ˸!ho#ylNOG9=ׁt;# 
!
u5]䎊<%>>2
|b%AbpFQ3xK>&_N!ߌ޼*0*K^W>rۯ$ugTǃn#PLr1ATۜm/V=LM:u>|=᲎ B\O!H;k/ |)xx>O浍hQܾOnwk׌-/ȒB$"Q:{
 ihtlD]q=kQ8CdЭV*zcωuy; yMKj+!W
|CVfzXk-n ËGq"	dG1Q6YCyq$?
r0Txp\_6穘N>>cm5K3[C8ks,>wR8;R[sUՙh^#̨I=~iZ6=ԇ;V20O8zE{JJ+v;hNy3_P+3ws#GLq__?xRӌ:e!RX;8?BZz]JuV ?A5ٷ@lo<#okpy 8czW|O[^,yPq;?s_*T_.:O=5=Y᥉[о xuu"5$;]$1=_N?l"aW(8'kMk>30JZyhя_8I.]~X )3ߦ=k<SqM4+o0D\OQۿ4GԴJGx^4;x	LN7=g.%|	
"Yd[b *ocJjJkk_5;Ck#۹8Ҿ?zl/lo ]1FFxUڦG<ϒ<F<y7#<r ?7\㶓yiǥNc2<03:ӞsYԥ-g9RC?lCZ`gԀ\gڏMǧ3	78:O}*vX%N=cDMcJԚ_p9st`:WOkomh`VL9'ɮMI_G00tܕ+)SͶSѣo ^1|oVޫ39ަOOg>7!;-v5K'}n$ H;ךRZku3#h=N; >Gf*s) Ļx#B"->rJp:u<c6>-<A]}"Se.XJ900+ljI=̍JG5LĥH`G<cc_4/%vO'385X<WS}XYڗlRt2Y,;J=ֿ3lO
Q+H@G=:iSs	iϯ](S'? ?:yquTO 3zΟkL'Gc~Fx##=ً-Mn`IuF1|sp:ֿ)S}'By*FNpu0bwZ=?@M,
I7+wNOa޼3Ǟ-Ŝz<_YaiASQZmRq5V|뾧h?0@abNzhla
JKbG'
8Ju+mk䑋ܪ7sַb
۽HFwr6䀤goCϛ(-Th/g.\<$|WIFzYJ=ahUtۋkգ?GHN	'9S<qU|)º+Fv;51gGV-%gx&18{J*2Dml. Ӯ<#ƶ{xUc@ =^q[%X"Q6xSӯ1ļ5ys)ktadnOO6h*NJJ;4ݵӹjfO
6펵~(p.Y8#<zRQ{6{j\j/ۍRQ(bU
*+oSnyT ̤9Q޼Ug]*verqVqcu
Qe$"`8GG?쎜W
.D?f 1zFcQ{ja
5ʵZοh4H =5c?h0  1#~lzbh:|T3֯BkoƯLC	PCֺ.@1$@ >)ES|D>Ϊ?Sݼ?g AZ;(##A-'n8{?oVUE>:cvaEQaUtRݶuwV|Ǳn̒^Gmt ('\t=?*8+}xJ9/w_
dM]"@H#{|q =s^ͮak"qW$tZ]`^ בxSf-_ޒ~`29m B,r#=ֹp؟mV~G}t1*{ˈtxv "8 ?~ǞyKQIV_:8_dNI~%.iR>#[nQEim#}!<Z4kcc6bCԌrF>(}^n\>҆b"-_zg>j2мaIa[sG > hoƷt@YAǯyx9f;=n[|I5{WX`c#GzxT{.Ӑ#NklPkTNq
|Ҽ:/^jiߗtI0㜌?OY^~,۸`	<nX'8TsL.tb2/qp'x
'VZ^Mѳɓdzry
/
[{ї,uox:u%t$xz߈ h_k>KY]r91=SzPRMLK i9MW/Qwu+]:#.		C3WM9YA5K^G?f=~SĖͳiif+{~5#M'VD>V]$8 pJ[јI]V}g73Ǿ!_գTQ#'~|<|3Ь}^(B$ `v ^eYJ]c9Sez-<WuՉ^??hϛj6r:wR|_bʕf$f/=ی<sG9 {WG?oiW:nVq}1%t%Ed-OjS{0`'o':Ax0"P?9c]viJY@OiȠHcO:c}x̑Zj/$<d9שao_k#YAJ1i"v8Czzq_ wOxa瞝xqުXFS6M]DFPHbqI'sg 
{  :S~ Y4+ѿTLTy>60Z'ÏAB3ۦN#?a1+r-YŦ<잟4_ǅmѭ|EJ# +)'={u5B[=v͐	<}AU)?	b҄f ɬx{VDfu;e!;~2ԒfŹ̼z1V^ͷm;~߂Yx<O+Um4<^{iMoeo

 8_g)273,C2$p;@. x8C4oDyu|WͫTpk>h]lݵ-Xn&q)N:p	+_X8ɶ2X 3dvjt%NG%u'Q̥GnH;v1ך8e71:_y-.l+tq]2z앏SJTNNӵD|[IrnT*x bxCZ8`6p qӧWЩvtxy~eƍU*+Rqyw؟z#Ϩ+
 P̙r o#8ǡ}&q쨸l)iڃKujd^N:EHy<Fy?w=21וjrjÌR(YD
'\;4+>bqqs [05D2n19'cguMXXnw%	JU4h @>+[ԡO<c q<-*t'fyY	ʼk-ՃLdM,ÿ1p'=}Wjۏ4Nߞ9_t罾 ɥ.h c_J~ZW|3X F	 1霑vg0*qKMlxv^fǌnlfg!y05ß$g1OYIYf-H<;\qd{|bߙC_..u-wU7PnB1z~u׌~\,}3G>N}@gߚ<EZX/cѥpK5sO?O?~|L|AT[!2[[2eR3#Q_o|H⋻?1y!)RVrx?+3&3_+FW|vxyC,.
o3?	'#>$i/ }.$8 wҿxKq_X[b+|G~YǸE|ʬaSܧ-5J]MZk^M  Yj71TҬaT =F{5:g~":Fm8s\rz~)KRZoU;+ԧ՞7O|Q(_ᩣ z`v漿w^?k55<8/g",8z)/7sSSkR^|⧄0x!_[
q
 :uֺ:d g݀}.#A65zԱ??O঳㿈wba'FJzG
CEX9ݑ^îjYQB5M'g<mJU|?r="Ǻx~$Ӽ岯l#j3z0%72F 瞟\煥	l$=sx+ȵ+dbvQϧCj =;i],)f|8:/RnΤ>ҼxrAe<PHw WnL/p͸ryx/r<Z\)Z>xMu,1	F!
LG+xI-t[s`z ͞1ӌ\ҦY)}a7-QxA[2)*`cr{u|k^+sw@XkXʦmN9n+{i_xVMGlN.Ta{gv׭2]JGY\}=+'4:\)޺#>9[2Nys
>hw~Wԙ#ao޲Λ~|7@ATkq׬X|IUlaP$$:շe2II-`0IwfZP2{OǾ.jî.gc{zpBRSrjДzmOXmG= j?|/9+lc'tOwRGᦧK=2 AߗҨ}?z>gDt\Z{@ >ӷz9uԈ  }x:&'|?W
6U}ok[s<_H>gq vC[/lF
7
dc׭}7(U-c3K!{l<ChuƖ"7q篥|Olz
a!?tu?zZNTZIGC?bu\ 	^HU< 0XWǝuoEtlıWwI#`kᓦ֚_ӉR#'+Kw,CXwr]iHQG'WwJb5|H8_=L9hb*ӓ	4""z=6bvD`pSyyӌñg;[kr@%Yhc'z	JvztgRaV{7 _fc,Rig]1y-
OMR8 霎1ߞ:s]BT՟P#+h	5חT!2Ofs<Z]'S6H0Fp?*#/y%ݝ'{38'޼gt_ms%dF
ӆdjiTj5yjQ_LXGK1*v$x{kV 6mOk&l` O=b{O=G>Wjq2i\K"Byg.e;eH<t)V_X{Փ]/ᆡxشtelrA~|oğЭy8fxOuv1C
R|w?nO٣~{k&ts,;V͓~5_iY6:&M~Rʐǘ', 	?9hԟ+Wkk2dʥxk~'o!j֟+K(g
FaYS8$`Z9|~&:GfAn 韠*G8RZ|<BT^|CŷgZ^M<bQ8# ?</us[Ǩ݆1۝#g>^35ʭ4t)ҏ$_|߆ eiyo ^J!<*ovwq[F7W>|+X#G6g33垼TW~π>x#SڦXbef{	< ijR@gZիGU?QRT>9_R|G} \eA#z> +xF|KssTT b&bIR9$p@ ekV4fpt߽'EGB +Y+"Yb	6I%O'Zx6sqw>K%wF>Wƿ
6kVt(TI3:qϭ{*?_Oޚc1JZ# P_|tsOҮa..c
fgA{^
l;2\,heXjjN13^ֻ,uxk3ǒd\}+v֛j,oE8U:Z_C=^^%"afNoI6*<o+	ըJёly
#OLWVupќs ς2h>qhXhf
FA%|1[MC@uPx#A9c޼ӏvkc8W<gW{$%F+<p?
T
Zz4#W`Oa%YlN2֧sxse,ۚ]rXI# ɯ~5FWoPm8<~<+ŵ(SV:ҔϽ{ }y.X;pc Azcھ_#OaHK.Ӟ35*J:r,FaCߛ_C߾|t_i29/}q*]qy^1 <Lvs&2a2J#(hC\1j-7gi:46;rde8Uc~sU$mo5ip''mC<g<JȖ +
8zlW?كQx:N;xG=(k2 bx
IcA}HeIROO=̾vb/ gLP@۝F߯|V·"Iu<nsMA߳=+s/[{7``zT oiE[V <k|/س\VCWCˤ$'!?du<h912Qw<֬2)Tז7<O?xsP[;Ar@l <ʞ2STg^6w\ٕhWirfN<.*Hh/O(# m6IW^9֯Ebr2	,z}?{trR)E#*{5IjdޤPJ$_ B|
#c("RrIW$#<
8nkRM\A^Dy`G9|gBK\	$2cԌNҒxI*N6lc;~zeԑZLw}k×z$8%;H'o!Ool~u\}I=u}
8uϸ>i7վ&.NA9=zrkK?iix[E>\)#x$yH45*w/	@z{0&x7~[xDhH
I-C #xD%֧*MigYj%+xٙsx g;s^5Oޣo!|eYG^nH}+}Ǖr.<"rWIBAt
u}o8C.M3̷$Rwc=rx<<>*OF;؉ږC<3{%&4 :qI=˿s]:>~&N`pFNOlU+;q̪beGDߩ^o,g`rɳ*tc<W߳'!:Oxivw_j $zfl֤0
I4S 5KZ |wŧ^xJYH pb#cc uָo =oƱ|EO7b
<u~@J9)ۻ]\%I_Sྲ0h>eEWAW~:ңҞQl
s5S	YWi9.x7w-|//S-ǺϽ{&kxS_f$7*0W &0zW+UrkDF5i+bl/w:PY&!<	?:)tn+!Hg $r8<T%d{j4>:5sL K׬ݼsGpn\W>sxy$5S6Ss:z8rW#Nw3R{Nş!^1]3Rh8H>ᮻ
x1eɕzt>X8J!RjY?~3Y<l!	vOm|9^wO
z
\Eܤxe'8?ado4.ѣëuz>5/OjhH≝G_L6nc7>W$$~<k*ekX*ګ7o@l-|:i|,Ŕ1'񎾕"ĿvUxKV&LzӑSa1v_N?6xy.5*G|~ |jο')Nt<qӎ;~5{;c7iĊq~5qjfy)>G/>^=E][b 19;gl~
)Ym#f; Nv<<~)Is.)߅-mMuc"BAz~c|zS/jbc
s?rrC]K=O>'ly:cHgxK_aк$p2 `߽}4pakDi	rM<_i 
0 Hlq}}߂<gemN	 8\ը+>K:i'}Wƽ>/ע-)A`?tpOL޾0nr;'N (VTdMٞ*nK@nWI.@n?(}zcV,+̎
\:O[(yxxӆ> tuyR
!Ns?OF6 _Om_Aw9Ew$K2?0XqќW
zu}'X thXE'ztjq!	^G:~ xN+KsµWȴgII$Qry@`9ӹin<7um sW>W=n;!ZYYeo(Pyڱo/
?%R
M4?X>9| ׂtH4۬ Yv硯8c6w;p  +<Ҭn ?u#xL/=jQ߾Kl<Em{e,69!6Cş.miцh
ǩOa	Snm<>dh8|hX5$/:xiwb`THk	NvUukf6{X&{ogg6.xaЏ~3ӟ]?
I{MF2vG!b]c# }H80;9a8ԛ{-l*MܿOu6 :s]^cw$^z~wWWtqkNF|!Үti@5J83ӠA𷀛TdbZO5J6A9@9 z1!Vtql2&2(^/FXn͐F[ ^E]qy4tI{1Qn\Z7ݵbp	_Exů(n	a<Rp@giׅNROY/2*apP{?3ož+VQ.tNٜKi:#o$<c&yx;8d8#,l>~<R	Z>{WupΏ*69\w^蚩oeс'L7/ 8<eխ^;;}=u^|j?oXyDe\3u?tc#8_H|( =A$Jc"G%H=9\^eGB-B퓒PN]Yw eۇrZ\yVKXdyv5_Wçc$pYʻʖ cX<+vGԯc׏{7/_A$I8C }x Wx75ux~(ZY	P~;s˱V!ӝ/s_eV
*|c׮CjVR4bd#}ן|g˨kԗJc!0?_OJr/N+ޖy	/?
|QCFfTR~qܜN_|?=='ذTjU;k ui՟i|R_Y
"93	`v_ 
j<QAg\-ԛ  0qߦyUJ8;r.9Q]?_Sx_va#VA0@Cg<g z\OڪO	$ņ%0	$\c-8u42Cdoňrt|W igk^f<w 8ࡺϊ4 S*HI-zwNkp.0uynڿ੘6O韞 'uw+jF}{W:f$ҭi(s IֿEȲ9~]QmO'VU*:wV #%?co>4mB(Lɞrpϥ` Rb
|Bu\VE98 ?s~+qSKm,ݴ
ӓ-sH7 aBcokA.-ZVX6Z*K-fN?jv vXo'	8ϧ5#6!S x]Xc$מ:zBaeUYӔ^3F籕U8T$G^K  c³.nkfdOD(r{z 7tk \ Yy###z}+ h;࿁sa)_(hm$`g<rMkWYR+Sdg!	wiž ڙQZOݩ285w5
	"n/3^RjQHTS물|lpN9klHȖ8w+:RWs<|ox)n%R|K0 }{^<]XǪ+n Nn+T,<]lȫ<s ^;:π_ɩ^fs~R9=LtӫZZr]zt=_ixgO*j	i!Q)$WXw_wBks:*y~45l[F>q^C~15
vPF!cwjta{kSc'o֞v NP[[?Jn]mcglW=6gK5Q* ݷ!xH/Ejkz{QjI?P>%n-^[e#8#k-o6Z:L$l푰{~uxj%t?IܷrXrI8ωͥP$n@8zϭzkMsM>dQ*%H;`^"9M{?6\YsN8/%?Gl/
1'9$sic]C>}N*FWֻNO>WXq+IF3R}_-P>
V*ytk{вLAW&yc,36:z{v$'
f5Z8yFL7ƾʸN_W%\FQq]o{{o|
bh^8}ir,4.SonHiK
tp;Z(.UHJ_\ly9$`?
9-δ$|;9zfqX\_Z;~<д9}3eٍ{ڱ c+-⯌uk}hl,TܖBKU^1j:Zk|<ƶ/0YjWhx?NMz)Ʋ0P#5^TsVxV7{F`  6۞ˣ׭oUt~ه*EZߙ?wjG,a_ɊH{
@$
C>m7
;Řv9;}B|ɳc+{7UjҼ=3jSroצ8 X?ZD>.>^P]d12Hڼ\pYym)|se?|-3[ r@z{z^ }JxsSxBe Qӎ{Zm\ti%_3gujk??oxwjjs$+O|)N~@^HȲC[*qU}c~w:H%I卉1Rq<_N_63j3\e_u˳ƞ'4M+77(Ngپu$6uv吶rq`}}WGikxɩ,zt`I3ӎ+F99Q~ #
SZx~մ=:Pb	I8 sӨӥ||-GV	&ϜCc9ק?KUl.Ֆ}n[~ O'<m2xIt|]$Wӟ Y~  |u+a{[1PGX=8;4WCΕJm~'G>#K5Ԯnp38#8#Ɲw$,8bCl?ȞӖQPQtG,EEYTn=/^ky"Q' 3?^k]BWA= ea1xL-_NFbnI+;k&<=!VMI!< ]__~0|
cCjzk"~ }+<.e^Оҵ}Jvݤ>5ioмHУ9lu${WmC|=OZbtV2b y5r:Ks+??.Ym>]S?mF^Xټy ǧz ϊz~aތ.ON{׫ U:Y>\һٿS3v'<H?)Dܾ~wNڸ'Vm"IK[x3ȧ~ ï~|VST/</c]Cַ8/qX!c'kktI	`HRO=}+ePIjZ=Ow |05Ks<hp:z~DsMt	VK	1Ќדϵu-*jZ$Ҩϫ
?Ij*#y' cX'Oeԑj3`7vq<eGf moZ?:>!M"K؟`;q8kq+߅bƂBє~y'zףS"kԔeP'YmxCO$cܛ#HWS6ƽ}v򰠌,qҎ*k:SSiGފ|E6Ww_\wA_ax?{-Bؠ	# ~9>Ƨ)tZ_3,]F"?	1\{[oL{dvp:c=;/ňkCV gk%~cyǠ =RRVJ͗AYtGj<J	\d/<WG]떑4Wl.yꭉNͷgRz؋s;&|5]nE՛Fڪr=.,ʗr
 '펃(J~g7;N3z~G!Q;q{c$?S ~׽My~x+۴Q3`6rq>?~zeȽNZ\WXk燌-[< OiZE&wМ=?e=sU䶶ZL(	ǯy!VtuUSMυ)|  xYt,ʌY18铞;7C'Det<{^'G1´5Wj#<upz2q}FöUHy =1s_AbIh"vS3cv~ns~}pVU}G9V[4kv>7u
>ctdۼg*|89:t|5Qj\ƥ	e8wg9s'xP/xnigd:ėmJw2FU%I$N?MXTk;%.r[I#g95XXWܖםho5/q8OqǷ B֗m%"ᶵv/яx@ʫie<,OakE&{WEg$	weH\ հ:ct^>OO 	[Id"$q_e:1<no%Fc)mS:ߌJ_tqb!U .$~S|K|SsBV(rWsn:?&&5o=
sڳ^|m?./3}G\Ūac#t.+</M647,̺C,y#)AW.*ܧUdOYNLKJC~ž1𭿈|&q~pw/ tZ4cMQ߫mqۿY3rXĪڳeLʌs093_^: xžt5%[==y.1խgʴ{KPhSg~_/ZA~i72elc v?.suz;e2!B[@}~Ka9LD~)XT^+_&ЭaHc8=s־gSLR[kڱM)C7q=}y_'dl<\Zaf"Jlt}:]qs rrO9>Ox_/#fc8㌜?.PӒb%N4=n<|2Ѿ$jw2z$3 ӿA|["W{+Ni(آ}ɞGA{c^McuMRQT#JEEqy(GeVy qׯZ59ugF~|s?_Qu+ө}8tVOizy
.7 ÂO״sᾝ/I]M%hG0QէAF*G(=',oRu]=py +~|j2%1wA8۷ş`sau~ˡZn	?kٿG5;Lsh_'[<j+(kp9<Qr~y8	a3r[kxVT4?˯E\r_Mܘq+<}kᨭ5[j&2A{w?jH/;G>8[ۥ^766=ߕp':0B>>	GQ&ƒM#O'#km!xtzmʭto
jwM)/>l!f\_Tf'Xt	Ϟkǳv/Mű<Jy; :Ѿ9~obMFi|3`6V=&4B%
z
}˯}v'
O@H_?~3MUuXԴ{goPw?:j(I}>f([[qm;
=7xҮ$/3OupČҿ%</:kX4"F1<~JU&OC|,JcS>Sk.p6!0@9}1_`~گQeѵ*0Tr2G lʧ/+'jWC~Ş7𮱨(n.Hdg H_+/Ծx:]4YknatUSSstg4|?كWz΍_3J'h<zߎ-u;/Y!,v\|1z׌2P3٣QHYǗχou1y_~e/m=r|`WiFI0pT\
~kS[$vǶEdy , ߩ?ƾ*.) Y}2;]D֐HT3o~دo;eiDJpI#?FiN15'MԷx]6;bFy0񿏼N7ne*Pq¼)c3EfH^ZVo~%xV	PJ~뎣}Y Bs;VVdG<o<+0T|53 	4?ЁS!ק|e[Eh&68_u?`0x=|LQcij> %"ز7|w?_>
xcX]Allܓ9ި<dA溥zM}gJz +2Rth1\"c'~+|mu[\gHa *O aA*wXpýoc9.n4}B|"$Lnzpy0:tϭ}oowOcs|ZB

=UɗԆҊO1PߕIs_QQI*dWv07xwD~L&w`c{h8|ʛ@@&WQ>ε%ouh.?IiFZ}8/ O|(.|'[y4FO6F=C`v֯r3nGǸ&}Tt''Qڽy`jSĹ~_aF߼i_O.a]4q+Wlc!:q5[OHwPFL'^IaWh|EI:s_#~K.XqY7mSq^'O>5zԮ;CS#[Ss>U9ǝy۴Hd(dppB3; 6m+q'WJ*QtNMoz.6E*@ pHw~<Q=1ܻRUghQԷPN\(O _kYh7<~_<Zr=]T`: =?|e'Mfd+j4wDm᫘#.(ߜӁ~OĭgW
ks/Ѷ dsx|-puqyǥ?2msYn&GhWq__|N	dYY9N2ONk0ժՃH1SSv̟C[cŖb+r8N>75紌19u .[TA%H$i_kJĚՊi5v5*T!usK刼 ,c3JYPX2zPQހ?
!A8?J=#_5WkKj3=z+!}:J+ .Hf9V*'NőRL+FUi2zJث@#XSҿ?
~՟ e>%E
3p dּ<<eSQRhTc?7
{ækH['$ro^6VX=Ղ.λtՊsZJNuInκ
P$*Yٰ23N5τZ^i ۞y=NRJpJ6y>M[ms/srdBK)axӽ^o^csԑ>ՅlsR7VtaI|O%gMzkC FO< NwJaF_ ΃=vø_I4DuYNu cM3ns';Tqï|cTկn@,G npq={v}OcQ{g7^v
R!q={q_77vHu.C8ǧ7nZV]Qf9IGDЖ3{ Ojk < zr#VOK/7S[HshW{tlm!JѵR&ooD< |a; sVXlUZғX /Etw3{u$ҿ%Ms<wx\uoێsga*kGjv>k*R_/mۻx9x3?g~*Pֶ('JpJV]\]4Mƥ6֝M=7h5"G1BW:wQ\ſق!Sq8! >_py=OJqU)ine:Srso7qj/Ky@$=>v?|;ix}% @93qShcV[{u>Oy&rצ	䟯j^h:_M5CC \-Q`A=JM$Jr8p]G'k৊lZtٳbRUٜp`ڶ:Ŗ
G٧Kb/sJPyd$g= y2&PNiI/6x/*aTX2'rMY6Z_}>룦/ #e1vR/7d,c  o}*X,̋8dpoHx j)zcW \*ӥoio$~WJ?z-(^{z lh&EyYܢ(۲q?m>ZxǞd)A{ }cWJW迯:SW2\O@/C[Manf`~~)[~ξ;VmO\oPQ8I8J[s_W.*wvh'1xI/mKTќpT<_uĞ%յEٰ	PnA$gIz9uDq3Gͷf Oዩ-l,}jQTsT` ]'ďαD A#pNz;?LJZXӞeshϒ9g(ǹlx 8^uw^=ϋʙc7E;?B[MW_2rVAp=x:X-nM#ջ㖡x
Cios0gpy=/7&pɫIH$ 6qL_;^9z;iiGWV~~%Z<9xy,`$	dp38|5
vXw=l W_,%(Z9V^n|߉?.{}`q&:+	X\,0{#7;ZBkĳ[aJ)sӟηR	B^xm.n9q	U8fGJ|!EͮHqGCG(Qk:u!R}l%IRH#2FMh=53r	z\(vyk)V] I{Gl$"@=O<ʾO[J]]"c!U'-tonx*RW)˛kzͶK&]bFR qLXrNyz;OLW]t%euo㥝$E:
'uI4rVl(<ӥ7SZl|<.t=?OΣn$T%FG__vF5V"Ru&}
NHi;}$.NZxkY$
9##1c9N
n{Q1r6g!s}Uzv~6jz| ]`<8,xa#J2FNgR)z2gat>8dp"dG|oo++r<`9^
RM"wT#	osSmF7-
mlc~u/4}oe's+IIEesə<vYLGʎ:޾Nk{}v0pz:z+'FiUsKSEmf\11wR=T? ߄ 
Ty74QKiٗ-Bb}?Wh%4xL9ly=+#i0VngWx61T]W ѿgKKYqO|;^"]#ATPԒ퓜A#
23Q5I[cc>%PVȐMe(u`vRXpW=+㆙m.x"HuVYl$ָL})JJٟ
hK%C=NH^:;6ōoL|6z ^":Gbg$8nό?ટd-D΢A;sNs5~Z\Zm33rO+Ub2<mhF%.7d.ZTIU&) 篧|[;[MvҌr7I)9/`u9\#VޑN޶}.
#1Ь)?& Pе[?ja-Y#.~H1r3Ҽ\l/|c%-nCyj' ־3	ʓKU(,
e(ҧOKuM(D0l4x3ͺ|2n@ヒ>';dko۷1O;99}|>sH(kuo	\/I|;=mma9n0q?h ڷQw?O/} Ց~Py aGLV&3VSpr`ܨR79~ Sz?$Gpی
8ҽ3$|i6۽2(4ϳW0F~+*T){.+VPo[~;G{Iy,*PĹ'Wyox}6q4r̪ːı<u#jiE{!t  Wk`Xlk5-/Zv3H'%8N:o=9]1Ui/3h%V\W #_-D}OX]HC`~l:4dH2rv
>G)r:5'T
d߉ȱWGcO>6-íq=x7E**
VNc.U㪱*iMYG_nRQ4s:8Y1#,Ӯ{bڸjU]H&YRM[k?/ O՗ DQ\I=?uw[
2gn۷|}&|kel[Sx*O_O& ^.T5U{zW}X咆YV]N,b*n  bٿC=f!D|ć~8cY 6xݭ-VtcnߏC~{qûՓ Zp5(Ggl/zcy\^96LӼ7wYtXĬ>ry<dgڿju3,*ji_|gX|eJ4'-ηⅷX' SzekF
JH@׀3ߓՇIE/u#Wͳ@2}=C@!nrϯ]򋱯
 Sun- *'=n/|Atҧq;ѱ  *?ri g~z]R#o#Fzb|%w^BŮ}(2yu3k9qqJtl_?fxBy("^ ׉cwu8Ýc~Pz5ՃSEQ]5QFf^5m(9͎p	~+V/hY9]EKJ}s}
ʽH?wզ3<3۟^3kTm	aCҽ4Z ";wS]KDj1< IKY
szY9Bn4&tcJ?O?f/~[^Fb0Hob#sJxγe2:\Ȣbf둎{Vv%2ur;>'}?_g+70ݒI<sV6HYU
'cQ;?iNq%V{'`$ J(P:A_u|YWS$$H";sq {cTC
ӾڤqHe?<&BpA{%OZ]^p{ۯz3,EHQ9s,g>%gF.cah
rEg's4o?׷J)Mݥ:wQM)^k[	taG ?}_sE4_Go('
Ԗǵs8q5,RѕQ[+]/7~qm򬉅<U98%m>
R}Vcdm.8=23t?=yi^M>pcYx?93[:v 7`p:z? mj%Uv|~uǈhR<Hn⏚8;(JA<SVgO[FI`ʌw2>+SW|״#ѥ"Ng5L
+HE{޾:qy?ƿv𭗄[<Qe~fiMON=3޵yK
JuR0
T tjqc+4ͷ8{}s-N𿈴ZE¸bpy': 3_r+A[29n6UXv ws9K]<iqtz_u_\<@V2O^$v+MSM-]ײ̑T@$sx	QKǗf C7_f[SZg쭨?|鄌Ct+1P񏾨ߴ>Ӗm׷U<0sp\br ʜaexK_w<|%W.:`
-Vg*WH\<>ݾ&x'
*kfY5yTU #r9sy9JRQqkopӒ[VwG_Q' 207somi>mo̯;RT0ʕ+~hsFk_K|-gW2GN\Wg8j4WvW^gjyj4֍~ßJ/_ž |C,~u`nXO1&֝UxJpA3Bj	ve䫐Gݎ&.~_ iW6uh;eH)% ס/ yi(~YI|e[% '8<+~uajQi,T_顭׻η@W)i?ը[U*8< +񗌯|3IWɏjG`[$?ҩSRtVd =~ּ9uo':yQA:FX(!_ >J3AueBA&3H~;BIZK_[t*TgB_ 4~۟ڇty9g+?~=ouOjClm,epT#F<s0nqⲬF<Zm5s^
1k:A|)yR6u?jBO
|β6lǷx|SʱoR9|SSS _3~R<C' D1q3힝5[O*هȩx<Yo	saSyybyi 񥵏ğ9yWCʀ{mxsK>L3%F;u={w|;KA5KsgN4Hۘ'ƒ\j>6do3NTɝ #<|M [Z;XK  Nzz]+LrxUE~GTZ/iＧMrG?'};WevΊѴrtnM{RP|2T1p%Y'o+e9#@8WYj&@69|׿JzW4g^[Z(T<eA{ǥ|cyޖCy(_ZV gӬd8[#A:ַ|f7z~@J*s3$\d;u)J得9M#S6ͩٮMTq8ޡW"\fGۼF#${D_,(=J[еlDY#+)ۜq|// h%â\IYS9'(Kv;2rrG~Sh
I/!Q*ɰA'N߳
1#.Tݜ猞:;VTtWĚ7x2vqmϮ~i cù$F@vzJE0`51rJu[%\TU^C̴O{,=! @G@pOmmt#$N8py֝vqw=8M;=]l|Q⇋oUe9厝5l+mGV\c~&'EFWv4cT{yv
5[>Ss}zgpep3H {@N=y1R[=
9I||otK.<	%vdsֻޭT¶x?ts`\Xx֝i{Et<n.UUgP%I
dOZq <O.r.it;iTcH|5iZq5x?CLtx{x3_V̢n|]U
~=:߁+?iVj~W?٧~7(;ʷL<Ѳzח	*'tGǜ]gٝNxW^mv:kG~4Kǎ'p=>#-N-n`1ِ`rFyl
֌e>[-u=,VY٧Ѥk;vOuG7
_Uưtc^'3fiZZug7v1+C^~sV>֬`>?|GеwIL7L#~š[N`$1ɵw?cǛƜi4ךf\%[џ}ggoT3x?B>o^2]
2OeY0NI#`Nzצ
gVJq׌dȶ;}^h\3'9~
~ugİ*+dK*>St
38h #wϤ ed:.'wUhqX6rp2lqEx෷M!bAY0q%rTe,\+'/ӾGUJ)~xmBnb#
>e
	+i<Ox[F߆~]ZStsF\.[j8i(jX*(|2o~|KRv7v6Gh"H`WXn')M/FV^fոII~0pOhRUh+ݵ< R׋W>+x h= .cu{$K-mэ܃aZ5v>Ft)$^KexY=>jf$K؃@!N>5j*cm;H?oDBq>&ŚfEAm،3Mjkg<ףY+Ez[>I?a=&9tеC+:8`du]8`u41<ȸ_҄cr+yVүlN4A ac8o9?JfBVfKxFxQ*RZ	cjPP];M_m
_w r3PUUTvɯ < _
 9n暩'WBqۛ~3OM}f9|H|= }:Wh
yhmgݩP<zh֍H:y[+J {d~7|dx"dOx?qx'F:f~X޾{¾' ȒhAh\`=s?:'/cXC&ͤq':Rִ61gτ0xX|9{HRP@)	>&~iN]]฼DJ7Q3Wf&8=Nn4>,|	|3jy@:G6<Lz6w?"oCRH^tRAὫdͩVrw?]2P7rL'Ğ[|=}9ޏ.x-ƓM(]/r~\gEU^npcSnhnGt<8D9sW?h
<iX?<=qڼ)Kce^iEt<o4KQc.cqұl<si>OU\'LiWr&	m\֏[jG;F 1m/C$:8 %`Ƥv2><Ӛ'ͨV
׎:>ᆿ7j	Ǯ#קQ_> ҵ9$cF<92.`0p2E335:=+im]s}jkA#cpJgڹiFr[MT4xv?% 'wQ_kj$\axo^I#]ۧJ1OTuu%Mw8%B%RŶ͞pֿ6|[_X|AIt(2r~7*th*i|<m3BEjwq)ev?N?wL!"n5X-ēyĐXtq-ߙ9ӫVl6N4ʣHĜtXt䎾C?@[MNvmU|潘Ry:CxXxS9`<V/+of?ZՋ/'KN) /`FJd7N9a[	q >Qbo%~Rdk6{kyoٺr>B$k j/ZUi}IϞ|zYLSu^_gMωmq}h3> |NwM{Sh"">)St8V9bOW}40~2|3kZ0ن142C؟ٷ>[hM'P#|d6 #_/PaQ^~NPy5J/(w3KOZ[܉%BC~ +g?" )u5|)SN=<k8,L(Ө+=:w8Ɣ%V=x~|s!5K8+g	+QcυH5Kj

ڕ'R-=
)%~;C?fvĲKcx[(F}~`A<u9KPQH^h TVW6w_~u#CTԿS޼Mb[.4)%f	 9*Glk/x+n/d
;FP |F.(}jߩ#
scߏP:}+7#=h].SGg?G~iwjڣ@`>fZŹ6Ġg9#]|
:hh |41:9(=t߆ _HLҦhE̳2] J
	?{ W*|tߎ~x:Z?>Xbܫǩ$p}~CNiiz&51u*ܷjVK˿þ8]FET8ppG?kA4"80g* ]Lg2ߒ>crV :=Zl>vIV-<i[xfKf\SX}ץ=ޏ 3ƭKGieadkL0woSqW'ţʐ  }=Y$#tJzg^*){<p|!鹁s}*BH Tlu<|`vi+ws":=G_To$ƻAO?5+/ZԤmƓZHӜʾٮ\T}UtRk	GX4>|S,x,	%r1Ӏ=8+ۯ?d$:G<"NtТn[/S+7Jrχiz&A ctxcVӯ<-c2yA@-8F)%0ѿhxvmխed|ǂy=N Ҽ.2zFvP]
Aw"}25R]ύ.u?7@r9`˸ ?J$>QS1,p ceэr^/ iWYlfPqA=p}|gᯋ
h+Jyᜧ1Cty<`ZnQO6cl|CWc( =5|8nlnɤe#*	PywBr'uo擌tWBx/4hC\Y X^Ú.k	^69Fkpu"8Rw>^־*:[XUJr0X O/⟅/u% a@$z؏ZCF*[ҋc?knHv68Q?5<n</6z|u?. FបQRmQse^o|)]Kv`;c1T?>"֮5vnWdNsRJPN.5?SZVZ# $ _Mk<'>K5Ge	m# 9q騿hk	ӍW<wG:L:L_ȗfAF q/Gմ#RBr=}8kǝu1&}_RhK==ఐ
Nqk´o1X5{X]ya==Vu~3m|DO\T\cWB~?"\]2Q=' +&5PWr緐bpҥVW#
ek3<m9-brG	=ƕkw&7|O|:Nr}5RKMkMV+}J  "8QǮN1oƹ A+  [OMI~ϕZgn=IxJXy<^#iᛏݱ>brs8UuTov?9W[᷋|e[S{*~ iR73:W嗉MWL+B]I8?L4ӝ/uk*޶>x>ӵ\퓆@}z*:PrTc)+ng)>W|iwcK
܌a^OOOum!U =:KkzP)-e>;H
x]^˟q8|e
rDyG1* 	cEyY*RMk\SZ_kmӱǋnUy\;r1ב?\WHRZogϬjǺ~<SWrH.[Sns?E>/Ǆy_Fr2+"g9>ݫ|
[bPPY7J_ٲ& F ~iLӧ  z79o_ctȍ9v;R0P7A펂_OVoF{z4(d}/=O.Asxg{^($v\qבpxA45h#'NHe9P =:++N4hF4Z_ϛaINKuߑ_
?tǥYlncv8@<rH\MkW6Nr
£ӅGRALN&ϷRXYQvk3o˝
Z]0	ي(qt<)sךKOҮՌ*_#%8: qft\j*jPm4mjdj2f"R>QOÊ4o麋-E#Q^rT-UxH=?G~|1`!x%FqzuLe\\<*
̸#+}S汸I*	'Q:2 ::c@8:q^ZNKedҲRZ%Ea 5-cz _]<uGL5-ȭu圬N6 $\į{ xKOF|˴}W*xRh**FS )xW<}Ö=%m,	Fy唱ڛR=Fkş~7xKǇaIa#aA;>f_
򦸰*:XE˯mњWww{2wĲ}_)lct{?=
"ivn׵zw>^'2gRյay5FGdtZ{QּI@
raxK+fDۧχßi[Y$B	 1 믷_hWvg_vk[B{WS5/w!.ϥ31
}}8~?x惡[iђ{>\*"{Ϧ@:-Ɯ]9T⓲>o_4[]cW\] Xt\ W~6nĘs<za8NMwďj]:ҶuI<rsz~'=[Ox%\O#3;涡J2Rߡ̖<"=zy23>潫nu,[p}:f&]H-N.h>TO nhw 7ch91UPqcI8W_Mr4ɼʫϙaH?\Y9Ū̮ #So<Y]fĳ)$
8|X\	c,y瞜rysV^4o}4:vV$#+w铁ӟּq=pi3d R:E4)YI/x_O&;8&>^|Mm~e"ݠޫ'M۞I?ZUok~w*ǖhWweDc@|qJG"Mo_xי@(I`!+ڹeA<mR#g _.=zbFO>R6䞇pOZx|r,`Ux~3u{,+/oJL_\_EK&50	%\q+ t[Ŕ[4I>pX{>;e.^/.#	,ʷs y? ⫡+K޲1XFC5]X%e rq<t	rqL zskZ
Wʭ򵡑 <-{ƶxCJvr3_>4{h_A#D&aB;^+
Z]R"qéo >ڔΫHҾɋ._W״iHTc8f]ji&uQ6~GxmFw1G?.1+R5FyXԱPYXHv;w%DԬm)ԩn~?~;xS~ CLB8 ( g8'+Ox:=~,no0 gΰԥԅ-g>)ZR+^g?xm{bBX9w/ĝk&"keK$H`~PHGl2ÿg=\U*U%a#v ~:GԂD̑)=r2>WO?b߇Z<#29!H<rx8Wҕ C]5nO<O_L+$tXHgv$ʕÄI g5K	SCZHmżGp	 䂱s+f9;MB>~O6jϬ4#G$] k:+wE$ن0]H#>y dlVPj.KÓ,s{d澒&w}|, ]?! ߳?^RƣMhTGm䁷Lp蟳om&Q"udx~Q:eO$EcV-ys_luMEF3_?%v.s<I庯'| +(MޕhMYvc'py/<}uKzkxjztt6/J6#E<ޙ#ˊgT><mC<ayb2S
rrQMzThr\|3L.tV ?62q푑ϯz.oFDȿ*:2|tjZ3Ͳ^ڜoM緂HlʹI9׊Yywp]#q'$g^U*m)hGŸy}'43=Y1@z^?imum5]%r	܁]83t0ym;l˱V3)@Pz־)--XsשO(?_aT%zf
B$a~;_:wYAHI<Wv^l'OuWkNE jxr+)K/⹉-aUId(''G!xJB"D\H)r<Eva'SZ6gX:n|ͫjWlڌIIs"w8z|J6j0!~Q9+%:iImΕC-"w:į=yBY@$cv u#cA( U2t'ӏ6[37̻~gxO>5RYlT1A^}y4_5c$|FFIzӳ~6:hiǞ9t]hP|r|^6ag#I˒HO\"A{3okb{Qeۀ+g9q\<aLVzeܐ8'ЦH>bywG</#Km`ߧUW-(ιAJ2=s[5m@XT't=kwO}cYX'SeN4)UJPۡRڬl`Oqwi-4}6OHfg!z{=8tehk"i٤ڿc%o.p#2 <P@o𯊴̔zc^r})֢K2%{PvҎ2@=6u}2ռu⫻=CTԧ(iVflHp;펣\qT-XBқ>_#]jMn8ws׿|VC}kq1ʒ=rzu#׿yҏ5eQT([?:ӯxI&i
HU9nx}\&ʬ|BFI|9TBG٭\Qoz4
x\.D.>Rz  q+
<CGk{vRs3q$g q#v8W;kXsӿ#7k}fA3)y=sWϟ?d1T
W?BtJVGs	/qZm=7gffw>@{~^l_sG&'6t.xg j+uZۀ#
>\gbw{{-RӰh8D(ceVvxSPڧe[kǴs;n[>uéL
+#*$NRx;z!ҵ5Ӈq1UAmyPD
dO~s\䞩{|t)x';\JY1Wېxaϧ=G<sWW޹nfӥFA@@}+XJtUWbX eQkd ;2š}gs_߲[0&
R]
ક9 +αi҅%+A/;Z(^y+o?k1IO!H3p1s]|cO
)ІhqS|KjIͽj~6ҍ(^ss%mHdc H#+xI4"O1 $v3r2O]W2u$JSKct_32y/^B?j-?^fy8'+r ux.3%$-rI1/<Aồ\1%ۻ dm䓜qVtmFFu]*Xw0D ;=H!q#rk|7>"×s-
V*Oɓ$ֻx>+(cd<w=뺭(ՠ7KPzO>XxMxj,R\rx+6\(GlZ<Z|[xI, r~`4թ۾q^2x,,TTTy?h ]u5~
6zC+̴~:=}YjZ\ϧ73E2+~9R3ǩ?1VIWeGSFS喾Ga 
"N؍܀@ ӷ9<T֟-
x%28Q%F2+
r{D{+Z~T~44BUA*}1c~&j֖<djd$q>־  >_0qv4=B-lx7`1$^	9 zoGu m;#+(ǚOMϒ%
aIՐ0
-s<
a X*mE^3> H<Qφ_|;sៈ^ԴY$%p{z( ߿_?j	ӼE:bh=aw Ns{׵*Ў#5C9[>??D?ړ:fK[y7  mv2HAyOثY7t|-m8?y-ݔlF-mĎ9U5׌ ,wG1*9Ru #¾|5v$On$E!<0G{&];4R-t)~Q'b/yԊ <4,J_.z6WƧNƬ%Ѯ!
o VOR:~4?Gm.Ss5Շ1-'
;]x!MJ&~\oL=|sY67as3ϵuSSzJMt>pgsx@ICzmfTykN:<STi:iIo b& #~98E-[BA_ ?Ng(U|CNQé%_  ejk @{k6֪xwSKn݅89IFJI_KqI:6˱u{-R妷ř񎤟\$tE)3ͣBIVaR2pi5IQCmyOg}kK[kCEf1a1
FGAqN2qRZ$_΋^"4[;Uf7\.~SH' y>+x׮r#,ϭNt3yr:Ưo-Ozʶу}Ҡw!5ωZu;fmAKib"d@O9z`#F|Y{hu8_u|GͤͤNV]*Bo|?>i(i%(cg'$9yڱq*ގ1ahFU; #o>"aUOz2O_<mItO^5p)J:Ǿueĥ/!dJy9$>4ˍS$B_vӁ#83kb.F~^/yπt}"2;4Wq8!zd~~خŵ7KmxZ<6y~J5'f_ku>|+vi6sjk۝GAx]aYfGRO
|VW\I_q=K^cյ[ L
e
{{1]ƕx%,B==Gֳz.U{z3Vnş
x<). F
gg:Ggn/..͞vqz{Zp}ct?9[?DdO6|Zt(V/!u%Z]jZ5s43Z	lNYOiUF[O[pLq|FBkZ}dHX$<5&Vr-Da8 䜰+gF
2m=> 4JRO~)Y%o
#- pn/V g= pV<@dJg'}!k ]O"6E(H>v@'qҾnGDņҤ}^:קITi?`״m^0񾅧BΡv)I
x,NЮG^~'ԬTrtT@+vN:a
q}+r x5JGe̗  h
ow^ŮZ?iPVW@tn6tdel_.|YgOܳL|c|"ܿשOIbMmM}䪒3'>OĿ^:_ཅLӰ}>g5Տg%J/ߟ̺5_0׼3FTѡb@bfUC8G?Ux>/[tɷ?yt|c LWV(Twk8F-WwowO^ E$.8p:`;dg?>R%Elm,z_;¼&%Ԥ}]X*[K?LfEkejO8fpp`$\Gk#@f;aL}osฆ"VK=E'Y#erTz{κ+[
sH~ƾDq^!,I4n:)s W˺H3'${z򱵗34=l9J1
mNzNkhҖF	 1],\踴p/x~?ѣhY7Vf>& 
iڎ7,7Ȭ35,t'9FV<N1)4|_	%"|UMJ=ǅ-f$ \8(m W㷏_]cUq=nGkbr)H^/y'sE'_'өt wQ_ogƿ$GƝJ5Z
Y8/@Ñ/ۨ+f/|4S76*8ӷֺ)lyM&EŪ6Wnb}Ĩ s|OoVUNa\yR9#gZKxY"
 8s?]
>{ӝIg+c9V)4z0^Ə<ga[m.7\	y{`*+(#Gj#E(%~)Bp3Wz,ԓrE*2:2"ɮ's$3p7;p8khEF)#-1bXS*h ՝Tfp=}1~k֙ᆵ΁ w9<
ʼT涡5y[xZخj.[x۸wg'#]>*GYܟ$Ag<Q^2M7&: $h i<?kU04e
-tgCmKYvn|ԩŦgNY̚}3>n5+wP;3R6dֽ_?uxzibFyW@9㞝{~W8jVN9zT Pj/nYٙ!ےryz s o?[.Uo{ZͶ>zt[w%
aB089Pմ(o
_ZSp:U~RKv|*Uo?yxGQ_
,#8#}~?[k\$hT#8SsF1V>_VLVk;]]?>G ϾzY'gmoN񦀳i :;y>ߕFч_q_vO8 Śf/`+;@?vqGNy;xN2v&YYYpP]XzЕkTP|̙וּMJ H`e9=@v9g+okxlm3_B)ctcT'9\{+1&.[Ek'n w?_iR4(KpNG<7sӗHW8<dy^UN>K~B<.SqtKd?ž%L·ys6({cƯL֭dwP*EXI$Ks+{8,Ln|cBm%ݦCxc̓*APrzs^9|G[[n(y \׾@S+-C݆zw}:gx䲼{[ʆ+$ن
Y$HR8|e>lV&{ \ݘ 
P_3og	AuX`i%1J$<iaAɯ?ۧK+/sj:EfW
[	wWc9jNo O=|-J5(+s?" /0b׾&g,D
Y.bŘ#hOcO'lv2&6;aqؚ'V3B;Jwk?4|Z[~}]"9RW#$dq+otHMm  N=S'8IwO> x/!Paޣ-hVW
q .|EC*)ӭ|TZ-m~*_dǺo5Hn;cr"pGʿLvqOÝriZd|HA1|QY?
灩O[<;
φמz7$I-<,1AßjZaH9Y^~+<MQޞh5tzjy ><I_Zad 8
p?ϭzF\<"KĄr'ھ^n*mh?>фզPgJ6ݨNlrp?_4itR[6hR3i0s{?μާz"ted('` a.ݡI\zV2F ?9|nZnzW<[ k䣣9Ǿ3ҽXV!݌/9>a)CI?q4%inuO+5L=28ҺvJ(ǚséb0'w\{>ti-K"8  ' ;x}tH gUOFѕ׬jY.Nj{  ~|E_xz5Kiou2
@''$W0|Odǃ紸6SZYrp:]DZ.*<f4kR56LoW}8fr=A?ʵ<o=CPԴs< nplgW,D%fӝ{EK7WnO-u,NIj<]'oGHc!F z+J|cڸs\GFNɮodS\N#
w$P  q^>>$fb8⪕jrW:($sm3A2zڭfsakg(4sIrCS`߯GF\@nMsԯYFoQO_<1#i$Kw}m<Q
(;mm ~=kS)ͻy&煾\xR\5liA99Ϧ09|bZ#E䉑e|o!s#9{pb!5mb\ڭvf| n:k(N,@J}q_z>,xw7uk,0=n+XXO[$5o5)ÿ{߄|wݪN1c8 g;-ҋX:,.sQ/%kH_\S?1  -ڱ f  W\bUhErݯ_?_ϡ>d`Ⱥ[Hb
AV<^<,FRb>&| V?.0z`+KNM~}Wd%8-;wVz4Z#)S"1*3fG?ֵ!avLX6@\We\76SZ?Ťtaǒ]O~?~ٿo<siP_$79^W3Fy~s_Uv2hZ	tRG'pX'93SO]*},)ʤޭE> U e?:_KǹBygu8²W->A ZCczG>.e/rN:dn9F"fNm`rK ,GtUBʷ~K,eg!
;wWX<uOo{mp>5B^ULq 6r|VG.Juy_SN׺0~ #X֒/)I1vs 3kj𽔷ޯ4vUs1qי	T+8W^k˷>"4iG~-|Df]N;H`MSv?~)?9G59AndPNӂy1Ts{z{|<O9KKa-ՙpvpE||1W눧SJ!eڤPqY1>0IN)CUۧmo{)woX"J@w	ЮAoC``⺽u+*1q$#R\_*!<`}x4!)yzjrx<_㯊Z|q FY IBJ(x2gx4 3Hq/\"ByU!J{cq	Z:,~e<eֲj[MKhɾm.6;n!+Q NwO]Yk `O->}~;=Zvy_Kt<GmrKu g<ek+WWo\2Fn9^^[)L Dq( wRX3q۹˱X=/ 'ůiZZTd&csn'$U}o|Wxo9.dvp@WYJN]K]ףii>$DѮY|6exP"71}:d
cKiEP8,AZUogo V=M%(mt.U fYF[y5OZظ?g,q hrp6ӵ]D]z);\ڞgʹ䁌^{Q~ŭBeIh@|^q}VA\]?SN:kxS,ě.H}3^W𦫧.ujs6s ^޺(fQNU+;Z|_9+eSՄh+5cKѼS 7$$dûJ0z5ڇVuEO= JVWc2\`?p$+ӌ2"~^5`0i6xG0
#y>~КV[@ rcj2Ǿ{MWVP?-y
N7]Gk⮇&9x'9#IѮf	Udly<rzg|6&1wO_>?M~yZ_4kxQ#d*:`g]#I+Fkz1'NZbedtG#
׷'ߵ\+e-wlB	]UoAJq]3^Ҟ_C_T~x s|B!=Эd
Vniw*2yzWǏ^"k>xuԀQ>鏭r2IZHJh(M_>1G1zݩ[ǌ<>]s95?쥨xwKm2DVe( =GB]<U)JGV<ꐫuo#oaoEenrw83;{יxC#~p΄fF..S t =ӊ֌ZKV Ų|`3?\tzZ{Yx{J°0H 
9<w?ftFmtd5&)Bc+t<X d9ZO7<mT?HK|SoF͖1^g8|QmSÒPO@:` έOͼbV7gn;f+R3۱WG<]KӮUHݕqԎ|O^"-M@퍘	#~Jus_]Suf!ό j#QxkM񮢺 G ;q	#~DּLdnY帒Wwy$oݞ:kQIΤ\ֿ*ά#FR.߯TgAFti,a䎋׎c㆓Y4[[sV;Fsz4#9¢éP+M2.wefs֏+<?jzv8d?V<[oi&$6ؓB]J @,)Otju.de˵Pp:ソFndk~97V];lznψqIL~x%&bh"fLrNko

p/GSuٵ(wͯjZt)&eoCߙ`3Vb#]JV$vJ Y>`**N9+YMOšDco|A5m'J,m8CXDb۟Y/SMk=k0!I+; q4-*0aߣV*ח+Ul|8 BGb>q`1,/]碚5U:uXȶAXwmǠzZP~_WZkX~9k[(4L r fwE;~6\k8˃8lg}iFXhەtw8RԿپU =ޕqL"mh$Jldg Eu=>avHyX
Ȫ ?+"K0r }Բ<E<fY|Iw9/
^wy:Dʤ
9Ča2E7$ng3*"gaϋx߯Uݣ'4 ~ymd-梤c( yQGB8X\3<٬E<"&p1xVg+]=}pʼʟ H^K~_e(-;mX=Fy9,{M53$I<Gs
>@9î}5q%߲~XNSQM;_M6"/?[pj,]2
U$888_
]ZFϾ=Ly$`Gˎ5x4^s&c<Y4ސ^G7 +cWZڭ-2(Jā'jd }MJecŭ
ֵG+'M-Z4)崠OLSLٱ4
?U3H g2siZ8/sSϳ>gY<Jo@o.9,9^dܑ|'>\k,:),N>C}OL"ʑn=6*rJ5k+oF#{uD?x_Fu}f=RTIaD_5 QA-渜<99;k:魏ѣUT|i=R[߿Ht\`Ӟ|'ӯFdR̖҂<31ִb#%R.7]t /Cq%[ dZ[χ:66"2d'?3CD	,݃D΁K0'.IW,p|cw=cVê{YK
*:,7_cqn`b`-U&Qp޼x;_-CBu)DZܘ8u
 #Qq^ɫ&iVC˯(JMm~{WůŞ%zėt
's Xa'<i}&ZKY!iia`3=$(?fp4Te*tW'ǹ:PUꖽ-cEik:h.mvG@pSW?.w¬e J~b~t5RIIj__׷I6ߓп_g,#MCL6$esA!^<A.(h*}
ėlgfӱ&Q^揱~|g$OXiubF>
ul_fx#D^dn3"ǯr 1+%Mu~|iQ6>ӼVQ$2Hbz%GG m1j
$[]DW|?Yȷ#0ɐzk㿈_7\76^ d9OkiMZI.tkسoeפҍׇR#h; O׷#Ҽ>Դm8Fyq<wҭ8ԍ,^T]7t>/KKPK5qsT =×~.D
rwc<g8 9b#+=&]WV4]<aج|'&s8\=ij:lhvy:eR&rFUhi?­#_UtTkKSد' `cy+_)c@F	۷Qҭ֜~Q("/r<;sk=I(Is\΃CJҵmfM[H@_Le	sS.i&.BY|c+gGjiz{[3DMx9ʞ׵eCxScqtc׭>	 ;$ҿ
w <}qקs?
-&YȈ
``R9V߁ƕJunGi.KEX΄*1?]<nN:"]VrC)LZT: tii/Z;{n\B6pHnW3ǅ]U%RPASM.OS?xMu
x.c%Z\Zo|1AX;tU<9kSA/#IZn$Y«a a18^~+s-VwߡpG
*"򽬽,7IW^XLEV+A>d0<ğ{.ֲxCNv[jБ3Iyu,Iv4W
!a$?KGFqz'ݻF{
np,UXӞ& 3K&y<iamCHq춪LQ.QFvT sK	/ŞKDU+ox$nfK!@6"y'8BoNE N Y|1tf;og&[n3+%R2\.߸-KU~oGYEĐ[-7l1;~,pĒ"pӂҩ<WFWZ$SԜ!)k ^#A_Xm^gcr xwpY~DC|We)5ǍwPQ3$dKp !V9Zc7& ?5M{G. ~I7
z
c@ɽF ߥ~<Ox~,<o,Yd̻˶w2HIR)1ѻ_;[>sw=g!e1]Y<v+Fgˀ@$G (Uυ~!ud23is@,;rUJ_W=m.Tq
Sz{y=WNz;
"&y
&wg1@b0NNuKl$v{FIc~w(88_7N1W{]-V5%7n'k]'Qbuw[ͨ[@.0I8k<Eo e$ZYOR]2H``H#8Z4ʯw~tVNiu]/GZ׊.,/w)x]BLlۋ1YH)"0^կE/"L	İpHH[<aGZVqvm|kf֏Sm6w)dyK=IuyGk|h&qiIP<zЫ	ӓmFɽ6zLTd=Iݶoaw .ҌB0:V~>^( nU"Ǩ9
½SKxj߻>i&z.xtxf2mʐ;p ? hmvŭBddͶRΥ>lOɷ d}=7
 3өE:<SKofQ6L:qyD͖qk|J)aU^ cr܄1,UR"f@K~Y\;<5աI;ӺkͰ*k*,Ghi/]:F0kF,ZƗVBp)`18A#џ
|<cjڽl9"$Crۓ|vYQj /d:oF}Go/]ВhH3:<s0[h8<o~
ōS,71=O}N^}WѡS{]63Heτ:ǂǇ@f+9'|Sŕޡz
A#
޿OCաN>{[SpKҫUJ|? k*=N{=Ima[403+FFT5B|>]K·ړEki&g#yRwH;ASG[nwcS?J5Yԧ,
ުwn}sj\+P){ͧח+O	7oo$Þ2}9Bx4_&VZC$;m ٹ;GNظ#cc%(  ~/>e|%"Z亷HQ;%s
~ ;F2c1xB~~8=r:3k	&%oCM9AM61Ïër]}̳lwo8z$@5K跑KpW$My[a/gxy̡T?G}ݏ<;^HVKL`N{zuzΏinmM&ؐ9;XL{&?rM|3WIyz%lo{ ϯ>5>B2V@݌d=v﯅j׹FZ:^;|&iK K540$&_lu=#[gn\.3è*F1۞Z_=+
+Egf<O'h&%q(7̤O8O|Cv,|+c=*Eq^9+dх%<w[ׅY?oyώsխ^Ly7(ߏȯ,<0jaznJQ==kãBN*To  \>&Y ǔ́ӌ{5|2.اѥv8ǥkk'{W 3[DLO1jNvөk<1]Hwn#dD<61#SNe>h͡Rv}W]:"<?O\~l?m}6{{1Џ;W_9
rn:+}zf{i^.jfRWw|W 7mV++(
3׹5DM,S7֟wֽ꺑S}*/˃沼
 ]IM3
o|%8Z{+IWmv=Z2`r362@&~mo2Zoʖv=/ u{{`,I'!܇d
6	>f>{CK.}.W:bF*vI4e|Co-5&xr]IsoRD=ZmnKl*	#y _ic jɫ;KYY (Dշ)VG;BMIf[oN[[$mR=Jiz~=1fuƊcs1[q3!7H";28v<{CT. 8P2ȉ"<m'vNrOc
R}mw_CPmW}}K[;H:	,4XxL2aW"uOi?4o$bEZ[UZ.
	gSrn1	ms_]&嶗j=9VQq{.T]߳_ώ db?- d7Zh_M+`	b$(Qߞ/UjzT-aet%i"S>	P:U+)?qmWw?B,IԼ-.G{!o"b4vO6q, /Mk_H%P&n$6Z&4ixfuDҘ$XRS٦]ֵצ˪{,].yieku4x:ZGJ"L]H=Bo[i>M#Po[F-.nb P0,y$>3
f&|I]߼/N9R-zi6~H4_xJ7BVown8l:|;DEOx>A?RMB8idP[T]wd#ldx*RTҳwצ^]
ԧ,BI=͏s'uԷˤj6wR4BۥeU!#.0_ ѶL,HRD^ٛz@8N~)ጿ1U Z [g癇RxM<uiψ ܒiGwqo,I rs~2x+G#Iun~Щ W>f	)B}98e[^z~##Ӎhc-սw՞ 5BǶg`)]d-_ FcbU&xLgGJ
CMH	lQ+9ޡ@SoLl%_Nz{Ct}t{u;l~%Ӵ/xjLл0bI%Ih_ĞTmotS~*[[؀<Qc}TPF1yը֯{?)֔%s~5x.qԴ2xaԬ.UiEtN1۾l07ٟ
jH,<?Yjnt~{$Ic' r @~ô_S5GDKx

-|Hum&RؤFb*;b;a?я6x7q,zo}SH񰦬Grydǽ۸H|a)s5x m ɜ9.iW)pɢZ{ Gޫx[|Qxzf,ڌT͡d(2X}-szo>+[A!X&E`$e6z#UIJ]yUf:ona񔱮#&t>5O%{i,̬%>;<CA_V&oúeΏmpɞ+d$b&<Gd+9/u7MOϦEK{4V{R>?k_|A5]zSoq}ܾ7['Tx!C{ߵw/&!B7H同ʫ )==3bUk0zجSI^M藙~_RK;u/|?}2*cd<a`F|djznbhH| ݝgs7ײ,Ugy]+;~.\ZX﵉;dgۏٟ-c8I⾏	ĘhR6캞F/QֺrM;2S6ѹwc#x<}-ŏ #^ҍ<kyq<NnKEh'/*l5rPjj蝯VU?cNn5j=U|l$>+$0BBʓDq%ߌd{v/-8@s	benY eT:l+kx*%OZz lM5.Y+;=W }q//nd`[\2]T26q ٧
ر;mR%yQe|㑍^V//ӳ_^m-G)0bOs,Ko%nH|eO<g"nM?:][7
jh,Ĳm
w|C IȮ<>6K|Xp410T褛o_'m@C;J	Ka ڽAMu#HP}0˖Osbw_2|7u䊰u$N'{]s	wݽC]Sv*:=kjH6d0d?tm	YheRroC>-frF'G$O\t&_5oCoBG'@r+ů<6"u+w=\30]_k#~񟏼6 ~h
x[stq0'g\ t|%ֵe3yU	=3JcNޯY0z
e.˶|m WM-;LEsr{6gԼq^ qsӞ+eҋj54~Gߴ KwM_kW:[<2O9_(gtodX"C0ݻC^~#0!VQq:h|	yjzWxoUAshi&inrIPӧ~~iIݿGS
:U%N:[ZҴK  ij1xe>*&<69Z* Mz
8f̿
v\_<^ZEݢƭ4&,c9ۻʐ _4cWSUH,P^g *YCUF +RMmݍKOZJO]6/}CNגLt+kYm-oRO>S֥
>2V9;h`H-#}rEC3T˲v.Uպ]=rJYR׭_ݱQ]+V7POcOp 3F&?B23Hx?ව+M%w4X#]̇`Y7LR1.'V7 TS9[םx9?	Ʒs^Y &TYnRfew<ρY/	' ;;DߴrjvՖkx#HٹcHrv$ROܪ[7-_(FtI^㏇/<Ysi,Eo*c19H1aBYq?g^9V>P$mb	\ h2ܴwXo9e,6XʜNm7OKvOwQYTTgVT qWƽy
fLri
"#m(qjП-Q&X<'>|="Y|W"XU<F\K$y(].T(fr%݊9߼QWV5&ySVkv
ͽMuni[[t{־ i	Yv&|"i[b 	W/PK$єQ  @՞M8uwkU)^SV{i4j- c-n
rIKлyVܳe3ߌ?i >6#cK&q:&)dKAMQbrwZ|zMPֶ/+[{K |YzF5[HΦcem q#7;08*aI\|'oY6iKӔbS3D#pn
 fr$0%o*W.&
_J{Zݏ<
|P4uyxA <9kv.6nѢbHQHy`iZ&/\<},KQ岻N
 &8!C``Vt3|ELＣf׭&{trҔb+_mzxsW~1_>)GӤ	
^((,1(z/9ϩ<?e[HB10Έ/! x32z)Y^ޗNt<Z\;tUv[[赏-_$o%M*I,h7 #;6Gπ>\h1|;ĪQ,}L6&7p_Z oUsB׶ޒ~kT|kD|wg&;OsxQ< ^LI9T'?/|RX}F$mjei3Pv  =XʤUzveR _r>A}h >':Ϗ/4ZZ#
'9'p$ĖMUڎv-g_Th;׌=d5I$&{%2+3vw 3 GH}_o!&6mɵUQd _X
:oxS3MMvlE.cHU]Q*@,9u*ʒV穷 [z3겼Xza*+}9ӭ^#,5Yt?
4ɧu>,D$K3<a9N?QƳxǷYFklm$-Ȏdއ(sakqvYE_]Ƶ9Jѳ+_=W3ۮϞ&oN-m~
'öw*JDI=ё弊H N؛99߭  ŏG^;CPVۮݶYa'_2т(Sh&zgZ%B+٥O+PsPmޛ[G??Y'jj4kmS7=(ݭRDYbĥ(hZcF.<}c;vN nVbo#4lY*htb⬬>w=:1;Kb?
.,[i[Z[2EXet 1MCu פ?ídj7$PZLx+a(%%25`rC,Ob" 1x+D޶]k$MR=N:]S0䉥)2	)򓿀0!.?e?jVͽƕhfO6E]0BB#Tg
N2U⡮zz~/Kƥ-uWG_γopZ('XbUI䀸@U
9~VZPk45Ĭ"1 pT:&;uECܳV~u}O#¿<լn]xS4|2ڴ7'xV)R:x%];"_>/ri
6F}.97J^V7gVr79WxjۍUhԫE:t)E3WM'սOx;G{6b
oFe=5tf{Z"kXp0#my~sW|Tuf̓Tmn]c*
Ɗ2@%Nӕ tU(f&}4m> >>6RӝGE/_揻?d ]ioy0vB+vdN	k x~3ŒYDv$8 IhI}zƾu-t~|+<}kY,iU˂NP0x>ygZ}؀%<㿭}WbTm_,ׇjX_wCO|zcm>rs	ڽSOo:	*>:ƾi	B-5o
kRIm
q8!Xjy'#`CIq9G"jRoy&yb/U-^$ewz}3U]7]O5mnmX}Rݠ&OC[hڋ54o#)O[WSeT1vZ*Ӧy	Qz9_CN]^,&n.\,q3! 9ϵ~r  )%Ooog5RE1&i1Hx8B0tN"wrӶ+>20xsDrވJH ʸ<矝oþ9𥿋A8gxw'lzu!9}iśbb*6wWjvqkAa		7C=]?Vѩ]4%weZ DL Q$Z<r1
+2(rXHXs!;A>ojZ|g
ܖIo`&[Ktpw&ƣiSv}]% kѦ7$۳bOx6 A|enoumobᤰsFE
#°H<;-Z}u--V։ir*%T2FPHAT*F]:_C/~qCÇZ]E6j j&2OE
2ݗǽU5xOÓ e!.wk	a#=bĨ>Ty⭭ץ.BJMkgOAQѠ{YZ+x1DMd$q_n#eOXO	xc#uݼ{;K#s\@C YHe5JU"}, MSӣ8Q'%Ӯ^ĸTogn!%i)n]<8$I~#k
|LE4r^IK9FfKxFWbd>r\W}W#V7i}5<T\h:_R$_)$HЍUTAhd'/l6&-tc7Y䂤0YaJM'V~v<`o"k/IڔImy"Et(e*A܎#wF cIbx;Au~5idҭtE\ )wG\<ʲsHԯv\^1o䬿W&O
i-x5iLע/VHZ~h9!ӠkKY屍s-o8*,(	-JQtE%ӳ)WU$}$O>o?xQ|gq[yV^9dU$aUb2LxsǃCKIl.mX/&
<q4+elPeܫ4H+jҪI{kfzu3wejT8t޶&z>F-+[Axו^$v7PF 6_WO/|7֬eΐthƝ׆{s7U}Z}M{Zi{rN8?.d}tV[?Z~OqׇO C$OL"Q͊2GY:B }[xs?-![{5/5fd)f6$"Eac9
:韛R>zvN2rvٕ2J0R9gurM-lݵW;7M [<MZ{mKI[..wkrq.V q	3/ńǊ4}ZmNzŴ;V&$q<FV@ YH e8QԭYSI&ߢNۚt*:jSJ?[3C߅7&n]ۮi[#x?&EY!iwj@tw VoY5-gSB<3z(g8?¿H1q8:UhY[ߩעJ׺mQ|OO #m"Ť1ٶRԥ[7Ȱǧ^
cp?f߈$
iw=J-7.3E3ѳÎP i\M>כ-xxѩ5{=~K?|s_[tY01	WWmbq)mOQ4|FBյ,_Ehڞ[!dTypH}ߛqnܲoK+ylJ)aqZ_<EsIk-WKXu]BmJI"7mZQcsnĒf{˧QW߱w&	e/5eY0?b:M\r3\)U;ͨ>fMna	aKOZ&r:Qh%P5潸9cu{R)Ⱈ̗M
I%/<wUhj:t4|1#mV2HaNWP۾o[}b%({ͥӾݮx+H'>r}rm=PQB6̲V_4.[9g7WhIu+oI-}<Ė&^/6?0#ʖs$T~Z5c
QJ:z8/><-;hv-߽4K
5Y
9$ 5o"\x[χYX$PAn<N,m8lrS8{;Y} FH8wQIޏyѼMiM~ZK%mYoD]Į܍s_<CZ|A+Y-o2I-I$RMg*
Qμh4zj1P^so6Vygz^|<I9/tԾ4zM[!mlj+nY<k׃b]<k2ga5ʴX8.]\۰bYZ\BԩB_2~i}׼lt5G;Iz-R_7s zw{!M#N:{
& F+LB0Ge$nW|ǂeOxvůQ])-bQow1R-KLX2qVV~Enq01˿+vϙ}]:~ _~".FV
gK#[GT)4xy%~=꟱ŮM}c귶^Y5M&}k1d$6ʉ%
+܍jL:N_m~<JI aΥ{-THo[~> dh ;H/A5ֹ-Ͳ	}JJՒtмg$;o5
 7> w'֡{]jkHa"X!Q"@XCL\cfi}v=|&i:4ჩYs$4oGOc<4_jzEbhgx2I{2Kyѿh/QxŶZ\y]OJ,vsI9]ϑJV齿'l\
H[]]|)Y/S<MS}W6gmowyx^FE#Y3J͵y	
> hemSOnCHg*H]N3>tݭ[+=U(i?CZqSmm
nȬ۹
;H5mfD-=ĥ-^YG$2pXPʫQ-mܮx<i]3:TqH'
2Ib?Rq}+o~4-.@eAULq|סOO2oEߵ>;~w
Yer,g$o}#֬%ƟĈ7}y柳ZPGrɣɝ	S]~o#}9 ѵK@RXlʤa"2O?߀n<Syo6om̘\q<VJ=,]d3#U${oi-ߕQT=ig_o"ޝ>vwY.JG&J#;$\W}C]յDQ{;[-4*X#~0*54o3JWv Jz}F|^fd&Qi#dt y_.K /מ5b	ЂM 3ɼO;h:L<Zt+$	IoH6"T>iZuveY4yw;ɽ$U['LN:!_kKwXNzI[Ż-CV_Dby0<`1I,G$X:F/xQmW %fJ2GNp)'^Q6=m=4عu)I5˦ֿ~ѿ)l\jH5/&B0\1"E+ZauGš7-"yx5LEH7k[+|oNI?}~O%񶏧zi0}Quł	H}R2kҏ߈bKUbw6OZrE[^_r^^һKmoMt\}.#[ǪChVy+̄ocu=6̶'.wit1Cp̑Ğg]T("qrWR[R_ծsҡUH9ݚjtvN/S/u#MFYhcIl)
_x^Ӿ+xR.7&+(#]
뚸qMNZodˮ4e9Vt.n뭾oCƼaKW:~sBFlgbg,x¾-)3Ҳ ,͸yjTFR>uוWiio%hBw 
kzΧ[
r9s"ܢ|HFw7^+|ci+α{x>nuWDlHTЪAp	QyAiݿ]`e<]Z	2k~vУ]#IҼS;'@hai˶$j!Wx yO^]'c/ &FD䑗bqVRG{uoϿNu nQKW#>|Ӽ]sG|w$1(\(ÅTxCgo\K:,mHFBT3}0Mٷm.tvׯ0J1<<vWV_o<1Hh-񞩨XX6`j%h
eܠrx+\t~6>"OiZ:-?RƍmP,k USS);Juuwow$k~W_B߂|g]Ӽ-=̳=vhƌB۴q_4|v=PmWXDd;B3*(O곒猚'y.f62Go5GS5k>%TMuqk<6Grvg@uvYW fzfw4	l7m(]%^pU4&e|񘼺zt-,wihUӱ6x5*z'ߪVi[j Le߳o 5Z׍utf)&{8xɘn0d zg fZK]>Rk4 jg8]3$]y{VLV><ݼ~ytQJ V٧-5-|%yK7,<n怺<b":{o1=}7"hլWNdmITgF6sX6Q-TԍHxe	]([mxix#T}ykCG~fEᄒ.nnFdhkt,cwOusm}B_S
6[ox~Cr$`+<Kb_yR6զ}z?wc1N4}$M-?ō;>]'k%r%vM!lo#*qWM֩d}
asoQ#g *)¥9mk٭7ǟ^)T[-mEM'VC!Ťjy}J11JHNRVB$㞻^RH#Gن%mC0CVc^%S}6Xʞrӫ쭺NcnoY}6Gh7Pc-`#aiU]xG|/i2ޤ:͂ k<DSzƱpˊJXd)։ndռK[+3*K(v[W/>xZWĖ6wu+QiZivY
cTt8Fl|R/%ѯѮṋS4`eթU^vH"N!2EP0zZ	6kj/F奶Ue&oS|A{]U/-WD#ҤF'XfXRglDHB^ľ~|4<5|I}gyj0A=RD B0۶**<(ʼJzkwvIuZ߯X܋Qz'ʺDD5ͥ1lKuX㽎yZo/22-ɕU$|?=^j^85PUT$`jcyb?e@cFS1ym148wo_{Mk9RtەҵJ?՞x:n~8&O0C3:F<UQA]dwÏ
kXC}eZP6mwCB\TPȭ( zm?C΢Q))KbO7V<5k|rVĿi)Y
$TܸE/iĻ++]GV:XN4o3'Ḹn]+?r1o]-rV+ZM7xb}DX6g*Ct5տA~[s%wR~\
x	?j:gQyrDUJ<&ndU$F3XwZ{ZZN멄9qwwv>wjҮE
:Lm!G&eax!oI:S_I֯6hj#KU(VKV[呝Enc&F$߲u+zw}NV
Mkvvӹđ\x[J (]Z7;݁d?özs%JQ$Qf5nr
卼&XU<2;ڿ'R_,:X?n|:Ő|EGRm4k{jh+2rW˙Aq?Fxηexo8`W+(V+9q')я"vUkRKF>U78V__$n=][Cc}
֣wq#\Kgkdn%p(/Bߴǀm~):ޝYy%+b#IDcp+ptsNm&%o%dqՄF)=n_m|T<3;Sͥ/Qs#9D~fĔŗb`VOy_ѓ/ AWڤM٘I|QtY-9f3|½>*<y62wmt뷑ru4|m}m[^\dR'q7Aq<T8}zm|c:tk;ͫ@Mhwb@~o;)'*MViS=Rr a=G\-KMxm.fUȻCWh@r07'7	 ?Ex>gg䣺zC6ݝ7eʊF凣dvȮFyskep.\r
펧=k֓Q4ʌ/]Gt^:}9XpU%Y#v++Y'ɦˢk:7kq|n.J$8+XӞWwW=ŭq=?z'Kj)61aI| '>-}^i$Hؖ'$@ eܐ	0ѓz}v "iJѳNݖkJ3ۭՅ O@˹,d I}XOjs-a37uYC5_Mvv:7
X8(1 Ieim:Ψ#p.0riQ>ٯD񮣩N𧅵Te׳;NؕaVSK(tXVj:4~C7R#)IrEuI}mZg<iqVxN6	o*e'BEIO|8|B!\&Y3q#I@!'wMU?iRK%%+nTz0=OW5McɛV<#kjP%Icl΀Gnr6+p~/s;}Yo~d	*S+W6'ҍ8Hj[O8c'K˧u}WVw_>tw}e-+OX;np	\;w#'o'WK`Fi2"8"bQtc,Zoݴ}_3g7E-=.<³>>_H"dO+,d5'Ι6dmS6mkT.|e:WMCڹB[U [zRUMig?{IqxbŤ|eΟq)
q.apH9<K_{k\!6G{ndG3mzSxPUMֿ+mwuTSEBfiVφ PS0Ւ{MM0Ŗ'((b~dRXAM;KSϋwA%FVUs93^+jOwZ_}^(~i4I.mOM$.$[J1$ן.F%$הKz&|o/.]:<s'co%KFq]T>T ynv֭۴s?h0=#m%O/)3kz6bmco!֤hav%3
nv>^o?LA`>
[j>bD{mJSmҍ%(ͦG
>zX%Zz<[GׯY5Xo&S)'0;$.A/u
MwVuޕ[KM/0˸#6Wr6 ȮiR8n2ti[9F7Jښӫ |9xODB׬UiayI,[儌DYbKv?x^.BԬFpq u?3Vr,<,X]zt9>]v~;-{Vo<S 	/@nuO*+P*
N8ϙ2+1kϊO/
S3Oű^+](Aڪ<Q2˽wnc)*tN{u|_
V
޵\Ru)nZ683q8>(cGҾ!x~-KNQSH)(#=z6Fk	u	){Sʯ^*qis^R_}ݱLch:Nm#<iH)<[9.	bQyO;o3M(tv)HeLuU 62"P~grun1~VSߴR^$E9iy-|&c:-t!V.Ϩ^^}hѕQ T8Na{,FIv7VWgd7~;_z%KO|+]?OROhw$R, |Sf
J}:K/o媦T6	h;(t uw\h^[B-?=nfv]Nw3Iiiz"EH(C
XO_i~ |Ei?$4\e"jI
ٕTd)Mjsum}{t֍U;{Ik+?K[~O|Vsy`*3ȫqt*@(Pڻ<'mmֶKYm )>0E坸-lBG]ZB|yhޭkUU{H4с^#sxcTftB>HlW <)l%rF܃7ωOtud0]<qLel rWEi%F|-ZNi6|=y  
zi%򿅬4VEc`]^Ky5*m΅T!.shז𯮬1:n	*v`QvӡJ5wZ:W8M(olg;K׾ ]iW3QC+Inh1һUGO-FYe[TD2<cuԤ9Un˧k0Jcwv_mz<ڏImCHo=|l %x_
-.I1UhZ-`Ken] rR vV]EN!ZY4jSw{}OG~ hxzt:$!,cᠾ9Gf&8ǘ@V ˌ,55Ay]^?@jtV(fa~XliZDnMy蝭{-lx:
V|i;tI?/+ObV-:l'b]|7(T7mM? ^^6ڣWD!#(5I?ݨ6uʤ%Sg}|z/b#OXCs)Y eidh1@αnQlw5țKj	o"I$l P#3~BӫTSWi<<*uVҊ{6͆]sƞF=WJ
֡4N"ٓ3DK0ʱl4K _^vjE+i ;#1!;qݻ^鷣z `YqZ?7sך-#o[EzKs0vo)MĲZw)eaP98"xΞSCRo+~k+%JB=!><x	M
,,̦oݝے@i#r>I<`j cH gL 5G(Ú*O;Nʎ=O΋K[ڼ\c(N}:ֵNSIHg[ mIKo6aj%t_(<'ai4SL[+ |w ķN7fD|U yAWTa$tFen[ByV:/mPeB1ޝ}9T|s;oKӭж	Nv djc/gFkBnXϙKFoz,~0K-q @WOXӴ{XHӥ6fBBFfX8Znuj۲fʝ:U~߃Z-|Al7iHy@ŎI*G8<4Ewی^>l'-EN\2t}|(J%gÚ47ThV18v{֌hsGy~5h𧁜FܨO+*_z|̪d]E?t>|7V-z9
J#8* g8>;^ht}bSvҲUlc#>NkLEwoNmI&Osk[/şR
h*|ۊ
j&w)l1mm}9lyޠ[qZqj'#|hQӧ5iz~	wKǶOqX5 p:y$f$F;qCHѼ!h^,I-Μ@i6Au	}pXUࢣNX\NJO2i?Ct 4ZAKYGNdUDw^x7i	nu>mc+s^:T+5һkcRJV/Ta>N--&^d<IA;zpg/j T)YZPAvʅt%OMjh;ue]T^] 
7Ø/<SgxCp4GPTBqbFϥqx^N;Hn>IqdLy?1 TZTG7A*ֿSMt~/lxGE-R$/"I"'#N^ =7ݥ&	hCrG<rzqj3Z)I2MY'~zG+
|/K-t!saw˙Rg gOz,zNxNª/e=Lla+NMQMZk
FNk)A,'=Jn1oi0H2TOsI6/ਧWS/
m<
# =1^pSZߵv2u\ 
g>_ϊ^1B$M&)ά
od)g{|TԴ]N$ڼQ%hܻ;<L+{hԔ*JQ]oޱT'¯ggg<IiI7Pۻyc}1{Vů5O_F
Rnv4+nRz`khjƄjJ:B_6_1X
*%){m7o̯xk#pY2mHpr$1]ME\^<B;-\^nja}<ggӓ]WbpڅR^TizMͶ|N׵mB
SXO^nRqU);z\_i})ua^b 
2Xu2Ǚuw>Z5*MҧhIdWAM~x߇[?-4NAg`v>$+Jռ077msNLJM  n2IJ*hN/TOi&J<AƇ?\I[J3i5M"(˕O+y:bMEٺMyf	' `c	SVK_5wnEXQJُ_ڋFWNőEFkXGe(S8$sȬ_^I 0hVZEq,ϖ˳J#kdrFG
8#O]Y7|c?Dt ֫E"|i#Iq~||QCZxїE񾓩i>w
%gTRHx"Gw 8MZ%NizZ[&{8gN
jKvuWKٜvzkmhp[x3KPۚ'?yv8#&a_i>2k(5fG$
)]V%Z6 WJ4(-z[ƣUf"U.w]-}_#^(5IKÉRıޯ i
_iwCKKF΍!Xx@8N:sn${TtiMǖIvVƭ K
jNHd1(M;/(Im¶gީVzzFm/ZUcTX_'s<I"d!p@֍m[򱋜ZBqv~smῳK%o6\ƀ>$*x|!$W]CXj:ʳ-^{&m)pJ]N~K- K/'
RKu
ukJR7,bdܶUyb>aѫc{h'_ceHJ!9~<H+҃7I5+ʹL^🆵,u˕KEm$i*⍷&D Bp>nׯqj/=/ݡ-(b iJjU}
4g9^1i?8~:'ÿxVJwϟcr$vq<7o-@*U<;kk#Gÿb;,LŮUIN0JqTպFU!Nҷ,|t1
Mҕ|_ևq\M׋WNyd_%Cѻ t-:Y?><k2IqIu{4GeP@
a	QQsNn޶K	兒ϦߛuzOSMbPh2\+HæР*Sj*dzi_JO4tWP玏eC9`^m>$ĶwKuh1#G>>"WE~+'uqTz?G%)/vw⯉l!u0ƙ`@p(kz͞`ID`x#YxdiRvRy)_%&O2~ \q<MjeƜVod
X>r1k9[Us(>k[z&ftج.PyͳLm潥 n[޶b*<6L( `zW9IBptԅ%~8f*^y{3E)y$qڸxVcyX`A'Pxv+u^+?3VtFrݷoMFxL׍<UiLZHWF>l~>ՙ<#jwₛ%
38|i8Vh[C(ʥY}v|"ݰvtfXe
tL$t<9ook9qh;N@략RӨQRrOɞk
jL1yt5xGWU먖Sz-ۙ#V^ތK_FKJݿ[cy9FrszvR>"%!*8v:ӎqMNTϗWVGz5*_R/f;9y>^4|; 1x-]U8zҕ'bև-Yڲ>%ѬnWsy1)~ g8ό籽4Ix*`Fl= :FO)E][W*
ΊZ M>X徿uP& t<Ij>`5+dج0ÌVEJOS^r u׌UDtYs"אG\޳
@K;풴qlvl#V*QyXFI_V)k ^ǒ\!CӖWS3}x4:Oe-N8mԗZ71 F>l;{T6˕:r*M)4z>%#+CeF9|mǦkto
i'm#ZBCUFz'WF!Nv T[ceoWx|2ݤS{<`<.T2c=~7|Koh}>Xės&$':f>}(7&
A5NI{ok~'ҭ#;Mb+]My\u0q^wٽ|<^-z[eHۺְ\<#-3˰:uz';+_377uҮnKJJW$1}rk-Wgǃuqܶ\8^T'2}Ϧl<kЧ4ҷ[N|ƚgԱF>{O_ږizǈ㴃X35Z[H\cלw*w^>)3m)]yf\KСK=Buk%Y2Ioi}j2ky&[b.F!szFqް\Eh;Fױ>PQ\zMzXhϚڄqdrI00}zVG
3AEqc3iienJάi&.kK_M'{=H7a֓y-V@!{Zc`9jxsxSK4qZG.к.g7r2)htҷLOmdߒDR?cN]Z^{?ͳz 9Ϧjo#(K`:XA'WΖ
Sb;-VCjL`җd pNJթ֚ikȼL0_ >Z[IZGB<'\+tk7c[K\!e@axUq\&ڞiKNI&Wfy'm~ hIa^4*DrC ]_
<\z.4g,WjV71cfӧRU%udyhe)BSݵ qKg=6A<q
`T36NXw,.|xSQZK%pq{h.$2GH'@ˎ
5ݗSu8_O=ǝц/˙Ivk.}h>,F_ky粳hd[H#3Ѽ+lc}eeRv`sjRWw{CZx(QJܮ5j:osn
vH z?^.KzD{4ƸW$mWH8"gQΜ}vZ;t*²'n~OPyKjcӑCуЁgQGe[XzOColȢWeJ Tkk鯭[vVyR2O{]|.f<Bma|Up`#Pgvw"h>=έZuJ$.lGʖƎ")Tn׍tczHS)m]-s]g;n-%-cI#_,F_BW2Qr8EumSAN- lKQ(T&bTPA`m,[犩I4+6*rs5}lmL>O_~![Sj#!1MIbC
?<S Ak/ _YGҌھ/5?xAȵ[ɟt==I^xrVaH )bx#^=XrI=Yj6߇;Eg s^ա_;*?_z妧Lҍ;65 YbhdF=kMguU4١jX$wr3 X{itSJ|7x~)zck|<Lܷ:h0ܳ?oZ4얖Z*ԝU:y
¯i2ϦjOb#ܟ|SZlN,ǡ kthQjgUJ'|4< ޒFl`q\wXo&C
ND([bFպgסRgc:e7B5Vy  :]WڃI4
#19}/
O&/!! xu^MԋwXxX7JJ{?C╽Y<Sf61d1^4KYa)mpOjľZ>jי8HFҿ4K-J-%LI\zW)c}fU5Q>ZR.]zfp6֯w}?<+i7ZO|]
s0q|x/=΍-&q1zc#bR(;YƗ=tGW48U6@'9+e9un9V|p>?LVf
1٫0ҭBu%/z2K>k.<QU`ax'ws_XxKrn|9Ļ猐F{^WEߙE^F(B~z޽ L<??^kDͧ۳'#^0jΝW}{WQ B8{
s`{}ǗR%(Amd_vxG.A
COak<:~Fxib oRӹ!cĶ\hlw9^ʣcN3ŭ.HcC36ߙیsNAÕQEmawiF״ 5<DTt־ּ/kwtщ| o u'mw(OVrQuBas~? ZMGgx ӥ?ֿ55u%elxHV{K*ORͺi"/  ;xtYJ80{g w᷄+"~-oGG)>;[rm}ΰx0架oc|%iy_h
\ y9֥o~8N>f/Cm
OAӚZ8]_*XU)ijW?hvWł[vN$p9'}ώj(5Kf[ޮDeJb%Q7 ^c-i'tZ3<	c+%khyJG,Wźf=yxhʰ8, kVPkomj!<%۵kH~&].ͭtIF26d`'>)Uy%;ec1fO+,DRSF>k349>I{Gӿ_LD"!y8jr)h]7U]=S][J&95d*#ck+Ş-"^ss) 0^ӑZjFR}q.N۷Mk(tMO{3ofiƻe.Pnwq~s_tj:׉fO:,޸?̽eU$Z=ݗ.z[sUΎٌ[4okc<&QףxQϋiP^\lwGٍD{ 	RݾWɫtJeSN^U|^
	][5ԁȸ_G?߶jN|/YtZ$c~*b5Xjय(
6a&j31arV
d 8蠞{
 k2ZG٭4lm
4BXFz9OK5'˷N9\IxSQ'5KgQI,`G
9[=rI])V!ewaL6$U*8c9Я{ wV%W׷K|Sy2Y\D-dPFlѐX5#O:OsG&{}oh>U]	:e<WJ]#o[t<LkP	^S֝oo.Mz.dQWd rq:?_j: .H.نFTb\ԆʭIbik^3K:;~z3g{];CUeGa Bw9 a5r#	TwIqW|}χKKV%@?y~&MjWj2p:VWn|s䊌]Y^iL-W'q#p8޾-}9m>&c$N׿(4>;ag{l0P1I^uScYYծJ< }:::0v"{_[ܲRUoěGyܱ~rǜ C\OrcWCӾ;˦Lr*3sSLxmUA:~g*R]cR x?
G83ּR<rF:]Y>Dg] eikf>lv$׀H.w   cUK_WmBVhX pĂrHԟjydӼG=yln]rkͪ[:0&F3᎗^+l1'8U!ѴՊ K>QRU$	;skfh]Ŀod#W#!' IӴ֥ehW?1P=EmgF
OxīF
-2x-+~7GʱITbߟc_S~c f[k=wU`Y^2uK[m-Kye)")ep?S\8rsVBŻ)~^}y?)9t;h%*MSg+<TiVxe+kOE?5pgopǾ8/Z[62lWhIʞ~3ӌc^??Yt,$xٶsס|~0߱_++WoG^)g~Yv@6`^k;}ΟVSp%py 5GǉJ8,K{?".56}RgYR$wfg6Ŧj2
=kͦ RUI-W7Y5㼌Ӗbcמkåi _1c;=GƺpqUsW~RP]*Aaeofa'F]ǩk:.=,FI ʼ=XF539Kީ RoѴnTFT5 h>ҭ>8 iUX3y?s旯cqӜVa<'|'c#Xv;@m,ȪN2Mj%mt8'&燋zZ_G?u0-;Hі,OsϽzG,m,uRi&RrxR5jB;Z?9]-]uf3I$:c<zש#EV-pYv9>ۗ:Mt3'z>ɪk;cIb#Tp>ROaig}KhB䞬]1q. ySNm}~:K
FON{3Rnu,9U28;vG=y*ʝK #ĥR 2 +&hG";7nkc~&ӯmXu<Μ:r}ϭzԵM=6./T~p]AQ<2[9@ge|.Q!ϏjYtkQӊߕz׋,m|WB[ ) D0:s]ރmgH[|YVYjS7-lݏSƾ)%cŞM5ƍn[+1^H׃|jY{IR.v f`,IMI?ūB4ь;)|%.R1@9#ǂ{ik#mBD|g*.i&;>0{*Zto>zYzKZ_$e#%^ɫ[y^8LT`g1s[WiNQsQgeiXH+),r~`ze T 4JE&peJ2?
