/*
This file is part of Ext JS 3.4

Copyright (c) 2011-2013 Sencha Inc

Contact:  http://www.sencha.com/contact

GNU General Public License Usage
This file may be used under the terms of the GNU General Public License version 3.0 as
published by the Free Software Foundation and appearing in the file LICENSE included in the
packaging of this file.

Please review the following information to ensure the GNU General Public License version 3.0
requirements will be met: http://www.gnu.org/copyleft/gpl.html.

If you are unsure which license is appropriate for your use, please contact the sales department
at http://www.sencha.com/contact.

Build date: 2013-04-03 15:07:25
*/
Ext.data.JsonP.Ext_data_DirectStore({"alternateClassNames":[],"aliases":{"widget":["directstore"]},"enum":null,"parentMixins":[],"tagname":"class","subclasses":[],"extends":"Ext.data.Store","uses":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='docClass'>Ext.util.Observable</a><div class='subclass '><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='docClass'>Ext.data.Store</a><div class='subclass '><strong>Ext.data.DirectStore</strong></div></div></div><h4>Files</h4><div class='dependency'><a href='source/DirectStore.html#Ext-data-DirectStore' target='_blank'>DirectStore.js</a></div></pre><div class='doc-contents'><p>Small helper class to create an <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a> configured with an\n<a href=\"#!/api/Ext.data.DirectProxy\" rel=\"Ext.data.DirectProxy\" class=\"docClass\">Ext.data.DirectProxy</a> and <a href=\"#!/api/Ext.data.JsonReader\" rel=\"Ext.data.JsonReader\" class=\"docClass\">Ext.data.JsonReader</a> to make interacting\nwith an <a href=\"#!/api/Ext.Direct\" rel=\"Ext.Direct\" class=\"docClass\">Ext.Direct</a> Server-side <a href=\"#!/api/Ext.direct.Provider\" rel=\"Ext.direct.Provider\" class=\"docClass\">Provider</a> easier.\nTo create a different proxy/reader combination create a basic <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a>\nconfigured as needed.</p>\n\n\n\n\n<p><b>*Note:</b> Although they are not listed, this class inherits all of the config options of:</p>\n\n\n<div><ul class=\"mdetail-params\">\n<li><b><a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Store</a></b></li>\n<div class=\"sub-desc\"><ul class=\"mdetail-params\">\n\n</ul></div>\n<li><b><a href=\"#!/api/Ext.data.JsonReader\" rel=\"Ext.data.JsonReader\" class=\"docClass\">JsonReader</a></b></li>\n<div class=\"sub-desc\"><ul class=\"mdetail-params\">\n<li><tt><b><a href=\"#!/api/Ext.data.JsonReader-cfg-root\" rel=\"Ext.data.JsonReader-cfg-root\" class=\"docClass\">root</a></b></tt></li>\n<li><tt><b><a href=\"#!/api/Ext.data.JsonReader-cfg-idProperty\" rel=\"Ext.data.JsonReader-cfg-idProperty\" class=\"docClass\">idProperty</a></b></tt></li>\n<li><tt><b><a href=\"#!/api/Ext.data.JsonReader-cfg-totalProperty\" rel=\"Ext.data.JsonReader-cfg-totalProperty\" class=\"docClass\">totalProperty</a></b></tt></li>\n</ul></div>\n\n<li><b><a href=\"#!/api/Ext.data.DirectProxy\" rel=\"Ext.data.DirectProxy\" class=\"docClass\">DirectProxy</a></b></li>\n<div class=\"sub-desc\"><ul class=\"mdetail-params\">\n<li><tt><b><a href=\"#!/api/Ext.data.DirectProxy-cfg-directFn\" rel=\"Ext.data.DirectProxy-cfg-directFn\" class=\"docClass\">directFn</a></b></tt></li>\n<li><tt><b><a href=\"#!/api/Ext.data.DirectProxy-cfg-paramOrder\" rel=\"Ext.data.DirectProxy-cfg-paramOrder\" class=\"docClass\">paramOrder</a></b></tt></li>\n<li><tt><b><a href=\"#!/api/Ext.data.DirectProxy-cfg-paramsAsHash\" rel=\"Ext.data.DirectProxy-cfg-paramsAsHash\" class=\"docClass\">paramsAsHash</a></b></tt></li>\n</ul></div>\n</ul></div>\n\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-autoDestroy' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-cfg-autoDestroy' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-cfg-autoDestroy' class='name expandable'>autoDestroy</a><span> : Boolean</span></div><div class='description'><div class='short'>true to destroy the store when the component the store is bound\nto is destroyed (defaults to false). ...</div><div class='long'><p><tt>true</tt> to destroy the store when the component the store is bound\nto is destroyed (defaults to <tt>false</tt>).</p>\n\n<p><b>Note</b>: this should be set to true when using stores that are bound to only 1 component.</p>\n\n<p>Defaults to: <code>false</code></p></div></div></div><div id='cfg-autoLoad' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-cfg-autoLoad' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-cfg-autoLoad' class='name expandable'>autoLoad</a><span> : Boolean/Object</span></div><div class='description'><div class='short'>If data is not specified, and if autoLoad\nis true or an Object, this store's load method is automatically called\nafte...</div><div class='long'><p>If <tt><a href=\"#!/api/Ext.data.Store-cfg-data\" rel=\"Ext.data.Store-cfg-data\" class=\"docClass\">data</a></tt> is not specified, and if <tt>autoLoad</tt>\nis <tt>true</tt> or an <tt>Object</tt>, this store's <a href=\"#!/api/Ext.data.Store-method-load\" rel=\"Ext.data.Store-method-load\" class=\"docClass\">load</a> method is automatically called\nafter creation. If the value of <tt>autoLoad</tt> is an <tt>Object</tt>, this <tt>Object</tt> will\nbe passed to the store's <a href=\"#!/api/Ext.data.Store-method-load\" rel=\"Ext.data.Store-method-load\" class=\"docClass\">load</a> method.</p>\n</div></div></div><div id='cfg-autoSave' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-cfg-autoSave' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-cfg-autoSave' class='name expandable'>autoSave</a><span> : Boolean</span></div><div class='description'><div class='short'>Defaults to true causing the store to automatically save records to\nthe server when a record is modified (ie: becomes...</div><div class='long'><p>Defaults to <tt>true</tt> causing the store to automatically <a href=\"#!/api/Ext.data.Store-method-save\" rel=\"Ext.data.Store-method-save\" class=\"docClass\">save</a> records to\nthe server when a record is modified (ie: becomes 'dirty'). Specify <tt>false</tt> to manually call <a href=\"#!/api/Ext.data.Store-method-save\" rel=\"Ext.data.Store-method-save\" class=\"docClass\">save</a>\nto send all modifiedRecords to the server.</p>\n\n\n<br><p><b>Note</b>: each CRUD action will be sent as a separate request.</p>\n\n<p>Defaults to: <code>true</code></p></div></div></div><div id='cfg-baseParams' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-cfg-baseParams' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-cfg-baseParams' class='name expandable'>baseParams</a><span> : Object</span></div><div class='description'><div class='short'>An object containing properties which are to be sent as parameters\nfor every HTTP request. ...</div><div class='long'><p>An object containing properties which are to be sent as parameters\nfor <i>every</i> HTTP request.</p>\n\n\n<p>Parameters are encoded as standard HTTP parameters using <a href=\"#!/api/Ext-method-urlEncode\" rel=\"Ext-method-urlEncode\" class=\"docClass\">Ext.urlEncode</a>.</p>\n\n\n<p><b>Note</b>: <code>baseParams</code> may be superseded by any <code>params</code>\nspecified in a <code><a href=\"#!/api/Ext.data.Store-method-load\" rel=\"Ext.data.Store-method-load\" class=\"docClass\">load</a></code> request, see <code><a href=\"#!/api/Ext.data.Store-method-load\" rel=\"Ext.data.Store-method-load\" class=\"docClass\">load</a></code>\nfor more details.</p>\n\n\n<p>This property may be modified after creation using the <code><a href=\"#!/api/Ext.data.Store-method-setBaseParam\" rel=\"Ext.data.Store-method-setBaseParam\" class=\"docClass\">setBaseParam</a></code>\nmethod.</p>\n</div></div></div><div id='cfg-batch' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-cfg-batch' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-cfg-batch' class='name expandable'>batch</a><span> : Boolean</span></div><div class='description'><div class='short'>Defaults to true (unless restful:true). ...</div><div class='long'><p>Defaults to <tt>true</tt> (unless <code><a href=\"#!/api/Ext.data.Store-cfg-restful\" rel=\"Ext.data.Store-cfg-restful\" class=\"docClass\">restful</a>:true</code>). Multiple\nrequests for each CRUD action (CREATE, READ, UPDATE and DESTROY) will be combined\nand sent as one transaction. Only applies when <code><a href=\"#!/api/Ext.data.Store-cfg-autoSave\" rel=\"Ext.data.Store-cfg-autoSave\" class=\"docClass\">autoSave</a></code> is set\nto <tt>false</tt>.</p>\n\n\n<br><p>If Store is RESTful, the DataProxy is also RESTful, and a unique transaction is\n\n\n<p>generated for each record.</p></p>\n<p>Defaults to: <code>true</code></p></div></div></div><div id='cfg-data' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-cfg-data' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-cfg-data' class='name expandable'>data</a><span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></span></div><div class='description'><div class='short'>An inline data object readable by the reader. ...</div><div class='long'><p>An inline data object readable by the <code><a href=\"#!/api/Ext.data.Store-cfg-reader\" rel=\"Ext.data.Store-cfg-reader\" class=\"docClass\">reader</a></code>.\nTypically this option, or the <code><a href=\"#!/api/Ext.data.Store-cfg-url\" rel=\"Ext.data.Store-cfg-url\" class=\"docClass\">url</a></code> option will be specified.</p>\n</div></div></div><div id='cfg-defaultParamNames' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-cfg-defaultParamNames' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-cfg-defaultParamNames' class='name expandable'>defaultParamNames</a><span> : Object</span></div><div class='description'><div class='short'>Provides the default values for the paramNames property. ...</div><div class='long'><p>Provides the default values for the <a href=\"#!/api/Ext.data.Store-cfg-paramNames\" rel=\"Ext.data.Store-cfg-paramNames\" class=\"docClass\">paramNames</a> property. To globally modify the parameters\nfor all stores, this object should be changed on the store prototype.</p>\n<p>Defaults to: <code>{start: 'start', limit: 'limit', sort: 'sort', dir: 'dir'}</code></p></div></div></div><div id='cfg-listeners' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-cfg-listeners' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-cfg-listeners' class='name expandable'>listeners</a><span> : Object</span></div><div class='description'><div class='short'>(optional) A config object containing one or more event handlers to be added to this\nobject during initialization. ...</div><div class='long'><p>(optional) <p>A config object containing one or more event handlers to be added to this\nobject during initialization.  This should be a valid listeners config object as specified in the\n<a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">addListener</a> example for attaching multiple handlers at once.</p></p>\n\n<br><p><b><u>DOM events from ExtJs <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Components</a></u></b></p>\n\n\n<br><p>While <i>some</i> ExtJs Component classes export selected DOM events (e.g. \"click\", \"mouseover\" etc), this\n\n\n<p>is usually only done when extra value can be added. For example the <a href=\"#!/api/Ext.DataView\" rel=\"Ext.DataView\" class=\"docClass\">DataView</a>'s\n<b><code><a href=\"#!/api/Ext.DataView-event-click\" rel=\"Ext.DataView-event-click\" class=\"docClass\">click</a></code></b> event passing the node clicked on. To access DOM\nevents directly from a Component's HTMLElement, listeners must be added to the <i><a href=\"#!/api/Ext.Component-method-getEl\" rel=\"Ext.Component-method-getEl\" class=\"docClass\">Element</a></i> after the Component\nhas been rendered. A plugin can simplify this step:</p>\n\n<pre><code>// Plugin is configured with a listeners config object.\n// The Component is appended to the argument list of all handler functions.\nExt.DomObserver = <a href=\"#!/api/Ext-method-extend\" rel=\"Ext-method-extend\" class=\"docClass\">Ext.extend</a>(Object, {\n    constructor: function(config) {\n        this.listeners = config.listeners ? config.listeners : config;\n    },\n\n    // Component passes itself into plugin&#39;s init method\n    init: function(c) {\n        var p, l = this.listeners;\n        for (p in l) {\n            if (<a href=\"#!/api/Ext-method-isFunction\" rel=\"Ext-method-isFunction\" class=\"docClass\">Ext.isFunction</a>(l[p])) {\n                l[p] = this.createHandler(l[p], c);\n            } else {\n                l[p].fn = this.createHandler(l[p].fn, c);\n            }\n        }\n\n        // Add the listeners to the Element immediately following the render call\n        c.render = c.render.<a href=\"#!/api/Function-method-createSequence\" rel=\"Function-method-createSequence\" class=\"docClass\">createSequence</a>(function() {\n            var e = c.getEl();\n            if (e) {\n                e.on(l);\n            }\n        });\n    },\n\n    createHandler: function(fn, c) {\n        return function(e) {\n            fn.call(this, e, c);\n        };\n    }\n});\n\nvar combo = new <a href=\"#!/api/Ext.form.ComboBox\" rel=\"Ext.form.ComboBox\" class=\"docClass\">Ext.form.ComboBox</a>({\n\n    // Collapse combo when its element is clicked on\n    plugins: [ new Ext.DomObserver({\n        click: function(evt, comp) {\n            comp.collapse();\n        }\n    })],\n    store: myStore,\n    typeAhead: true,\n    mode: 'local',\n    triggerAction: 'all'\n});\n</code></pre>\n\n\n<p></p></p>\n</div></div></div><div id='cfg-paramNames' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-cfg-paramNames' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-cfg-paramNames' class='name expandable'>paramNames</a><span> : Object</span></div><div class='description'><div class='short'>An object containing properties which specify the names of the paging and\nsorting parameters passed to remote servers...</div><div class='long'><p>An object containing properties which specify the names of the paging and\nsorting parameters passed to remote servers when loading blocks of data. By default, this\nobject takes the following form:</p>\n\n\n<pre><code>{\n    start : 'start',  // The parameter name which specifies the start row\n    limit : 'limit',  // The parameter name which specifies number of rows to return\n    sort : 'sort',    // The parameter name which specifies the column to sort on\n    dir : 'dir'       // The parameter name which specifies the sort direction\n}\n</code></pre>\n\n\n<p>The server must produce the requested data block upon receipt of these parameter names.\nIf different parameter names are required, this property can be overriden using a configuration\nproperty.</p>\n\n\n<p>A <a href=\"#!/api/Ext.PagingToolbar\" rel=\"Ext.PagingToolbar\" class=\"docClass\">PagingToolbar</a> bound to this Store uses this property to determine\nthe parameter names to use in its <a href=\"#!/api/Ext.data.Store-method-load\" rel=\"Ext.data.Store-method-load\" class=\"docClass\">requests</a>.\n\n</p></div></div></div><div id='cfg-proxy' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-cfg-proxy' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-cfg-proxy' class='name expandable'>proxy</a><span> : <a href=\"#!/api/Ext.data.DataProxy\" rel=\"Ext.data.DataProxy\" class=\"docClass\">Ext.data.DataProxy</a></span></div><div class='description'><div class='short'>The DataProxy object which provides\naccess to a data object. ...</div><div class='long'><p>The <a href=\"#!/api/Ext.data.DataProxy\" rel=\"Ext.data.DataProxy\" class=\"docClass\">DataProxy</a> object which provides\naccess to a data object.  See <code><a href=\"#!/api/Ext.data.Store-cfg-url\" rel=\"Ext.data.Store-cfg-url\" class=\"docClass\">url</a></code>.</p>\n</div></div></div><div id='cfg-pruneModifiedRecords' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-cfg-pruneModifiedRecords' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-cfg-pruneModifiedRecords' class='name expandable'>pruneModifiedRecords</a><span> : Boolean</span></div><div class='description'><div class='short'>true to clear all modified record information each time\nthe store is loaded or when a record is removed (defaults to ...</div><div class='long'><p><tt>true</tt> to clear all modified record information each time\nthe store is loaded or when a record is removed (defaults to <tt>false</tt>). See <a href=\"#!/api/Ext.data.Store-method-getModifiedRecords\" rel=\"Ext.data.Store-method-getModifiedRecords\" class=\"docClass\">getModifiedRecords</a>\nfor the accessor method to retrieve the modified records.</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='cfg-reader' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-cfg-reader' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-cfg-reader' class='name expandable'>reader</a><span> : <a href=\"#!/api/Ext.data.DataReader\" rel=\"Ext.data.DataReader\" class=\"docClass\">Ext.data.DataReader</a></span></div><div class='description'><div class='short'>The Reader object which processes the\ndata object and returns an Array of Ext.data.Record objects which are cached ke...</div><div class='long'><p>The <a href=\"#!/api/Ext.data.DataReader\" rel=\"Ext.data.DataReader\" class=\"docClass\">Reader</a> object which processes the\ndata object and returns an Array of <a href=\"#!/api/Ext.data.Record\" rel=\"Ext.data.Record\" class=\"docClass\">Ext.data.Record</a> objects which are cached keyed by their\n<b><tt><a href=\"#!/api/Ext.data.Record-method-id\" rel=\"Ext.data.Record-method-id\" class=\"docClass\">id</a></tt></b> property.</p>\n</div></div></div><div id='cfg-remoteSort' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-cfg-remoteSort' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-cfg-remoteSort' class='name expandable'>remoteSort</a><span> : boolean</span></div><div class='description'><div class='short'>true if sorting is to be handled by requesting the Proxy\nto provide a refreshed version of the data object in sorted ...</div><div class='long'><p><tt>true</tt> if sorting is to be handled by requesting the <tt><a href=\"#!/api/Ext.data.Store-cfg-proxy\" rel=\"Ext.data.Store-cfg-proxy\" class=\"docClass\">Proxy</a></tt>\nto provide a refreshed version of the data object in sorted order, as opposed to sorting the Record cache\nin place (defaults to <tt>false</tt>).</p>\n\n<p>If <tt>remoteSort</tt> is <tt>true</tt>, then clicking on a <a href=\"#!/api/Ext.grid.Column\" rel=\"Ext.grid.Column\" class=\"docClass\">Grid Column</a>'s\n<a href=\"#!/api/Ext.grid.Column-cfg-header\" rel=\"Ext.grid.Column-cfg-header\" class=\"docClass\">header</a> causes the current page to be requested from the server appending\nthe following two parameters to the <b><tt><a href=\"#!/api/Ext.data.Store-method-load\" rel=\"Ext.data.Store-method-load\" class=\"docClass\">params</a></tt></b>:<div class=\"mdetail-params\"><ul>\n<li><b><tt>sort</tt></b> : String<p class=\"sub-desc\">The <tt>name</tt> (as specified in the Record's\n<a href=\"#!/api/Ext.data.Field\" rel=\"Ext.data.Field\" class=\"docClass\">Field definition</a>) of the field to sort on.</p></li>\n<li><b><tt>dir</tt></b> : String<p class=\"sub-desc\">The direction of the sort, 'ASC' or 'DESC' (case-sensitive).</p></li>\n</ul></div></p>\n\n<p>Defaults to: <code>false</code></p></div></div></div><div id='cfg-restful' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-cfg-restful' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-cfg-restful' class='name expandable'>restful</a><span> : Boolean</span></div><div class='description'><div class='short'>Defaults to false. ...</div><div class='long'><p>Defaults to <tt>false</tt>.  Set to <tt>true</tt> to have the Store and the set\nProxy operate in a RESTful manner. The store will automatically generate GET, POST,\nPUT and DELETE requests to the server. The HTTP method used for any given CRUD\naction is described in <a href=\"#!/api/Ext.data.Api-property-restActions\" rel=\"Ext.data.Api-property-restActions\" class=\"docClass\">Ext.data.Api.restActions</a>.  For additional information\nsee <a href=\"#!/api/Ext.data.DataProxy-cfg-restful\" rel=\"Ext.data.DataProxy-cfg-restful\" class=\"docClass\">Ext.data.DataProxy.restful</a>.</p>\n\n<p><b>Note</b>: if <code><a href=\"#!/api/Ext.data.Store-cfg-restful\" rel=\"Ext.data.Store-cfg-restful\" class=\"docClass\">restful</a>:true</code> <code>batch</code> will\ninternally be set to <tt>false</tt>.</p>\n\n<p>Defaults to: <code>false</code></p></div></div></div><div id='cfg-sortInfo' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-cfg-sortInfo' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-cfg-sortInfo' class='name expandable'>sortInfo</a><span> : Object</span></div><div class='description'><div class='short'>A config object to specify the sort order in the request of a Store's\nload operation. ...</div><div class='long'><p>A config object to specify the sort order in the request of a Store's\n<a href=\"#!/api/Ext.data.Store-method-load\" rel=\"Ext.data.Store-method-load\" class=\"docClass\">load</a> operation.  Note that for local sorting, the <tt>direction</tt> property is\ncase-sensitive. See also <a href=\"#!/api/Ext.data.Store-cfg-remoteSort\" rel=\"Ext.data.Store-cfg-remoteSort\" class=\"docClass\">remoteSort</a> and <a href=\"#!/api/Ext.data.Store-cfg-paramNames\" rel=\"Ext.data.Store-cfg-paramNames\" class=\"docClass\">paramNames</a>.\nFor example:</p>\n\n<pre><code>sortInfo: {\n    field: 'fieldName',\n    direction: 'ASC' // or 'DESC' (case sensitive for local sorting)\n}\n</code></pre>\n\n</div></div></div><div id='cfg-storeId' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-cfg-storeId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-cfg-storeId' class='name expandable'>storeId</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>If passed, the id to use to register with the StoreMgr. ...</div><div class='long'><p>If passed, the id to use to register with the <b><a href=\"#!/api/Ext.StoreMgr\" rel=\"Ext.StoreMgr\" class=\"docClass\">StoreMgr</a></b>.</p>\n\n<p><b>Note</b>: if a (deprecated) <tt>id</tt> is specified it will supersede the <tt>storeId</tt>\nassignment.</p>\n\n</div></div></div><div id='cfg-url' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-cfg-url' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-cfg-url' class='name expandable'>url</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>If a proxy is not specified the url will be used to\nimplicitly configure a HttpProxy if an url is specified. ...</div><div class='long'><p>If a <tt><a href=\"#!/api/Ext.data.Store-cfg-proxy\" rel=\"Ext.data.Store-cfg-proxy\" class=\"docClass\">proxy</a></tt> is not specified the <tt>url</tt> will be used to\nimplicitly configure a <a href=\"#!/api/Ext.data.HttpProxy\" rel=\"Ext.data.HttpProxy\" class=\"docClass\">HttpProxy</a> if an <tt>url</tt> is specified.\nTypically this option, or the <code><a href=\"#!/api/Ext.data.Store-cfg-data\" rel=\"Ext.data.Store-cfg-data\" class=\"docClass\">data</a></code> option will be specified.</p>\n</div></div></div><div id='cfg-writer' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-cfg-writer' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-cfg-writer' class='name expandable'>writer</a><span> : <a href=\"#!/api/Ext.data.DataWriter\" rel=\"Ext.data.DataWriter\" class=\"docClass\">Ext.data.DataWriter</a></span></div><div class='description'><div class='short'>The Writer object which processes a record object for being written\nto the server-side database. ...</div><div class='long'><p>The <a href=\"#!/api/Ext.data.DataWriter\" rel=\"Ext.data.DataWriter\" class=\"docClass\">Writer</a> object which processes a record object for being written\nto the server-side database.</p>\n\n\n<br><p>When a writer is installed into a Store the <a href=\"#!/api/Ext.data.Store-event-add\" rel=\"Ext.data.Store-event-add\" class=\"docClass\">add</a>, <a href=\"#!/api/Ext.data.Store-method-remove\" rel=\"Ext.data.Store-method-remove\" class=\"docClass\">remove</a>, and <a href=\"#!/api/Ext.data.Store-event-update\" rel=\"Ext.data.Store-event-update\" class=\"docClass\">update</a>\n\n\n<p>events on the store are monitored in order to remotely <a href=\"#!/api/Ext.data.Store-method-createRecords\" rel=\"Ext.data.Store-method-createRecords\" class=\"docClass\">create records</a>,\n<a href=\"#!/api/Ext.data.Store-method-destroyRecord\" rel=\"Ext.data.Store-method-destroyRecord\" class=\"docClass\">destroy records</a>, or <a href=\"#!/api/Ext.data.Store-method-updateRecord\" rel=\"Ext.data.Store-method-updateRecord\" class=\"docClass\">update records</a>.</p></p>\n\n<br><p>The proxy for this store will relay any writexception events to this store.</p>\n\n\n<br><p>Sample implementation:\n\n\n<pre><code>var writer = new <a href=\"#!/api/Ext.data.JsonWriter\" rel=\"Ext.data.JsonWriter\" class=\"docClass\">Ext.data.JsonWriter</a>({\n    encode: true,\n    writeAllFields: true // write all fields, not just those that changed\n});\n\n// Typical Store collecting the Proxy, Reader and Writer together.\nvar store = new <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a>({\n    storeId: 'user',\n    root: 'records',\n    proxy: proxy,\n    reader: reader,\n    writer: writer,     // <-- plug a DataWriter into the store just as you would a Reader\n    paramsAsHash: true,\n    autoSave: false    // <-- false to delay executing create, update, destroy requests\n                        //     until specifically told to do so.\n});\n</code></pre>\n\n\n<p></p></p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-baseParams' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-property-baseParams' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-property-baseParams' class='name expandable'>baseParams</a><span> : Object</span></div><div class='description'><div class='short'>See the corresponding configuration option\nfor a description of this property. ...</div><div class='long'><p>See the <code><a href=\"#!/api/Ext.data.Store-property-baseParams\" rel=\"Ext.data.Store-property-baseParams\" class=\"docClass\">corresponding configuration option</a></code>\nfor a description of this property.\nTo modify this property see <code><a href=\"#!/api/Ext.data.Store-method-setBaseParam\" rel=\"Ext.data.Store-method-setBaseParam\" class=\"docClass\">setBaseParam</a></code>.</p>\n</div></div></div><div id='property-batchKey' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-property-batchKey' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-property-batchKey' class='name expandable'>batchKey</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<p>Defaults to: <code>'_ext_batch_'</code></p></div></div></div><div id='property-fields' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-property-fields' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-property-fields' class='name expandable'>fields</a><span> : <a href=\"#!/api/Ext.util.MixedCollection\" rel=\"Ext.util.MixedCollection\" class=\"docClass\">Ext.util.MixedCollection</a></span></div><div class='description'><div class='short'>A MixedCollection containing the defined Fields\nfor the Records stored in this Store. ...</div><div class='long'><p>A <a href=\"#!/api/Ext.util.MixedCollection\" rel=\"Ext.util.MixedCollection\" class=\"docClass\">MixedCollection</a> containing the defined <a href=\"#!/api/Ext.data.Field\" rel=\"Ext.data.Field\" class=\"docClass\">Field</a>s\nfor the <a href=\"#!/api/Ext.data.Record\" rel=\"Ext.data.Record\" class=\"docClass\">Records</a> stored in this Store. Read-only.</p>\n</div></div></div><div id='property-hasMultiSort' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-property-hasMultiSort' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-property-hasMultiSort' class='name not-expandable'>hasMultiSort</a><span> : Boolean</span></div><div class='description'><div class='short'><p>True if this store is currently sorted by more than one field/direction combination.</p>\n</div><div class='long'><p>True if this store is currently sorted by more than one field/direction combination.</p>\n</div></div></div><div id='property-isDestroyed' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-property-isDestroyed' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-property-isDestroyed' class='name expandable'>isDestroyed</a><span> : Boolean</span></div><div class='description'><div class='short'>True if the store has been destroyed already. ...</div><div class='long'><p>True if the store has been destroyed already. Read only</p>\n</div></div></div><div id='property-lastOptions' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-property-lastOptions' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-property-lastOptions' class='name expandable'>lastOptions</a><span> : Object</span></div><div class='description'><div class='short'>Contains the last options object used as the parameter to the load method. ...</div><div class='long'><p>Contains the last options object used as the parameter to the <a href=\"#!/api/Ext.data.Store-method-load\" rel=\"Ext.data.Store-method-load\" class=\"docClass\">load</a> method. See <a href=\"#!/api/Ext.data.Store-method-load\" rel=\"Ext.data.Store-method-load\" class=\"docClass\">load</a>\nfor the details of what this may contain. This may be useful for accessing any params which were used\nto load the current Record cache.</p>\n</div></div></div><div id='property-multiSortInfo' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-property-multiSortInfo' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-property-multiSortInfo' class='name not-expandable'>multiSortInfo</a><span> : Object</span></div><div class='description'><div class='short'><p>Object containing overall sort direction and an ordered array of sorter configs used when sorting on multiple fields</p>\n</div><div class='long'><p>Object containing overall sort direction and an ordered array of sorter configs used when sorting on multiple fields</p>\n</div></div></div><div id='property-recordType' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-property-recordType' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-property-recordType' class='name expandable'>recordType</a><span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a></span></div><div class='description'><div class='short'>The Record constructor as supplied to (or created by) the\nReader. ...</div><div class='long'><p>The <a href=\"#!/api/Ext.data.Record\" rel=\"Ext.data.Record\" class=\"docClass\">Record</a> constructor as supplied to (or created by) the\n<a href=\"#!/api/Ext.data.DataReader\" rel=\"Ext.data.DataReader\" class=\"docClass\">Reader</a>. Read-only.</p>\n\n<p>If the Reader was constructed by passing in an Array of <a href=\"#!/api/Ext.data.Field\" rel=\"Ext.data.Field\" class=\"docClass\">Ext.data.Field</a> definition objects,\ninstead of a Record constructor, it will implicitly create a Record constructor from that Array (see\n<a href=\"#!/api/Ext.data.Record\" rel=\"Ext.data.Record\" class=\"docClass\">Ext.data.Record</a>.<a href=\"#!/api/Ext.data.Record-static-method-create\" rel=\"Ext.data.Record-static-method-create\" class=\"docClass\">create</a> for additional details).</p>\n\n\n<p>This property may be used to create new Records of the type held in this Store, for example:</p>\n\n\n<pre><code>    // create the data store\n    var store = new <a href=\"#!/api/Ext.data.ArrayStore\" rel=\"Ext.data.ArrayStore\" class=\"docClass\">Ext.data.ArrayStore</a>({\n        autoDestroy: true,\n        fields: [\n           {name: 'company'},\n           {name: 'price', type: 'float'},\n           {name: 'change', type: 'float'},\n           {name: 'pctChange', type: 'float'},\n           {name: 'lastChange', type: 'date', dateFormat: 'n/j h:ia'}\n        ]\n    });\n    store.loadData(myData);\n\n    // create the Grid\n    var grid = new <a href=\"#!/api/Ext.grid.EditorGridPanel\" rel=\"Ext.grid.EditorGridPanel\" class=\"docClass\">Ext.grid.EditorGridPanel</a>({\n        store: store,\n        colModel: new <a href=\"#!/api/Ext.grid.ColumnModel\" rel=\"Ext.grid.ColumnModel\" class=\"docClass\">Ext.grid.ColumnModel</a>({\n            columns: [\n                {id:'company', header: 'Company', width: 160, dataIndex: 'company'},\n                {header: 'Price', renderer: 'usMoney', dataIndex: 'price'},\n                {header: 'Change', renderer: change, dataIndex: 'change'},\n                {header: '% Change', renderer: pctChange, dataIndex: 'pctChange'},\n                {header: 'Last Updated', width: 85,\n                    renderer: <a href=\"#!/api/Ext.util.Format-method-dateRenderer\" rel=\"Ext.util.Format-method-dateRenderer\" class=\"docClass\">Ext.util.Format.dateRenderer</a>('m/d/Y'),\n                    dataIndex: 'lastChange'}\n            ],\n            defaults: {\n                sortable: true,\n                width: 75\n            }\n        }),\n        autoExpandColumn: 'company', // match the id specified in the column model\n        height:350,\n        width:600,\n        title:'Array Grid',\n        tbar: [{\n            text: 'Add Record',\n            handler : function(){\n                var defaultData = {\n                    change: 0,\n                    company: 'New Company',\n                    lastChange: (new Date()).clearTime(),\n                    pctChange: 0,\n                    price: 10\n                };\n                var recId = 3; // provide unique id\n                var p = new store.recordType(defaultData, recId); // create new record\n                grid.stopEditing();\n                store.<a href=\"#!/api/Ext.data.Store-method-insert\" rel=\"Ext.data.Store-method-insert\" class=\"docClass\">insert</a>(0, p); // insert a new record into the store (also see <a href=\"#!/api/Ext.data.Store-event-add\" rel=\"Ext.data.Store-event-add\" class=\"docClass\">add</a>)\n                grid.startEditing(0, 0);\n            }\n        }]\n    });\n</code></pre>\n\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-constructor' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.DirectStore'>Ext.data.DirectStore</span><br/><a href='source/DirectStore.html#Ext-data-DirectStore-method-constructor' target='_blank' class='view-source'>view source</a></div><strong class='new-keyword'>new</strong><a href='#!/api/Ext.data.DirectStore-method-constructor' class='name expandable'>Ext.data.DirectStore</a>( <span class='pre'>config</span> ) : <a href=\"#!/api/Ext.data.DirectStore\" rel=\"Ext.data.DirectStore\" class=\"docClass\">Ext.data.DirectStore</a></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.data.DirectStore\" rel=\"Ext.data.DirectStore\" class=\"docClass\">Ext.data.DirectStore</a></span><div class='sub-desc'>\n</div></li></ul><p>Overrides: <a href='#!/api/Ext.data.Store-method-constructor' rel='Ext.data.Store-method-constructor' class='docClass'>Ext.data.Store.constructor</a></p></div></div></div><div id='method-add' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-method-add' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-method-add' class='name expandable'>add</a>( <span class='pre'>records</span> )</div><div class='description'><div class='short'>Add Records to the Store and fires the add event. ...</div><div class='long'><p>Add Records to the Store and fires the <a href=\"#!/api/Ext.data.Store-event-add\" rel=\"Ext.data.Store-event-add\" class=\"docClass\">add</a> event.  To add Records\nto the store from a remote source use <code><a href=\"#!/api/Ext.data.Store-method-load\" rel=\"Ext.data.Store-method-load\" class=\"docClass\">load</a>({add:true})</code>.\nSee also <code><a href=\"#!/api/Ext.data.Store-property-recordType\" rel=\"Ext.data.Store-property-recordType\" class=\"docClass\">recordType</a></code> and <code><a href=\"#!/api/Ext.data.Store-method-insert\" rel=\"Ext.data.Store-method-insert\" class=\"docClass\">insert</a></code>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>records</span> : <a href=\"#!/api/Ext.data.Record\" rel=\"Ext.data.Record\" class=\"docClass\">Ext.data.Record</a>[]<div class='sub-desc'><p>An Array of <a href=\"#!/api/Ext.data.Record\" rel=\"Ext.data.Record\" class=\"docClass\">Ext.data.Record</a> objects\nto add to the cache. See <a href=\"#!/api/Ext.data.Store-property-recordType\" rel=\"Ext.data.Store-property-recordType\" class=\"docClass\">recordType</a>.</p>\n</div></li></ul></div></div></div><div id='method-addEvents' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-addEvents' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-addEvents' class='name expandable'>addEvents</a>( <span class='pre'>o, Optional</span> )</div><div class='description'><div class='short'>Adds the specified events to the list of events which this Observable may fire. ...</div><div class='long'><p>Adds the specified events to the list of events which this Observable may fire.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>o</span> : Object|<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>Either an object with event names as properties with a value of <code>true</code>\nor the first event name string if multiple event names are being passed as separate parameters.</p>\n</div></li><li><span class='pre'>Optional</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">string</a><div class='sub-desc'><p>. Event name if multiple event names are being passed as separate parameters.\nUsage:</p>\n\n<pre><code>this.addEvents('storeloaded', 'storecleared');\n</code></pre>\n\n</div></li></ul></div></div></div><div id='method-addListener' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-addListener' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-addListener' class='name expandable'>addListener</a>( <span class='pre'>eventName, handler, [scope], [options]</span> )</div><div class='description'><div class='short'>Appends an event handler to this object. ...</div><div class='long'><p>Appends an event handler to this object.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The name of the event to listen for.</p>\n</div></li><li><span class='pre'>handler</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The method the event invokes.</p>\n</div></li><li><span class='pre'>scope</span> : Object (optional)<div class='sub-desc'><p>The scope (<code><b>this</b></code> reference) in which the handler function is executed.\n<b>If omitted, defaults to the object which fired the event.</b></p>\n</div></li><li><span class='pre'>options</span> : Object (optional)<div class='sub-desc'><p>An object containing handler configuration.\nproperties. This may contain any of the following properties:<ul>\n<li><b>scope</b> : Object<div class=\"sub-desc\">The scope (<code><b>this</b></code> reference) in which the handler function is executed.\n<b>If omitted, defaults to the object which fired the event.</b></div></li>\n<li><b>delay</b> : Number<div class=\"sub-desc\">The number of milliseconds to delay the invocation of the handler after the event fires.</div></li>\n<li><b>single</b> : Boolean<div class=\"sub-desc\">True to add a handler to handle just the next firing of the event, and then remove itself.</div></li>\n<li><b>buffer</b> : Number<div class=\"sub-desc\">Causes the handler to be scheduled to run in an <a href=\"#!/api/Ext.util.DelayedTask\" rel=\"Ext.util.DelayedTask\" class=\"docClass\">Ext.util.DelayedTask</a> delayed\nby the specified number of milliseconds. If the event fires again within that time, the original\nhandler is <em>not</em> invoked, but the new handler is scheduled in its place.</div></li>\n<li><b>target</b> : Observable<div class=\"sub-desc\">Only call the handler if the event was fired on the target Observable, <i>not</i>\nif the event was bubbled up from a child Observable.</div></li>\n</ul><br></p>\n\n<p>\n<b>Combining Options</b><br>\nUsing the options argument, it is possible to combine different types of listeners:<br>\n<br>\nA delayed, one-time listener.\n<pre><code>myDataView.on('click', this.onClick, this, {\nsingle: true,\ndelay: 100\n});</code></pre>\n<p>\n<b>Attaching multiple handlers in 1 call</b><br>\nThe method also allows for a single argument to be passed which is a config object containing properties\nwhich specify multiple handlers.\n<p>\n<pre><code>myGridPanel.on({\n'click' : {\n    fn: this.onClick,\n    scope: this,\n    delay: 100\n},\n'mouseover' : {\n    fn: this.onMouseOver,\n    scope: this\n},\n'mouseout' : {\n    fn: this.onMouseOut,\n    scope: this\n}\n});</code></pre>\n<p>\nOr a shorthand syntax:<br>\n<pre><code>myGridPanel.on({\n'click' : this.onClick,\n'mouseover' : this.onMouseOver,\n'mouseout' : this.onMouseOut,\n scope: this\n});</code></pre>\n\n</p></p></p></p></div></li></ul></div></div></div><div id='method-addSorted' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-method-addSorted' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-method-addSorted' class='name expandable'>addSorted</a>( <span class='pre'>record</span> )</div><div class='description'><div class='short'>(Local sort only) Inserts the passed Record into the Store at the index where it\nshould go based on the current sort ...</div><div class='long'><p>(Local sort only) Inserts the passed Record into the Store at the index where it\nshould go based on the current sort information.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>record</span> : <a href=\"#!/api/Ext.data.Record\" rel=\"Ext.data.Record\" class=\"docClass\">Ext.data.Record</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-addToBatch' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-method-addToBatch' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-method-addToBatch' class='name expandable'>addToBatch</a>( <span class='pre'>batch</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>batch</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-afterCommit' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-method-afterCommit' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-method-afterCommit' class='name expandable'>afterCommit</a>( <span class='pre'>record</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>record</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-afterEdit' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-method-afterEdit' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-method-afterEdit' class='name expandable'>afterEdit</a>( <span class='pre'>record</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>record</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-afterReject' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-method-afterReject' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-method-afterReject' class='name expandable'>afterReject</a>( <span class='pre'>record</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>record</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-applySort' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-method-applySort' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-method-applySort' class='name expandable'>applySort</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>Invokes sortData if we have sortInfo to sort on and are not sorting remotely ...</div><div class='long'><p>Invokes sortData if we have sortInfo to sort on and are not sorting remotely</p>\n</div></div></div><div id='method-buildWriter' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-method-buildWriter' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-method-buildWriter' class='name expandable'>buildWriter</a>( <span class='pre'>config</span> ) : <a href=\"#!/api/Ext.data.DataWriter\" rel=\"Ext.data.DataWriter\" class=\"docClass\">Ext.data.DataWriter</a><strong class='private signature' >private</strong></div><div class='description'><div class='short'>builds a DataWriter instance when Store constructor is provided with a writer config-object instead of an instace. ...</div><div class='long'><p>builds a DataWriter instance when Store constructor is provided with a writer config-object instead of an instace.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>Writer configuration</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.data.DataWriter\" rel=\"Ext.data.DataWriter\" class=\"docClass\">Ext.data.DataWriter</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-clearData' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-method-clearData' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-method-clearData' class='name expandable'>clearData</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n</div></div></div><div id='method-clearFilter' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-method-clearFilter' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-method-clearFilter' class='name expandable'>clearFilter</a>( <span class='pre'>suppressEvent</span> )</div><div class='description'><div class='short'>Revert to a view of the Record cache with no filtering applied. ...</div><div class='long'><p>Revert to a view of the Record cache with no filtering applied.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>suppressEvent</span> : Boolean<div class='sub-desc'><p>If <tt>true</tt> the filter is cleared silently without firing the\n<a href=\"#!/api/Ext.data.Store-event-datachanged\" rel=\"Ext.data.Store-event-datachanged\" class=\"docClass\">datachanged</a> event.</p>\n</div></li></ul></div></div></div><div id='method-clearModified' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-method-clearModified' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-method-clearModified' class='name expandable'>clearModified</a>( <span class='pre'>rs</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>Clears records from modified array after an exception event. ...</div><div class='long'><p>Clears records from modified array after an exception event.\nNOTE:  records are left marked dirty.  Do we want to commit them even though they were not updated/realized?\nTODO remove this method?</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>rs</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-collect' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-method-collect' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-method-collect' class='name expandable'>collect</a>( <span class='pre'>dataIndex, [allowNull], [bypassFilter]</span> ) : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></div><div class='description'><div class='short'>Collects unique values for a particular dataIndex from this store. ...</div><div class='long'><p>Collects unique values for a particular dataIndex from this store.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>dataIndex</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The property to collect</p>\n</div></li><li><span class='pre'>allowNull</span> : Boolean (optional)<div class='sub-desc'><p>Pass true to allow null, undefined or empty string values</p>\n</div></li><li><span class='pre'>bypassFilter</span> : Boolean (optional)<div class='sub-desc'><p>Pass true to collect from all records, even ones which are filtered</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></span><div class='sub-desc'><p>An array of the unique values</p>\n</div></li></ul></div></div></div><div id='method-commitChanges' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-method-commitChanges' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-method-commitChanges' class='name expandable'>commitChanges</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Commit all Records with outstanding changes. ...</div><div class='long'><p>Commit all Records with <a href=\"#!/api/Ext.data.Store-method-getModifiedRecords\" rel=\"Ext.data.Store-method-getModifiedRecords\" class=\"docClass\">outstanding changes</a>. To handle updates for changes,\nsubscribe to the Store's <a href=\"#!/api/Ext.data.Store-event-update\" rel=\"Ext.data.Store-event-update\" class=\"docClass\">update event</a>, and perform updating when the third parameter is\nExt.data.Record.COMMIT.</p>\n</div></div></div><div id='method-createCallback' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-method-createCallback' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-method-createCallback' class='name expandable'>createCallback</a>( <span class='pre'>action, rs, batch</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>callback-handler for remote CRUD actions\nDo not override -- override loadRecords, onCreateRecords, onDestroyRecords a...</div><div class='long'><p>callback-handler for remote CRUD actions\nDo not override -- override loadRecords, onCreateRecords, onDestroyRecords and onUpdateRecords instead.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>action</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>rs</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>batch</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-createFilterFn' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-method-createFilterFn' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-method-createFilterFn' class='name expandable'>createFilterFn</a>( <span class='pre'>property, value, anyMatch, caseSensitive, exactMatch</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>Returns a filter function used to test a the given property's value. ...</div><div class='long'><p>Returns a filter function used to test a the given property's value. Defers most of the work to\n<a href=\"#!/api/Ext.util.MixedCollection\" rel=\"Ext.util.MixedCollection\" class=\"docClass\">Ext.util.MixedCollection</a>'s createValueMatcher function</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>property</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The property to create the filter function for</p>\n</div></li><li><span class='pre'>value</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/RegExp<div class='sub-desc'><p>The string/regex to compare the property value to</p>\n</div></li><li><span class='pre'>anyMatch</span> : Boolean<div class='sub-desc'><p>True if we don't care if the filter value is not the full value (defaults to false)</p>\n</div></li><li><span class='pre'>caseSensitive</span> : Boolean<div class='sub-desc'><p>True to create a case-sensitive regex (defaults to false)</p>\n</div></li><li><span class='pre'>exactMatch</span> : Boolean<div class='sub-desc'><p>True to force exact match (^ and $ characters added to the regex). Defaults to false. Ignored if anyMatch is true.</p>\n</div></li></ul></div></div></div><div id='method-createMultipleFilterFn' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-method-createMultipleFilterFn' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-method-createMultipleFilterFn' class='name expandable'>createMultipleFilterFn</a>( <span class='pre'>filters</span> ) : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><strong class='private signature' >private</strong></div><div class='description'><div class='short'>Given an array of filter functions (each with optional scope), constructs and returns a single function that returns\n...</div><div class='long'><p>Given an array of filter functions (each with optional scope), constructs and returns a single function that returns\nthe result of all of the filters ANDed together</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>filters</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a><div class='sub-desc'><p>The array of filter objects (each object should contain an 'fn' and optional scope)</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a></span><div class='sub-desc'><p>The multiple filter function</p>\n</div></li></ul></div></div></div><div id='method-createRecords' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-method-createRecords' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-method-createRecords' class='name expandable'>createRecords</a>( <span class='pre'>store, records, index</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>Should not be used directly. ...</div><div class='long'><p>Should not be used directly.  Store#add will call this automatically if a Writer is set</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>store</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>records</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>index</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-createSortFunction' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-method-createSortFunction' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-method-createSortFunction' class='name expandable'>createSortFunction</a>( <span class='pre'>field, direction</span> ) : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><strong class='private signature' >private</strong></div><div class='description'><div class='short'>Creates and returns a function which sorts an array by the given field and direction ...</div><div class='long'><p>Creates and returns a function which sorts an array by the given field and direction</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>field</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The field to create the sorter for</p>\n</div></li><li><span class='pre'>direction</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The direction to sort by (defaults to \"ASC\")</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a></span><div class='sub-desc'><p>A function which sorts by the field/direction combination provided</p>\n</div></li></ul></div></div></div><div id='method-destroy' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-method-destroy' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-method-destroy' class='name expandable'>destroy</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Destroys the store. ...</div><div class='long'><p>Destroys the store.</p>\n</div></div></div><div id='method-destroyRecord' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-method-destroyRecord' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-method-destroyRecord' class='name expandable'>destroyRecord</a>( <span class='pre'>store, record, index</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>Destroys a Record. ...</div><div class='long'><p>Destroys a Record.  Should not be used directly.  It's called by Store#remove if a Writer is set.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>store</span> : Store<div class='sub-desc'><p>this</p>\n</div></li><li><span class='pre'>record</span> : <a href=\"#!/api/Ext.data.Record\" rel=\"Ext.data.Record\" class=\"docClass\">Ext.data.Record</a><div class='sub-desc'>\n</div></li><li><span class='pre'>index</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-doTransaction' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-method-doTransaction' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-method-doTransaction' class='name expandable'>doTransaction</a>( <span class='pre'>action, rs, batch</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private. ...</div><div class='long'><p>private.  Simply wraps call to Store#execute in try/catch.  Defers to Store#handleException on error.  Loops if batch: false</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>action</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>rs</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>batch</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-doUpdate' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-method-doUpdate' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-method-doUpdate' class='name expandable'>doUpdate</a>( <span class='pre'>rec</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>Update a record within the store with a new reference ...</div><div class='long'><p>Update a record within the store with a new reference</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>rec</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-each' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-method-each' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-method-each' class='name expandable'>each</a>( <span class='pre'>fn, [scope]</span> )</div><div class='description'><div class='short'>Calls the specified function for each of the Records in the cache. ...</div><div class='long'><p>Calls the specified function for each of the <a href=\"#!/api/Ext.data.Record\" rel=\"Ext.data.Record\" class=\"docClass\">Records</a> in the cache.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The function to call. The <a href=\"#!/api/Ext.data.Record\" rel=\"Ext.data.Record\" class=\"docClass\">Record</a> is passed as the first parameter.\nReturning <tt>false</tt> aborts and exits the iteration.</p>\n</div></li><li><span class='pre'>scope</span> : Object (optional)<div class='sub-desc'><p>The scope (<code>this</code> reference) in which the function is executed.\nDefaults to the current <a href=\"#!/api/Ext.data.Record\" rel=\"Ext.data.Record\" class=\"docClass\">Record</a> in the iteration.</p>\n</div></li></ul></div></div></div><div id='method-enableBubble' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable-more.html#Ext-util-Observable-method-enableBubble' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-enableBubble' class='name expandable'>enableBubble</a>( <span class='pre'>events</span> )</div><div class='description'><div class='short'>Enables events fired by this Observable to bubble up an owner hierarchy by calling\nthis.getBubbleTarget() if present. ...</div><div class='long'><p>Enables events fired by this Observable to bubble up an owner hierarchy by calling\n<code>this.getBubbleTarget()</code> if present. There is no implementation in the Observable base class.</p>\n\n\n<p>This is commonly used by Ext.Components to bubble events to owner Containers. See Ext.Component.getBubbleTarget. The default\nimplementation in <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> returns the Component's immediate owner. But if a known target is required, this can be overridden to\naccess the required target more quickly.</p>\n\n\n<p>Example:</p>\n\n\n<pre><code><a href=\"#!/api/Ext-method-override\" rel=\"Ext-method-override\" class=\"docClass\">Ext.override</a>(<a href=\"#!/api/Ext.form.Field\" rel=\"Ext.form.Field\" class=\"docClass\">Ext.form.Field</a>, {\n    //  Add functionality to Field&#39;s initComponent to enable the change event to bubble\n    initComponent : Ext.form.Field.prototype.initComponent.createSequence(function() {\n        this.enableBubble('change');\n    }),\n\n    //  We know that we want Field&#39;s events to bubble directly to the FormPanel.\n    getBubbleTarget : function() {\n        if (!this.formPanel) {\n            this.formPanel = this.findParentByType('form');\n        }\n        return this.formPanel;\n    }\n});\n\nvar myForm = new Ext.formPanel({\n    title: 'User Details',\n    items: [{\n        ...\n    }],\n    listeners: {\n        change: function() {\n            // Title goes red if form has been modified.\n            myForm.header.setStyle('color', 'red');\n        }\n    }\n});\n</code></pre>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>events</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a><div class='sub-desc'><p>The event name to bubble, or an Array of event names.</p>\n</div></li></ul></div></div></div><div id='method-execute' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-method-execute' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-method-execute' class='name expandable'>execute</a>( <span class='pre'>action, rs, options</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>This method should generally not be used directly. ...</div><div class='long'><p>This method should generally not be used directly.  This method is called internally\nby <a href=\"#!/api/Ext.data.Store-method-load\" rel=\"Ext.data.Store-method-load\" class=\"docClass\">load</a>, or if a Writer is set will be called automatically when <a href=\"#!/api/Ext.data.Store-event-add\" rel=\"Ext.data.Store-event-add\" class=\"docClass\">add</a>,\n<a href=\"#!/api/Ext.data.Store-method-remove\" rel=\"Ext.data.Store-method-remove\" class=\"docClass\">remove</a>, or <a href=\"#!/api/Ext.data.Store-event-update\" rel=\"Ext.data.Store-event-update\" class=\"docClass\">update</a> events fire.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>action</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>Action name ('read', 'create', 'update', or 'destroy')</p>\n</div></li><li><span class='pre'>rs</span> : Record/Record[]<div class='sub-desc'>\n</div></li><li><span class='pre'>options</span> : Object<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Throws</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>Error</p>\n</div></li></ul></div></div></div><div id='method-filter' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-method-filter' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-method-filter' class='name expandable'>filter</a>( <span class='pre'>field, value, [anyMatch], [caseSensitive], [exactMatch]</span> )</div><div class='description'><div class='short'>Filter the records by a specified property. ...</div><div class='long'><p>Filter the <a href=\"#!/api/Ext.data.Record\" rel=\"Ext.data.Record\" class=\"docClass\">records</a> by a specified property. Alternatively, pass an array of filter\noptions to filter by more than one property.\nSingle filter example:\nstore.filter('name', 'Ed', true, true); //finds all records containing the substring 'Ed'\nMultiple filter example:</p>\n\n<pre><code>store.filter([\n  {\n    property     : 'name',\n    value        : 'Ed',\n    anyMatch     : true, //optional, defaults to true\n    caseSensitive: true  //optional, defaults to true\n  },\n\n  //filter functions can also be passed\n  {\n    fn   : function(record) {\n      return record.get('age') == 24\n    },\n    scope: this\n  }\n]);\n</code></pre>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>field</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>|<a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a><div class='sub-desc'><p>A field on your records, or an array containing multiple filter options</p>\n</div></li><li><span class='pre'>value</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/RegExp<div class='sub-desc'><p>Either a string that the field should begin with, or a RegExp to test\nagainst the field.</p>\n</div></li><li><span class='pre'>anyMatch</span> : Boolean (optional)<div class='sub-desc'><p><tt>true</tt> to match any part not just the beginning</p>\n</div></li><li><span class='pre'>caseSensitive</span> : Boolean (optional)<div class='sub-desc'><p><tt>true</tt> for case sensitive comparison</p>\n</div></li><li><span class='pre'>exactMatch</span> : Boolean (optional)<div class='sub-desc'><p>True to force exact match (^ and $ characters added to the regex). Defaults to false. Ignored if anyMatch is true.</p>\n</div></li></ul></div></div></div><div id='method-filterBy' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-method-filterBy' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-method-filterBy' class='name expandable'>filterBy</a>( <span class='pre'>fn, [scope]</span> )</div><div class='description'><div class='short'>Filter by a function. ...</div><div class='long'><p>Filter by a function. The specified function will be called for each\nRecord in this Store. If the function returns <tt>true</tt> the Record is included,\notherwise it is filtered out.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The function to be called. It will be passed the following parameters:<ul>\n<li><b>record</b> : <a href=\"#!/api/Ext.data.Record\" rel=\"Ext.data.Record\" class=\"docClass\">Ext.data.Record</a><p class=\"sub-desc\">The <a href=\"#!/api/Ext.data.Record\" rel=\"Ext.data.Record\" class=\"docClass\">record</a>\nto test for filtering. Access field values using <a href=\"#!/api/Ext.data.Record-method-get\" rel=\"Ext.data.Record-method-get\" class=\"docClass\">Ext.data.Record.get</a>.</p></li>\n<li><b>id</b> : Object<p class=\"sub-desc\">The ID of the Record passed.</p></li>\n</ul></p>\n</div></li><li><span class='pre'>scope</span> : Object (optional)<div class='sub-desc'><p>The scope (<code>this</code> reference) in which the function is executed. Defaults to this Store.</p>\n</div></li></ul></div></div></div><div id='method-find' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-method-find' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-method-find' class='name expandable'>find</a>( <span class='pre'>fieldName, value, [startIndex], [anyMatch], [caseSensitive]</span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Finds the index of the first matching Record in this store by a specific field value. ...</div><div class='long'><p>Finds the index of the first matching Record in this store by a specific field value.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fieldName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The name of the Record field to test.</p>\n</div></li><li><span class='pre'>value</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/RegExp<div class='sub-desc'><p>Either a string that the field value\nshould begin with, or a RegExp to test against the field.</p>\n</div></li><li><span class='pre'>startIndex</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> (optional)<div class='sub-desc'><p>The index to start searching at</p>\n</div></li><li><span class='pre'>anyMatch</span> : Boolean (optional)<div class='sub-desc'><p>True to match any part of the string, not just the beginning</p>\n</div></li><li><span class='pre'>caseSensitive</span> : Boolean (optional)<div class='sub-desc'><p>True for case sensitive comparison</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'><p>The matched index or -1</p>\n</div></li></ul></div></div></div><div id='method-findBy' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-method-findBy' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-method-findBy' class='name expandable'>findBy</a>( <span class='pre'>fn, [scope], [startIndex]</span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Find the index of the first matching Record in this Store by a function. ...</div><div class='long'><p>Find the index of the first matching Record in this Store by a function.\nIf the function returns <tt>true</tt> it is considered a match.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The function to be called. It will be passed the following parameters:<ul>\n<li><b>record</b> : <a href=\"#!/api/Ext.data.Record\" rel=\"Ext.data.Record\" class=\"docClass\">Ext.data.Record</a><p class=\"sub-desc\">The <a href=\"#!/api/Ext.data.Record\" rel=\"Ext.data.Record\" class=\"docClass\">record</a>\nto test for filtering. Access field values using <a href=\"#!/api/Ext.data.Record-method-get\" rel=\"Ext.data.Record-method-get\" class=\"docClass\">Ext.data.Record.get</a>.</p></li>\n<li><b>id</b> : Object<p class=\"sub-desc\">The ID of the Record passed.</p></li>\n</ul></p>\n</div></li><li><span class='pre'>scope</span> : Object (optional)<div class='sub-desc'><p>The scope (<code>this</code> reference) in which the function is executed. Defaults to this Store.</p>\n</div></li><li><span class='pre'>startIndex</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> (optional)<div class='sub-desc'><p>The index to start searching at</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'><p>The matched index or -1</p>\n</div></li></ul></div></div></div><div id='method-findExact' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-method-findExact' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-method-findExact' class='name expandable'>findExact</a>( <span class='pre'>fieldName, value, [startIndex]</span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Finds the index of the first matching Record in this store by a specific field value. ...</div><div class='long'><p>Finds the index of the first matching Record in this store by a specific field value.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fieldName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The name of the Record field to test.</p>\n</div></li><li><span class='pre'>value</span> : Mixed<div class='sub-desc'><p>The value to match the field against.</p>\n</div></li><li><span class='pre'>startIndex</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> (optional)<div class='sub-desc'><p>The index to start searching at</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'><p>The matched index or -1</p>\n</div></li></ul></div></div></div><div id='method-findInsertIndex' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-method-findInsertIndex' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-method-findInsertIndex' class='name expandable'>findInsertIndex</a>( <span class='pre'>record</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>record</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-fireEvent' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-fireEvent' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-fireEvent' class='name expandable'>fireEvent</a>( <span class='pre'>eventName, args</span> ) : Boolean</div><div class='description'><div class='short'>Fires the specified event with the passed parameters (minus the event name). ...</div><div class='long'><p>Fires the specified event with the passed parameters (minus the event name).</p>\n\n\n<p>An event may be set to bubble up an Observable parent hierarchy (See <a href=\"#!/api/Ext.Component-method-getBubbleTarget\" rel=\"Ext.Component-method-getBubbleTarget\" class=\"docClass\">Ext.Component.getBubbleTarget</a>)\nby calling <a href=\"#!/api/Ext.util.Observable-method-enableBubble\" rel=\"Ext.util.Observable-method-enableBubble\" class=\"docClass\">enableBubble</a>.</p>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The name of the event to fire.</p>\n</div></li><li><span class='pre'>args</span> : Object...<div class='sub-desc'><p>Variable number of parameters are passed to handlers.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>returns false if any of the handlers return false otherwise it returns true.</p>\n</div></li></ul></div></div></div><div id='method-getAt' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-method-getAt' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-method-getAt' class='name expandable'>getAt</a>( <span class='pre'>index</span> ) : <a href=\"#!/api/Ext.data.Record\" rel=\"Ext.data.Record\" class=\"docClass\">Ext.data.Record</a></div><div class='description'><div class='short'>Get the Record at the specified index. ...</div><div class='long'><p>Get the Record at the specified index.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>index</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The index of the Record to find.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.data.Record\" rel=\"Ext.data.Record\" class=\"docClass\">Ext.data.Record</a></span><div class='sub-desc'><p>The Record at the passed index. Returns undefined if not found.</p>\n</div></li></ul></div></div></div><div id='method-getById' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-method-getById' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-method-getById' class='name expandable'>getById</a>( <span class='pre'>id</span> ) : <a href=\"#!/api/Ext.data.Record\" rel=\"Ext.data.Record\" class=\"docClass\">Ext.data.Record</a></div><div class='description'><div class='short'>Get the Record with the specified id. ...</div><div class='long'><p>Get the Record with the specified id.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>id</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The id of the Record to find.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.data.Record\" rel=\"Ext.data.Record\" class=\"docClass\">Ext.data.Record</a></span><div class='sub-desc'><p>The Record with the passed id. Returns undefined if not found.</p>\n</div></li></ul></div></div></div><div id='method-getCount' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-method-getCount' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-method-getCount' class='name expandable'>getCount</a>( <span class='pre'></span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Gets the number of cached records. ...</div><div class='long'><p>Gets the number of cached records.</p>\n\n<p>If using paging, this may not be the total size of the dataset. If the data object\nused by the Reader contains the dataset size, then the <a href=\"#!/api/Ext.data.Store-method-getTotalCount\" rel=\"Ext.data.Store-method-getTotalCount\" class=\"docClass\">getTotalCount</a> function returns\nthe dataset size.  <b>Note</b>: see the Important note in <a href=\"#!/api/Ext.data.Store-method-load\" rel=\"Ext.data.Store-method-load\" class=\"docClass\">load</a>.</p>\n\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'><p>The number of Records in the Store's cache.</p>\n</div></li></ul></div></div></div><div id='method-getModifiedRecords' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-method-getModifiedRecords' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-method-getModifiedRecords' class='name expandable'>getModifiedRecords</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.data.Record\" rel=\"Ext.data.Record\" class=\"docClass\">Ext.data.Record</a>[]</div><div class='description'><div class='short'>Gets all records modified since the last commit. ...</div><div class='long'><p>Gets all <a href=\"#!/api/Ext.data.Record\" rel=\"Ext.data.Record\" class=\"docClass\">records</a> modified since the last commit.  Modified records are\npersisted across load operations (e.g., during paging). <b>Note</b>: deleted records are not\nincluded.  See also <tt><a href=\"#!/api/Ext.data.Store-cfg-pruneModifiedRecords\" rel=\"Ext.data.Store-cfg-pruneModifiedRecords\" class=\"docClass\">pruneModifiedRecords</a></tt> and\n<a href=\"#!/api/Ext.data.Record\" rel=\"Ext.data.Record\" class=\"docClass\">Ext.data.Record</a><tt><a href=\"#!/api/Ext.data.Record-method-markDirty\" rel=\"Ext.data.Record-method-markDirty\" class=\"docClass\">markDirty</a>.</tt>.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.data.Record\" rel=\"Ext.data.Record\" class=\"docClass\">Ext.data.Record</a>[]</span><div class='sub-desc'><p>An array of <a href=\"#!/api/Ext.data.Record\" rel=\"Ext.data.Record\" class=\"docClass\">Records</a> containing outstanding\nmodifications.  To obtain modified fields within a modified record see\n<a href=\"#!/api/Ext.data.Record\" rel=\"Ext.data.Record\" class=\"docClass\">Ext.data.Record</a><tt><a href=\"#!/api/Ext.data.Record-property-modified\" rel=\"Ext.data.Record-property-modified\" class=\"docClass\">modified</a>.</tt>.</p>\n</div></li></ul></div></div></div><div id='method-getRange' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-method-getRange' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-method-getRange' class='name expandable'>getRange</a>( <span class='pre'>[startIndex], [endIndex]</span> ) : <a href=\"#!/api/Ext.data.Record\" rel=\"Ext.data.Record\" class=\"docClass\">Ext.data.Record</a>[]</div><div class='description'><div class='short'>Returns a range of Records between specified indices. ...</div><div class='long'><p>Returns a range of Records between specified indices.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>startIndex</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> (optional)<div class='sub-desc'><p>The starting index (defaults to 0)</p>\n</div></li><li><span class='pre'>endIndex</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> (optional)<div class='sub-desc'><p>The ending index (defaults to the last Record in the Store)</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.data.Record\" rel=\"Ext.data.Record\" class=\"docClass\">Ext.data.Record</a>[]</span><div class='sub-desc'><p>An array of Records</p>\n</div></li></ul></div></div></div><div id='method-getSortState' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-method-getSortState' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-method-getSortState' class='name expandable'>getSortState</a>( <span class='pre'></span> ) : Object</div><div class='description'><div class='short'>Returns an object describing the current sort state of this Store. ...</div><div class='long'><p>Returns an object describing the current sort state of this Store.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>The sort state of the Store. An object with two properties:<ul>\n<li><b>field : String</b><p class=\"sub-desc\">The name of the field by which the Records are sorted.</p></li>\n<li><b>direction : String</b><p class=\"sub-desc\">The sort order, 'ASC' or 'DESC' (case-sensitive).</p></li>\n</ul>\nSee <tt><a href=\"#!/api/Ext.data.Store-cfg-sortInfo\" rel=\"Ext.data.Store-cfg-sortInfo\" class=\"docClass\">sortInfo</a></tt> for additional details.</p>\n</div></li></ul></div></div></div><div id='method-getTotalCount' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-method-getTotalCount' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-method-getTotalCount' class='name expandable'>getTotalCount</a>( <span class='pre'></span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Gets the total number of records in the dataset as returned by the server. ...</div><div class='long'><p>Gets the total number of records in the dataset as returned by the server.</p>\n\n<p>If using paging, for this to be accurate, the data object used by the <a href=\"#!/api/Ext.data.Store-cfg-reader\" rel=\"Ext.data.Store-cfg-reader\" class=\"docClass\">Reader</a>\nmust contain the dataset size. For remote data sources, the value for this property\n(<tt>totalProperty</tt> for <a href=\"#!/api/Ext.data.JsonReader\" rel=\"Ext.data.JsonReader\" class=\"docClass\">JsonReader</a>,\n<tt>totalRecords</tt> for <a href=\"#!/api/Ext.data.XmlReader\" rel=\"Ext.data.XmlReader\" class=\"docClass\">XmlReader</a>) shall be returned by a query on the server.\n<b>Note</b>: see the Important note in <a href=\"#!/api/Ext.data.Store-method-load\" rel=\"Ext.data.Store-method-load\" class=\"docClass\">load</a>.</p>\n\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'><p>The number of Records as specified in the data object passed to the Reader\nby the Proxy.</p>\n\n<p><b>Note</b>: this value is not updated when changing the contents of the Store locally.</p>\n\n</div></li></ul></div></div></div><div id='method-handleException' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-method-handleException' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-method-handleException' class='name expandable'>handleException</a>( <span class='pre'>e</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>protected handleException. ...</div><div class='long'><p>protected handleException.  Possibly temporary until Ext framework has an exception-handler.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-hasListener' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-hasListener' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-hasListener' class='name expandable'>hasListener</a>( <span class='pre'>eventName</span> ) : Boolean</div><div class='description'><div class='short'>Checks to see if this object has any listeners for a specified event ...</div><div class='long'><p>Checks to see if this object has any listeners for a specified event</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The name of the event to check for</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>True if the event is being listened for, else false</p>\n</div></li></ul></div></div></div><div id='method-indexOf' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-method-indexOf' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-method-indexOf' class='name expandable'>indexOf</a>( <span class='pre'>record</span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Get the index within the cache of the passed Record. ...</div><div class='long'><p>Get the index within the cache of the passed Record.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>record</span> : <a href=\"#!/api/Ext.data.Record\" rel=\"Ext.data.Record\" class=\"docClass\">Ext.data.Record</a><div class='sub-desc'><p>The <a href=\"#!/api/Ext.data.Record\" rel=\"Ext.data.Record\" class=\"docClass\">Ext.data.Record</a> object to find.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'><p>The index of the passed Record. Returns -1 if not found.</p>\n</div></li></ul></div></div></div><div id='method-indexOfId' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-method-indexOfId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-method-indexOfId' class='name expandable'>indexOfId</a>( <span class='pre'>id</span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Get the index within the cache of the Record with the passed id. ...</div><div class='long'><p>Get the index within the cache of the Record with the passed id.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>id</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The id of the Record to find.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'><p>The index of the Record. Returns -1 if not found.</p>\n</div></li></ul></div></div></div><div id='method-insert' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-method-insert' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-method-insert' class='name expandable'>insert</a>( <span class='pre'>index, records</span> )</div><div class='description'><div class='short'>Inserts Records into the Store at the given index and fires the add event. ...</div><div class='long'><p>Inserts Records into the Store at the given index and fires the <a href=\"#!/api/Ext.data.Store-event-add\" rel=\"Ext.data.Store-event-add\" class=\"docClass\">add</a> event.\nSee also <code><a href=\"#!/api/Ext.data.Store-event-add\" rel=\"Ext.data.Store-event-add\" class=\"docClass\">add</a></code> and <code><a href=\"#!/api/Ext.data.Store-method-addSorted\" rel=\"Ext.data.Store-method-addSorted\" class=\"docClass\">addSorted</a></code>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>index</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The start index at which to insert the passed Records.</p>\n</div></li><li><span class='pre'>records</span> : <a href=\"#!/api/Ext.data.Record\" rel=\"Ext.data.Record\" class=\"docClass\">Ext.data.Record</a>[]<div class='sub-desc'><p>An Array of <a href=\"#!/api/Ext.data.Record\" rel=\"Ext.data.Record\" class=\"docClass\">Ext.data.Record</a> objects to add to the cache.</p>\n</div></li></ul></div></div></div><div id='method-isFiltered' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-method-isFiltered' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-method-isFiltered' class='name expandable'>isFiltered</a>( <span class='pre'></span> ) : Boolean</div><div class='description'><div class='short'>Returns true if this store is currently filtered ...</div><div class='long'><p>Returns true if this store is currently filtered</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-load' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-method-load' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-method-load' class='name expandable'>load</a>( <span class='pre'>options</span> ) : Boolean</div><div class='description'><div class='short'>Loads the Record cache from the configured proxy using the configured reader. ...</div><div class='long'><p>Loads the Record cache from the configured <tt><a href=\"#!/api/Ext.data.Store-cfg-proxy\" rel=\"Ext.data.Store-cfg-proxy\" class=\"docClass\">proxy</a></tt> using the configured <tt><a href=\"#!/api/Ext.data.Store-cfg-reader\" rel=\"Ext.data.Store-cfg-reader\" class=\"docClass\">reader</a></tt>.</p>\n\n\n<br><p>Notes:</p><div class=\"mdetail-params\"><ul>\n\n\n<p><li><b><u>Important</u></b>: loading is asynchronous! This call will return before the new data has been\nloaded. To perform any post-processing where information from the load call is required, specify\nthe <tt>callback</tt> function to be called, or use a <a href=\"#!/api/Ext.util.Observable-cfg-listeners\" rel=\"Ext.util.Observable-cfg-listeners\" class=\"docClass\">a 'load' event handler</a>.</li>\n<li>If using <a href=\"#!/api/Ext.PagingToolbar\" rel=\"Ext.PagingToolbar\" class=\"docClass\">remote paging</a>, the first load call must specify the <tt>start</tt> and <tt>limit</tt>\nproperties in the <code>options.params</code> property to establish the initial position within the\ndataset, and the number of Records to cache on each read from the Proxy.</li>\n<li>If using <a href=\"#!/api/Ext.data.Store-cfg-remoteSort\" rel=\"Ext.data.Store-cfg-remoteSort\" class=\"docClass\">remote sorting</a>, the configured <code><a href=\"#!/api/Ext.data.Store-cfg-sortInfo\" rel=\"Ext.data.Store-cfg-sortInfo\" class=\"docClass\">sortInfo</a></code>\nwill be automatically included with the posted parameters according to the specified\n<code><a href=\"#!/api/Ext.data.Store-cfg-paramNames\" rel=\"Ext.data.Store-cfg-paramNames\" class=\"docClass\">paramNames</a></code>.</li>\n</ul></div></p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>options</span> : Object<div class='sub-desc'><p>An object containing properties which control loading options:<ul>\n<li><b><tt>params</tt></b> :Object<div class=\"sub-desc\"><p>An object containing properties to pass as HTTP\nparameters to a remote data source. <b>Note</b>: <code>params</code> will override any\n<code><a href=\"#!/api/Ext.data.Store-property-baseParams\" rel=\"Ext.data.Store-property-baseParams\" class=\"docClass\">baseParams</a></code> of the same name.</p></p>\n\n<p>Parameters are encoded as standard HTTP parameters using <a href=\"#!/api/Ext-method-urlEncode\" rel=\"Ext-method-urlEncode\" class=\"docClass\">Ext.urlEncode</a>.</p>\n\n\n<p></div></li>\n<li><b>callback</b> : Function<div class=\"sub-desc\"><p>A function to be called after the Records\nhave been loaded. The callback is called after the load event is fired, and is passed the following arguments:<ul>\n<li>r : <a href=\"#!/api/Ext.data.Record\" rel=\"Ext.data.Record\" class=\"docClass\">Ext.data.Record</a>[] An Array of Records loaded.</li>\n<li>options : Options object from the load call.</li>\n<li>success : Boolean success indicator.</li></ul></p></div></li>\n<li><b>scope</b> : Object<div class=\"sub-desc\"><p>Scope with which to call the callback (defaults\nto the Store object)</p></div></li>\n<li><b>add</b> : Boolean<div class=\"sub-desc\"><p>Indicator to append loaded records rather than\nreplace the current cache.  <b>Note</b>: see note for <tt><a href=\"#!/api/Ext.data.Store-method-loadData\" rel=\"Ext.data.Store-method-loadData\" class=\"docClass\">loadData</a></tt></p></div></li>\n</ul></p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>If the <i>developer</i> provided <tt><a href=\"#!/api/Ext.data.Store-event-beforeload\" rel=\"Ext.data.Store-event-beforeload\" class=\"docClass\">beforeload</a></tt> event handler returns\n<tt>false</tt>, the load call will abort and will return <tt>false</tt>; otherwise will return <tt>true</tt>.</p>\n</div></li></ul></div></div></div><div id='method-loadData' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-method-loadData' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-method-loadData' class='name expandable'>loadData</a>( <span class='pre'>data, [append]</span> )</div><div class='description'><div class='short'>Loads data from a passed data block and fires the load event. ...</div><div class='long'><p>Loads data from a passed data block and fires the <a href=\"#!/api/Ext.data.Store-method-load\" rel=\"Ext.data.Store-method-load\" class=\"docClass\">load</a> event. A Reader\nwhich understands the format of the data must have been configured in the constructor.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>data</span> : Object<div class='sub-desc'><p>The data block from which to read the Records.  The format of the data expected\nis dependent on the type of Reader that is configured and should correspond to\nthat Reader's <tt>Ext.data.Reader.readRecords</tt> parameter.</p>\n</div></li><li><span class='pre'>append</span> : Boolean (optional)<div class='sub-desc'><p><tt>true</tt> to append the new Records rather the default to replace\nthe existing cache.\n<b>Note</b>: that Records in a Store are keyed by their <a href=\"#!/api/Ext.data.Record-method-id\" rel=\"Ext.data.Record-method-id\" class=\"docClass\">id</a>, so added Records\nwith ids which are already present in the Store will <i>replace</i> existing Records. Only Records with\nnew, unique ids will be added.</p>\n</div></li></ul></div></div></div><div id='method-loadRecords' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-method-loadRecords' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-method-loadRecords' class='name expandable'>loadRecords</a>( <span class='pre'>o, options, success</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private\nCalled as a callback by the Reader during a load operation. ...</div><div class='long'><p>private\nCalled as a callback by the Reader during a load operation.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>o</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>options</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>success</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-multiSort' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-method-multiSort' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-method-multiSort' class='name expandable'>multiSort</a>( <span class='pre'>sorters, direction</span> )</div><div class='description'><div class='short'>Sorts the contents of this store by multiple field/direction sorters. ...</div><div class='long'><p>Sorts the contents of this store by multiple field/direction sorters. This is called internally by sort\nand would not usually be called manually.\nMulti sorting only currently applies to local datasets - multiple sort data is not currently sent to a proxy\nif remoteSort is used.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sorters</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a><div class='sub-desc'><p>Array of sorter objects (field and direction)</p>\n</div></li><li><span class='pre'>direction</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>Overall direction to sort the ordered results by (defaults to \"ASC\")</p>\n</div></li></ul></div></div></div><div id='method-on' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-on' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-on' class='name expandable'>on</a>( <span class='pre'>eventName, handler, [scope], [options]</span> )</div><div class='description'><div class='short'>Appends an event handler to this object (shorthand for addListener.) ...</div><div class='long'><p>Appends an event handler to this object (shorthand for <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">addListener</a>.)</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The type of event to listen for</p>\n</div></li><li><span class='pre'>handler</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The method the event invokes</p>\n</div></li><li><span class='pre'>scope</span> : Object (optional)<div class='sub-desc'><p>The scope (<code><b>this</b></code> reference) in which the handler function is executed.\n<b>If omitted, defaults to the object which fired the event.</b></p>\n</div></li><li><span class='pre'>options</span> : Object (optional)<div class='sub-desc'><p>An object containing handler configuration.</p>\n</div></li></ul></div></div></div><div id='method-onClear' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-method-onClear' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-method-onClear' class='name expandable'>onClear</a>( <span class='pre'>store, records</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>store</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>records</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-onCreateRecords' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-method-onCreateRecords' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-method-onCreateRecords' class='name expandable'>onCreateRecords</a>( <span class='pre'>success, rs, data</span> )<strong class='private signature' >private</strong><strong class='protected signature' >protected</strong></div><div class='description'><div class='short'>onCreateRecord proxy callback for create action ...</div><div class='long'><p>onCreateRecord proxy callback for create action</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>success</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>rs</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>data</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-onDestroyRecords' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-method-onDestroyRecords' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-method-onDestroyRecords' class='name expandable'>onDestroyRecords</a>( <span class='pre'>success, rs, data</span> )<strong class='private signature' >private</strong><strong class='protected signature' >protected</strong></div><div class='description'><div class='short'>onDestroyRecords proxy callback for destroy action ...</div><div class='long'><p>onDestroyRecords proxy callback for destroy action</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>success</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>rs</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>data</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-onMetaChange' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-method-onMetaChange' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-method-onMetaChange' class='name expandable'>onMetaChange</a>( <span class='pre'>meta</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>meta</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-onUpdateRecords' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-method-onUpdateRecords' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-method-onUpdateRecords' class='name expandable'>onUpdateRecords</a>( <span class='pre'>success, rs, data</span> )<strong class='private signature' >private</strong><strong class='protected signature' >protected</strong></div><div class='description'><div class='short'>, onUpdateRecords proxy callback for update action ...</div><div class='long'><p>, onUpdateRecords proxy callback for update action</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>success</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>rs</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>data</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-purgeListeners' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-purgeListeners' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-purgeListeners' class='name expandable'>purgeListeners</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Removes all listeners for this object ...</div><div class='long'><p>Removes all listeners for this object</p>\n</div></div></div><div id='method-query' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-method-query' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-method-query' class='name expandable'>query</a>( <span class='pre'>field, value, [anyMatch], [caseSensitive]</span> ) : MixedCollection</div><div class='description'><div class='short'>Query the records by a specified property. ...</div><div class='long'><p>Query the records by a specified property.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>field</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>A field on your records</p>\n</div></li><li><span class='pre'>value</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/RegExp<div class='sub-desc'><p>Either a string that the field\nshould begin with, or a RegExp to test against the field.</p>\n</div></li><li><span class='pre'>anyMatch</span> : Boolean (optional)<div class='sub-desc'><p>True to match any part not just the beginning</p>\n</div></li><li><span class='pre'>caseSensitive</span> : Boolean (optional)<div class='sub-desc'><p>True for case sensitive comparison</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>MixedCollection</span><div class='sub-desc'><p>Returns an <a href=\"#!/api/Ext.util.MixedCollection\" rel=\"Ext.util.MixedCollection\" class=\"docClass\">Ext.util.MixedCollection</a> of the matched records</p>\n</div></li></ul></div></div></div><div id='method-queryBy' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-method-queryBy' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-method-queryBy' class='name expandable'>queryBy</a>( <span class='pre'>fn, [scope]</span> ) : MixedCollection</div><div class='description'><div class='short'>Query the cached records in this Store using a filtering function. ...</div><div class='long'><p>Query the cached records in this Store using a filtering function. The specified function\nwill be called with each record in this Store. If the function returns <tt>true</tt> the record is\nincluded in the results.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The function to be called. It will be passed the following parameters:<ul>\n<li><b>record</b> : <a href=\"#!/api/Ext.data.Record\" rel=\"Ext.data.Record\" class=\"docClass\">Ext.data.Record</a><p class=\"sub-desc\">The <a href=\"#!/api/Ext.data.Record\" rel=\"Ext.data.Record\" class=\"docClass\">record</a>\nto test for filtering. Access field values using <a href=\"#!/api/Ext.data.Record-method-get\" rel=\"Ext.data.Record-method-get\" class=\"docClass\">Ext.data.Record.get</a>.</p></li>\n<li><b>id</b> : Object<p class=\"sub-desc\">The ID of the Record passed.</p></li>\n</ul></p>\n</div></li><li><span class='pre'>scope</span> : Object (optional)<div class='sub-desc'><p>The scope (<code>this</code> reference) in which the function is executed. Defaults to this Store.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>MixedCollection</span><div class='sub-desc'><p>Returns an <a href=\"#!/api/Ext.util.MixedCollection\" rel=\"Ext.util.MixedCollection\" class=\"docClass\">Ext.util.MixedCollection</a> of the matched records</p>\n</div></li></ul></div></div></div><div id='method-reMap' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-method-reMap' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-method-reMap' class='name expandable'>reMap</a>( <span class='pre'>record</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>remap record ids in MixedCollection after records have been realized. ...</div><div class='long'><p>remap record ids in MixedCollection after records have been realized.  @see Store#onCreateRecords, @see DataReader#realize</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>record</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-rejectChanges' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-method-rejectChanges' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-method-rejectChanges' class='name expandable'>rejectChanges</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Reject outstanding changes on all modified records. ...</div><div class='long'><p><a href=\"#!/api/Ext.data.Record-method-reject\" rel=\"Ext.data.Record-method-reject\" class=\"docClass\">Reject</a> outstanding changes on all <a href=\"#!/api/Ext.data.Store-method-getModifiedRecords\" rel=\"Ext.data.Store-method-getModifiedRecords\" class=\"docClass\">modified records</a>.</p>\n</div></div></div><div id='method-relayEvents' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable-more.html#Ext-util-Observable-method-relayEvents' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-relayEvents' class='name expandable'>relayEvents</a>( <span class='pre'>o, events</span> )</div><div class='description'><div class='short'>Relays selected events from the specified Observable as if the events were fired by this. ...</div><div class='long'><p>Relays selected events from the specified Observable as if the events were fired by <tt><b>this</b></tt>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>o</span> : Object<div class='sub-desc'><p>The Observable whose events this object is to relay.</p>\n</div></li><li><span class='pre'>events</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a><div class='sub-desc'><p>Array of event names to relay.</p>\n</div></li></ul></div></div></div><div id='method-reload' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-method-reload' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-method-reload' class='name expandable'>reload</a>( <span class='pre'>options</span> )</div><div class='description'><div class='short'>Reloads the Record cache from the configured Proxy using the configured\nReader and the options from the last load ope...</div><div class='long'><p>Reloads the Record cache from the configured Proxy using the configured\nReader and the options from the last load operation\nperformed.</p>\n\n\n<p><b>Note</b>: see the Important note in <a href=\"#!/api/Ext.data.Store-method-load\" rel=\"Ext.data.Store-method-load\" class=\"docClass\">load</a>.</p>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>options</span> : Object<div class='sub-desc'><p>(optional) An <tt>Object</tt> containing\n<a href=\"#!/api/Ext.data.Store-method-load\" rel=\"Ext.data.Store-method-load\" class=\"docClass\">loading options</a> which may override the <a href=\"#!/api/Ext.data.Store-property-lastOptions\" rel=\"Ext.data.Store-property-lastOptions\" class=\"docClass\">options</a>\nused in the last <a href=\"#!/api/Ext.data.Store-method-load\" rel=\"Ext.data.Store-method-load\" class=\"docClass\">load</a> operation. See <a href=\"#!/api/Ext.data.Store-method-load\" rel=\"Ext.data.Store-method-load\" class=\"docClass\">load</a> for details\n(defaults to <tt>null</tt>, in which case the <a href=\"#!/api/Ext.data.Store-property-lastOptions\" rel=\"Ext.data.Store-property-lastOptions\" class=\"docClass\">lastOptions</a> are\nused).</p>\n\n\n<br><p>To add new params to the existing params:</p>\n\n\n<pre><code>lastOptions = myStore.lastOptions;\n<a href=\"#!/api/Ext-method-apply\" rel=\"Ext-method-apply\" class=\"docClass\">Ext.apply</a>(lastOptions.params, {\n    myNewParam: true\n});\nmyStore.reload(lastOptions);\n</code></pre>\n\n</div></li></ul></div></div></div><div id='method-remove' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-method-remove' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-method-remove' class='name expandable'>remove</a>( <span class='pre'>record</span> )</div><div class='description'><div class='short'>Remove Records from the Store and fires the remove event. ...</div><div class='long'><p>Remove Records from the Store and fires the <a href=\"#!/api/Ext.data.Store-method-remove\" rel=\"Ext.data.Store-method-remove\" class=\"docClass\">remove</a> event.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>record</span> : <a href=\"#!/api/Ext.data.Record\" rel=\"Ext.data.Record\" class=\"docClass\">Ext.data.Record</a>/<a href=\"#!/api/Ext.data.Record\" rel=\"Ext.data.Record\" class=\"docClass\">Ext.data.Record</a>[]<div class='sub-desc'><p>The record object or array of records to remove from the cache.</p>\n</div></li></ul></div></div></div><div id='method-removeAll' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-method-removeAll' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-method-removeAll' class='name expandable'>removeAll</a>( <span class='pre'>silent</span> )</div><div class='description'><div class='short'>Remove all Records from the Store and fires the clear event. ...</div><div class='long'><p>Remove all Records from the Store and fires the <a href=\"#!/api/Ext.data.Store-event-clear\" rel=\"Ext.data.Store-event-clear\" class=\"docClass\">clear</a> event.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>silent</span> : Boolean<div class='sub-desc'><p>[false] Defaults to <tt>false</tt>.  Set <tt>true</tt> to not fire clear event.</p>\n</div></li></ul></div></div></div><div id='method-removeAt' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-method-removeAt' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-method-removeAt' class='name expandable'>removeAt</a>( <span class='pre'>index</span> )</div><div class='description'><div class='short'>Remove a Record from the Store at the specified index. ...</div><div class='long'><p>Remove a Record from the Store at the specified index. Fires the <a href=\"#!/api/Ext.data.Store-method-remove\" rel=\"Ext.data.Store-method-remove\" class=\"docClass\">remove</a> event.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>index</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The index of the record to remove.</p>\n</div></li></ul></div></div></div><div id='method-removeFromBatch' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-method-removeFromBatch' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-method-removeFromBatch' class='name expandable'>removeFromBatch</a>( <span class='pre'>batch, action, data</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>batch</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>action</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>data</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-removeListener' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-removeListener' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-removeListener' class='name expandable'>removeListener</a>( <span class='pre'>eventName, handler, [scope]</span> )</div><div class='description'><div class='short'>Removes an event handler. ...</div><div class='long'><p>Removes an event handler.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The type of event the handler was associated with.</p>\n</div></li><li><span class='pre'>handler</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The handler to remove. <b>This must be a reference to the function passed into the <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">addListener</a> call.</b></p>\n</div></li><li><span class='pre'>scope</span> : Object (optional)<div class='sub-desc'><p>The scope originally specified for the handler.</p>\n</div></li></ul></div></div></div><div id='method-resumeEvents' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-resumeEvents' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-resumeEvents' class='name expandable'>resumeEvents</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Resume firing events. ...</div><div class='long'><p>Resume firing events. (see <a href=\"#!/api/Ext.util.Observable-method-suspendEvents\" rel=\"Ext.util.Observable-method-suspendEvents\" class=\"docClass\">suspendEvents</a>)\nIf events were suspended using the <tt><b>queueSuspended</b></tt> parameter, then all\nevents fired during event suspension will be sent to any listeners now.</p>\n</div></div></div><div id='method-save' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-method-save' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-method-save' class='name expandable'>save</a>( <span class='pre'></span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Saves all pending changes to the store. ...</div><div class='long'><p>Saves all pending changes to the store.  If the commensurate <a href=\"#!/api/Ext.data.Api-property-actions\" rel=\"Ext.data.Api-property-actions\" class=\"docClass\">Ext.data.Api.actions</a> action is not configured, then\nthe configured <code><a href=\"#!/api/Ext.data.Store-cfg-url\" rel=\"Ext.data.Store-cfg-url\" class=\"docClass\">url</a></code> will be used.</p>\n\n<pre>change            url\n---------------   --------------------\nremoved records   Ext.data.Api.actions.destroy\nphantom records   Ext.data.Api.actions.create\n<a href=\"#!/api/Ext.data.Store-method-getModifiedRecords\" rel=\"Ext.data.Store-method-getModifiedRecords\" class=\"docClass\">modified records</a>  Ext.data.Api.actions.update\n</pre>\n\n\n<p>@TODO:  Create extensions of Error class and send associated Record with thrown exceptions.\ne.g.:  <a href=\"#!/api/Ext.data.DataReader.Error\" rel=\"Ext.data.DataReader.Error\" class=\"docClass\">Ext.data.DataReader.Error</a> or Ext.data.Error or <a href=\"#!/api/Ext.data.DataProxy.Error\" rel=\"Ext.data.DataProxy.Error\" class=\"docClass\">Ext.data.DataProxy.Error</a>, etc.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'><p>batch Returns a number to uniquely identify the \"batch\" of saves occurring. -1 will be returned\nif there are no items to save or the save was cancelled.</p>\n</div></li></ul></div></div></div><div id='method-setBaseParam' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-method-setBaseParam' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-method-setBaseParam' class='name expandable'>setBaseParam</a>( <span class='pre'>name, value</span> )</div><div class='description'><div class='short'>Set the value for a property name in this store's baseParams. ...</div><div class='long'><p>Set the value for a property name in this store's <a href=\"#!/api/Ext.data.Store-property-baseParams\" rel=\"Ext.data.Store-property-baseParams\" class=\"docClass\">baseParams</a>.  Usage:</p></p>\n\n<pre><code>myStore.setBaseParam('foo', {bar:3});\n</code></pre>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>name</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>Name of the property to assign</p>\n</div></li><li><span class='pre'>value</span> : Mixed<div class='sub-desc'><p>Value to assign the <tt>name</tt>d property</p>\n</div></li></ul></div></div></div><div id='method-setDefaultSort' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-method-setDefaultSort' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-method-setDefaultSort' class='name expandable'>setDefaultSort</a>( <span class='pre'>fieldName, [dir]</span> )</div><div class='description'><div class='short'>Sets the default sort column and order to be used by the next load operation. ...</div><div class='long'><p>Sets the default sort column and order to be used by the next <a href=\"#!/api/Ext.data.Store-method-load\" rel=\"Ext.data.Store-method-load\" class=\"docClass\">load</a> operation.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fieldName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The name of the field to sort by.</p>\n</div></li><li><span class='pre'>dir</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> (optional)<div class='sub-desc'><p>The sort order, 'ASC' or 'DESC' (case-sensitive, defaults to <tt>'ASC'</tt>)</p>\n</div></li></ul></div></div></div><div id='method-singleSort' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-method-singleSort' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-method-singleSort' class='name expandable'>singleSort</a>( <span class='pre'>fieldName, [dir]</span> )</div><div class='description'><div class='short'>Sorts the store contents by a single field and direction. ...</div><div class='long'><p>Sorts the store contents by a single field and direction. This is called internally by sort and would\nnot usually be called manually</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fieldName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The name of the field to sort by.</p>\n</div></li><li><span class='pre'>dir</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> (optional)<div class='sub-desc'><p>The sort order, 'ASC' or 'DESC' (case-sensitive, defaults to <tt>'ASC'</tt>)</p>\n</div></li></ul></div></div></div><div id='method-sort' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-method-sort' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-method-sort' class='name expandable'>sort</a>( <span class='pre'>fieldName, [dir]</span> )</div><div class='description'><div class='short'>Sort the Records. ...</div><div class='long'><p>Sort the Records.\nIf remote sorting is used, the sort is performed on the server, and the cache is reloaded. If local\nsorting is used, the cache is sorted internally. See also <a href=\"#!/api/Ext.data.Store-cfg-remoteSort\" rel=\"Ext.data.Store-cfg-remoteSort\" class=\"docClass\">remoteSort</a> and <a href=\"#!/api/Ext.data.Store-cfg-paramNames\" rel=\"Ext.data.Store-cfg-paramNames\" class=\"docClass\">paramNames</a>.\nThis function accepts two call signatures - pass in a field name as the first argument to sort on a single\nfield, or pass in an array of sort configuration objects to sort by multiple fields.\nSingle sort example:\nstore.sort('name', 'ASC');\nMulti sort example:\nstore.sort([\n  {</p>\n\n<pre><code>field    : 'name',\ndirection: 'ASC'\n</code></pre>\n\n<p>  },\n  {</p>\n\n<pre><code>field    : 'salary',\ndirection: 'DESC'\n</code></pre>\n\n<p>  }\n], 'ASC');\nIn this second form, the sort configs are applied in order, with later sorters sorting within earlier sorters' results.\nFor example, if two records with the same name are present they will also be sorted by salary if given the sort configs\nabove. Any number of sort configs can be added.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fieldName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a><div class='sub-desc'><p>The name of the field to sort by, or an array of ordered sort configs</p>\n</div></li><li><span class='pre'>dir</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> (optional)<div class='sub-desc'><p>The sort order, 'ASC' or 'DESC' (case-sensitive, defaults to <tt>'ASC'</tt>)</p>\n</div></li></ul></div></div></div><div id='method-sortData' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-method-sortData' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-method-sortData' class='name expandable'>sortData</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>Performs the actual sorting of data. ...</div><div class='long'><p>Performs the actual sorting of data. This checks to see if we currently have a multi sort or not. It applies\neach sorter field/direction pair in turn by building an OR'ed master sorting function and running it against\nthe full dataset</p>\n</div></div></div><div id='method-storeOptions' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-method-storeOptions' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-method-storeOptions' class='name expandable'>storeOptions</a>( <span class='pre'>o</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>o</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-sum' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-method-sum' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-method-sum' class='name expandable'>sum</a>( <span class='pre'>property, [start], [end]</span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Sums the value of property for each record between start\nand end and returns the result. ...</div><div class='long'><p>Sums the value of <tt>property</tt> for each <a href=\"#!/api/Ext.data.Record\" rel=\"Ext.data.Record\" class=\"docClass\">record</a> between <tt>start</tt>\nand <tt>end</tt> and returns the result.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>property</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>A field in each record</p>\n</div></li><li><span class='pre'>start</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> (optional)<div class='sub-desc'><p>The record index to start at (defaults to <tt>0</tt>)</p>\n</div></li><li><span class='pre'>end</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> (optional)<div class='sub-desc'><p>The last record index to include (defaults to length - 1)</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'><p>The sum</p>\n</div></li></ul></div></div></div><div id='method-suspendEvents' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-suspendEvents' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-suspendEvents' class='name expandable'>suspendEvents</a>( <span class='pre'>queueSuspended</span> )</div><div class='description'><div class='short'>Suspend the firing of all events. ...</div><div class='long'><p>Suspend the firing of all events. (see <a href=\"#!/api/Ext.util.Observable-method-resumeEvents\" rel=\"Ext.util.Observable-method-resumeEvents\" class=\"docClass\">resumeEvents</a>)</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>queueSuspended</span> : Boolean<div class='sub-desc'><p>Pass as true to queue up suspended events to be fired\nafter the <a href=\"#!/api/Ext.util.Observable-method-resumeEvents\" rel=\"Ext.util.Observable-method-resumeEvents\" class=\"docClass\">resumeEvents</a> call instead of discarding all suspended events;</p>\n</div></li></ul></div></div></div><div id='method-un' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-un' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-un' class='name expandable'>un</a>( <span class='pre'>eventName, handler, [scope]</span> )</div><div class='description'><div class='short'>Removes an event handler (shorthand for removeListener.) ...</div><div class='long'><p>Removes an event handler (shorthand for <a href=\"#!/api/Ext.util.Observable-method-removeListener\" rel=\"Ext.util.Observable-method-removeListener\" class=\"docClass\">removeListener</a>.)</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The type of event the handler was associated with.</p>\n</div></li><li><span class='pre'>handler</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The handler to remove. <b>This must be a reference to the function passed into the <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">addListener</a> call.</b></p>\n</div></li><li><span class='pre'>scope</span> : Object (optional)<div class='sub-desc'><p>The scope originally specified for the handler.</p>\n</div></li></ul></div></div></div><div id='method-updateRecord' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-method-updateRecord' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-method-updateRecord' class='name expandable'>updateRecord</a>( <span class='pre'>store, record, action</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>updateRecord  Should not be used directly. ...</div><div class='long'><p>updateRecord  Should not be used directly.  This method will be called automatically if a Writer is set.\nListens to 'update' event.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>store</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>record</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>action</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-event'>Events</h3><div class='subsection'><div id='event-add' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-event-add' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-event-add' class='name expandable'>add</a>( <span class='pre'>this, records, index</span> )</div><div class='description'><div class='short'>Fires when Records have been added to the Store ...</div><div class='long'><p>Fires when Records have been <a href=\"#!/api/Ext.data.Store-event-add\" rel=\"Ext.data.Store-event-add\" class=\"docClass\">add</a>ed to the Store</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : Store<div class='sub-desc'>\n</div></li><li><span class='pre'>records</span> : <a href=\"#!/api/Ext.data.Record\" rel=\"Ext.data.Record\" class=\"docClass\">Ext.data.Record</a>[]<div class='sub-desc'><p>The array of Records added</p>\n</div></li><li><span class='pre'>index</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The index at which the record(s) were added</p>\n</div></li></ul></div></div></div><div id='event-beforeload' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-event-beforeload' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-event-beforeload' class='name expandable'>beforeload</a>( <span class='pre'>this, options</span> )</div><div class='description'><div class='short'>Fires before a request is made for a new data object. ...</div><div class='long'><p>Fires before a request is made for a new data object.  If the beforeload handler returns\n<tt>false</tt> the <a href=\"#!/api/Ext.data.Store-method-load\" rel=\"Ext.data.Store-method-load\" class=\"docClass\">load</a> action will be canceled.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : Store<div class='sub-desc'>\n</div></li><li><span class='pre'>options</span> : Object<div class='sub-desc'><p>The loading options that were specified (see <a href=\"#!/api/Ext.data.Store-method-load\" rel=\"Ext.data.Store-method-load\" class=\"docClass\">load</a> for details)</p>\n</div></li></ul></div></div></div><div id='event-beforesave' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-event-beforesave' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-event-beforesave' class='name expandable'>beforesave</a>( <span class='pre'>store, data</span> )</div><div class='description'><div class='short'>Fires before a save action is called. ...</div><div class='long'><p>Fires before a save action is called. A save encompasses destroying records, updating records and creating records.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>store</span> : <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a><div class='sub-desc'>\n</div></li><li><span class='pre'>data</span> : Object<div class='sub-desc'><p>An object containing the data that is to be saved. The object will contain a key for each appropriate action,\nwith an array of records for each action.</p>\n</div></li></ul></div></div></div><div id='event-beforewrite' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-event-beforewrite' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-event-beforewrite' class='name expandable'>beforewrite</a>( <span class='pre'>store, action, rs, options, arg</span> )</div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>store</span> : <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a><div class='sub-desc'>\n</div></li><li><span class='pre'>action</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>[Ext.data.Api.actions.create|update|destroy]</p>\n</div></li><li><span class='pre'>rs</span> : Record/Record[]<div class='sub-desc'><p>The Record(s) being written.</p>\n</div></li><li><span class='pre'>options</span> : Object<div class='sub-desc'><p>The loading options that were specified. Edit <code>options.params</code> to add Http parameters to the request.  (see <a href=\"#!/api/Ext.data.Store-method-save\" rel=\"Ext.data.Store-method-save\" class=\"docClass\">save</a> for details)</p>\n</div></li><li><span class='pre'>arg</span> : Object<div class='sub-desc'><p>The callback's arg object passed to the request function</p>\n</div></li></ul></div></div></div><div id='event-clear' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-event-clear' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-event-clear' class='name expandable'>clear</a>( <span class='pre'>this, records</span> )</div><div class='description'><div class='short'>Fires when the data cache has been cleared. ...</div><div class='long'><p>Fires when the data cache has been cleared.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : Store<div class='sub-desc'>\n</div></li><li><span class='pre'>records</span> : Record[]<div class='sub-desc'><p>The records that were cleared.</p>\n</div></li></ul></div></div></div><div id='event-datachanged' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-event-datachanged' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-event-datachanged' class='name expandable'>datachanged</a>( <span class='pre'>this</span> )</div><div class='description'><div class='short'>Fires when the data cache has changed in a bulk manner (e.g., it has been sorted, filtered, etc.) and a\nwidget that i...</div><div class='long'><p>Fires when the data cache has changed in a bulk manner (e.g., it has been sorted, filtered, etc.) and a\nwidget that is using this Store as a Record cache should refresh its view.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : Store<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='event-exception' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-event-exception' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-event-exception' class='name expandable'>exception</a>( <span class='pre'>misc</span> )</div><div class='description'><div class='short'>Fires if an exception occurs in the Proxy during a remote request. ...</div><div class='long'><p>Fires if an exception occurs in the Proxy during a remote request.\nThis event is relayed through the corresponding <a href=\"#!/api/Ext.data.DataProxy\" rel=\"Ext.data.DataProxy\" class=\"docClass\">Ext.data.DataProxy</a>.\nSee <a href=\"#!/api/Ext.data.DataProxy\" rel=\"Ext.data.DataProxy\" class=\"docClass\">Ext.data.DataProxy</a>.<a href=\"#!/api/Ext.data.DataProxy-event-exception\" rel=\"Ext.data.DataProxy-event-exception\" class=\"docClass\">exception</a>\nfor additional details.\n\n</p><h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>misc</span> : misc<div class='sub-desc'><p>See <a href=\"#!/api/Ext.data.DataProxy\" rel=\"Ext.data.DataProxy\" class=\"docClass\">Ext.data.DataProxy</a>.<a href=\"#!/api/Ext.data.DataProxy-event-exception\" rel=\"Ext.data.DataProxy-event-exception\" class=\"docClass\">exception</a>\nfor description.</p>\n</div></li></ul></div></div></div><div id='event-load' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-event-load' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-event-load' class='name expandable'>load</a>( <span class='pre'>this, records, options</span> )</div><div class='description'><div class='short'>Fires after a new set of Records has been loaded. ...</div><div class='long'><p>Fires after a new set of Records has been loaded.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : Store<div class='sub-desc'>\n</div></li><li><span class='pre'>records</span> : <a href=\"#!/api/Ext.data.Record\" rel=\"Ext.data.Record\" class=\"docClass\">Ext.data.Record</a>[]<div class='sub-desc'><p>The Records that were loaded</p>\n</div></li><li><span class='pre'>options</span> : Object<div class='sub-desc'><p>The loading options that were specified (see <a href=\"#!/api/Ext.data.Store-method-load\" rel=\"Ext.data.Store-method-load\" class=\"docClass\">load</a> for details)</p>\n</div></li></ul></div></div></div><div id='event-loadexception' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-event-loadexception' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-event-loadexception' class='name expandable'>loadexception</a>( <span class='pre'>misc</span> )</div><div class='description'><div class='short'>This event is deprecated in favor of the catch-all exception\nevent instead. ...</div><div class='long'><p>This event is <b>deprecated</b> in favor of the catch-all <b><code><a href=\"#!/api/Ext.data.Store-event-exception\" rel=\"Ext.data.Store-event-exception\" class=\"docClass\">exception</a></code></b>\nevent instead.</p>\n\n\n<p>This event is relayed through the corresponding <a href=\"#!/api/Ext.data.DataProxy\" rel=\"Ext.data.DataProxy\" class=\"docClass\">Ext.data.DataProxy</a>.\nSee <a href=\"#!/api/Ext.data.DataProxy\" rel=\"Ext.data.DataProxy\" class=\"docClass\">Ext.data.DataProxy</a>.<a href=\"#!/api/Ext.data.DataProxy-event-loadexception\" rel=\"Ext.data.DataProxy-event-loadexception\" class=\"docClass\">loadexception</a>\nfor additional details.\n\n</p><h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>misc</span> : misc<div class='sub-desc'><p>See <a href=\"#!/api/Ext.data.DataProxy\" rel=\"Ext.data.DataProxy\" class=\"docClass\">Ext.data.DataProxy</a>.<a href=\"#!/api/Ext.data.DataProxy-event-loadexception\" rel=\"Ext.data.DataProxy-event-loadexception\" class=\"docClass\">loadexception</a>\nfor description.</p>\n</div></li></ul></div></div></div><div id='event-metachange' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-event-metachange' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-event-metachange' class='name expandable'>metachange</a>( <span class='pre'>this, meta</span> )</div><div class='description'><div class='short'>Fires when this store's reader provides new metadata (fields). ...</div><div class='long'><p>Fires when this store's reader provides new metadata (fields). This is currently only supported for JsonReaders.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : Store<div class='sub-desc'>\n</div></li><li><span class='pre'>meta</span> : Object<div class='sub-desc'><p>The JSON metadata</p>\n</div></li></ul></div></div></div><div id='event-remove' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-event-remove' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-event-remove' class='name expandable'>remove</a>( <span class='pre'>this, record, index</span> )</div><div class='description'><div class='short'>Fires when a Record has been removed from the Store ...</div><div class='long'><p>Fires when a Record has been <a href=\"#!/api/Ext.data.Store-method-remove\" rel=\"Ext.data.Store-method-remove\" class=\"docClass\">remove</a>d from the Store</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : Store<div class='sub-desc'>\n</div></li><li><span class='pre'>record</span> : <a href=\"#!/api/Ext.data.Record\" rel=\"Ext.data.Record\" class=\"docClass\">Ext.data.Record</a><div class='sub-desc'><p>The Record that was removed</p>\n</div></li><li><span class='pre'>index</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The index at which the record was removed</p>\n</div></li></ul></div></div></div><div id='event-save' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-event-save' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-event-save' class='name expandable'>save</a>( <span class='pre'>store, batch, data</span> )</div><div class='description'><div class='short'>Fires after a save is completed. ...</div><div class='long'><p>Fires after a save is completed. A save encompasses destroying records, updating records and creating records.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>store</span> : <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a><div class='sub-desc'>\n</div></li><li><span class='pre'>batch</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The identifier for the batch that was saved.</p>\n</div></li><li><span class='pre'>data</span> : Object<div class='sub-desc'><p>An object containing the data that is to be saved. The object will contain a key for each appropriate action,\nwith an array of records for each action.</p>\n</div></li></ul></div></div></div><div id='event-update' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-event-update' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-event-update' class='name expandable'>update</a>( <span class='pre'>this, record, operation</span> )</div><div class='description'><div class='short'>Fires when a Record has been updated ...</div><div class='long'><p>Fires when a Record has been updated</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : Store<div class='sub-desc'>\n</div></li><li><span class='pre'>record</span> : <a href=\"#!/api/Ext.data.Record\" rel=\"Ext.data.Record\" class=\"docClass\">Ext.data.Record</a><div class='sub-desc'><p>The Record that was updated</p>\n</div></li><li><span class='pre'>operation</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The update operation being performed.  Value may be one of:</p>\n\n<pre><code>     Ext.data.Record.EDIT\n     Ext.data.Record.REJECT\n     Ext.data.Record.COMMIT\n</code></pre>\n\n</div></li></ul></div></div></div><div id='event-write' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Store' rel='Ext.data.Store' class='defined-in docClass'>Ext.data.Store</a><br/><a href='source/Store.html#Ext-data-Store-event-write' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Store-event-write' class='name expandable'>write</a>( <span class='pre'>store, action, result, res, rs</span> )</div><div class='description'><div class='short'>Fires if the server returns 200 after an Ext.data.Api.actions CRUD action. ...</div><div class='long'><p>Fires if the server returns 200 after an <a href=\"#!/api/Ext.data.Api-property-actions\" rel=\"Ext.data.Api-property-actions\" class=\"docClass\">Ext.data.Api.actions</a> CRUD action.\nSuccess of the action is determined in the <code>result['successProperty']</code>property (<b>NOTE</b> for RESTful stores,\na simple 20x response is sufficient for the actions \"destroy\" and \"update\".  The \"create\" action should should return 200 along with a database pk).</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>store</span> : <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a><div class='sub-desc'>\n</div></li><li><span class='pre'>action</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>[Ext.data.Api.actions.create|update|destroy]</p>\n</div></li><li><span class='pre'>result</span> : Object<div class='sub-desc'><p>The 'data' picked-out out of the response for convenience.</p>\n</div></li><li><span class='pre'>res</span> : <a href=\"#!/api/Ext.Direct.Transaction\" rel=\"Ext.Direct.Transaction\" class=\"docClass\">Ext.Direct.Transaction</a><div class='sub-desc'>\n</div></li><li><span class='pre'>rs</span> : Record/Record[]<div class='sub-desc'><p>Store's records, the subject(s) of the write-action</p>\n</div></li></ul></div></div></div></div></div></div></div>","superclasses":["Ext.util.Observable","Ext.data.Store"],"meta":{},"requires":[],"html_meta":{},"statics":{"property":[],"cfg":[],"css_var":[],"method":[],"event":[],"css_mixin":[]},"files":[{"href":"DirectStore.html#Ext-data-DirectStore","filename":"DirectStore.js"}],"linenr":1,"members":{"property":[{"tagname":"property","owner":"Ext.data.Store","meta":{},"name":"baseParams","id":"property-baseParams"},{"tagname":"property","owner":"Ext.data.Store","meta":{"private":true},"name":"batchKey","id":"property-batchKey"},{"tagname":"property","owner":"Ext.data.Store","meta":{},"name":"fields","id":"property-fields"},{"tagname":"property","owner":"Ext.data.Store","meta":{},"name":"hasMultiSort","id":"property-hasMultiSort"},{"tagname":"property","owner":"Ext.data.Store","meta":{},"name":"isDestroyed","id":"property-isDestroyed"},{"tagname":"property","owner":"Ext.data.Store","meta":{},"name":"lastOptions","id":"property-lastOptions"},{"tagname":"property","owner":"Ext.data.Store","meta":{},"name":"multiSortInfo","id":"property-multiSortInfo"},{"tagname":"property","owner":"Ext.data.Store","meta":{},"name":"recordType","id":"property-recordType"}],"cfg":[{"tagname":"cfg","owner":"Ext.data.Store","meta":{},"name":"autoDestroy","id":"cfg-autoDestroy"},{"tagname":"cfg","owner":"Ext.data.Store","meta":{},"name":"autoLoad","id":"cfg-autoLoad"},{"tagname":"cfg","owner":"Ext.data.Store","meta":{},"name":"autoSave","id":"cfg-autoSave"},{"tagname":"cfg","owner":"Ext.data.Store","meta":{},"name":"baseParams","id":"cfg-baseParams"},{"tagname":"cfg","owner":"Ext.data.Store","meta":{},"name":"batch","id":"cfg-batch"},{"tagname":"cfg","owner":"Ext.data.Store","meta":{},"name":"data","id":"cfg-data"},{"tagname":"cfg","owner":"Ext.data.Store","meta":{},"name":"defaultParamNames","id":"cfg-defaultParamNames"},{"tagname":"cfg","owner":"Ext.util.Observable","meta":{},"name":"listeners","id":"cfg-listeners"},{"tagname":"cfg","owner":"Ext.data.Store","meta":{},"name":"paramNames","id":"cfg-paramNames"},{"tagname":"cfg","owner":"Ext.data.Store","meta":{},"name":"proxy","id":"cfg-proxy"},{"tagname":"cfg","owner":"Ext.data.Store","meta":{},"name":"pruneModifiedRecords","id":"cfg-pruneModifiedRecords"},{"tagname":"cfg","owner":"Ext.data.Store","meta":{},"name":"reader","id":"cfg-reader"},{"tagname":"cfg","owner":"Ext.data.Store","meta":{},"name":"remoteSort","id":"cfg-remoteSort"},{"tagname":"cfg","owner":"Ext.data.Store","meta":{},"name":"restful","id":"cfg-restful"},{"tagname":"cfg","owner":"Ext.data.Store","meta":{},"name":"sortInfo","id":"cfg-sortInfo"},{"tagname":"cfg","owner":"Ext.data.Store","meta":{},"name":"storeId","id":"cfg-storeId"},{"tagname":"cfg","owner":"Ext.data.Store","meta":{},"name":"url","id":"cfg-url"},{"tagname":"cfg","owner":"Ext.data.Store","meta":{},"name":"writer","id":"cfg-writer"}],"css_var":[],"method":[{"tagname":"method","owner":"Ext.data.DirectStore","meta":{},"name":"constructor","id":"method-constructor"},{"tagname":"method","owner":"Ext.data.Store","meta":{},"name":"add","id":"method-add"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"addEvents","id":"method-addEvents"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"addListener","id":"method-addListener"},{"tagname":"method","owner":"Ext.data.Store","meta":{},"name":"addSorted","id":"method-addSorted"},{"tagname":"method","owner":"Ext.data.Store","meta":{"private":true},"name":"addToBatch","id":"method-addToBatch"},{"tagname":"method","owner":"Ext.data.Store","meta":{"private":true},"name":"afterCommit","id":"method-afterCommit"},{"tagname":"method","owner":"Ext.data.Store","meta":{"private":true},"name":"afterEdit","id":"method-afterEdit"},{"tagname":"method","owner":"Ext.data.Store","meta":{"private":true},"name":"afterReject","id":"method-afterReject"},{"tagname":"method","owner":"Ext.data.Store","meta":{"private":true},"name":"applySort","id":"method-applySort"},{"tagname":"method","owner":"Ext.data.Store","meta":{"private":true},"name":"buildWriter","id":"method-buildWriter"},{"tagname":"method","owner":"Ext.data.Store","meta":{"private":true},"name":"clearData","id":"method-clearData"},{"tagname":"method","owner":"Ext.data.Store","meta":{},"name":"clearFilter","id":"method-clearFilter"},{"tagname":"method","owner":"Ext.data.Store","meta":{"private":true},"name":"clearModified","id":"method-clearModified"},{"tagname":"method","owner":"Ext.data.Store","meta":{},"name":"collect","id":"method-collect"},{"tagname":"method","owner":"Ext.data.Store","meta":{},"name":"commitChanges","id":"method-commitChanges"},{"tagname":"method","owner":"Ext.data.Store","meta":{"private":true},"name":"createCallback","id":"method-createCallback"},{"tagname":"method","owner":"Ext.data.Store","meta":{"private":true},"name":"createFilterFn","id":"method-createFilterFn"},{"tagname":"method","owner":"Ext.data.Store","meta":{"private":true},"name":"createMultipleFilterFn","id":"method-createMultipleFilterFn"},{"tagname":"method","owner":"Ext.data.Store","meta":{"private":true},"name":"createRecords","id":"method-createRecords"},{"tagname":"method","owner":"Ext.data.Store","meta":{"private":true},"name":"createSortFunction","id":"method-createSortFunction"},{"tagname":"method","owner":"Ext.data.Store","meta":{},"name":"destroy","id":"method-destroy"},{"tagname":"method","owner":"Ext.data.Store","meta":{"private":true},"name":"destroyRecord","id":"method-destroyRecord"},{"tagname":"method","owner":"Ext.data.Store","meta":{"private":true},"name":"doTransaction","id":"method-doTransaction"},{"tagname":"method","owner":"Ext.data.Store","meta":{"private":true},"name":"doUpdate","id":"method-doUpdate"},{"tagname":"method","owner":"Ext.data.Store","meta":{},"name":"each","id":"method-each"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"enableBubble","id":"method-enableBubble"},{"tagname":"method","owner":"Ext.data.Store","meta":{"private":true},"name":"execute","id":"method-execute"},{"tagname":"method","owner":"Ext.data.Store","meta":{},"name":"filter","id":"method-filter"},{"tagname":"method","owner":"Ext.data.Store","meta":{},"name":"filterBy","id":"method-filterBy"},{"tagname":"method","owner":"Ext.data.Store","meta":{},"name":"find","id":"method-find"},{"tagname":"method","owner":"Ext.data.Store","meta":{},"name":"findBy","id":"method-findBy"},{"tagname":"method","owner":"Ext.data.Store","meta":{},"name":"findExact","id":"method-findExact"},{"tagname":"method","owner":"Ext.data.Store","meta":{"private":true},"name":"findInsertIndex","id":"method-findInsertIndex"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"fireEvent","id":"method-fireEvent"},{"tagname":"method","owner":"Ext.data.Store","meta":{},"name":"getAt","id":"method-getAt"},{"tagname":"method","owner":"Ext.data.Store","meta":{},"name":"getById","id":"method-getById"},{"tagname":"method","owner":"Ext.data.Store","meta":{},"name":"getCount","id":"method-getCount"},{"tagname":"method","owner":"Ext.data.Store","meta":{},"name":"getModifiedRecords","id":"method-getModifiedRecords"},{"tagname":"method","owner":"Ext.data.Store","meta":{},"name":"getRange","id":"method-getRange"},{"tagname":"method","owner":"Ext.data.Store","meta":{},"name":"getSortState","id":"method-getSortState"},{"tagname":"method","owner":"Ext.data.Store","meta":{},"name":"getTotalCount","id":"method-getTotalCount"},{"tagname":"method","owner":"Ext.data.Store","meta":{"private":true},"name":"handleException","id":"method-handleException"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"hasListener","id":"method-hasListener"},{"tagname":"method","owner":"Ext.data.Store","meta":{},"name":"indexOf","id":"method-indexOf"},{"tagname":"method","owner":"Ext.data.Store","meta":{},"name":"indexOfId","id":"method-indexOfId"},{"tagname":"method","owner":"Ext.data.Store","meta":{},"name":"insert","id":"method-insert"},{"tagname":"method","owner":"Ext.data.Store","meta":{},"name":"isFiltered","id":"method-isFiltered"},{"tagname":"method","owner":"Ext.data.Store","meta":{},"name":"load","id":"method-load"},{"tagname":"method","owner":"Ext.data.Store","meta":{},"name":"loadData","id":"method-loadData"},{"tagname":"method","owner":"Ext.data.Store","meta":{"private":true},"name":"loadRecords","id":"method-loadRecords"},{"tagname":"method","owner":"Ext.data.Store","meta":{},"name":"multiSort","id":"method-multiSort"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"on","id":"method-on"},{"tagname":"method","owner":"Ext.data.Store","meta":{"private":true},"name":"onClear","id":"method-onClear"},{"tagname":"method","owner":"Ext.data.Store","meta":{"protected":true,"private":true},"name":"onCreateRecords","id":"method-onCreateRecords"},{"tagname":"method","owner":"Ext.data.Store","meta":{"protected":true,"private":true},"name":"onDestroyRecords","id":"method-onDestroyRecords"},{"tagname":"method","owner":"Ext.data.Store","meta":{"private":true},"name":"onMetaChange","id":"method-onMetaChange"},{"tagname":"method","owner":"Ext.data.Store","meta":{"protected":true,"private":true},"name":"onUpdateRecords","id":"method-onUpdateRecords"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"purgeListeners","id":"method-purgeListeners"},{"tagname":"method","owner":"Ext.data.Store","meta":{},"name":"query","id":"method-query"},{"tagname":"method","owner":"Ext.data.Store","meta":{},"name":"queryBy","id":"method-queryBy"},{"tagname":"method","owner":"Ext.data.Store","meta":{"private":true},"name":"reMap","id":"method-reMap"},{"tagname":"method","owner":"Ext.data.Store","meta":{},"name":"rejectChanges","id":"method-rejectChanges"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"relayEvents","id":"method-relayEvents"},{"tagname":"method","owner":"Ext.data.Store","meta":{},"name":"reload","id":"method-reload"},{"tagname":"method","owner":"Ext.data.Store","meta":{},"name":"remove","id":"method-remove"},{"tagname":"method","owner":"Ext.data.Store","meta":{},"name":"removeAll","id":"method-removeAll"},{"tagname":"method","owner":"Ext.data.Store","meta":{},"name":"removeAt","id":"method-removeAt"},{"tagname":"method","owner":"Ext.data.Store","meta":{"private":true},"name":"removeFromBatch","id":"method-removeFromBatch"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"removeListener","id":"method-removeListener"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"resumeEvents","id":"method-resumeEvents"},{"tagname":"method","owner":"Ext.data.Store","meta":{},"name":"save","id":"method-save"},{"tagname":"method","owner":"Ext.data.Store","meta":{},"name":"setBaseParam","id":"method-setBaseParam"},{"tagname":"method","owner":"Ext.data.Store","meta":{},"name":"setDefaultSort","id":"method-setDefaultSort"},{"tagname":"method","owner":"Ext.data.Store","meta":{},"name":"singleSort","id":"method-singleSort"},{"tagname":"method","owner":"Ext.data.Store","meta":{},"name":"sort","id":"method-sort"},{"tagname":"method","owner":"Ext.data.Store","meta":{"private":true},"name":"sortData","id":"method-sortData"},{"tagname":"method","owner":"Ext.data.Store","meta":{"private":true},"name":"storeOptions","id":"method-storeOptions"},{"tagname":"method","owner":"Ext.data.Store","meta":{},"name":"sum","id":"method-sum"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"suspendEvents","id":"method-suspendEvents"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"un","id":"method-un"},{"tagname":"method","owner":"Ext.data.Store","meta":{"private":true},"name":"updateRecord","id":"method-updateRecord"}],"event":[{"tagname":"event","owner":"Ext.data.Store","meta":{},"name":"add","id":"event-add"},{"tagname":"event","owner":"Ext.data.Store","meta":{},"name":"beforeload","id":"event-beforeload"},{"tagname":"event","owner":"Ext.data.Store","meta":{},"name":"beforesave","id":"event-beforesave"},{"tagname":"event","owner":"Ext.data.Store","meta":{},"name":"beforewrite","id":"event-beforewrite"},{"tagname":"event","owner":"Ext.data.Store","meta":{},"name":"clear","id":"event-clear"},{"tagname":"event","owner":"Ext.data.Store","meta":{},"name":"datachanged","id":"event-datachanged"},{"tagname":"event","owner":"Ext.data.Store","meta":{},"name":"exception","id":"event-exception"},{"tagname":"event","owner":"Ext.data.Store","meta":{},"name":"load","id":"event-load"},{"tagname":"event","owner":"Ext.data.Store","meta":{},"name":"loadexception","id":"event-loadexception"},{"tagname":"event","owner":"Ext.data.Store","meta":{},"name":"metachange","id":"event-metachange"},{"tagname":"event","owner":"Ext.data.Store","meta":{},"name":"remove","id":"event-remove"},{"tagname":"event","owner":"Ext.data.Store","meta":{},"name":"save","id":"event-save"},{"tagname":"event","owner":"Ext.data.Store","meta":{},"name":"update","id":"event-update"},{"tagname":"event","owner":"Ext.data.Store","meta":{},"name":"write","id":"event-write"}],"css_mixin":[]},"inheritable":null,"private":null,"component":false,"name":"Ext.data.DirectStore","singleton":false,"override":null,"inheritdoc":null,"id":"class-Ext.data.DirectStore","mixins":[],"mixedInto":[]});