package DBIx::QuickORM::Builder::Variable;
use strict;
use warnings;

use Carp qw/croak/;

use parent 'DBIx::QuickORM::Builder::Base';
use DBIx::QuickORM::Util::HashBase qw{
    <variants
};

sub init {
    my $self = shift;

    $self->SUPER::init();

    $self->{+VARIANTS} //= {};
}

sub set_variant { $_[0]->{+VARIANTS}->{$_[1]} = $_[2] }
sub def_variant { $_[0]->{+VARIANTS}->{$_[1]} //= $_[2] }
sub get_variant { $_[0]->{+VARIANTS}->{$_[1]} }
sub has_variant { defined $_[0]->{+VARIANTS}->{$_[1]} }
sub del_variant { delete $_[0]->{+VARIANTS}->{$_[1]} }

sub build {
    my $self = shift;
    my %params = @_;

    my $variants = $params{variants} or croak "'variants' key must be present in build arguments";

    my %attrs = %{$self->{+ATTRIBUTES}};

    %attrs = (%attrs, %{$self->{+VARIANTS}->{$_} // {}}) for @$variants;

    $self->build_class->new(%attrs);
}

1;
