<?php
/**
 * 
 * @license    GPL 2 (http://www.gnu.org/licenses/gpl.html)
 * @author     Myron Turner <turnermm02@shaw.ca>
 */

// Syntax: <color somecolour/somebackgroundcolour>
 
// must be run within Dokuwiki
if(!defined('DOKU_INC')) die();
 
if(!defined('DOKU_PLUGIN')) define('DOKU_PLUGIN',DOKU_INC.'lib/plugins/');
require_once(DOKU_PLUGIN.'syntax.php');
 
/**
 * All DokuWiki plugins to extend the parser/rendering mechanism
 * need to inherit from this class
 */
class syntax_plugin_fckg_code extends DokuWiki_Syntax_Plugin {
 
    /**
     * return some info
     */
    function getInfo(){
        return array(
            'author' => 'Myron Turner',
            'email'  => '',
            'date'   => '2009-08-15',
            'name'   => 'code Plugin',
            'desc'   => '',
            'url'    => '',
        );
    }
 
    function getType(){ return 'formatting'; }
    function getAllowedTypes() { return array('formatting', 'substition', 'disabled'); }   
    function getSort(){
       global $Using_FCKG_EDITOR;
       if(!$Using_FCKG_EDITOR) return;
       return 158; 
     }
    function connectTo($mode) {
      global $Using_FCKG_EDITOR;

      if(!$Using_FCKG_EDITOR) return;      
      $this->Lexer->addEntryPattern('<code.*?>(?=.*?</code>)',$mode,'plugin_fckg_code'); 
     }

    function postConnect() {
       global $Using_FCKG_EDITOR;

       if(!$Using_FCKG_EDITOR) return;     
       $this->Lexer->addExitPattern('</code>','plugin_fckg_code');
      }
 
 
    /**
     * Handle the match
     */
    function handle($match, $state, $pos, &$handler){

    global $Using_FCKG_EDITOR;
    if(!$Using_FCKG_EDITOR) {  // if file is not an FCKG file and we are not in FCKG editor
         return;         
    }

        //$this->write_debug($match);
        switch ($state) {
          case DOKU_LEXER_ENTER :
 
                return array($state, $match);
 
          case DOKU_LEXER_UNMATCHED : 
                               // fckgCodeBLOCK identifies this as fckg file 
                               // for Using_FCKG_EDITOR where nothing else but block is on page
                               // hence no align tags since FCKEditor doesn't put pre in p
         $match = str_replace('fckgCodeBLOCK', '', $match);        
         $match = str_replace('fckgOpenPAREN', '<', $match);        
         $match = str_replace('fckgOpen_C_COMMENT', '/*', $match); 
         $match = str_replace('fckgClosed_C_COMMENT', '*/', $match);  
        
                     return array($state, $match);

          case DOKU_LEXER_EXIT : 
   
                     return array($state, $match);
        }
        return array();
    }
 
    /**
     * Create output
     */
    function render($mode, &$renderer, $data) {
        if($mode == 'xhtml'){
            list($state, $match) = $data;

            switch ($state) {
              case DOKU_LEXER_ENTER :      
             
                $renderer->doc .= '<pre class="code">'; 
                break;
                
              case DOKU_LEXER_UNMATCHED : 
                 // $this->write_debug("Unmatched Rendered: " . $renderer->_xmlEntities($match));  
                  $renderer->doc .=  $renderer->_xmlEntities($match);
                  break;
                 
              case DOKU_LEXER_EXIT :                   
                       $renderer->doc .= '</pre>';
                       break;  
            }
            return true;
        }
        return false;
    }
 
      
function write_debug($data) {
return;
  if (!$handle = fopen('data_check_ent.txt', 'a')) {
    return;
    }

    // Write $somecontent to our opened file.
    fwrite($handle, "$data\n");
    fclose($handle);
    
}

}
?>
