use v6.c;
use Test;
use Range::SetOps;

plan 79;

my @unions = [
    [ (1..3), (5..6), Set($(1..3), $(5..6)) ],
    [ (1..4), (3..6), Set([$(1..6)]) ],
    [ (1..10), (5..6), Set( [$(1..10)] ) ],
    [ (5..6), (1..10), Set( [$(1..10)] ) ],
    [ (1..10), (1..10), Set( [$(1..10)] ) ],
    [ (1..3), Set( $(2..7), $(8..11) ), Set( $(1..7), $(8..11) ) ],
    [ (5..8), Set( $(2..7), $(9..11) ), Set( $(2..8), $(9..11) ) ],
    [ (9..13), Set( $(2..7), $(8..11) ), Set( $(2..7), $(8..13) ) ],
    [ (6..10), Set( $(2..7), $(8..11) ), Set( [$(2..11)] ) ],
    [ (14..17), Set( $(2..7), $(8..11) ), Set( $(2..7), $(8..11), $(14..17) ) ],
    [ Set( $(2..7), $(8..11) ), (1..3), Set( $(1..7), $(8..11) ) ],
    [ Set( $(2..7), $(9..11) ), (5..8), Set( $(2..8), $(9..11) ) ],
    [ Set( $(2..7), $(8..11) ), (9..13), Set( $(2..7), $(8..13) ) ],
    [ Set( $(2..7), $(8..11) ), (6..10), Set( [$(2..11)] ) ],
    [ Set( $(2..7), $(8..11) ), (14..17), Set( $(2..7), $(8..11), $(14..17) ) ],
    [ Set( $(1..4), $(6..10) ), Set( $(3..7), $(12..15) ), Set( $(1..10), $(12..15) ) ],

    [ ("a".."d"),("f".."z"), Set( $("a".."d"), $("f".."z") ) ],
    [ ("a".."f"),("b".."z"), Set([$("a".."z")]) ],
    [ ("a".."z"),("d".."n"), Set([$("a".."z")]) ],
    [ ("d".."n"),("a".."z"), Set([$("a".."z")]) ],
    
    [ (1.1..3), (5.1..6), Set($(1.1..3), $(5.1..6)) ],
    [ (1.1..4), (3.1..6), Set([$(1.1..6)]) ],
    [ (1.1..10), (5.1..6), Set( [$(1.1..10)] ) ],
    [ (5.1..6), (1.1..10), Set( [$(1.1..10)] ) ],

    [ (1..3.2), (5..6.2), Set($(1..3.2), $(5..6.2)) ],
    [ (1..4.2), (3..6.2), Set([$(1..6.2)]) ],
    [ (1..10.2), (5..6.2), Set( [$(1..10.2)] ) ],
    [ (5..6.2), (1..10.2), Set( [$(1..10.2)] ) ],
    
    [ (1.1..3.2), (5.1..6.2), Set($(1.1..3.2), $(5.1..6.2)) ],
    [ (1.1..4.2), (3.1..6.2), Set([$(1.1..6.2)]) ],
    [ (1.1..10.2), (5.1..6.2), Set( [$(1.1..10.2)] ) ],
    [ (5.1..6.2), (1.1..10.2), Set( [$(1.1..10.2)] ) ],

    [ (Date.new("2018-01-01")..Date.new("2018-03-01")),(Date.new("2018-04-01")..Date.new("2018-12-31")), Set( $(Date.new("2018-01-01")..Date.new("2018-03-01")),
                                                                                                              $(Date.new("2018-04-01")..Date.new("2018-12-31")) ) ],
    [ (Date.new("2018-01-01")..Date.new("2018-03-01")),(Date.new("2018-02-01")..Date.new("2018-12-31")), Set( [$(Date.new("2018-01-01")..Date.new("2018-12-31"))] ) ],
    [ (Date.new("2018-01-01")..Date.new("2018-03-01")),(Date.new("2018-01-01")..Date.new("2018-12-31")), Set( [$(Date.new("2018-01-01")..Date.new("2018-12-31"))] ) ],
    [ (Date.new("2018-01-01")..Date.new("2018-12-31")),(Date.new("2018-01-01")..Date.new("2018-03-01")), Set( [$(Date.new("2018-01-01")..Date.new("2018-12-31"))] ) ],
    
];

for @unions -> [ $a, $b, $expected ] {
    my $got = $a (|) $b;    
    is-deeply $got,  $expected, "{$a.perl} (|) {$b.perl} => {$expected.perl} but got {$got.perl}";
    $got = $a ∪ $b;
    is-deeply $got, $expected, "{$a.perl} ∪ {$b.perl} => {$expected.perl} but got {$got.perl}";
}

is-deeply ((2..7) (|) (8..11) (|) (9..13)), Set( $(2..7), $(8..13) ), "Chained (|) Union";
is-deeply ([(|)] (2..7), (8..11), (9..13)), Set( $(2..7), $(8..13) ), "Meta Op (|) Union";

is-deeply ((2..7)  (|) (9..13) (|) (8..11)), Set( $(2..7), $(8..13) ), "Chained (|) Union not ordered";
is-deeply ([(|)] (2..7), (9..13), (8..11)), Set( $(2..7), $(8..13) ), "Meta Op (|) Union not ordered";

is-deeply ((2..7) ∪ (8..11) ∪ (9..13)), Set( $(2..7), $(8..13) ), "Chained ∪ Union";
is-deeply ([∪] (2..7), (8..11), (9..13)), Set( $(2..7), $(8..13) ), "Meta Op ∪ Union";

is-deeply ([(|)] $(6..10),$(3..7),$(12..15),$(1..4) ), Set( $(1..10), $(12..15) ), "Longer Chain";
