#define TEST_NAME "aead_aegis256"
#include "cmptest.h"

static struct {
    const char *key_hex;
    const char *nonce_hex;
    const char *message_hex;
    const char *ad_hex;
    const char *ciphertext_hex;
    const char *mac_hex;
} tests[] = {
    { "7083505997f52fdf86548d86ee87c1429ed91f108cd56384dc840269ef7fdd73",
      "18cd778e6f5b1d35d4ca975fd719a17aaf22c3eba01928b6a78bac5810c92c75",
      "5d6691271eb1b2261d1b34fa7560e274b83373343c2e49b2b6a82bc0f20cee85cd608d195c1a16679d720441c95f"
      "ae86631f3f2cd27f38f71cedc79aaca7fdddbd4da4eeb97632366db65ca21acd85b41fd1a9de688bddff433a4757"
      "eb084e6816dbc8ff93f5995804",
      "af5b16a480e6a1400be15c8e6b194c2aca175e3b5c3f3fbbeca865f9390a",
      "0943a3e659b86e267ffea969ddd6d6d63aa35d1a1f31fb6f47205104b132da65799cc64cc9f66ffa5ec479550c2c"
      "5dfa006f827ef02e3ab4dae3446bf93ccb5c17e1ec0393f161fca94f2944d041f162e9c964558b6b57d3bb393b97"
      "43b1f8338ff878a154800fd16c",
      "480091eb823480e8b29c7aa96ffd55a026ac3d7fa16787c36c25865131a639a4" },
    { "c88bb05b2aec1218e1a5026511e6d44de7bd502588e9e2a01591b39c5ead76ff",
      "4a485f226a73f0c4e16242e8234841cdf6af1771eb278e7f35428d03eb5b4cf0",
      "2a4c06941ec356390542d7d7833fd68fc85a00c0452281f87dee6f10180d02182791232c7007fde35dfd5a901afa"
      "896296f9f344db717994d078fbd3a4cec8d782d2bdc205f3709827b776fd5c863a952fea97a14a6c2ee3f20432b8"
      "baa084470179078bd6a83597478b2fd9ae00ecb424822cb0d61e9a55a4",
      "38a9809dbdd2579010d38bf5314f255b",
      "b8565db06c2fa493e09b6764f4d09296422095eb6e9890f606654713bfee6f362a123688b61f254f315f18b20bcc"
      "5ed8b0b4f2224de9f498e3ef03532a8bcddb361f5ace8ff491bab8b3d06550496501264f9f48ebad277e74921467"
      "89d0fc1a3b1e3e81598370a4183683d1fee25a9a1fe359c836932746b9",
      "5d5d35e0299dea47956a2e2143cdace4de8d228784d6717ae5a6bf5ea6b3ed04" },
    { "77b473865175ebd5ddf9c382bac227029c25bdb836e683a138e4618cc964488b",
      "f183d8de1e6dd4ccefa79fe22fabfda58e68dd29116d13408042f0713a4ee5f8",
      "9888b8ee03c3217a777b7558a31e331909570ea196f02c8cffad2c8dc6499b8125363c06a71c057842666bfb5c6a"
      "cc937d2eecd960330c2361abdd88a4b191557ddf5102de75ddc7e09aee9862f32e24f1db3847a5f5b379fb32e2ef"
      "7ffb0d3a60",
      "0679fd74a846965e33e558676115d843e440fa37092fbd5c57c82fd914210fcf948f911b04632d66be46248d772b"
      "3eb9f55b537e54b1ec751b63f035c8",
      "3464d835302583ade6ed99e23333e865d3308f31a6cb65bcefdc9a1b9b4d0e0f75513188480dac4a64922af44413"
      "24ce7de74eb9f7f4e414f6177a4814edc96313694b99ff8dd36b2f7f79c7ecd70ec475abe1c1909238767f172fd6"
      "b95e92c025",
      "33527e829a3db1929cd643d5251ee19482aab7f2d74635cbf8370f1e1621ecdf" },
    { "b8c6e8cea59ca9fd2922530ee61911c1ed1c5af98be8fb03cbb449adcea0ed83",
      "af5bc1abe7bafadee790390277874cdfcc1ac1955f249d1131555d345832f555",
      "b6c15f560be043d06aa27e15d8c901af6b19db7a15e1",
      "d899366a0b4e4d86cce5ba61aca2a84349c8de5757e008e94e7d7a3703",
      "4c8496dfa6c419ef3c4867769a9014bd17118c22eef5",
      "f81ceacaaae6263c33f836fa26d92b0f08eb0796135c7fe312c93add6a208e8a" },
    { "d4ed0fe94cda2be7e50d57833158c84180b4cb7dec95d5ba774b6b5e1b0597bd",
      "cae41ba20bfd124270b76c13d61c1dffd7a42017731546d41aa071c22b9967cc",
      "1cd4b85fa6c14d5adea84ed3167479c1cd18e77792cca73a540aa16a00e50ba62ddd12a62911b21d3ee108651693"
      "7f33ed7756c7ec93b3",
      "35564745c05bc961994ea03764eb02044f9e7b2f6130d6d1f041580d6b3ea7ade2b6e231dacc5e97db01",
      "a1f64f45985a89303d1fdacf6f31ad745a8015350f1afe63d6ecc26677f661addd3c229ed76f4c627b1e902f8ce8"
      "c42fd08baef481e86e",
      "c706b2f13d4e76b4e024a2d72540637a8d9ff5e626d6bffeb7801c58ccab0c2e" },
    { "d755d9d980e8cb221955b63c19f3989eecce945f61307a0593bd7cbea6577e1d",
      "9f83666d787e5ceb0e17fc1b084b3734dc3ea88dda73b1b7ed53be7491f4637f",
      "d1093941fdb3d9710cfcbe504be2434c17296d0b7e0f4e4058e79062f2b2cf3cbe2007ae2e5d391ebf3fc1e07e4e"
      "e7d1705044c9bc2bf08e97a4d8",
      "f2a1432fba86dc01b3bfbf3206943bfa3dc66e9f54b576c57f61ad515555b0c371dcfcec45eaa58ca06654b6cd47"
      "6aaaaf1b2602c03f9e41a2cefc265d10f19d42bda0b07aac8e86",
      "58e044943cf3b73e48ce75c048464fedb0445b02bffc00c1998b212f48f48c93e89dbfbf36cfade1112629e8deb2"
      "67c55118c10ab67b7ef2740fc2",
      "0179f0edd217214881e90c1be3b513170d1292603c484a55499e1bc70970d5ed" },
    { "152f15933e4ae26192bd3aaecea29daf77e9b2bcd97e7eae7637025de8a3d3ac",
      "e177be02348efb533fc2e9d5a259cef80aabeec97da50c937e8d5f7c6eeb32ce",
      "ef86da6d5b0dab27a444a95ef5c237baa5819b863dcf0232d0162dceda8f180e1b9c6b9d94ccc0692eb52923783e"
      "f9de17497f1da62d6524bbf432aa6c3bbc1e851310218a03ef97ac6676eb6ec30ba6ab131802b992a11417cd00e6"
      "270ac73dec8dad88ecc3cba25734ef7de3b8e3cceb5d19778d6808",
      "221b1875425844e48c2111fa59b6df729a924a43b3869ab64f8291dca8f12be34d62d11ac94f9f308e0744d5d5f4"
      "564fe9fc1e014cefee3cf7706ace4643871d41f1ad5c616adbcc1e9701a3b4",
      "dc48260eb047397f41c4d0a0ffe394557aaff8b149cf4b16e7c22754095f51b626ded66e3db9d4cbd98421ee9d8e"
      "7c6eb72b607cd462f1fb3ab0c41b2cc84ad320c781ccda9aefa1a68ff5d280500a17c7959e869f45f97bf09cd0bf"
      "2c4c068d2b9603710ca8f71f82acd47faefdebdd0abc9b45c83388",
      "97191234839a54c00143463e8e8c863f5710e520ee9d9b9ce051076696bc8b52" },
    { "873edbe818233d0f51bcfc1d5340cc4712c909de36f963e6157f128b8a71e3a8",
      "16e7637700a6fc10539c056663d12ec85bd529f1e6adb131a3853578f5d27c12",
      "db38cdcecbd99003978832d29cf6a34acb4d0e6293e37d2795fcded538ba37d6a11ed41430dc9f4c0cfd27587d60"
      "7846f42aa30682bcc295097053821b80b5869b4a0b852ba7ac1d7b784ea0e76b2d033678011889a5adbf7e091cdb"
      "b9754f828b7519f1179e2426ca6bf80a509e34729c854a5052e61adf8d",
      "0b0bd264fb5030f84da620f07099f42dfbad57c314102a1f7fc0b452ebb7966ad4b88ea773aa07",
      "de67a4eb8821625d4451734993d93e0fafd2c55c761afb097bfccba898e6d634be975d5f2ce8d456785a089c9b40"
      "724d8ea41095c1cc80f070c3ababc9258e5eea504831b034baccff61d8f73c220d5bdb1244c8a675f2d6081abea8"
      "f59088b99583cae22f8bd37fa030f94d5bfe1c9e799aa71bb41874b17f",
      "8665ecac1758be7eea0b5f482ce8024ce3c78b3f51af3ee4e0b440f24db2f451" },
    { "b04b735c74d2286302e5994e126a8a8f52af38d6cb094279ac883b560a52a6a6",
      "6af57ad705792ac2f71a61bcea9ab38a9a5acc510de7995b66f3ae4cd2079aa4",
      "1c052ab52a21894287fa7f763b12f49b2edd6a0cd266e93207573d08d75ec31b294d171f0098f804020cc12056c6"
      "0f8d396ec94d97eae1c07a874849e39a3302e8c3b538de6c9e268fb922f6875ee5bbc264137035a76d9ceb269dc0"
      "988517a302c2bace2fb6efc4ffaa2c1455a16b6cd0",
      "52618046f112a5a35780e370c713987e24609c38157e5fd5d51ed36324359b0615af70f801b05a98ceb1",
      "7183180c37ab14f38ed084bdd2aaa4e8d8e8442b526214f594054e0379a2aba6992804afa8c63bb1e580d7d905d0"
      "c46536970e98bf7cb921e95db8faf388e7c98cc08496a7036b90a2e4efdfbcf79610edbc9f905067358b13934825"
      "c0ed2e3c3d1f03f7ceb812945f77fcb7731f805b1c",
      "483a6b3a7d5de797f0911d2a514350d5ae5af89aefe1245cb08cf8c7487eb99a" },
    { "5bd7cbff6b469c03643cabb99dc50f905091fc9cfcd6d8f28e74ac1a33fd0198",
      "3b458a51fdb6b9d5a7071a22825a79f2844c5ac7ae91014ed7862499dcf10461",
      "4eda7997fa3b9e12e39eb00b209b43af9949c017660e523e78d0e483f23e9113b662f42a164db3511d",
      "808d8a8523a983a2afb2f9daed913efdc19a3c1ca3315382ffe757426e7ef65bc1d83d8e6af95191f3c30de29806"
      "5be1e5d14d0dba8f82281aa2fde67684cf7eb6f32ca4de7a116caa796f2b27222f93b9275f4b95f08c4a4e8d6b13"
      "cd326c16daf232c8",
      "98959acc116ede75df052f4028783105408022ed6db9516e8a27f18c2b4d59f1bcaa7163e0811203a2",
      "edff06bd132fd3031cfa5a47803d5169289a29d304f7091b20dec2b284a0e271" },
    { "1bc0dea26d8583e51cece0df7021522adb9336450929715fecb497c43cfba717",
      "7cced62d655e703f54824f4e2ceb6e5af1507e2000f1bfec9e50eb87328c2218",
      "edeb537b66dc39d20ef6ca5647e6f34df0f5dce2964d227b0c444613f951edbbc532b5576735e9dbf39177ccf807"
      "1e5fe9fa011bf8ab7fe9f716acd50847f7a9ce35262b22f04486f1e956e09005249b5ed70e68ca9896802c4ff9b8"
      "019fab057bbd5ecddaebb6a079e57cb6e39c95f6748b22cf3703e30a5e",
      "36febc6e0763391b6b1031478fd485b54d427b88d06d3582c10263",
      "5f75548b3bdc53e80c61fe8659f2b90350a59dff4477fad24764621dbc35ebbb6d71f80c556a825a2bba962561a9"
      "db3360311438d4b3eb7452926dc5ec88d451be66eeaa491cc21837ec202b3e71b3ec2d0ed2f53ec59da253fc9920"
      "482545f570e3b2e4ecb3629757f3c721fc462a380504aa8fa9fc8880fa",
      "9e46a21c41a40101ca413017cadc2fed4fc3ff390a57fc0643784871af07492f" },
    { "230bf249a043d34effa31974328fce207daf3ce10b42e5b44073b70e9566b1bf",
      "de67af72aa00fe1798e8b41be2528f36a45aeb3d957bbcc5c01490e4a786437d",
      "12403a1905c9da8bd546946612e7d4ddab1c716a533cbd5898240b4c68c675c2f18b72dd40c218bc6f7599edb573"
      "f89af867ab3c05fcef8c78b9bd0a267e8db3d9ab1dd04dd14a11f9c9e0",
      "77fe28a72f7029da86bfbcddcb819f7068afc07a249e207ae80f0acb90",
      "e9f1c7e28b1581f25448b1e21de4fe67c3ff432338b2f7364460b6b1f666a2ddb5b9cc896c3f410445d00c146952"
      "180ad1a36944aad13956e6ff95449bcf8bb6cdb1b3e87112507663441c",
      "7174e0d47bd83c1a8cf9cb14127d26bad67bf413e146bdfceab4e79b7ef13c70" },
    { "c9675c6e2c0d8cf9f45f17faff568943e4a9038df4472908dd631c5ba8a29c2f",
      "bc07c8de4778d50f5dbf324e3f9e377b82e6defdb84163bc9447f156bb70beb7",
      "d2c4c2773ac5fcbfe43869bafa8278709a32dc395be3df8360562184d47675133ff716c620fe4d18902dfb41d09b"
      "205c87a9a2acd268f9d5662c9e4b12c50181d93ec7b676cb7afd0639f2b3c1154f7489cdf926a85f51c62eb16c47"
      "b1bde2b46df56ffc9438b395",
      "88a976fd2e7ab25e492f90a1901d7d3982b678217d4b248066c6d8e7a97af0aa93d04300eb0fc0be23a5db41b1c5"
      "62efc21c6057c57cd723894d9735d3a651240c6c30e7afc2be2192081c4622ff1d7390e81182642a4d532dda34e2"
      "ed45994ce50e1524ce",
      "15f5a70290975933cbb70f830200fdd876732952577ef9c0bce0293e78c0525a1209eba2531d9c58cb742ecb4555"
      "d4c9cb6bbe69c62a0910e633d14351d3b8f0c3c6734ed9adc384c294bc4935d0026fcd50d513750826da12ecb5f4"
      "6b7c6595550547b963de030e",
      "da44d1dc3de8523cb2dc0b3d5012f0920ef4665fb676bd4ff66fd6662db058ea" },
    { "c4de2cc53d61339da13f360f88ae40b1895067680a7a9d28b3d281bb2a7d2f34",
      "29428c6b06edddd68e8f4973fc2a698fc49c71230bb97da4fbcdafb7f945c9de",
      "e9d1f0438a405d57816cf8eb37d3bbada217837db578d7c8e26355ecffc3b497732a54ae509fe8402f30239dca95"
      "9b0aa7bd436f23c31e2b9cec889f3bc82d4ad2d4af9c6f978a14b1a8dd325d8976368af2d3f04b83ee343a0bea47"
      "0bf8d56913986121402a49ed4a68c6526cb53d41ac",
      "74",
      "f1bc93dc853b7989e79d34615742488c52221d9d277560406fae0dca1a086ec09ae034a37424556922cd6661bb01"
      "a389aa00823fe3e2fb84e9811a078bdcbb4da5e949fefd45988131846259c64b45b279b7cce15ad2b1ba0b52db1d"
      "e7d39b07458bba7b26a4a4081fa3b0b6aa53b73d6d",
      "ff4527b7c136c8c92b151e0658ff456262fe74a07747f9437445d9336919939a" },
    { "0d0b70db983f4afeac46cb5e042ca51a6a85cdc500f2dfb2f97282d2f96d3235",
      "a1280a20ba18cf8977c63450318ff1f6c4303b20c111fc733212e37e11cbd38e",
      "d9db68a084a6aaacdbfa1cfd7ab1f9b4fde06f18ff093d9f5a04afb9f1a23a573125906fbe126e8fc0f51e65465a"
      "09c1167bb6fbb623f311fe07f564ad4216a01b597d4d756acfc736b905a26dcbad3c6aae8bb7043039d06561ff59"
      "7924d623767105024c170113b6",
      "0a9d9525935e346ede23c3eee268c24f1070959d392d1aa1c4234cc19cce7807c477ac8e9062ff302015952aa910"
      "6de9db40c8d20e022f3617",
      "2f517ff86b32f3841fd9cfd34fbbf2bfb77b190dd2bdb74f438914d95809d52d20f07af6fa7a03913a517a6cf3dc"
      "591045eb4fd7fa0b55d80ca54d48ee85d56841fd44db7585e5d0ad8f27264751157be2190b85f224623a40c4c821"
      "cc8c7c680c548204e7f742d749",
      "054df03cbd4f45572ecee0a8fe80b37eeca1f17881bd12c42ad6575a5ef304c5" },
    { "8011b1043674d753172302aa123478a121640daf4317957545749d0be6a91698",
      "57bd1ac0f3db407989f88a762f60b3eabd03d3bc3bae577f3818b15c0974ae9c",
      "be1833fd169fd745acaa7d8584c457657433e6a3237225a086d47806804120613d78344e097ecc6a5f869d07",
      "",
      "e34dff511e16bf12570a6828843c414b8fdced120db36ea0223e8700f57bea4c9dfbec5d3195caa633d52ee8",
      "0ac3f0459608a7f38b5b77c3f38c73f9ebc48253b316830b9583bcd51ba5c995" },
    { "d4af433d4d7598a8bf02f3e34ba9014a85f92e7ff946d51ea7fa9a4f5cab09dc",
      "4fa45413eca04bccc3c732e18fc6442646e5d809afc00e1e749a8b8f84d6926c",
      "b867dea7593a03b7b7762052e58b18483163c0828f5ebecb8cbbe4d55c7f1a4ceadf55f4c3a979e619763377cfba"
      "4f88e9e692c2794ee862b2aed63902879e11c5ee167ea4fc266a4556fbb54357ad243f92418a1d13c987f5b260e"
      "d",
      "ee4ff169ca",
      "e2e12b2510c72d2d59ad8bf30235d14f3e85824e19b09f4e84eed629325b5a5368178dc94dac13b9aa262f12592f"
      "8748bbed8581dad74895fe73dac4cc3a5f17ba480903ab86d349d68cfa0e4dcedea3321ffe1023b092cc77853a0"
      "7",
      "07a59bb7b8f5805195197a01bf6f628c689024dd64218f0a2a9b77aa5cd6b357" },
    { "2eb12f163119cd1262e0dbb26338486bc75c183026cbc71bed601f6cde324bb7",
      "c59654bef68ff95760ce8fdd39f480a3655c650647d00e49620b9938f917535d",
      "9cf103fd377ee14f1fd775530b5153eb31789755382697aef6008f59b0404bcf3fe34509835308cfac8cfed2678f"
      "523815615423831317ad7770ef74145db7a72ca9462ecd50d7b19a0d50e894bdadbb0f63d6624c80c85836bfabf4"
      "4359f700fe04b5e6bf1db1b4ded24fe9054e7318",
      "a3fb893a7baf646371e92f3c34c6700e6a9306bd7e905a25be4bd7d6239416ca94a1a31b59068729",
      "22139c2d9bedf4a0535c22de56fe441df6752a692a99c10c186b439fde9954e815d6e81d0bfa0a7c3caf60808343"
      "3e9b8d32321392f41ae03e5b67cd7801362c371223a98989b00c79fb42d4b25cc222ef6a4fe415654030e67ec506"
      "44bbc93fe83c20e1a30259a14ae1ec82ac4759d8",
      "83b054697569ad69e55ee1b1491b9353255c4cef4c0f31a0db8090b7dd06ce0b" },
    { "553928dbf68b2dfdacd75bacda2cbb4fb33d81f55731f8ac6615631ed4169784",
      "92e86bd57fafd57c88a090397a72f7af5967fb623eec8892b358abd1665f88ac",
      "b305ac06529bc8483fdc6d765a535ccbc8125a27b8d72fa2450053ad4be45beede300f87e035a05538b3",
      "1f80c2c7694a35f5653ab2fc2cc93614d959f2136bd4cf2918d2a20d6440e8ae73a652e08b7987d1df8c",
      "4885419082270c83c03f5d4869adc63cd2f940bf527e8474c7c61a748fc883b74e5ffbd8b0cd3e780a92",
      "ef4b2bbe41b9c4e58e207fe9fdbb0e9aed224989d9b9a77e78003b1c2fd7bc31" },
    { "4d6ffdfc693ab2d94d760163bb9b31728a2762c26236f04859b7b31b98c0e159",
      "e412d9b3b1b40c740ce56cdc0bec430c0ba4f95f5d83124244cebae8295b31c5",
      "ff03d03191d459d57a628a8d69d398214699bf88c2ce8694e2dcbe6d9c987056a50319ef387363b6266fb8d3e15a"
      "fe3b2eeb964800799c0686c3d6f0b27d9523592690ba7d765e9a21d62e113788076267cb50193d64b43156b3683e"
      "7ab0758e",
      "78c96946f355a8153659dd06b41b75b8109b0c31c0d6ff2feb90c875a3b211f01061f73a88a9d42550c807676dd3"
      "a405516da1d2639395cb4df526e046d621ec997c1c4fc858b60ff9051f2ee093fc8f032f367bf25b3f32361d8aec"
      "5c0e239dbb129316411e96da198d6fb512",
      "4c3083ed17c2de0981fcfd38bc244c6e6d0756fa3c23b22fe770c0c952159b6e112c6f4b6686aef4bbd0be98bcb2"
      "c32c44af09425f70cbe031d08798ef258a820dcd3029d2b0a857615a939e2a008ef14b949f5bd4ccb4607c8a8a4f"
      "c5f1236e",
      "bfa101aea1676baa3b5205d45b572425ef7da415984796d2b76f01fe5e37e919" },
    { "c9bde00bad3334e5792b5c1e5a8fda8ea7f7eed152c0a3feceb565208017af73",
      "2ee41bb5c473206ec00ec597548161573e8c2adf7387f88e4fcf64c84a2f5905",
      "b7dac21337a4029b80ae0ce7578eb0eb45c76eb84d68c4dde73690162b377118237fd1f466ce1d7d7638945779e0"
      "b148047c61b63c7e05c877f75f4a52865efe94fb65ee99e4b0d79242c69c3aad1c425d017a71eb26adc2594a6a52"
      "16eb72b736f40a91001b13c91d13d5b057ff05ea883ccff3eb6033679b7b41a62f",
      "26b1dbda8f99f9492955fab6891c3de81e4535ed525fdc6d98beebef67067fefb1674359525cacb2119d016876fe"
      "b5dd",
      "6249b44800c9d47ca20cfc1726563befbedf20639735d441917f52cbcc7ef72d5b095c6a15a7bf1239f8b93a62d9"
      "bd5e7f47b05ab9f12b4da72392ab4ba093de150fb8b7b61ea92e6a3204b178e2e1c066102ea9aea6241749ebdfba"
      "4b307ab0a5471d1d43fc930dc29a1ed5e687d41883c69d0de38ffdd25ce4d8ea33",
      "53bf7cee58474076330dc64d1eeff748df909700dd942d8d59da2447b9f84fec" },
    { "6466a65e9fe920b026739645b446cafb70919a5d03a7e890537bf88c620c5bdf",
      "db812442fcc36f2deb4b04a9c32354579abd8a57c185654dc8ce5af21f5e5463",
      "39917090786a9532f0700bbdd94d960491d89b68b2b9b1425ef8db67b735ff08d73cb171d911eb94eda3354e252b"
      "ee238408ced860a8c1657fdf8c9afea4f4bd041173ae22f236c238d38e469c89b2b2bc73d3ec88cda37530362939"
      "34732295e29dda",
      "34c8b124c1e26a893aeee4b228214ce840cd9e49f1ab7bbfbb4d90c808215be99c9da5d0d426d5933f6aaf9d1af5"
      "78c1a6f2b56e6b4c2ef41f6fa67e7f2693f36b3e21223a5428a8a24d2db24d",
      "e1d4206c53b1072c317a494b43323a65d4f17afd6f02f865d94c425f80153add9d611175e9f0bb45c51d7f469272"
      "10bfeafdcbf29cf3e1de3c01f4fc3fa94848af52293e3f48be11d1efa5d6e2aefb62385c97ab1dc7aaa96bd0210b"
      "af8a7c732386b8",
      "bb406b111937304d1ede67719247747cb082efa5e8743364b763ef0e9af1059b" },
    { "be69e13f684ade9206fc567da10871fa4bface67e86e23b9bab7da87f5c2f39c",
      "d8b143fd6fe42e1ddf4460592c2c3239e2dd97bad39066b86d121b658395bdce",
      "4f7c016b4ad5d4822e125851ea3cff387ed83933c6e20965225c34e5da784ba36585e38293c6508eca322e9a9bfb"
      "21b3d5b5b0866c2d32b850072abfebf5417f9cf7c1b3e995338b99cab418b9812863c051fd03131c82b999bfa107"
      "bb987a83528931e75a5f4ca0de75f0",
      "0d32bb65ce4936e3c9eed5cea33bec6cdc7c4e105c132a2dd663bb2cb0fa2ca62fa1fd55ee46ba39853c04655a84"
      "fcb4eec40e5a810e8ecc01063420cae63259ed33cb3fac23b343cbfaa7d9bb30ea45f824d0eaff4d836845baf675"
      "6564c66e3aef9457baa1c70e3a9b6cf4",
      "4cb6bb6308675a9a03f72d1fbf1d2b7b092bb4743e6f8e6d4f8bc176e1778eb226efd8b33a14c3bf0a554d7cd648"
      "80dff4adf7fe622d8b2a51d5a3becc06f77046eb98f6f8b7e4c9a9cbf24eb7a384f87912146662a065f22b984e9f"
      "11bbba929183d4152c2dd607f87714",
      "c06e27543c2dad50440824ab41013fa2fb34bc1c47222e5a157fe2a8d8324c18" },
    { "e365b446bd38e82eec6f10ef0ab21ee388ad485f08935ab5b27d812c77c8c2eb",
      "b5d1efebc38b831ef46617bfc282e47e20a844c326c35981b0af5e97cf151cef",
      "a04e8c9a01dcc73001fc6a53", "c6064f3f164594ab4bfe65c76c753d81e110a255d3cd9e512c3ef38d54",
      "bca8a253d89f09d92b364671",
      "4ef59bdf41cb393aada19b052ed31e568855c6edb37d286078ea3c8b8969061b" },
    { "f6c8e88d9e0da3770d3499977a5b9f9d071731244c6b0ccac921261ca799c4ca",
      "de6b3d103cf9efc4cb7d60dd3458e7c5a348692ab63a87c8ff611a336f0bf63b",
      "5eda6f7400227d5f0c4f8910c621dcd6ef0c4f9d2d9fb3feab68b3b162fc3db362acfb61c55b06febf04546a3bb0"
      "02dd6f3b9e2f531cafb7a6b1d31c29483526b2958eddbc9f2eab5717e1",
      "0dff4615b2084f8e01dce6ecf3edfc785f1cc51361f32f29b7e5c49c82f9666454f2143b9fffaac5ad9ef9fc0aab"
      "e91245cc050d5e21dd3d31bb508072d8a23d3e289aede9e95bef1bc8c8dd6d1401409234237f7e4df6db44cf9290"
      "ebca5ee8a69768eb6dc29dcc5aabde",
      "50c1b3be72fed8b6feeeeac72b999bf7f24bec747d30dee62f91753e7a26fdb4666cbea2f437232e57edb331ef32"
      "7119b8b41572e8a6198fd4377e6657520d6e833fac4b2b2b1ea4c01923",
      "342804e54894f812c0879615dd7d4b8959d36f00b03c3e183148ebba41d34d88" },
    { "c9268f6053542789747187da6140b7566024b623dc9691a534bd730764b20a63",
      "b0cd1ad38a01130f0b312be85a9dd570937c0fa1050ec7c3aa31befc400b8283", "60bf644abf31501722",
      "3091f60cfb9fa8946e8a06b1a663e60b54a24f2e5f8eb5282d980a21878c794efaa2f6f699300e3facc64197c5",
      "a3bdd452eecc7c431d", "32d6f160b3c802fc4a92344f6edd6bd47cc83630ac76b3f7d2d8ea38bf1d8886" },
    { "491c6c8be1926521f6abfdaff5f95c5fc6ee07a800fffb4715e36c5de167e8f3",
      "747cf6c78d7462846364b00f21a26b18c49d7bc3878f478af38a7dedf86c9ab1",
      "9ca6b63dce33c54e7122ef72a5bec5552b1cd8099596ed8917ff694390e970248f1ef672e985121c",
      "3d545120992929ab79fbe41da239705bbd20ab461daeb3f13b74069b0797b02699abe360382669e6752564f6525c"
      "349b0bf6a8833445d14ad99d2cfa1212e20874603760682769ec1abdf33186de04d33621d8",
      "f5a2cf25a6e22b71786ebf2adeb78d0675d08711b0cc9f1bbc6b065f056f1948570ebf4dc8df1574",
      "8c7250ec14c5e10239d1d8d275059a09dce220b496a4869f82718258f52d004f" },
    { "512cb5bfea47aa81a414e0e9c866daa1f2f7d7562a9ff7616ca182642695e9c2",
      "39f87cc65699610a3a5b84abaf4d8333e1f83f640b7673ba630d53eb608f3c57",
      "371b10a048dc329eadda98b1ab87a8fbcf817eac1fc0a40f5a8c3e34e1b735dd4bf2f185964a",
      "96fdeb760af9a39b819676fbd7cf6e025de97d9a735012b0fc2aaf2f845b4d76e97220920b7beb1b7f920e0795cd"
      "e96ff923865a5eec1a08fd88c837b2ac0b38e860b1ac5d5054e46c6538fd916f46e8bb17751cf152a3dd531762a8"
      "abbafe38198dfbd35ce232ec1927b8f47d1833db9bdebf6f7d92eb029056835ae0",
      "dfa26829a13b2383e59180b896920d0a8dc02d11ab91fcea5e004416517cbb465f951447237b",
      "7325d446ad6af8023893386201dc1a8c7b3d603d13241a5bbc33f6248d42cd48" },
    { "f2ffec87944d3061075de87038cfed1797276d8c6857433c9458677f67e090b8",
      "7aef11906a27ec49ace7193bf61183e4c67835c9c26b50381c7ec18b81e4bac4",
      "1460c5acbb61d26d0af31b565d3696e50d6dc022c528f11569dde0ad691b32fb20538236028d51b98d441ba5ef52"
      "7ace9a59ee9784c9ff14e8a1d03b2450bb75aba2a91ddf1827c14ef131",
      "d95e3d49c922e70c4c34edbde880239eec5bad1c13158a07d6a13462a8978158cadb13ee5f2cc95a21673b6ce25d"
      "7c30f0c8acdfa55c259c6d03a4b25d22fa65",
      "bfb8d129ab8a3898eb71aa46e2d976c44d790803420ce1b6c77c399ac19842b1486339571b82d84a0461a946664a"
      "68e6387b4bec56ee0acc08bec0100175d670ebdb6a9c36fcd13126762a",
      "2956d57d9089e44a5c34400b411210dd35c261a9354f6ef1d07235224f2f3b85" },
    { "5c2b46c8c5e5a4661c26ad19be10a781cb845c824a403a6bb708c738e90d9c46",
      "b80e79dc4b26bb75d284f0346697816efd98b0412549d4ab09e5453b14a1362f",
      "ead1a7d4f2a4d5d5a979e16cdbd32005a5b5506968e18d68a598ba5c0fe2863839ecb029450b0b2d0966558a890c"
      "af2b2c5ee750be7784f583b6d3e0bed0cb5d4fa6f7fd098dbe05ba8416c400faf2034c3074dc1ef7d7ee63ea1cfe"
      "d18526d394c445848a959fee",
      "9aa44ce6a70328ac8455e5648a34176e",
      "09633b3761e956bca7602b876d9b5429e64e56c2b39ee00484ce92ffa7395751cfd43f6c46ac3b0552fbc2280404"
      "df446cdd8632a41fc7989c4d603b3f6b7efbd075aaceeb3e01bbe60ef88b696ac22f41fec3d7b65b35c0c45d8bfb"
      "0cc99d80316b913968089e28",
      "2e1954215e5487ac78177f851a580067ff75de270b664e962240f38a42f67150" },
    { "05fead6fb5a0f2be62533e0a29377010bac0a25c753155d56de340a094e7c426",
      "aa6663a20646cdcc620fcf23c31deac51ef80b68bc8c5df1f91197066763eb39",
      "5e9162142770449251a541fcb7798ee6a59ef56c518a96742b4186f3d27e3a8ef9855dd5c0c586cf957725726a5d"
      "9518919c54b07b87630c8f5079b49aa656d03b0a10ae7aa498c1eaf4bf0660ff999c8080524843ff8a8137d95921"
      "b8425ff6a3cbac4f52c198f9932af067ef734ca00b682f6ad0ef0e",
      "08fffcc594bc5d08a1f6473b604289aa885d9b199c2acbc56493cbd740a5127ed1e218a719076a310301954e54f3"
      "8b682eb9f50cb05d2335e7d82bb88487f333",
      "211957354e5bd50bc25009e2cdb0adbad870d25aa02c3759bebb29ea2de74afd194aa82edf530086b07569588e5f"
      "bc3618f762712d63844c8177d7d24b2d9d5f6be5ff98cf7ea678ac7022a15c17430c20213ef276284ceb7f35e00f"
      "2b33a124a88d9aa6ca5eb37afa4076b051f94e2c2018cd90bfb499",
      "79edf8d61edd0c8d23e2337c3cc7db00a622215540796800dd4c01be03958587" },
    { "96cfab5f246dfcf8b33a9e80fb15f90a089a9078dabacbe767082da806cb4fc9",
      "6a0ad0d16594d33730b03a7b40b86581fda3661264ea17f3a4327160a30f181d",
      "61b0d79387c11ac4a87c37a9b3", "a62d02eac118d047cae4ebd58ce97a7c99ed90f4a4bee9a442",
      "d0762aa4c8d20934e91a999ca5",
      "c0dc96d5ad1cdff9445e163c0df739880bb4dd741f4ca70eef655b213b53773e" },
    { "4206ea8a06c8fdfa6aa47e76e317c3108169d142f6de50927345a2825767a7db",
      "b9c7d7ce4503a4ca01b8762ff383f0c13c240d0c9ad691cabb61a73fb1ea7dd0",
      "0915f9ff74e3b4cc4d9faedd463176e8b4d259aca80b64fedb9427394fc5950d1db2ee8a57",
      "4b283f58f0938a62ba97144ac872b231bd93c8bc14c7bbe22f993598544d90991d713e289cc3",
      "963202b6d18e7742621ccdefd04ba47457aa639ec78ea6ebc277d062117fcb7f7efbe926e7",
      "33d965ed6fff8369f9e2173f784c19795ba93776e9de83fe0292830c0ad52dc5" },
    { "7729253efc6935859e8e7cbb15850aeb37e0e3fbc017754c9583d7b4353d37f6",
      "8b66e8adf9bdc7907e2127485410c30bd8488901d0c75857b35c087eb9e21d18",
      "ea7d864e9e1b537c409601fa7b35ed10e66b71ad6a81aae70ab07cc69123a459b9020034dd165a46035ce9ab29e7"
      "01d3622a76947e7adbf6c6fecfb4316f35e24fb01a5f46cf57",
      "a3788e4450cd6edc283dc66866a7d03b1250b8868364bdfa6017cd9a518046304c4e46f5203e547fbf9c5f416429"
      "41b198ea1f640ae2f6431caf544fff17a09fb288904fc3f1686c496f7c3dd47f9fe013a9",
      "01a5877237bc6b94f0597df25ff9482976a5ff545dd26759efa03b10280d5f9a058c7bb1c230be66977d463df1ae"
      "3ddc3d7ab02c10313320b5dab74a22dc0a6d9158cd3900a184",
      "7539465a447f836c3d2e6abfc53a8d9af7914d2fcb738735d64051f8f14d59c0" },
    { "d0c627cef866ebdab7a8030be47a9aae4e97311a3a1896de7971c78feba16dfa",
      "505b133a1f82a9eb4c57c485d139197fd3e59dbb07b9c8a02a32438f6502fd90",
      "206f537aac47c77eff924a9b3e74ea85623945e1c24490",
      "636238aea904adc5f4582d48a00357c4aa57ff1f822fdbf49cadf780f5e346f0153d8ecd353073517fe4f080",
      "c44ce4e69f32651596fc5fec1f9f59cfa62c7a44f7281f",
      "36d1db8dfadc687ed88ccedc2796b8aa76337ed49e999091186659586295b6a8" },
    { "e13e72cd7f25a23b4f605050771ce73980ac37ea3c2104a17a6dccfae70b795f",
      "3720f810b9d2fc0c01abe11477689b78ba6515488483b747fdf66f243f2bb387",
      "f2468d65f0c10f82d7989e84b500178f011bc98c199f0bc299c882644373f554ef4a6eb8ff008bf005aa8b40da2"
      "1",
      "1041f65b724df64dd279659ade61cddf90672f490453aed4f019dd86fe5eee3c15c359b01d0f91a34a67bb67b4ac"
      "f51e229ada29499a0503fcb6eff20be9f59b4ff57b73e173dcb1faddbb111e645149321883c02b7f2ec265009e1e"
      "8331905cef72a24111fd80de344b420b51e4daa88e6b3b054dd96f4536f5",
      "79e9eb1f7879d2c2b27e52f3f00fa7c0e813da9bd741f1a3955ea9de04703a8624f6b7b91b0d720c95432bb57fd"
      "a",
      "4071822c3d3d92142be2437266fba4701e5c28cab4c11e3ac32d245351b66135" },
    { "1caf2693aa463ae93d13f6b687d7a19fdf047c30d054c2fdb5e07e88b5ab5a08",
      "86603e8c83f17abf6af5d8571e4f78955440c1aa97bb6a6e146d787fcc1d4e50",
      "ea9eddcc4ac951c60afae654d012b307f21c823da4ca44b3276c7f7006ce82c07d8caefa665636d6f5031e31bc7"
      "7",
      "cfbaf3cac9237f19986571ec0e39ed09b1a5107cfde57bea24b3f5dba56bb7db7459c4fa82ade76f63ec59e9400f"
      "4f51188734811bb563131f49c2e2d71841334b596a63470b2dfe3a421cc657129b449628e5c1ce39a57ff07f2130"
      "643a725637014eeba27ff95146a99a06e2584cb9bb3f12",
      "de9912a8bec65989ba4c82daaeebb14aa21246bdcd52d01ae5d4e1aa3d70a12277651c75d62569349e0e4cebd80"
      "b",
      "7af7d1875ed73bf8db71707992f07ffb5fcaa82f5a821c0d3a9000443db1bc45" },
    { "cb1a72f1752672a7fc0ccaf10c76257c047fb767f42c3f23cabc78d35a8cae4d",
      "a48db1fa02317b85f1787ed869f1b13250d7f582304594fdf4a2899d50e22c3f",
      "25f09554ecaab85e2d00c6e76e31222a9ac91b79fe9eccadb6fd38bdb948502849ea5ed30470d0d94335a64fbfe0"
      "d01f5a5b6afb95a40c5406c43e022520c2c727d53f66846e35fa3fedb4c7efa44a16",
      "72c88fc1764d922dcc6f3a61e444213e6f7877ef585c65a57ab9814813c9ae73b5a4619b316a6cec5e34241ed2f3"
      "cc530d105de4e5ca356ad66cb95f2aef4cedff42a0522f5f7d9d7a9f2fa54901e914a5b733791ef5236b78d06533"
      "5477a5eac9d626da94b36a76c3f702",
      "ca4afd213fa1a13a18e6ec57488012451cb648902e367edf72902944422f3dddbfd4946f5b34292c39ddd84e5c76"
      "91afa22f359cec4dd14afd210a5df66a5799aea2bb57c17f29fcf9c3aeb9c528c260",
      "21ac240f5e13978f67a5a233e6ecadc5e555fa3c5637d29661ed9196556b231e" },
    { "34eeeed632897724c59cc20d82ec745af1a6b43665ac88290c11b9baeda6b80a",
      "562c76d4ff6201116aa3ba82056b43d8106565553efa4f65be2776ec7346156c",
      "485560e1c34a3f1068a77cfd144054f1add7ac802d013adf462fa1e112fef5ca2ee8b48c1a37f1d62c06",
      "26f75dda69bd27835c891b9d556fb7312ed524c8f4fed9029ad963eae7a43f85a6dec0146b919e195bcbcf7eeac0"
      "09ac5aac9ec784175e0d18a25693",
      "4a7861fc50e5c17910876b4cc45b1249ca8b8ed3940e82f5f6bf6e0a161263c66005ce91edd32f876c4c",
      "72b792ed7d8e1d5c044c452daab093029c63881044bfa97a819204f8fd87c499" },
    { "ffae6a920ea2fc5baea3c3278f8cbba1f1ab3f07f2499cc87eeb3df3858d67d4",
      "81a53e4c40e507e2071b7f9464914a273065ec7f24c5e6e5d0bb77f6fce20b76",
      "484672fe6dbd8223fa1cc097886e9b73e971a6120b9f909dec308cf1df8d02181216b35ca756025dc50f6bfe3d19"
      "2cc5531ad9bb4dccbc1687afc507539b5fd6259c80f55fb55cee1708485f78d013a03851e4e6ce28c0",
      "8bb27c47b62c7048b6117e0c631313d2e165c277742a2a1cdddd",
      "8027f08446e70cb72e52679809488940fe1965ec18bf1c56882cc412e41f7727efc55acd6c2b996b5fac79bf13bf"
      "ddc7e03b3900f57589215a37ff34241329ca7b5da9ee238ed7fdaf5b1bbbb172e040d1dccc6acbd8ae",
      "d25734872533b137110dec26861bcb77fe062c0c41775a2a05ccb86365bcac09" },
    { "57f2386e011a547a48e5c8c170bdc2758e246d4fdb4b5f90f06945efb6bf6c9e",
      "8647b48a6ac27f0b6b68f09d9a264963b0b62c8cc8b454ccef9c503e6d568b33",
      "523120a8a391e743e7e2d60fa509345da8145db83631881bcf21c0c56b47990966ee08a36b361d2660268bfebaa2"
      "2d4f5a8584c1c04a27693adfef76e910eeac0454c4c1aa3b",
      "e7b43a9582ba177e97df8725092ae30620a9066c1cdfa627dda1042f5a325a46496c4b200baff0e0709c52ed0ed8"
      "2ab11af1efec1e05d044f50d25a38eaf6da2fc2709e609df95f2dc6500d30caca60e421a169ac0f1f69b1d774f37"
      "5b942edfc4151e0c78",
      "a032008e9601e05f87694a001918c0389b66d13ea514f4c2d5c891591856a3e45472f74b14c409376060ecd90de7"
      "b700b0048cd84bac232f5211768e4185086d7992103be87e",
      "ce7174bc583746a5183676f5af292df91213a864bae6e6783cc51543cd18e80c" },
    { "29f1e4ad600bc24f64d2a99669f7317add8e61d5d3a3dcda1968b398e7ab3a8d",
      "15190e8300313a59c0c6c4dcb0358cc88f7e856240091f1b1bc599a2ff3aca00",
      "b01d68b18df703fa9d166efd6aa3ac15fd48dc99f4ac806194f0f500be971560b3135ae422095a",
      "cf90cd99d137d5bb0203c0a97f5d4842f4c0ad975df8a5dd863269b37e94fbcd941f220736ea4987e9cfb73b17c9"
      "39be601c40daa99133b9a0f98bdc4e4b77bc47d307354119a2fab2771285048a273aa859f99a4ceb6bcf5bae19d7"
      "b9d766529d53e29a384304af8de07e",
      "321523038cedbe3da195d701835cf62941e6260c3c4ce5466e1fe14b36bccfc0bfcf4955f1f061",
      "75b72ea023300ea4fd27926d097e49d4955c6dd6747ea38d2c33bb21ca61e168" },
    { "4600adc836738547a6e1fb257d6a7c290d4895dcbff2e071dc38bac04f338a30",
      "ab2f8f6a728f1bab52541407027c51a1619c1db32985120f5ab40cef22e08edd", "f8cbb1362eab78f7",
      "7adb0527d13748950fc60a8f6879ec1116c73817e343958965359c8f7f7465b26fe5da1f43112465be72751de684"
      "600456e97856aee757161f6157dafac3",
      "26baa1fd39aa3c33", "147f674a8345d803d23714b057bf8c030ffb002b6f9dac1a1a7d7582dd89b746" },
    { "01f560d41c4dcdb3906e687c5fe23c070b9a8a9653987706f3357037d7d512d2",
      "a47633929b3fbfafd2c29d25ab1e8e3b6402aeecff25d60761355ef44ace4cb0",
      "6e085d40606a8042e71fc16b720cec34e47d9bd5e0676f74b6be17f7c78b53ab910980ed7b0622c248006c0ff9e9"
      "4b66b8944acfe6857f3241d0abdd8d70a4a81eb0c0a86dde53849e34643b9f37e173ed218d88bea948a240",
      "d7631a8eea17f31555b3d4abf16439f763501827180a1f5e58389f796f1c0b468f41ea3ff2e1c76cd02d180c9df1"
      "e19f6524b2a8d006f2f954f340a2f0a5a97946d39c34b935f5da5b081f18ecf457b6f0b33a37185ea8af64aa0ade"
      "40026580dafe1a5dfd2c4a7acfa8a8254897c7fd3b",
      "c309272b71ffd6ee1ed80b91ad22fe88d0488fa7c2dc4539f3452d6d6d1508c162bb8df3ec1fa5ebbd8ab738387d"
      "5b0e649cfd83e17b3e943ccedf4548171c82cb8f0b2ae39c48d78df07e282cc40c3068dc70f1fc080114c1",
      "786061e81d76bc07550cab11bc1ba1765b41e2967bc8736e11029968cbd85ba4" },
    { "c440e9504cfb4544932adc72ff5fc1b657ba0aae703b1bff33805b7f9b81412d",
      "df08a05337a532382953728ef1e921b772d435803e671a02e9cdba82522714a1",
      "9dfa0945de0d4c2cb76aa55f8b55761911163b87993db7964760dc5e807f003b6875f74eb34cc160942f580bfba4"
      "d96d967d50b1b20b0643ae1a2c73691b6bfb64403350272686fc8bb3a8e3a5674761c2204ca240e37005",
      "0c9f5ad3e58b9bf021e09b83564c8d74b1b2bf7c8cba0dc8177084a4e1a07bb84c30c3566103f538",
      "279ac5eb9bf6e01cd50a0eda161658f331226f4c8d43fdb793ae07f353e6fc2f2821a01a02be62f515af80633215"
      "a908aad8e5199c4ff23a38277ff8f16f15058d69fca995718c0d837b6db3bbb5842dd21c07ca35b21bd4",
      "16f09ea8657c053e907bdf8f822936f2cac056af25e0240633c80ae0baf7ade2" },
    { "ca81440758e13fe0b847ea81be8037b1be4cf995f805d4f40c1f421c9864ab9d",
      "aed156910fd8af6af094c74c0ca0fba932b436bc282e0c5c910ffd3651777117", "fd83897f98974ac8",
      "64ff6ab0506574c5020e14c45a009192a7a17ffbf6761393e17a86aaf339264a5c72e9e2b7fd22832a999076dbd4"
      "9c75145228ba6d36b0372042e22435f34577a2c3e1c89e2e1846dbc393d57064f016d0487d591fc6b7f8499701f8"
      "2568182041929386c821b74a53232dd596b300a13fa09949939967e58b2c0cf2de5b8b",
      "cc1913d2e48750a0", "59db1143754b19f380fb1d1b9296fa992b7c2f5adc56f451349d1ff95cd2a1d9" },
    { "a657ee84d894bb98db137d57121d149eee96447353225f701b4c0c8bfc5d9497",
      "1edcd529feb85cd69e484c0989a9b60776437dd4dcf988e3bfcce5bead13f331",
      "4fd8a593ef021f81603e430e0c9eef2fa2e7cab56d86b13a9ecfee70fb96a7bb0cdc7b23df061ff73b96a289faf0"
      "c0756f0c2e4692489e58391eae3574539f40189fb8735735deda0c8d71ff361155a0d3a574b193a31746f0272001"
      "fbe8f840dbb4f16f522c90096ae5d76209af6eb2e423109d2bf0",
      "fd167c49f8e588d06df1ac5d94d61538e399d0c531aa0ac0f9a1c030dbd3e8b649796917f4f8f8078b104352b156"
      "4a042ccffd30c19340e067d4f17b0bacc47e121a8808d06b1ea6bcc06ffbc1bdaed0999dca79212c8df6ec",
      "99f8a75bbaef042167ebfb927e6ff5bdc23e3a2084e539780ffbdc20d9be6d21e761381f23937f3179aeff80469b"
      "a65b8d2169c5695ad2dc64e39d165eb7e57ded4ab07182ca59e516b41dc463c2093425d9dcf6a377312e4437d441"
      "6d063324d24945f86c57a060cdb4c182fb3c9094e6c43af38a8d",
      "977af18c47b4e1bf3f6ee45ae865d3e3dd6ebc953c4ee636c3e560beb433c5d6" },
    { "0cb4ac9b372daf29e69a698a434c67bf822f88eabe81c2fbd1869b151bec66ad",
      "b34c3f1d39ac43e9a10ed22019b858a679fc4c629b7554e4b205ec3f31d601d7",
      "40da148ae0cd9eb7d108fe5b04664e6369ac4f24465737a33f2a16164e67a84a403a66ea3f4166b4304f",
      "1559e36d745dd40b60d8006bfa6ad62f9f1a8a7992de66bbc71d8ddf18fd68ce01e7910a972a028334f686c3b214"
      "d725d3606eb3b762d69fb1460b95e949a724d09977c41b13fb094e16e186ddd429515e939e641cc38e5f6c492f3c"
      "f7495cbe2b474c48f1890e214edfb8580d1de07855084d69ae241b421ae6",
      "e2c7a3fcd1d66a1f71301dfcfc459ad8c3485f2586a4594a02e46d35dbc4e637e9562cee2e317adc7120",
      "feae706283fea438eaa7c20641bb8446e9695cd9a0292f99b3b3ed4609a28dee" },
    { "b38e1805f202898c64975134d2369d065b808ca28ac8562bef3dd97b96650b3c",
      "1bd55d1c60a6f84094c52906fb2f711aacb93831fee6dc27fb6a746f4c412012",
      "d4817734cb56d6bd3321c7a3dc4e23d5481703d72075ae6127f1f366a0624bc1e2ac175db9ee2fe4a9c0a016d1d9"
      "955c652970a05dbb4b16f7d2e7275b9a915bc39df5effea00190b77eeb6fd056cb2951cada1d8ef9c8e9ca0de03d"
      "7b2d659c947c9a82ab512641ae734f82",
      "1be672d193cec78c85db5636ebdfe4f087ab5a2fccff0885fb39b60f901e8d6921e4d285b5daa19dac9032d6b03a"
      "2a81740ba4ffd833e90a942253e607a800c1ff92",
      "5be3df33c976077a603612ee85cfdf388953e958e5ee0c53271058258dbcc1fa8e493e044467fd00229b64337644"
      "8e9958dae478e59808839daa20c983159be864a905f97e7e00bf82ac97bfd9d005f3282886b7c1df0b505f75741c"
      "518bedea91f800fcb135688940a38022",
      "5fe7fac48f68d44c9c8d8be7ac95025fb4bf890650af092d1228c4858a8c1a9f" },
    { "bdeb596ed2056c8a78eb1f33340d2b8b0789cc456d6e8db9bb45516233900e29",
      "7096012b1bf4f66f48c1f26ab48d8594d244be86426438993ed1cfad84376c90",
      "5f3638865cb87188951620dfbcf77c6da914372635542fca218b74f5808090f8ff72919975744dff1a6693a759da"
      "7579ee01c449246e12783546333d9201ddd0e9941acbedc6c1995b09",
      "186d83c27e4831ef0c472840230860513d15b0f3df6a27ce2decb7a53c15e38c3b043c8a",
      "399b4dbc243c979b481b18a29415fff5065c9da5367679a2bbe60b5864352fa096c65cc51c9d5054844b8f0cdacb"
      "c638f8defdc81b7d80a9f5b1fa58201f0c513dbb192ea93a05dda87f",
      "7f5644fb9adcbc68a86621c4d6d7b1b32a62cda6ccdbe2d5fa8e708a4de8a3f5" },
    { "42985b7c9c97ec16bba3c36bcf82e93205c35a57428262d9e45a7fd494a9020d",
      "be4b2dd3dde2e7a773f7b85f0acb48d65bdbf4d8bfc103eee72697c8834a5058",
      "6bfc05bc2457a43f50a7391a2c38627fb0429a446ac684e7552cd54c07b9608f716ceeb50d6bc0563247163213e6"
      "2ca2bbb5067dd00b3d884795a11dab0c96e23419ce7779554bf39c50edd6ae225998cf96d1effe70c81d348a938b"
      "116fcae5d402f35aa2900673376576",
      "a7f9f0d4a1cdeb5abf1d927f6968beab9c6ead6995f484c016",
      "985b208c4938d0fd9ac7b653e0d04445fd9666044e79a766c746354cf7c949e8724170dd76245f2af71ac34d379b"
      "0be203bcb863f40081564ba161087605a9863f5b39c2c7d0f7876c84b02d9131f5284ce5d837662575efedcbb3b0"
      "12053e2c4b15ef4ee0010840552759",
      "ac55330373905d10205b0884596166370c6c9c52af6a358bbf09195b3e2f2626" },
    { "50034fdf7205a542055cf377ef546d1fe01ae8c7581806688c04279aeccf76de",
      "215de8afdde0916097f91dda6fecbd18c5e65bc685e10488e99a225a5887d92b",
      "dcd4b2ef9dd40e50adc8ce3fb674801d650e",
      "6f1ce70899b24793fd8ad89784d62ebc43b750faa9bc63fa44e707cb6877dc400dbcb85500a386add1052bbf090c"
      "637c8c618428040226209023a0db954ac26824ce40ba5021bb19d1a65ee3e3c4261c9801bd85b9c282753072",
      "df3e9901518fa830aaacab9a5635c861aab5",
      "b2a32c41c181a42175cd9108135f815663981c51f43af547e7942f77ebdc46aa" },
    { "782358a4bf3258130b1ab345e76184bd37eeff55c6efe7b8489626e5ba01741b",
      "3ae5c450b1f426cedd3f5445ee785b6c2718d587f4239053cbad839e7e19f044", "454e",
      "bc5971d3c8a7284f6218685581fc0e67572e5f124405136021536da07ec4d443015de3a708e72eaa943f5b5fb8f4"
      "85472a3999e95dc3ab7cf72ecba533006681a49f39b5d5768e9ed22e3cfc7d20d3744308a6518d46a0",
      "8a75", "d5cf51a52be53fc9b297efd9c0f3421e598143718f7f46fc3dd542f166a65e8f" },
    { "5958a371e26fff28efef8a6e71a0b81b4a14e3cf57ac75d215376e050468806b",
      "1293abdd7b6c43483f8caa43836922fb3a92feb4eb1476f4fa5ec4f06a0431f7",
      "06544eb4f4baafd8880df8a4e1da38d3111149aef41669b56ae2", "5f6cd8814bf4915f08cbf1",
      "e4b718de939d6fbb41e32b57098b08fa16bd39ccc085625d0546",
      "d1a48afe22b3c7d28e239f103b93b0a200428f4bb8e80fcb2e5110fd1ed780eb" },
    { "7bdcad0b011743f3dec12c999ac89b28f60e03564cd076fbf0183457846e606b",
      "e008a14a3fb5e56e89e02d5fec31b37b3fb6357682bc3db3368f25987f6205c2",
      "c2bc1a650114c6d522d2f928c6a65fb6abcca554336dfb70b51f61558a349387b35462bba19c3f8f13488fd4812f"
      "9d6d58d04a6ca93e8dad62a5f695a0834dd99f876294",
      "18066e9f8cdd274090f075f3047a455ca6be1ec4d1672acb013f328a1d981bece9b9c9f0f38dd25db8523b885b47"
      "cfaba4844d5bb3972591bdc2b68062e7fb0e08773506e7851a18fbc6cd29c29358a347ea195a10f5a7d874010909"
      "278395f2f9820ee8eb6655602b7b44c6c1642b9c157cc5c1a454e1b18b46",
      "bcf887985dc0e45a156b522f02c4b2adbf90a2b30f4a30ee68505df9c61d3857a6216a827c98d1d7df6dc664a526"
      "32b61361f4d86ca646c83f690015535b149c545efed3",
      "bd2cbde77f6ef4955e956d440226534942f7a41a659eb826647b3a99a57efa87" },
    { "21505992872622190e47da3d4a985ceaf356b35e096429bdff8e4a21fcbeccac",
      "8b4ab2427a4177cd205fda2b2b31f8f5ecc5ff591262791f88f54535f3054977",
      "1ceea40aba4d9328718e9939eaba25f5b558ed0df855e743cc958506b4d0c5e44d0690b9637bf94a30e861ed9260"
      "e254d602be895f173453a7977236846c4687d2b38470f074b07e16e67721646989421cf5081555fa7bef42a83066"
      "6e6c2c9b61ba14932210",
      "106f5b1fed2f5d3a102733ef6fbb7e190e508e7e8cb73766bf18fa4d50b87d6f83144f9b616dceef6c0b085f09e4"
      "27f7f0985a535fd9edf3bc05aa8dbc0db601cb4f90761420164fba50a68c5a87322fecbe28c902b03035e88d499a"
      "f758eb2049659f2561ee6c5210579f8c0c",
      "1562c0d501518e478b0c5561b32a79bbf5249d0eb8db411190454b4f3a458bfc200f65af91a22eb0fce63c726cb2"
      "b51023d294c9a35e0ff842da517d6f91b6126c0ecfccd72cfc35d7ef98f11ebbb4cd071c2eafeda598a5ccf4e09d"
      "8cff52ed583d968525a7",
      "1dfe935ef87488e515897c850bc899d4a9844d512969802e98be90c0343bc146" },
    { "337bd1641222ad96608b0928eb3e05fee02a6fb1e2f66cb4c9b698d1d96ee39b",
      "b532f2e6485513a5b21a6326beded2b3a74bc49c74db3f7a23e440e5bc864e7d",
      "9cdf9d6c42cff95ca0bf8d199962f55ce013348fb06d878b10a344ad5a7b2b2981b0e44ddb7dda1f74bcd24f3ff1"
      "bb63da249bb02234edf123305759780e45ace82aac7a95adbd1c7e72741e374c82a4524146d13589ef28ee593678"
      "9e65724b10406aff6d19d0fee8289033c094bed67df3fd45b0bdd52fccc25492cd335a",
      "efa6fdd7e4c161a5cc2eb6d67b14d6d8f16ecd3c52e8c9720709c321de05973b51750a7286120a50b3039e54c4c5"
      "e09785f815ddb5eb528b43e972bf4c60e41252",
      "4616337212a9b1fb827ad8729cf40a8309330dcc958ac0d5f73c9e57279de69280065e13fd1309153243c1303cf1"
      "16227392c9ce4b8ab505a580c06926587378c83f49c30021a1f4038180fedbe90259a9d468c87bdff827da1d01a1"
      "23fbd5b091d62d3b17e3ce7f4e83cba4510dc1e41b420c2ffc7544464befe9eb5a898d",
      "709914dea13632a2127159bf004a73349efc090a46bfecec911c63679a1540e6" },
    { "88f3c9cd7b2f27295c5defc7ba7071996ae5d558192c1a4788efe8a3bc3559d0",
      "d1ec8bbec1bd039825009a00b35522ad81c8de7bbfb698551f880b05319330c6",
      "5fc7d4fba7f9018c91533584a5e61be925559d1c8b1270621aaa2f0f51ec69ee7b14628841e2a234f3ed4279e589"
      "bc40339928d600f79a051db41699a98a263864ae34909a7c37e9c833c106bc5e996c730879d7b94d18c87741a3e7"
      "2bbbd30a5c7a",
      "9c",
      "efec904dfe14b42ca52b083ca46fc0ab80877b425e8cfbafdbcdf8600bcaa64afa05119ebbdd0f8db82ae71236c2"
      "4cac6cc53b9e0ec701f94ae4a9217f9f63ad426394793cebb1f0af7ba4bf0dc8ac621c48e2a435955afc79f095ba"
      "518e20bbe360",
      "1ed588fb6966a006fccc5f5a6e57949f9389f89c3e346bd8851610a0b159e958" },
    { "db7c3c7c7e5aa8a1c5cd5173bfb0d25958db4038a3d8deb705c102935fea8f21",
      "315686635d388d5b2ecf3b12a8450280d92555a6920f6ad3b48ba3b4f8ec5053",
      "939b319d85880267f8be72b69d2a22ba2460bbd7ce68cfc9398afce09c4f0005cf510db2aa894dcbf08120f07640"
      "255a9464056ec16765521f23d602b5af51cab7133cf01123b3038cd7dc47fdd7801c46fd628de0aa",
      "b2da",
      "783dbc7d88eb43f69d7330326e58555f58df2e75a019586beb5e4a303a3b3e4439677fd7e00a6826372cb2bc15c2"
      "5ab445bb0dfa8aae1f4d9b5d6ded219e69037c161c7fd5911bf08e3179419dbef05d37df75fb19c2",
      "b96409a14cdac61218fcc2ece389e570ac6c665856f36d98fa01be4d767b960c" },
    { "cf1f1538739072f57ebf0fa4090a63c72cf8f5bb904effb6051073596ed1dd19",
      "41e11d23771626febef2435eaefddf0c93a484ea6c4c7fa0bfd48f93e50b646d",
      "a22ba67dac88efd1988863f8991bfc9dbb9dc1a34e3866b0a51e088671971225fed3bc0369b0bccb436249d6fa30"
      "e7",
      "80d7f1fc70203411f8827cd7eec9888f26e39e055d8fd1c2876e1e252b3b14363f493100f157d8246c29b973a490"
      "338dfa0bcb52221d260875a65e22a56f655a55330933b35e2937c53a625a55bf40564fc58f742ecf54aed0536ca3"
      "f7c59f6d",
      "b3c76b03eb90c78ca281f178f30a92a98ed9966698ceb24f15f6c5ebf2e65ec4880543847005a58006a0829d2d00"
      "b3",
      "22f4354c7487a2db0c8c2249fe96909ea1cc9a053447b4a83ad396e3b3ec87ca" },
    { "38a7aa902690a3e1b285953e0121eae7304815e12a015fa98cbd227e6f7d73c1",
      "f23f9ac01c0b118b684f10031836f7c92e8a70eea0e916dba2952b685ae2c148",
      "995580acc337ee1216802b1a45daf0df12280eb94953ac61916d35eee038e5ea1d1f53da1c6a3e17d54dd1555e79"
      "c4ac988494f805715f59f2404eee2fdb592fa538928d",
      "6b726ca02fa44684e7d92ddb0b6e2f30d6a6e75b537f209d21bf2375718b4092286ea592f3c1750af21b12f64961"
      "1370ee4bfac05e0281c9731242c507a56d9d6522c26e172fb406f3e61efbf3c346917988a1dc85c829d51d3954a0"
      "825d2ca4d0e2a784c78ea07bfc5973e80fe6b34ccfe72457",
      "c73f3832441f59ce54910fd16dca9e2bd59a168ccd658ba3eb87fbb1ba561f63ad73ecf9618481bc6e8c8020c60e"
      "8194cc65bdea155f0f6cc79adaf2334c099793efba4a",
      "5c52422a24f79990f26224082d375bf81eaf5df242389c894cf89c4d0131d01e" },
    { "aa54db3f1c5e6405d443afcf4a463974448435f4002d64044a21a04c269759b9",
      "0711d3a79176e4c75ac8cc1ecdbadd4203a6a4b9eda4c2ef17150f493d645b8b",
      "5a80d351e6a2682a6ceeb374acf59de7e7",
      "171077e40c0a689d44003bd1ce56c08b81f6fa3c118cf448f5e8b6386328d5e3465132e5bdf4f73e60b1b1e6e021"
      "d05f6881fe7ec8be523ae7e6c57dd1b0af6939b79dc785d584400dfb71aabc336817e295a922aa1d46b873ad3863"
      "3099ffbecbf43527a1e64f98d82cf85a18",
      "5026a9cbdd2239c6a9abd45e36d5b46b14",
      "afe7bea6340c227c0f062e73a05e1be4aa63b93d35f2322322d3e855e0ef5887" },
    { "c3dddd6891c6081f6b478a6cf89574636c8905efbc8079ef1924b97036a050ef",
      "abc30e2892910e8c3fb83d4cb6f93eea614a7ff03b750e31ad5fc74ab77e0715",
      "079db15c3fc075189ca979ae738e72f0e5a35410b0b746d2d92874f58214cedd7e69a5337485ff038a44f18cbb6c"
      "9bb02bc396aa128b87e7888011e803fd9f43dd43494dfb2b58981d1f95820be9d37cec3bc4f779861cf59137f764"
      "dd88ea41cf044d9a",
      "56c59f42c3429832f9f2333099d2c422ea40cf36162b162e6cda56a9",
      "6910f3c047011cf301c6d8458ca4d1c40aafc129476a9c89da7b35ced9479edd3c7cbd5c1ae7a8fabff159cce121"
      "c170c1e1a884255b08758d640371d26eb031ae92d1deb7091f202bff0698ca059eae8ae572ada217b6d3df5d446a"
      "a5aef503eda02f5e",
      "f5d285ebf784c68df40ff4324bf79d0808d43f0739d297f4238b833a7cf9c013" },
    { "77716c56b9f0e158530b24ae8bc160f827eb4a11ee3b1bb3fbef3922e41d58c1",
      "f340f377c03ffca01829e013ba7a175b158ac51e5ec84e13dcc1a1974e157557",
      "2b9b2bf80c7c65d0a2d243cfac9d01ec9a0250b5e985d430f5eed4ca6aa62b31e3f5d4256a9c998fc588c69486ad"
      "41618d8b9094468f9e74b6",
      "d314a97f25ebbb16aa2d8a444c70474b5733fa18507c544515ac905450507c708868a7c3847705fcc3b7651a72a2"
      "15675a24d44aec160c562c1d68f859dcd4b9aa3569595e040ef6",
      "a58d41ed071ccfd12e01de4038783e6b23f84f55354dc0368a025cb9ceff0aa01d9e77badba040fdbc5cd984f95f"
      "4c6c6ad1151f02b5687ffd",
      "f66ee48f6ab2bbdf3ebd292a11c997bfd6f81ef5a9b61f0c9c5f9e77d7fa2624" }
};

static int
tv(void)
{
    unsigned char     *ad;
    unsigned char     *ciphertext;
    unsigned char     *decrypted;
    unsigned char     *detached_ciphertext;
    unsigned char     *expected_ciphertext;
    unsigned char     *key;
    unsigned char     *message;
    unsigned char     *mac;
    unsigned char     *nonce;
    char              *hex;
    unsigned long long found_ciphertext_len;
    unsigned long long found_mac_len;
    unsigned long long found_message_len;
    size_t             ad_len;
    size_t             ciphertext_len;
    size_t             detached_ciphertext_len;
    size_t             i = 0U;
    size_t             message_len;

    key   = (unsigned char *) sodium_malloc(crypto_aead_aegis256_KEYBYTES);
    nonce = (unsigned char *) sodium_malloc(crypto_aead_aegis256_NPUBBYTES);
    mac   = (unsigned char *) sodium_malloc(crypto_aead_aegis256_ABYTES);

    do {
        assert(strlen(tests[i].key_hex) == 2 * crypto_aead_aegis256_KEYBYTES);
        sodium_hex2bin(key, crypto_aead_aegis256_KEYBYTES, tests[i].key_hex,
                       strlen(tests[i].key_hex), NULL, NULL, NULL);
        assert(strlen(tests[i].nonce_hex) == 2 * crypto_aead_aegis256_NPUBBYTES);
        sodium_hex2bin(nonce, crypto_aead_aegis256_NPUBBYTES, tests[i].nonce_hex,
                       strlen(tests[i].nonce_hex), NULL, NULL, NULL);
        message_len = strlen(tests[i].message_hex) / 2;
        message     = (unsigned char *) sodium_malloc(message_len);
        sodium_hex2bin(message, message_len, tests[i].message_hex, strlen(tests[i].message_hex),
                       NULL, NULL, NULL);
        ad_len = strlen(tests[i].ad_hex) / 2;
        ad     = (unsigned char *) sodium_malloc(ad_len);
        sodium_hex2bin(ad, ad_len, tests[i].ad_hex, strlen(tests[i].ad_hex), NULL, NULL, NULL);
        ciphertext_len          = message_len + crypto_aead_aegis256_ABYTES;
        detached_ciphertext_len = message_len;
        expected_ciphertext     = (unsigned char *) sodium_malloc(ciphertext_len);
        assert(strlen(tests[i].ciphertext_hex) == 2 * message_len);
        sodium_hex2bin(expected_ciphertext, message_len, tests[i].ciphertext_hex,
                       strlen(tests[i].ciphertext_hex), NULL, NULL, NULL);
        assert(strlen(tests[i].mac_hex) == 2 * crypto_aead_aegis256_ABYTES);
        sodium_hex2bin(expected_ciphertext + message_len, crypto_aead_aegis256_ABYTES,
                       tests[i].mac_hex, strlen(tests[i].mac_hex), NULL, NULL, NULL);
        ciphertext          = (unsigned char *) sodium_malloc(ciphertext_len);
        detached_ciphertext = (unsigned char *) sodium_malloc(detached_ciphertext_len);

        crypto_aead_aegis256_encrypt_detached(detached_ciphertext, mac, &found_mac_len, message,
                                              message_len, ad, ad_len, NULL, nonce, key);
        assert(found_mac_len == crypto_aead_aegis256_ABYTES);
        if (memcmp(detached_ciphertext, expected_ciphertext, detached_ciphertext_len) != 0 ||
            memcmp(mac, expected_ciphertext + message_len, crypto_aead_aegis256_ABYTES) != 0) {
            printf("Detached encryption of test vector #%u failed\n", (unsigned int) i);
            hex = (char *) sodium_malloc((size_t) ciphertext_len * 2 + 1);
            sodium_bin2hex(hex, (size_t) ciphertext_len * 2 + 1, ciphertext, ciphertext_len);
            printf("Computed: [%s]\n", hex);
            sodium_free(hex);
        }

        crypto_aead_aegis256_encrypt(ciphertext, &found_ciphertext_len, message, message_len, ad,
                                     ad_len, NULL, nonce, key);

        assert((size_t) found_ciphertext_len == ciphertext_len);
        if (memcmp(ciphertext, expected_ciphertext, ciphertext_len) != 0) {
            printf("Encryption of test vector #%u failed\n", (unsigned int) i);
            hex = (char *) sodium_malloc((size_t) found_ciphertext_len * 2 + 1);
            sodium_bin2hex(hex, (size_t) found_ciphertext_len * 2 + 1, ciphertext, ciphertext_len);
            printf("Computed: [%s]\n", hex);
            sodium_free(hex);
        }

        decrypted         = (unsigned char *) sodium_malloc(message_len);
        found_message_len = 1;
        if (crypto_aead_aegis256_decrypt(decrypted, &found_message_len, NULL, ciphertext,
                                         randombytes_uniform((uint32_t) ciphertext_len), ad, ad_len,
                                         nonce, key) != -1) {
            printf("Verification of test vector #%u after truncation succeeded\n",
                   (unsigned int) i);
        }
        if (found_message_len != 0) {
            printf("Message length should have been set to zero after a failure\n");
        }
        if (crypto_aead_aegis256_decrypt(decrypted, &found_message_len, NULL, guard_page,
                                         randombytes_uniform(crypto_aead_aegis256_ABYTES), ad,
                                         ad_len, nonce, key) != -1) {
            printf("Verification of test vector #%u with a truncated tag failed\n",
                   (unsigned int) i);
        }
        if (i == 0 && crypto_aead_aegis256_decrypt(NULL, NULL, NULL, ciphertext, ciphertext_len, ad,
                                                   ad_len, nonce, key) != 0) {
            printf("Verification of test vector #%u's tag failed\n", (unsigned int) i);
        }
        if (crypto_aead_aegis256_decrypt(decrypted, &found_message_len, NULL, ciphertext,
                                         ciphertext_len, ad, ad_len, nonce, key) != 0) {
            printf("Verification of test vector #%u failed\n", (unsigned int) i);
        }
        assert((size_t) found_message_len == message_len);
        if (memcmp(decrypted, message, message_len) != 0) {
            printf("Incorrect decryption of test vector #%u\n", (unsigned int) i);
        }
        memset(decrypted, 0xd0, message_len);
        if (crypto_aead_aegis256_decrypt_detached(decrypted, NULL, detached_ciphertext,
                                                  detached_ciphertext_len, mac, ad, ad_len, nonce,
                                                  key) != 0) {
            printf("Detached verification of test vector #%u failed\n", (unsigned int) i);
        }
        if (memcmp(decrypted, message, message_len) != 0) {
            printf("Incorrect decryption of test vector #%u\n", (unsigned int) i);
        }

        sodium_free(message);
        sodium_free(ad);
        sodium_free(expected_ciphertext);
        sodium_free(ciphertext);
        sodium_free(decrypted);
        sodium_free(detached_ciphertext);
    } while (++i < (sizeof tests) / (sizeof tests[0]));

    sodium_free(key);
    sodium_free(mac);
    sodium_free(nonce);

    return 0;
}

int
main(void)
{
    tv();
    assert(crypto_aead_aegis256_keybytes() == crypto_aead_aegis256_KEYBYTES);
    assert(crypto_aead_aegis256_nsecbytes() == crypto_aead_aegis256_NSECBYTES);
    assert(crypto_aead_aegis256_npubbytes() == crypto_aead_aegis256_NPUBBYTES);
    assert(crypto_aead_aegis256_abytes() == crypto_aead_aegis256_ABYTES);
    assert(crypto_aead_aegis256_messagebytes_max() == crypto_aead_aegis256_MESSAGEBYTES_MAX);
    printf("OK\n");

    return 0;
}
