package App::Manoc::Search::Driver::Rack;

use Moose;

our $VERSION = '2.99.2'; ##TRIAL VERSION

use App::Manoc::Search::Item::Rack;

extends 'App::Manoc::Search::Driver';

sub search_inventory {
    my ( $self, $query, $result ) = @_;
    return $self->_search( $query, $result );
}

sub search_rack {
    my ( $self, $query, $result ) = @_;
    return $self->_search( $query, $result );
}

sub _search {
    my ( $self, $query, $result ) = @_;
    my $pattern = $query->sql_pattern;
    my $schema  = $self->engine->schema;

    my $it =
        $schema->resultset('Rack')
        ->search( [ { name => { -like => $pattern } } ], { order_by => 'name' } );

    while ( my $e = $it->next ) {
        my $item = App::Manoc::Search::Item::Rack->new( { rack => $e } );
        $result->add_item($item);
    }
}

no Moose;
__PACKAGE__->meta->make_immutable;

__END__

=pod

=head1 NAME

App::Manoc::Search::Driver::Rack

=head1 VERSION

version 2.99.2

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
