package Acme::Very::Modern::Perl;

use warnings;
use strict;

=head1 NAME

Acme::Very::Modern::Perl - Use the most modern of Perl!

=head1 VERSION

Version 0.02

=cut

our $VERSION = '0.02';

use Modern::Perl;
use Toolkit;
use latest;
use uni::perl;
use common::sense;

2;
__END__

=head1 SYNOPSIS

    use Acme::Very::Modern::Perl;

=head1 DESCRIPTION

Using this module, you'll get L<Modern::Perl>, L<Toolkit>, L<latest>, L<uni::perl>,
and L<common::sense> with just one simple line.

=head1 AUTHOR

Frank Wiegand, C<< <frank.wiegand at gmail.com> >>

=head1 BUGS

Please report any bugs or feature requests to C<bug-acme-very-modern-perl at rt.cpan.org>, or through
the web interface at L<http://rt.cpan.org/NoAuth/ReportBug.html?Queue=Acme-Very-Modern-Perl>.  I will be notified, and then you'll
automatically be notified of progress on your bug as I make changes.

=head1 SUPPORT

You can find documentation for this module with the perldoc command.

    perldoc Acme::Very::Modern::Perl

You can also look for information at:

=over 4

=item * RT: CPAN's request tracker

L<http://rt.cpan.org/NoAuth/Bugs.html?Dist=Acme-Very-Modern-Perl>

=item * AnnoCPAN: Annotated CPAN documentation

L<http://annocpan.org/dist/Acme-Very-Modern-Perl>

=item * CPAN Ratings

L<http://cpanratings.perl.org/d/Acme-Very-Modern-Perl>

=item * Search CPAN

L<http://search.cpan.org/dist/Acme-Very-Modern-Perl/>

=back

=head1 SEE ALSO

L<Modern::Perl>, L<Toolkit>, L<latest>, L<uni::perl>, L<common::sense>.

=head1 COPYRIGHT & LICENSE

Copyright 2009 Frank Wiegand.

This program is free software; you can redistribute it and/or modify it
under the terms of either: the GNU General Public License as published
by the Free Software Foundation; or the Artistic License.

See http://dev.perl.org/licenses/ for more information.

=cut
